package antlr.debug;

import antlr.CommonToken;
import antlr.LLkParser;
import antlr.MismatchedTokenException;
import antlr.ParseTree;
import antlr.ParseTreeRule;
import antlr.ParseTreeToken;
import antlr.ParserSharedInputState;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Stack;

public class ParseTreeDebugParser extends LLkParser
{
  protected Stack currentParseTreeRoot = new Stack();
  protected ParseTreeRule mostRecentParseTreeRoot = null;
  protected int numberOfDerivationSteps = 1;

  public ParseTreeDebugParser(int paramInt)
  {
    super(paramInt);
  }

  public ParseTreeDebugParser(ParserSharedInputState paramParserSharedInputState, int paramInt)
  {
    super(paramParserSharedInputState, paramInt);
  }

  public ParseTreeDebugParser(TokenBuffer paramTokenBuffer, int paramInt)
  {
    super(paramTokenBuffer, paramInt);
  }

  public ParseTreeDebugParser(TokenStream paramTokenStream, int paramInt)
  {
    super(paramTokenStream, paramInt);
  }

  public ParseTree getParseTree()
  {
    return this.mostRecentParseTreeRoot;
  }

  public int getNumberOfDerivationSteps()
  {
    return this.numberOfDerivationSteps;
  }

  public void match(int paramInt)
    throws MismatchedTokenException, TokenStreamException
  {
    addCurrentTokenToParseTree();
    super.match(paramInt);
  }

  public void match(BitSet paramBitSet)
    throws MismatchedTokenException, TokenStreamException
  {
    addCurrentTokenToParseTree();
    super.match(paramBitSet);
  }

  public void matchNot(int paramInt)
    throws MismatchedTokenException, TokenStreamException
  {
    addCurrentTokenToParseTree();
    super.matchNot(paramInt);
  }

  protected void addCurrentTokenToParseTree()
    throws TokenStreamException
  {
    if (this.inputState.guessing > 0)
      return;
    ParseTreeRule localParseTreeRule = (ParseTreeRule)this.currentParseTreeRoot.peek();
    ParseTreeToken localParseTreeToken = null;
    if (LA(1) == 1)
      localParseTreeToken = new ParseTreeToken(new CommonToken("EOF"));
    else
      localParseTreeToken = new ParseTreeToken(LT(1));
    localParseTreeRule.addChild(localParseTreeToken);
  }

  public void traceIn(String paramString)
    throws TokenStreamException
  {
    if (this.inputState.guessing > 0)
      return;
    ParseTreeRule localParseTreeRule1 = new ParseTreeRule(paramString);
    if (this.currentParseTreeRoot.size() > 0)
    {
      ParseTreeRule localParseTreeRule2 = (ParseTreeRule)this.currentParseTreeRoot.peek();
      localParseTreeRule2.addChild(localParseTreeRule1);
    }
    this.currentParseTreeRoot.push(localParseTreeRule1);
    this.numberOfDerivationSteps += 1;
  }

  public void traceOut(String paramString)
    throws TokenStreamException
  {
    if (this.inputState.guessing > 0)
      return;
    this.mostRecentParseTreeRoot = ((ParseTreeRule)this.currentParseTreeRoot.pop());
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.ParseTreeDebugParser
 * JD-Core Version:    0.6.0
 */