package antlr.debug;

import java.util.Vector;

public class InputBufferEventSupport
{
  private Object source;
  private Vector inputBufferListeners;
  private InputBufferEvent inputBufferEvent;
  protected static final int CONSUME = 0;
  protected static final int LA = 1;
  protected static final int MARK = 2;
  protected static final int REWIND = 3;

  public InputBufferEventSupport(Object paramObject)
  {
    this.inputBufferEvent = new InputBufferEvent(paramObject);
    this.source = paramObject;
  }

  public void addInputBufferListener(InputBufferListener paramInputBufferListener)
  {
    if (this.inputBufferListeners == null)
      this.inputBufferListeners = new Vector();
    this.inputBufferListeners.addElement(paramInputBufferListener);
  }

  public void fireConsume(char paramChar)
  {
    this.inputBufferEvent.setValues(0, paramChar, 0);
    fireEvents(0, this.inputBufferListeners);
  }

  public void fireEvent(int paramInt, ListenerBase paramListenerBase)
  {
    switch (paramInt)
    {
    case 0:
      ((InputBufferListener)paramListenerBase).inputBufferConsume(this.inputBufferEvent);
      break;
    case 1:
      ((InputBufferListener)paramListenerBase).inputBufferLA(this.inputBufferEvent);
      break;
    case 2:
      ((InputBufferListener)paramListenerBase).inputBufferMark(this.inputBufferEvent);
      break;
    case 3:
      ((InputBufferListener)paramListenerBase).inputBufferRewind(this.inputBufferEvent);
      break;
    default:
      throw new IllegalArgumentException("bad type " + paramInt + " for fireEvent()");
    }
  }

  public void fireEvents(int paramInt, Vector paramVector)
  {
    Vector localVector = null;
    ListenerBase localListenerBase = null;
    synchronized (this)
    {
      if (paramVector == null)
        return;
      localVector = (Vector)paramVector.clone();
    }
    if (localVector != null)
      for (int i = 0; i < localVector.size(); i++)
      {
        localListenerBase = (ListenerBase)localVector.elementAt(i);
        fireEvent(paramInt, localListenerBase);
      }
  }

  public void fireLA(char paramChar, int paramInt)
  {
    this.inputBufferEvent.setValues(1, paramChar, paramInt);
    fireEvents(1, this.inputBufferListeners);
  }

  public void fireMark(int paramInt)
  {
    this.inputBufferEvent.setValues(2, ' ', paramInt);
    fireEvents(2, this.inputBufferListeners);
  }

  public void fireRewind(int paramInt)
  {
    this.inputBufferEvent.setValues(3, ' ', paramInt);
    fireEvents(3, this.inputBufferListeners);
  }

  public Vector getInputBufferListeners()
  {
    return this.inputBufferListeners;
  }

  protected void refresh(Vector paramVector)
  {
    Vector localVector;
    synchronized (paramVector)
    {
      localVector = (Vector)paramVector.clone();
    }
    if (localVector != null)
      for (int i = 0; i < localVector.size(); i++)
        ((ListenerBase)localVector.elementAt(i)).refresh();
  }

  public void refreshListeners()
  {
    refresh(this.inputBufferListeners);
  }

  public void removeInputBufferListener(InputBufferListener paramInputBufferListener)
  {
    if (this.inputBufferListeners != null)
      this.inputBufferListeners.removeElement(paramInputBufferListener);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.InputBufferEventSupport
 * JD-Core Version:    0.6.0
 */