package antlr.collections.impl;

import antlr.collections.List;
import antlr.collections.Stack;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LList
  implements List, Stack
{
  protected LLCell head = null;
  protected LLCell tail = null;
  protected int length = 0;

  public void add(Object paramObject)
  {
    append(paramObject);
  }

  public void append(Object paramObject)
  {
    LLCell localLLCell = new LLCell(paramObject);
    if (this.length == 0)
    {
      this.head = (this.tail = localLLCell);
      this.length = 1;
    }
    else
    {
      this.tail.next = localLLCell;
      this.tail = localLLCell;
      this.length += 1;
    }
  }

  protected Object deleteHead()
    throws NoSuchElementException
  {
    if (this.head == null)
      throw new NoSuchElementException();
    Object localObject = this.head.data;
    this.head = this.head.next;
    this.length -= 1;
    return localObject;
  }

  public Object elementAt(int paramInt)
    throws NoSuchElementException
  {
    int i = 0;
    for (LLCell localLLCell = this.head; localLLCell != null; localLLCell = localLLCell.next)
    {
      if (paramInt == i)
        return localLLCell.data;
      i++;
    }
    throw new NoSuchElementException();
  }

  public Enumeration elements()
  {
    return new LLEnumeration(this);
  }

  public int height()
  {
    return this.length;
  }

  public boolean includes(Object paramObject)
  {
    for (LLCell localLLCell = this.head; localLLCell != null; localLLCell = localLLCell.next)
      if (localLLCell.data.equals(paramObject))
        return true;
    return false;
  }

  protected void insertHead(Object paramObject)
  {
    LLCell localLLCell = this.head;
    this.head = new LLCell(paramObject);
    this.head.next = localLLCell;
    this.length += 1;
    if (this.tail == null)
      this.tail = this.head;
  }

  public int length()
  {
    return this.length;
  }

  public Object pop()
    throws NoSuchElementException
  {
    Object localObject = deleteHead();
    return localObject;
  }

  public void push(Object paramObject)
  {
    insertHead(paramObject);
  }

  public Object top()
    throws NoSuchElementException
  {
    if (this.head == null)
      throw new NoSuchElementException();
    return this.head.data;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.collections.impl.LList
 * JD-Core Version:    0.6.0
 */