package antlr.build;

import antlr.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;

public class Tool
{
  public String os = null;

  public static void main(String[] paramArrayOfString)
  {
    if (paramArrayOfString.length != 1)
    {
      System.err.println("usage: java antlr.build.Tool action");
      return;
    }
    String str1 = "antlr.build.ANTLR";
    String str2 = paramArrayOfString[0];
    Tool localTool = new Tool();
    localTool.perform(str1, str2);
  }

  public void perform(String paramString1, String paramString2)
  {
    if ((paramString1 == null) || (paramString2 == null))
    {
      error("missing app or action");
      return;
    }
    Class localClass = null;
    Method localMethod = null;
    Object localObject = null;
    try
    {
      localObject = Utils.createInstanceOf(paramString1);
    }
    catch (Exception localException1)
    {
      try
      {
        if (!paramString1.startsWith("antlr.build."))
          localClass = Utils.loadClass("antlr.build." + paramString1);
        error("no such application " + paramString1, localException1);
      }
      catch (Exception localException3)
      {
        error("no such application " + paramString1, localException3);
      }
    }
    if ((localClass == null) || (localObject == null))
      return;
    try
    {
      localMethod = localClass.getMethod(paramString2, new Class[] { Tool.class });
      localMethod.invoke(localObject, new Object[] { this });
    }
    catch (Exception localException2)
    {
      error("no such action for application " + paramString1, localException2);
    }
  }

  public void system(String paramString)
  {
    Runtime localRuntime = Runtime.getRuntime();
    try
    {
      log(paramString);
      Process localProcess = null;
      if (!this.os.startsWith("Windows"))
        localProcess = localRuntime.exec(new String[] { "sh", "-c", paramString });
      else
        localProcess = localRuntime.exec(paramString);
      StreamScarfer localStreamScarfer1 = new StreamScarfer(localProcess.getErrorStream(), "stderr", this);
      StreamScarfer localStreamScarfer2 = new StreamScarfer(localProcess.getInputStream(), "stdout", this);
      localStreamScarfer1.start();
      localStreamScarfer2.start();
      int i = localProcess.waitFor();
    }
    catch (Exception localException)
    {
      error("cannot exec " + paramString, localException);
    }
  }

  public void antlr(String paramString)
  {
    String str = null;
    try
    {
      str = new File(paramString).getParent();
      if (str != null)
        str = new File(str).getCanonicalPath();
    }
    catch (IOException localIOException)
    {
      error("Invalid grammar file: " + paramString);
    }
    if (str != null)
    {
      log("java antlr.Tool -o " + str + " " + paramString);
      antlr.Tool localTool = new antlr.Tool();
      localTool.doEverything(new String[] { "-o", str, paramString });
    }
  }

  public void stdout(String paramString)
  {
    System.out.println(paramString);
  }

  public void stderr(String paramString)
  {
    System.err.println(paramString);
  }

  public void error(String paramString)
  {
    System.err.println("antlr.build.Tool: " + paramString);
  }

  public void log(String paramString)
  {
    System.out.println("executing: " + paramString);
  }

  public void error(String paramString, Exception paramException)
  {
    System.err.println("antlr.build.Tool: " + paramString);
    paramException.printStackTrace(System.err);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.build.Tool
 * JD-Core Version:    0.6.0
 */