package antlr.actions.python;

import antlr.ANTLRStringBuffer;
import antlr.ActionTransInfo;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.CodeGenerator;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.RuleBlock;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.Tool;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;

public class ActionLexer extends CharScanner
  implements ActionLexerTokenTypes, TokenStream
{
  protected RuleBlock currentRule;
  protected CodeGenerator generator;
  protected int lineOffset = 0;
  private Tool antlrTool;
  ActionTransInfo transInfo;
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
  public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
  public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
  public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
  public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
  public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
  public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
  public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
  public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
  public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
  public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
  public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
  public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
  public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
  public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
  public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
  public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
  public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
  public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
  public static final BitSet _tokenSet_20 = new BitSet(mk_tokenSet_20());
  public static final BitSet _tokenSet_21 = new BitSet(mk_tokenSet_21());
  public static final BitSet _tokenSet_22 = new BitSet(mk_tokenSet_22());
  public static final BitSet _tokenSet_23 = new BitSet(mk_tokenSet_23());
  public static final BitSet _tokenSet_24 = new BitSet(mk_tokenSet_24());
  public static final BitSet _tokenSet_25 = new BitSet(mk_tokenSet_25());

  public ActionLexer(String paramString, RuleBlock paramRuleBlock, CodeGenerator paramCodeGenerator, ActionTransInfo paramActionTransInfo)
  {
    this(new StringReader(paramString));
    this.currentRule = paramRuleBlock;
    this.generator = paramCodeGenerator;
    this.transInfo = paramActionTransInfo;
  }

  public void setLineOffset(int paramInt)
  {
    setLine(paramInt);
  }

  public void setTool(Tool paramTool)
  {
    this.antlrTool = paramTool;
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    this.antlrTool.error("Syntax error in action: " + paramRecognitionException, getFilename(), getLine(), getColumn());
  }

  public void reportError(String paramString)
  {
    this.antlrTool.error(paramString, getFilename(), getLine(), getColumn());
  }

  public void reportWarning(String paramString)
  {
    if (getFilename() == null)
      this.antlrTool.warning(paramString);
    else
      this.antlrTool.warning(paramString, getFilename(), getLine(), getColumn());
  }

  public ActionLexer(InputStream paramInputStream)
  {
    this(new ByteBuffer(paramInputStream));
  }

  public ActionLexer(Reader paramReader)
  {
    this(new CharBuffer(paramReader));
  }

  public ActionLexer(InputBuffer paramInputBuffer)
  {
    this(new LexerSharedInputState(paramInputBuffer));
  }

  public ActionLexer(LexerSharedInputState paramLexerSharedInputState)
  {
    super(paramLexerSharedInputState);
    this.caseSensitiveLiterals = true;
    setCaseSensitive(true);
    this.literals = new Hashtable();
  }

  public Token nextToken()
    throws TokenStreamException
  {
    Token localToken = null;
    while (true)
    {
      Object localObject = null;
      int i = 0;
      resetText();
      try
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
        {
          mACTION(true);
          localToken = this._returnToken;
        }
        else if (LA(1) == 65535)
        {
          uponEOF();
          this._returnToken = makeToken(1);
        }
        else
        {
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        if (this._returnToken == null)
          continue;
        i = this._returnToken.getType();
        this._returnToken.setType(i);
        return this._returnToken;
      }
      catch (RecognitionException localRecognitionException)
      {
        throw new TokenStreamRecognitionException(localRecognitionException);
      }
      catch (CharStreamException localCharStreamException)
      {
        if (!(localCharStreamException instanceof CharStreamIOException))
          break;
        throw new TokenStreamIOException(((CharStreamIOException)localCharStreamException).io);
      }
    }
    throw new TokenStreamException(localCharStreamException.getMessage());
  }

  public final void mACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 4;
    for (int k = 0; ; k++)
      switch (LA(1))
      {
      case '#':
        mAST_ITEM(false);
        break;
      case '$':
        mTEXT_ITEM(false);
        break;
      default:
        if (_tokenSet_0.member(LA(1)))
        {
          mSTUFF(false);
        }
        else
        {
          if (k >= 1)
            break label126;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
    label126: if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mSTUFF(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 5;
    switch (LA(1))
    {
    case '"':
      mSTRING(false);
      break;
    case '\'':
      mCHAR(false);
      break;
    case '\n':
      match('\n');
      newline();
      break;
    default:
      if ((LA(1) == '/') && ((LA(2) == '*') || (LA(2) == '/')))
      {
        mCOMMENT(false);
      }
      else if ((LA(1) == '\r') && (LA(2) == '\n'))
      {
        match("\r\n");
        newline();
      }
      else if ((LA(1) == '/') && (_tokenSet_1.member(LA(2))))
      {
        match('/');
        match(_tokenSet_1);
      }
      else if (LA(1) == '\r')
      {
        match('\r');
        newline();
      }
      else if (_tokenSet_2.member(LA(1)))
      {
        match(_tokenSet_2);
      }
      else
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mAST_ITEM(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 6;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    int k;
    if ((LA(1) == '#') && (LA(2) == '('))
    {
      k = this.text.length();
      match('#');
      this.text.setLength(k);
      mTREE(true);
      localToken2 = this._returnToken;
    }
    else
    {
      String str1;
      if ((LA(1) == '#') && (_tokenSet_3.member(LA(2))))
      {
        k = this.text.length();
        match('#');
        this.text.setLength(k);
        mID(true);
        localToken3 = this._returnToken;
        str1 = localToken3.getText();
        String str2 = this.generator.mapTreeId(str1, this.transInfo);
        if (str2 != null)
        {
          this.text.setLength(j);
          this.text.append(str2);
        }
        if (_tokenSet_4.member(LA(1)))
          mWS(false);
        if (LA(1) == '=')
          mVAR_ASSIGN(false);
      }
      else if ((LA(1) == '#') && (LA(2) == '['))
      {
        k = this.text.length();
        match('#');
        this.text.setLength(k);
        mAST_CONSTRUCTOR(true);
        localToken4 = this._returnToken;
      }
      else if ((LA(1) == '#') && (LA(2) == '#'))
      {
        match("##");
        str1 = this.currentRule.getRuleName() + "_AST";
        this.text.setLength(j);
        this.text.append(str1);
        if (this.transInfo != null)
          this.transInfo.refRuleRoot = str1;
        if (_tokenSet_4.member(LA(1)))
          mWS(false);
        if (LA(1) == '=')
          mVAR_ASSIGN(false);
      }
      else
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mTEXT_ITEM(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 7;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    Token localToken6 = null;
    Token localToken7 = null;
    String str1;
    if ((LA(1) == '$') && (LA(2) == 's') && (LA(3) == 'e'))
    {
      match("$set");
      if ((LA(1) == 'T') && (LA(2) == 'e'))
      {
        match("Text");
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '(':
          break;
        default:
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        match('(');
        mTEXT_ARG(true);
        localToken3 = this._returnToken;
        match(')');
        str1 = "self.text.setLength(_begin) ; self.text.append(" + localToken3.getText() + ")";
        this.text.setLength(j);
        this.text.append(str1);
      }
      else if ((LA(1) == 'T') && (LA(2) == 'o'))
      {
        match("Token");
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '(':
          break;
        default:
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        match('(');
        mTEXT_ARG(true);
        localToken4 = this._returnToken;
        match(')');
        str1 = "_token = " + localToken4.getText();
        this.text.setLength(j);
        this.text.append(str1);
      }
      else if ((LA(1) == 'T') && (LA(2) == 'y'))
      {
        match("Type");
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '(':
          break;
        default:
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        match('(');
        mTEXT_ARG(true);
        localToken5 = this._returnToken;
        match(')');
        str1 = "_ttype = " + localToken5.getText();
        this.text.setLength(j);
        this.text.append(str1);
      }
      else
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    else
    {
      String str2;
      if ((LA(1) == '$') && (LA(2) == 'F') && (LA(3) == 'O'))
      {
        match("$FOLLOW");
        if ((_tokenSet_5.member(LA(1))) && (_tokenSet_6.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
        {
          switch (LA(1))
          {
          case '\t':
          case '\n':
          case '\r':
          case ' ':
            mWS(false);
            break;
          case '(':
            break;
          default:
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          match('(');
          mTEXT_ARG(true);
          localToken6 = this._returnToken;
          match(')');
        }
        str1 = this.currentRule.getRuleName();
        if (localToken6 != null)
          str1 = localToken6.getText();
        str2 = this.generator.getFOLLOWBitSet(str1, 1);
        if (str2 == null)
        {
          reportError("$FOLLOW(" + str1 + ")" + ": unknown rule or bad lookahead computation");
        }
        else
        {
          this.text.setLength(j);
          this.text.append(str2);
        }
      }
      else if ((LA(1) == '$') && (LA(2) == 'F') && (LA(3) == 'I'))
      {
        match("$FIRST");
        if ((_tokenSet_5.member(LA(1))) && (_tokenSet_6.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
        {
          switch (LA(1))
          {
          case '\t':
          case '\n':
          case '\r':
          case ' ':
            mWS(false);
            break;
          case '(':
            break;
          default:
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          match('(');
          mTEXT_ARG(true);
          localToken7 = this._returnToken;
          match(')');
        }
        str1 = this.currentRule.getRuleName();
        if (localToken7 != null)
          str1 = localToken7.getText();
        str2 = this.generator.getFIRSTBitSet(str1, 1);
        if (str2 == null)
        {
          reportError("$FIRST(" + str1 + ")" + ": unknown rule or bad lookahead computation");
        }
        else
        {
          this.text.setLength(j);
          this.text.append(str2);
        }
      }
      else if ((LA(1) == '$') && (LA(2) == 's') && (LA(3) == 'k'))
      {
        match("$skip");
        this.text.setLength(j);
        this.text.append("_ttype = SKIP");
      }
      else if ((LA(1) == '$') && (LA(2) == 'a'))
      {
        match("$append");
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(false);
          break;
        case '(':
          break;
        default:
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        match('(');
        mTEXT_ARG(true);
        localToken2 = this._returnToken;
        match(')');
        str1 = "self.text.append(" + localToken2.getText() + ")";
        this.text.setLength(j);
        this.text.append(str1);
      }
      else if ((LA(1) == '$') && (LA(2) == 'g'))
      {
        match("$getText");
        this.text.setLength(j);
        this.text.append("self.text.getString(_begin)");
      }
      else if ((LA(1) == '$') && (LA(2) == 'n'))
      {
        if ((LA(1) == '$') && (LA(2) == 'n') && (LA(3) == 'l'))
          match("$nl");
        else if ((LA(1) == '$') && (LA(2) == 'n') && (LA(3) == 'e'))
          match("$newline");
        else
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        this.text.setLength(j);
        this.text.append("self.newline()");
      }
      else
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mCOMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 19;
    if ((LA(1) == '/') && (LA(2) == '/'))
      mSL_COMMENT(false);
    else if ((LA(1) == '/') && (LA(2) == '*'))
      mML_COMMENT(false);
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mSTRING(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 24;
    match('"');
    while (true)
    {
      if (LA(1) == '\\')
      {
        mESC(false);
        continue;
      }
      if (!_tokenSet_7.member(LA(1)))
        break;
      matchNot('"');
    }
    match('"');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mCHAR(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 23;
    match('\'');
    if (LA(1) == '\\')
      mESC(false);
    else if (_tokenSet_8.member(LA(1)))
      matchNot('\'');
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    match('\'');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mTREE(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 8;
    Token localToken2 = null;
    Token localToken3 = null;
    StringBuffer localStringBuffer = new StringBuffer();
    int m = 0;
    Vector localVector = new Vector(10);
    int k = this.text.length();
    match('(');
    this.text.setLength(k);
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
      break;
    case '"':
    case '#':
    case '(':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '[':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      break;
    case '\013':
    case '\f':
    case '\016':
    case '\017':
    case '\020':
    case '\021':
    case '\022':
    case '\023':
    case '\024':
    case '\025':
    case '\026':
    case '\027':
    case '\030':
    case '\031':
    case '\032':
    case '\033':
    case '\034':
    case '\035':
    case '\036':
    case '\037':
    case '!':
    case '$':
    case '%':
    case '&':
    case '\'':
    case ')':
    case '*':
    case '+':
    case ',':
    case '-':
    case '.':
    case '/':
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    k = this.text.length();
    mTREE_ELEMENT(true);
    this.text.setLength(k);
    localToken2 = this._returnToken;
    localVector.appendElement(localToken2.getText());
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
      break;
    case ')':
    case ',':
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while (LA(1) == ',')
    {
      k = this.text.length();
      match(',');
      this.text.setLength(k);
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case '"':
      case '#':
      case '(':
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
      case '[':
      case '_':
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        break;
      case '\013':
      case '\f':
      case '\016':
      case '\017':
      case '\020':
      case '\021':
      case '\022':
      case '\023':
      case '\024':
      case '\025':
      case '\026':
      case '\027':
      case '\030':
      case '\031':
      case '\032':
      case '\033':
      case '\034':
      case '\035':
      case '\036':
      case '\037':
      case '!':
      case '$':
      case '%':
      case '&':
      case '\'':
      case ')':
      case '*':
      case '+':
      case ',':
      case '-':
      case '.':
      case '/':
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '\\':
      case ']':
      case '^':
      case '`':
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      k = this.text.length();
      mTREE_ELEMENT(true);
      this.text.setLength(k);
      localToken3 = this._returnToken;
      localVector.appendElement(localToken3.getText());
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case ')':
      case ',':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    this.text.setLength(j);
    this.text.append(this.generator.getASTCreateString(localVector));
    k = this.text.length();
    match(')');
    this.text.setLength(k);
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mID(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 17;
    switch (LA(1))
    {
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      matchRange('a', 'z');
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
      matchRange('A', 'Z');
      break;
    case '_':
      match('_');
      break;
    case '[':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while (_tokenSet_9.member(LA(1)))
      switch (LA(1))
      {
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        matchRange('a', 'z');
        break;
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
        matchRange('A', 'Z');
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        matchRange('0', '9');
        break;
      case '_':
        match('_');
        break;
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '[':
      case '\\':
      case ']':
      case '^':
      case '`':
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mWS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 29;
    for (int k = 0; ; k++)
      if ((LA(1) == '\r') && (LA(2) == '\n'))
      {
        match('\r');
        match('\n');
        newline();
      }
      else if (LA(1) == ' ')
      {
        match(' ');
      }
      else if (LA(1) == '\t')
      {
        match('\t');
      }
      else if (LA(1) == '\r')
      {
        match('\r');
        newline();
      }
      else if (LA(1) == '\n')
      {
        match('\n');
        newline();
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mVAR_ASSIGN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 18;
    match('=');
    if ((LA(1) != '=') && (this.transInfo != null) && (this.transInfo.refRuleRoot != null))
      this.transInfo.assignToRoot = true;
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mAST_CONSTRUCTOR(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 10;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    int k = this.text.length();
    match('[');
    this.text.setLength(k);
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
      break;
    case '"':
    case '#':
    case '(':
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '[':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      break;
    case '\013':
    case '\f':
    case '\016':
    case '\017':
    case '\020':
    case '\021':
    case '\022':
    case '\023':
    case '\024':
    case '\025':
    case '\026':
    case '\027':
    case '\030':
    case '\031':
    case '\032':
    case '\033':
    case '\034':
    case '\035':
    case '\036':
    case '\037':
    case '!':
    case '$':
    case '%':
    case '&':
    case '\'':
    case ')':
    case '*':
    case '+':
    case ',':
    case '-':
    case '.':
    case '/':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    k = this.text.length();
    mAST_CTOR_ELEMENT(true);
    this.text.setLength(k);
    localToken2 = this._returnToken;
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
      break;
    case ',':
    case ']':
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((LA(1) == ',') && (_tokenSet_10.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
    {
      k = this.text.length();
      match(',');
      this.text.setLength(k);
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case '"':
      case '#':
      case '(':
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
      case '[':
      case '_':
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        break;
      case '\013':
      case '\f':
      case '\016':
      case '\017':
      case '\020':
      case '\021':
      case '\022':
      case '\023':
      case '\024':
      case '\025':
      case '\026':
      case '\027':
      case '\030':
      case '\031':
      case '\032':
      case '\033':
      case '\034':
      case '\035':
      case '\036':
      case '\037':
      case '!':
      case '$':
      case '%':
      case '&':
      case '\'':
      case ')':
      case '*':
      case '+':
      case ',':
      case '-':
      case '.':
      case '/':
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '\\':
      case ']':
      case '^':
      case '`':
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      k = this.text.length();
      mAST_CTOR_ELEMENT(true);
      this.text.setLength(k);
      localToken3 = this._returnToken;
    }
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
      break;
    case ',':
    case ']':
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      if ((LA(1) == ',') || (LA(1) == ']'))
        break;
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    switch (LA(1))
    {
    case ',':
      k = this.text.length();
      match(',');
      this.text.setLength(k);
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case '"':
      case '#':
      case '(':
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
      case '[':
      case '_':
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        break;
      case '\013':
      case '\f':
      case '\016':
      case '\017':
      case '\020':
      case '\021':
      case '\022':
      case '\023':
      case '\024':
      case '\025':
      case '\026':
      case '\027':
      case '\030':
      case '\031':
      case '\032':
      case '\033':
      case '\034':
      case '\035':
      case '\036':
      case '\037':
      case '!':
      case '$':
      case '%':
      case '&':
      case '\'':
      case ')':
      case '*':
      case '+':
      case ',':
      case '-':
      case '.':
      case '/':
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '\\':
      case ']':
      case '^':
      case '`':
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      k = this.text.length();
      mAST_CTOR_ELEMENT(true);
      this.text.setLength(k);
      localToken4 = this._returnToken;
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case ']':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case ']':
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    k = this.text.length();
    match(']');
    this.text.setLength(k);
    String str = localToken2.getText();
    if (localToken3 != null)
      str = str + "," + localToken3.getText();
    if (localToken4 != null)
      str = str + "," + localToken4.getText();
    this.text.setLength(j);
    this.text.append(this.generator.getASTCreateString(null, str));
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mTEXT_ARG(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 13;
    switch (LA(1))
    {
    case '\t':
    case '\n':
    case '\r':
    case ' ':
      mWS(false);
      break;
    case '"':
    case '$':
    case '\'':
    case '+':
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      break;
    case '\013':
    case '\f':
    case '\016':
    case '\017':
    case '\020':
    case '\021':
    case '\022':
    case '\023':
    case '\024':
    case '\025':
    case '\026':
    case '\027':
    case '\030':
    case '\031':
    case '\032':
    case '\033':
    case '\034':
    case '\035':
    case '\036':
    case '\037':
    case '!':
    case '#':
    case '%':
    case '&':
    case '(':
    case ')':
    case '*':
    case ',':
    case '-':
    case '.':
    case '/':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case '[':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    for (int k = 0; ; k++)
      if ((_tokenSet_11.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mTEXT_ARG_ELEMENT(false);
        if ((_tokenSet_4.member(LA(1))) && (_tokenSet_12.member(LA(2))))
        {
          mWS(false);
        }
        else
        {
          if (_tokenSet_12.member(LA(1)))
            continue;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mTREE_ELEMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 9;
    Token localToken2 = null;
    switch (LA(1))
    {
    case '(':
      mTREE(false);
      break;
    case '[':
      mAST_CONSTRUCTOR(false);
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      mID_ELEMENT(false);
      break;
    case '"':
      mSTRING(false);
      break;
    case '#':
    case '$':
    case '%':
    case '&':
    case '\'':
    case ')':
    case '*':
    case '+':
    case ',':
    case '-':
    case '.':
    case '/':
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      int k;
      if ((LA(1) == '#') && (LA(2) == '('))
      {
        k = this.text.length();
        match('#');
        this.text.setLength(k);
        mTREE(false);
      }
      else if ((LA(1) == '#') && (LA(2) == '['))
      {
        k = this.text.length();
        match('#');
        this.text.setLength(k);
        mAST_CONSTRUCTOR(false);
      }
      else
      {
        String str;
        if ((LA(1) == '#') && (_tokenSet_3.member(LA(2))))
        {
          k = this.text.length();
          match('#');
          this.text.setLength(k);
          boolean bool = mID_ELEMENT(true);
          localToken2 = this._returnToken;
          if (bool)
            break;
          str = this.generator.mapTreeId(localToken2.getText(), null);
          this.text.setLength(j);
          this.text.append(str);
        }
        else if ((LA(1) == '#') && (LA(2) == '#'))
        {
          match("##");
          str = this.currentRule.getRuleName() + "_AST";
          this.text.setLength(j);
          this.text.append(str);
        }
        else
        {
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
    }
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final boolean mID_ELEMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    int i = 0;
    Token localToken1 = null;
    int k = this.text.length();
    int j = 12;
    Token localToken2 = null;
    mID(true);
    localToken2 = this._returnToken;
    int m;
    if ((_tokenSet_4.member(LA(1))) && (_tokenSet_13.member(LA(2))))
    {
      m = this.text.length();
      mWS(false);
      this.text.setLength(m);
    }
    else if (!_tokenSet_13.member(LA(1)))
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    int n;
    switch (LA(1))
    {
    case '(':
      match('(');
      if ((_tokenSet_4.member(LA(1))) && (_tokenSet_14.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        m = this.text.length();
        mWS(false);
        this.text.setLength(m);
      }
      else if ((!_tokenSet_14.member(LA(1))) || (LA(2) < '\003') || (LA(2) > 'ÿ'))
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      switch (LA(1))
      {
      case '"':
      case '#':
      case '\'':
      case '(':
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
      case '[':
      case '_':
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        mARG(false);
      case '\t':
      case '\n':
      case '\r':
      case ' ':
      case ')':
      case '\013':
      case '\f':
      case '\016':
      case '\017':
      case '\020':
      case '\021':
      case '\022':
      case '\023':
      case '\024':
      case '\025':
      case '\026':
      case '\027':
      case '\030':
      case '\031':
      case '\032':
      case '\033':
      case '\034':
      case '\035':
      case '\036':
      case '\037':
      case '!':
      case '$':
      case '%':
      case '&':
      case '*':
      case '+':
      case ',':
      case '-':
      case '.':
      case '/':
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '\\':
      case ']':
      case '^':
      case '`':
      }
      while (LA(1) == ',')
      {
        match(',');
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          m = this.text.length();
          mWS(false);
          this.text.setLength(m);
          break;
        case '"':
        case '#':
        case '\'':
        case '(':
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '[':
        case '_':
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
          break;
        case '\013':
        case '\f':
        case '\016':
        case '\017':
        case '\020':
        case '\021':
        case '\022':
        case '\023':
        case '\024':
        case '\025':
        case '\026':
        case '\027':
        case '\030':
        case '\031':
        case '\032':
        case '\033':
        case '\034':
        case '\035':
        case '\036':
        case '\037':
        case '!':
        case '$':
        case '%':
        case '&':
        case ')':
        case '*':
        case '+':
        case ',':
        case '-':
        case '.':
        case '/':
        case ':':
        case ';':
        case '<':
        case '=':
        case '>':
        case '?':
        case '@':
        case '\\':
        case ']':
        case '^':
        case '`':
        default:
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        mARG(false);
        continue;
        break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        m = this.text.length();
        mWS(false);
        this.text.setLength(m);
        break;
      case ')':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      match(')');
      break;
    case '[':
      n = 0;
    case '.':
    case '\t':
    case '\n':
    case '\r':
    case ' ':
    case ')':
    case '*':
    case '+':
    case ',':
    case '-':
    case '/':
    case '=':
    case ']':
    default:
      while (true)
      {
        if (LA(1) == '[')
        {
          match('[');
          switch (LA(1))
          {
          case '\t':
          case '\n':
          case '\r':
          case ' ':
            m = this.text.length();
            mWS(false);
            this.text.setLength(m);
            break;
          case '"':
          case '#':
          case '\'':
          case '(':
          case '0':
          case '1':
          case '2':
          case '3':
          case '4':
          case '5':
          case '6':
          case '7':
          case '8':
          case '9':
          case 'A':
          case 'B':
          case 'C':
          case 'D':
          case 'E':
          case 'F':
          case 'G':
          case 'H':
          case 'I':
          case 'J':
          case 'K':
          case 'L':
          case 'M':
          case 'N':
          case 'O':
          case 'P':
          case 'Q':
          case 'R':
          case 'S':
          case 'T':
          case 'U':
          case 'V':
          case 'W':
          case 'X':
          case 'Y':
          case 'Z':
          case '[':
          case '_':
          case 'a':
          case 'b':
          case 'c':
          case 'd':
          case 'e':
          case 'f':
          case 'g':
          case 'h':
          case 'i':
          case 'j':
          case 'k':
          case 'l':
          case 'm':
          case 'n':
          case 'o':
          case 'p':
          case 'q':
          case 'r':
          case 's':
          case 't':
          case 'u':
          case 'v':
          case 'w':
          case 'x':
          case 'y':
          case 'z':
            break;
          case '\013':
          case '\f':
          case '\016':
          case '\017':
          case '\020':
          case '\021':
          case '\022':
          case '\023':
          case '\024':
          case '\025':
          case '\026':
          case '\027':
          case '\030':
          case '\031':
          case '\032':
          case '\033':
          case '\034':
          case '\035':
          case '\036':
          case '\037':
          case '!':
          case '$':
          case '%':
          case '&':
          case ')':
          case '*':
          case '+':
          case ',':
          case '-':
          case '.':
          case '/':
          case ':':
          case ';':
          case '<':
          case '=':
          case '>':
          case '?':
          case '@':
          case '\\':
          case ']':
          case '^':
          case '`':
          default:
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          mARG(false);
          switch (LA(1))
          {
          case '\t':
          case '\n':
          case '\r':
          case ' ':
            m = this.text.length();
            mWS(false);
            this.text.setLength(m);
            break;
          case ']':
            break;
          default:
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          match(']');
        }
        else
        {
          if (n >= 1)
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        n++;
        continue;
        match('.');
        mID_ELEMENT(false);
        break;
        i = 1;
        String str = this.generator.mapTreeId(localToken2.getText(), this.transInfo);
        this.text.setLength(k);
        this.text.append(str);
        if ((_tokenSet_15.member(LA(1))) && (_tokenSet_16.member(LA(2))) && (this.transInfo != null) && (this.transInfo.refRuleRoot != null))
        {
          switch (LA(1))
          {
          case '\t':
          case '\n':
          case '\r':
          case ' ':
            mWS(false);
            break;
          case '=':
            break;
          default:
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          mVAR_ASSIGN(false);
        }
        else
        {
          if (_tokenSet_17.member(LA(1)))
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
    }
    if ((paramBoolean) && (localToken1 == null) && (j != -1))
    {
      localToken1 = makeToken(j);
      localToken1.setText(new String(this.text.getBuffer(), k, this.text.length() - k));
    }
    this._returnToken = localToken1;
    return i;
  }

  protected final void mAST_CTOR_ELEMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 11;
    if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      mSTRING(false);
    else if ((_tokenSet_18.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      mTREE_ELEMENT(false);
    else if ((LA(1) >= '0') && (LA(1) <= '9'))
      mINT(false);
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mINT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 27;
    for (int k = 0; ; k++)
      if ((LA(1) >= '0') && (LA(1) <= '9'))
      {
        mDIGIT(false);
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mARG(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 16;
    switch (LA(1))
    {
    case '\'':
      mCHAR(false);
      break;
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      mINT_OR_FLOAT(false);
      break;
    case '(':
    case ')':
    case '*':
    case '+':
    case ',':
    case '-':
    case '.':
    case '/':
    default:
      if ((_tokenSet_18.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
        mTREE_ELEMENT(false);
      else if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
        mSTRING(false);
      else
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while ((_tokenSet_19.member(LA(1))) && (_tokenSet_20.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
    {
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        mWS(false);
        break;
      case '*':
      case '+':
      case '-':
      case '/':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      switch (LA(1))
      {
      case '+':
        match('+');
        break;
      case '-':
        match('-');
        break;
      case '*':
        match('*');
        break;
      case '/':
        match('/');
        break;
      case ',':
      case '.':
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        mWS(false);
        break;
      case '"':
      case '#':
      case '\'':
      case '(':
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
      case '[':
      case '_':
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        break;
      case '\013':
      case '\f':
      case '\016':
      case '\017':
      case '\020':
      case '\021':
      case '\022':
      case '\023':
      case '\024':
      case '\025':
      case '\026':
      case '\027':
      case '\030':
      case '\031':
      case '\032':
      case '\033':
      case '\034':
      case '\035':
      case '\036':
      case '\037':
      case '!':
      case '$':
      case '%':
      case '&':
      case ')':
      case '*':
      case '+':
      case ',':
      case '-':
      case '.':
      case '/':
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '\\':
      case ']':
      case '^':
      case '`':
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      mARG(false);
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mTEXT_ARG_ELEMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 14;
    switch (LA(1))
    {
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
      mTEXT_ARG_ID_ELEMENT(false);
      break;
    case '"':
      mSTRING(false);
      break;
    case '\'':
      mCHAR(false);
      break;
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      mINT_OR_FLOAT(false);
      break;
    case '$':
      mTEXT_ITEM(false);
      break;
    case '+':
      match('+');
      break;
    case '#':
    case '%':
    case '&':
    case '(':
    case ')':
    case '*':
    case ',':
    case '-':
    case '.':
    case '/':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case '[':
    case '\\':
    case ']':
    case '^':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mTEXT_ARG_ID_ELEMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 15;
    Token localToken2 = null;
    mID(true);
    localToken2 = this._returnToken;
    int k;
    if ((_tokenSet_4.member(LA(1))) && (_tokenSet_21.member(LA(2))))
    {
      k = this.text.length();
      mWS(false);
      this.text.setLength(k);
    }
    else if (!_tokenSet_21.member(LA(1)))
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    int m;
    switch (LA(1))
    {
    case '(':
      match('(');
      if ((_tokenSet_4.member(LA(1))) && (_tokenSet_22.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
      }
      else if ((!_tokenSet_22.member(LA(1))) || (LA(2) < '\003') || (LA(2) > 'ÿ'))
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      if ((_tokenSet_23.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        mTEXT_ARG(false);
        while (LA(1) == ',')
        {
          match(',');
          mTEXT_ARG(false);
        }
      }
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        k = this.text.length();
        mWS(false);
        this.text.setLength(k);
        break;
      case ')':
        break;
      default:
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      match(')');
      break;
    case '[':
      m = 0;
    case '.':
    case '\t':
    case '\n':
    case '\r':
    case ' ':
    case '"':
    case '$':
    case '\'':
    case ')':
    case '+':
    case ',':
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case ']':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':
    case '\013':
    case '\f':
    case '\016':
    case '\017':
    case '\020':
    case '\021':
    case '\022':
    case '\023':
    case '\024':
    case '\025':
    case '\026':
    case '\027':
    case '\030':
    case '\031':
    case '\032':
    case '\033':
    case '\034':
    case '\035':
    case '\036':
    case '\037':
    case '!':
    case '#':
    case '%':
    case '&':
    case '*':
    case '-':
    case '/':
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case '\\':
    case '^':
    case '`':
    default:
      while (true)
      {
        if (LA(1) == '[')
        {
          match('[');
          if ((_tokenSet_4.member(LA(1))) && (_tokenSet_23.member(LA(2))) && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
          {
            k = this.text.length();
            mWS(false);
            this.text.setLength(k);
          }
          else if ((!_tokenSet_23.member(LA(1))) || (LA(2) < '\003') || (LA(2) > 'ÿ') || (LA(3) < '\003') || (LA(3) > 'ÿ'))
          {
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          mTEXT_ARG(false);
          switch (LA(1))
          {
          case '\t':
          case '\n':
          case '\r':
          case ' ':
            k = this.text.length();
            mWS(false);
            this.text.setLength(k);
            break;
          case ']':
            break;
          default:
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
          match(']');
        }
        else
        {
          if (m >= 1)
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
        m++;
        continue;
        match('.');
        mTEXT_ARG_ID_ELEMENT(false);
        break;
        break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mINT_OR_FLOAT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 28;
    for (int k = 0; ; k++)
      if ((LA(1) >= '0') && (LA(1) <= '9') && (_tokenSet_24.member(LA(2))))
      {
        mDIGIT(false);
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((LA(1) == 'L') && (_tokenSet_25.member(LA(2))))
    {
      match('L');
    }
    else if ((LA(1) == 'l') && (_tokenSet_25.member(LA(2))))
    {
      match('l');
    }
    else
    {
      if (LA(1) == '.')
      {
        match('.');
        while ((LA(1) >= '0') && (LA(1) <= '9') && (_tokenSet_25.member(LA(2))))
          mDIGIT(false);
      }
      if (!_tokenSet_25.member(LA(1)))
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mSL_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 20;
    match("//");
    this.text.setLength(j);
    this.text.append("#");
    while ((LA(1) != '\n') && (LA(1) != '\r') && (LA(1) >= '\003') && (LA(1) <= 'ÿ') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      matchNot(65535);
    if ((LA(1) == '\r') && (LA(2) == '\n'))
      match("\r\n");
    else if (LA(1) == '\n')
      match('\n');
    else if (LA(1) == '\r')
      match('\r');
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    newline();
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mML_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 22;
    match("/*");
    this.text.setLength(j);
    this.text.append("#");
    while ((LA(1) != '*') || (LA(2) != '/'))
    {
      if ((LA(1) == '\r') && (LA(2) == '\n') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        match('\r');
        match('\n');
        k = this.text.length();
        mIGNWS(false);
        this.text.setLength(k);
        newline();
        this.text.append("# ");
        continue;
      }
      if ((LA(1) == '\r') && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        match('\r');
        k = this.text.length();
        mIGNWS(false);
        this.text.setLength(k);
        newline();
        this.text.append("# ");
        continue;
      }
      if ((LA(1) == '\n') && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        match('\n');
        k = this.text.length();
        mIGNWS(false);
        this.text.setLength(k);
        newline();
        this.text.append("# ");
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ') || (LA(3) < '\003') || (LA(3) > 'ÿ'))
        break;
      matchNot(65535);
    }
    this.text.append("\n");
    int k = this.text.length();
    match("*/");
    this.text.setLength(k);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mIGNWS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 21;
    while (true)
    {
      if ((LA(1) == ' ') && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(3) >= '\003') && (LA(3) <= 'ÿ'))
      {
        match(' ');
        continue;
      }
      if ((LA(1) != '\t') || (LA(2) < '\003') || (LA(2) > 'ÿ') || (LA(3) < '\003') || (LA(3) > 'ÿ'))
        break;
      match('\t');
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mESC(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 25;
    match('\\');
    switch (LA(1))
    {
    case 'n':
      match('n');
      break;
    case 'r':
      match('r');
      break;
    case 't':
      match('t');
      break;
    case 'b':
      match('b');
      break;
    case 'f':
      match('f');
      break;
    case '"':
      match('"');
      break;
    case '\'':
      match('\'');
      break;
    case '\\':
      match('\\');
      break;
    case '0':
    case '1':
    case '2':
    case '3':
      matchRange('0', '3');
      if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mDIGIT(false);
        if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
        {
          mDIGIT(false);
        }
        else
        {
          if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case '4':
    case '5':
    case '6':
    case '7':
      matchRange('4', '7');
      if ((LA(1) >= '0') && (LA(1) <= '9') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mDIGIT(false);
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 26;
    matchRange('0', '9');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -103079215112L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -145135534866440L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_2()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -141407503262728L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_3()
  {
    long[] arrayOfLong = { 0L, 576460745995190270L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_4()
  {
    long[] arrayOfLong = { 4294977024L, 0L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_5()
  {
    long[] arrayOfLong = { 1103806604800L, 0L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_6()
  {
    long[] arrayOfLong = { 287959436729787904L, 576460745995190270L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_7()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -17179869192L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_8()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -549755813896L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_9()
  {
    long[] arrayOfLong = { 287948901175001088L, 576460745995190270L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_10()
  {
    long[] arrayOfLong = { 287950056521213440L, 576460746129407998L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_11()
  {
    long[] arrayOfLong = { 287958332923183104L, 576460745995190270L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_12()
  {
    long[] arrayOfLong = { 287978128427460096L, 576460746532061182L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_13()
  {
    long[] arrayOfLong = { 2306123388973753856L, 671088640L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_14()
  {
    long[] arrayOfLong = { 287952805300282880L, 576460746129407998L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_15()
  {
    long[] arrayOfLong = { 2305843013508670976L, 0L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_16()
  {
    long[] arrayOfLong = { 2306051920717948416L, 536870912L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_17()
  {
    long[] arrayOfLong = { 208911504254464L, 536870912L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_18()
  {
    long[] arrayOfLong = { 1151051235328L, 576460746129407998L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_19()
  {
    long[] arrayOfLong = { 189120294954496L, 0L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_20()
  {
    long[] arrayOfLong = { 288139722277004800L, 576460746129407998L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_21()
  {
    long[] arrayOfLong = { 288049596683265536L, 576460746666278910L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_22()
  {
    long[] arrayOfLong = { 287960536241415680L, 576460745995190270L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_23()
  {
    long[] arrayOfLong = { 287958337218160128L, 576460745995190270L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_24()
  {
    long[] arrayOfLong = { 288228817078593024L, 576460746532061182L, 0L, 0L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_25()
  {
    long[] arrayOfLong = { 288158448334415360L, 576460746532061182L, 0L, 0L, 0L };
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.actions.python.ActionLexer
 * JD-Core Version:    0.6.0
 */