package antlr;

class TokenQueue
{
  private Token[] buffer;
  private int sizeLessOne;
  private int offset;
  protected int nbrEntries;

  public TokenQueue(int paramInt)
  {
    if (paramInt < 0)
    {
      init(16);
      return;
    }
    if (paramInt >= 1073741823)
    {
      init(2147483647);
      return;
    }
    int i = 2;
    while (i < paramInt)
      i *= 2;
    init(i);
  }

  public final void append(Token paramToken)
  {
    if (this.nbrEntries == this.buffer.length)
      expand();
    this.buffer[(this.offset + this.nbrEntries & this.sizeLessOne)] = paramToken;
    this.nbrEntries += 1;
  }

  public final Token elementAt(int paramInt)
  {
    return this.buffer[(this.offset + paramInt & this.sizeLessOne)];
  }

  private final void expand()
  {
    Token[] arrayOfToken = new Token[this.buffer.length * 2];
    for (int i = 0; i < this.buffer.length; i++)
      arrayOfToken[i] = elementAt(i);
    this.buffer = arrayOfToken;
    this.sizeLessOne = (this.buffer.length - 1);
    this.offset = 0;
  }

  private final void init(int paramInt)
  {
    this.buffer = new Token[paramInt];
    this.sizeLessOne = (paramInt - 1);
    this.offset = 0;
    this.nbrEntries = 0;
  }

  public final void reset()
  {
    this.offset = 0;
    this.nbrEntries = 0;
  }

  public final void removeFirst()
  {
    this.offset = (this.offset + 1 & this.sizeLessOne);
    this.nbrEntries -= 1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TokenQueue
 * JD-Core Version:    0.6.0
 */