package antlr;

class RuleRefElement extends AlternativeElement
{
  protected String targetRule;
  protected String args = null;
  protected String idAssign = null;
  protected String label;

  public RuleRefElement(Grammar paramGrammar, Token paramToken, int paramInt)
  {
    super(paramGrammar, paramToken, paramInt);
    this.targetRule = paramToken.getText();
    if (paramToken.type == 24)
      this.targetRule = CodeGenerator.encodeLexerRuleName(this.targetRule);
  }

  public void generate()
  {
    this.grammar.generator.gen(this);
  }

  public String getArgs()
  {
    return this.args;
  }

  public String getIdAssign()
  {
    return this.idAssign;
  }

  public String getLabel()
  {
    return this.label;
  }

  public Lookahead look(int paramInt)
  {
    return this.grammar.theLLkAnalyzer.look(paramInt, this);
  }

  public void setArgs(String paramString)
  {
    this.args = paramString;
  }

  public void setIdAssign(String paramString)
  {
    this.idAssign = paramString;
  }

  public void setLabel(String paramString)
  {
    this.label = paramString;
  }

  public String toString()
  {
    if (this.args != null)
      return " " + this.targetRule + this.args;
    return " " + this.targetRule;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.RuleRefElement
 * JD-Core Version:    0.6.0
 */