package antlr;

import antlr.collections.impl.Vector;
import java.util.Hashtable;

public class RuleBlock extends AlternativeBlock
{
  protected String ruleName;
  protected String argAction = null;
  protected String throwsSpec = null;
  protected String returnAction = null;
  protected RuleEndElement endNode;
  protected boolean testLiterals = false;
  Vector labeledElements;
  protected boolean[] lock;
  protected Lookahead[] cache;
  Hashtable exceptionSpecs;
  protected boolean defaultErrorHandler = true;
  protected String ignoreRule = null;

  public RuleBlock(Grammar paramGrammar, String paramString)
  {
    super(paramGrammar);
    this.ruleName = paramString;
    this.labeledElements = new Vector();
    this.cache = new Lookahead[paramGrammar.maxk + 1];
    this.exceptionSpecs = new Hashtable();
    setAutoGen(paramGrammar instanceof ParserGrammar);
  }

  public RuleBlock(Grammar paramGrammar, String paramString, int paramInt, boolean paramBoolean)
  {
    this(paramGrammar, paramString);
    this.line = paramInt;
    setAutoGen(paramBoolean);
  }

  public void addExceptionSpec(ExceptionSpec paramExceptionSpec)
  {
    if (findExceptionSpec(paramExceptionSpec.label) != null)
    {
      if (paramExceptionSpec.label != null)
        this.grammar.antlrTool.error("Rule '" + this.ruleName + "' already has an exception handler for label: " + paramExceptionSpec.label);
      else
        this.grammar.antlrTool.error("Rule '" + this.ruleName + "' already has an exception handler");
    }
    else
      this.exceptionSpecs.put(paramExceptionSpec.label == null ? "" : paramExceptionSpec.label.getText(), paramExceptionSpec);
  }

  public ExceptionSpec findExceptionSpec(Token paramToken)
  {
    return (ExceptionSpec)this.exceptionSpecs.get(paramToken == null ? "" : paramToken.getText());
  }

  public ExceptionSpec findExceptionSpec(String paramString)
  {
    return (ExceptionSpec)this.exceptionSpecs.get(paramString == null ? "" : paramString);
  }

  public void generate()
  {
    this.grammar.generator.gen(this);
  }

  public boolean getDefaultErrorHandler()
  {
    return this.defaultErrorHandler;
  }

  public RuleEndElement getEndElement()
  {
    return this.endNode;
  }

  public String getIgnoreRule()
  {
    return this.ignoreRule;
  }

  public String getRuleName()
  {
    return this.ruleName;
  }

  public boolean getTestLiterals()
  {
    return this.testLiterals;
  }

  public boolean isLexerAutoGenRule()
  {
    return this.ruleName.equals("nextToken");
  }

  public Lookahead look(int paramInt)
  {
    return this.grammar.theLLkAnalyzer.look(paramInt, this);
  }

  public void prepareForAnalysis()
  {
    super.prepareForAnalysis();
    this.lock = new boolean[this.grammar.maxk + 1];
  }

  public void setDefaultErrorHandler(boolean paramBoolean)
  {
    this.defaultErrorHandler = paramBoolean;
  }

  public void setEndElement(RuleEndElement paramRuleEndElement)
  {
    this.endNode = paramRuleEndElement;
  }

  public void setOption(Token paramToken1, Token paramToken2)
  {
    if (paramToken1.getText().equals("defaultErrorHandler"))
    {
      if (paramToken2.getText().equals("true"))
        this.defaultErrorHandler = true;
      else if (paramToken2.getText().equals("false"))
        this.defaultErrorHandler = false;
      else
        this.grammar.antlrTool.error("Value for defaultErrorHandler must be true or false", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
    }
    else if (paramToken1.getText().equals("testLiterals"))
    {
      if (!(this.grammar instanceof LexerGrammar))
        this.grammar.antlrTool.error("testLiterals option only valid for lexer rules", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
      else if (paramToken2.getText().equals("true"))
        this.testLiterals = true;
      else if (paramToken2.getText().equals("false"))
        this.testLiterals = false;
      else
        this.grammar.antlrTool.error("Value for testLiterals must be true or false", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
    }
    else if (paramToken1.getText().equals("ignore"))
    {
      if (!(this.grammar instanceof LexerGrammar))
        this.grammar.antlrTool.error("ignore option only valid for lexer rules", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
      else
        this.ignoreRule = paramToken2.getText();
    }
    else if (paramToken1.getText().equals("paraphrase"))
    {
      if (!(this.grammar instanceof LexerGrammar))
      {
        this.grammar.antlrTool.error("paraphrase option only valid for lexer rules", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
      }
      else
      {
        TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(this.ruleName);
        if (localTokenSymbol == null)
          this.grammar.antlrTool.panic("cannot find token associated with rule " + this.ruleName);
        localTokenSymbol.setParaphrase(paramToken2.getText());
      }
    }
    else if (paramToken1.getText().equals("generateAmbigWarnings"))
    {
      if (paramToken2.getText().equals("true"))
        this.generateAmbigWarnings = true;
      else if (paramToken2.getText().equals("false"))
        this.generateAmbigWarnings = false;
      else
        this.grammar.antlrTool.error("Value for generateAmbigWarnings must be true or false", this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
    }
    else
      this.grammar.antlrTool.error("Invalid rule option: " + paramToken1.getText(), this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
  }

  public String toString()
  {
    String str = " FOLLOW={";
    Lookahead[] arrayOfLookahead = this.endNode.cache;
    int i = this.grammar.maxk;
    int j = 1;
    for (int k = 1; k <= i; k++)
    {
      if (arrayOfLookahead[k] == null)
        continue;
      str = str + arrayOfLookahead[k].toString(",", this.grammar.tokenManager.getVocabulary());
      j = 0;
      if ((k >= i) || (arrayOfLookahead[(k + 1)] == null))
        continue;
      str = str + ";";
    }
    str = str + "}";
    if (j != 0)
      str = "";
    return this.ruleName + ": " + super.toString() + " ;" + str;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.RuleBlock
 * JD-Core Version:    0.6.0
 */