package antlr;

public class RecognitionException extends ANTLRException
{
  public String fileName;
  public int line;
  public int column;

  public RecognitionException()
  {
    super("parsing error");
    this.fileName = null;
    this.line = -1;
    this.column = -1;
  }

  public RecognitionException(String paramString)
  {
    super(paramString);
    this.fileName = null;
    this.line = -1;
    this.column = -1;
  }

  /** @deprecated */
  public RecognitionException(String paramString1, String paramString2, int paramInt)
  {
    this(paramString1, paramString2, paramInt, -1);
  }

  public RecognitionException(String paramString1, String paramString2, int paramInt1, int paramInt2)
  {
    super(paramString1);
    this.fileName = paramString2;
    this.line = paramInt1;
    this.column = paramInt2;
  }

  public String getFilename()
  {
    return this.fileName;
  }

  public int getLine()
  {
    return this.line;
  }

  public int getColumn()
  {
    return this.column;
  }

  /** @deprecated */
  public String getErrorMessage()
  {
    return getMessage();
  }

  public String toString()
  {
    return FileLineFormatter.getFormatter().getFormatString(this.fileName, this.line, this.column) + getMessage();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.RecognitionException
 * JD-Core Version:    0.6.0
 */