package antlr;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrintWriterWithSMAP extends PrintWriter
{
  private int currentOutputLine = 1;
  private int currentSourceLine = 0;
  private Map sourceMap = new HashMap();
  private boolean lastPrintCharacterWasCR = false;
  private boolean mapLines = false;
  private boolean mapSingleSourceLine = false;
  private boolean anythingWrittenSinceMapping = false;

  public PrintWriterWithSMAP(OutputStream paramOutputStream)
  {
    super(paramOutputStream);
  }

  public PrintWriterWithSMAP(OutputStream paramOutputStream, boolean paramBoolean)
  {
    super(paramOutputStream, paramBoolean);
  }

  public PrintWriterWithSMAP(Writer paramWriter)
  {
    super(paramWriter);
  }

  public PrintWriterWithSMAP(Writer paramWriter, boolean paramBoolean)
  {
    super(paramWriter, paramBoolean);
  }

  public void startMapping(int paramInt)
  {
    this.mapLines = true;
    if (paramInt != -888)
      this.currentSourceLine = paramInt;
  }

  public void startSingleSourceLineMapping(int paramInt)
  {
    this.mapSingleSourceLine = true;
    this.mapLines = true;
    if (paramInt != -888)
      this.currentSourceLine = paramInt;
  }

  public void endMapping()
  {
    mapLine(false);
    this.mapLines = false;
    this.mapSingleSourceLine = false;
  }

  protected void mapLine(boolean paramBoolean)
  {
    if ((this.mapLines) && (this.anythingWrittenSinceMapping))
    {
      Integer localInteger1 = new Integer(this.currentSourceLine);
      Integer localInteger2 = new Integer(this.currentOutputLine);
      Object localObject = (List)this.sourceMap.get(localInteger1);
      if (localObject == null)
      {
        localObject = new ArrayList();
        this.sourceMap.put(localInteger1, localObject);
      }
      if (!((List)localObject).contains(localInteger2))
        ((List)localObject).add(localInteger2);
    }
    if (paramBoolean)
      this.currentOutputLine += 1;
    if (!this.mapSingleSourceLine)
      this.currentSourceLine += 1;
    this.anythingWrittenSinceMapping = false;
  }

  public void dump(PrintWriter paramPrintWriter, String paramString1, String paramString2)
  {
    paramPrintWriter.println("SMAP");
    paramPrintWriter.println(paramString1 + ".java");
    paramPrintWriter.println("G");
    paramPrintWriter.println("*S G");
    paramPrintWriter.println("*F");
    paramPrintWriter.println("+ 0 " + paramString2);
    paramPrintWriter.println(paramString2);
    paramPrintWriter.println("*L");
    ArrayList localArrayList = new ArrayList(this.sourceMap.keySet());
    Collections.sort(localArrayList);
    Iterator localIterator1 = localArrayList.iterator();
    while (localIterator1.hasNext())
    {
      Integer localInteger1 = (Integer)localIterator1.next();
      List localList = (List)this.sourceMap.get(localInteger1);
      Iterator localIterator2 = localList.iterator();
      while (localIterator2.hasNext())
      {
        Integer localInteger2 = (Integer)localIterator2.next();
        paramPrintWriter.println(localInteger1 + ":" + localInteger2);
      }
    }
    paramPrintWriter.println("*E");
    paramPrintWriter.close();
  }

  public void write(char[] paramArrayOfChar, int paramInt1, int paramInt2)
  {
    int i = paramInt1 + paramInt2;
    for (int j = paramInt1; j < i; j++)
      checkChar(paramArrayOfChar[j]);
    super.write(paramArrayOfChar, paramInt1, paramInt2);
  }

  public void checkChar(int paramInt)
  {
    if ((this.lastPrintCharacterWasCR) && (paramInt != 10))
      mapLine(true);
    else if (paramInt == 10)
      mapLine(true);
    else if (!Character.isWhitespace((char)paramInt))
      this.anythingWrittenSinceMapping = true;
    this.lastPrintCharacterWasCR = (paramInt == 13);
  }

  public void write(int paramInt)
  {
    checkChar(paramInt);
    super.write(paramInt);
  }

  public void write(String paramString, int paramInt1, int paramInt2)
  {
    int i = paramInt1 + paramInt2;
    for (int j = paramInt1; j < i; j++)
      checkChar(paramString.charAt(j));
    super.write(paramString, paramInt1, paramInt2);
  }

  public void println()
  {
    mapLine(true);
    super.println();
    this.lastPrintCharacterWasCR = false;
  }

  public Map getSourceMap()
  {
    return this.sourceMap;
  }

  public int getCurrentOutputLine()
  {
    return this.currentOutputLine;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.PrintWriterWithSMAP
 * JD-Core Version:    0.6.0
 */