package antlr;

import java.io.IOException;

class ParserGrammar extends Grammar
{
  ParserGrammar(String paramString1, Tool paramTool, String paramString2)
  {
    super(paramString1, paramTool, paramString2);
  }

  public void generate()
    throws IOException
  {
    this.generator.gen(this);
  }

  protected String getSuperClass()
  {
    if (this.debuggingOutput)
      return "debug.LLkDebuggingParser";
    return "LLkParser";
  }

  public void processArguments(String[] paramArrayOfString)
  {
    for (int i = 0; i < paramArrayOfString.length; i++)
      if (paramArrayOfString[i].equals("-trace"))
      {
        this.traceRules = true;
        this.antlrTool.setArgOK(i);
      }
      else if (paramArrayOfString[i].equals("-traceParser"))
      {
        this.traceRules = true;
        this.antlrTool.setArgOK(i);
      }
      else
      {
        if (!paramArrayOfString[i].equals("-debug"))
          continue;
        this.debuggingOutput = true;
        this.antlrTool.setArgOK(i);
      }
  }

  public boolean setOption(String paramString, Token paramToken)
  {
    String str = paramToken.getText();
    if (paramString.equals("buildAST"))
    {
      if (str.equals("true"))
        this.buildAST = true;
      else if (str.equals("false"))
        this.buildAST = false;
      else
        this.antlrTool.error("buildAST option must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("interactive"))
    {
      if (str.equals("true"))
        this.interactive = true;
      else if (str.equals("false"))
        this.interactive = false;
      else
        this.antlrTool.error("interactive option must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("ASTLabelType"))
    {
      super.setOption(paramString, paramToken);
      return true;
    }
    if (paramString.equals("className"))
    {
      super.setOption(paramString, paramToken);
      return true;
    }
    if (super.setOption(paramString, paramToken))
      return true;
    this.antlrTool.error("Invalid option: " + paramString, getFilename(), paramToken.getLine(), paramToken.getColumn());
    return false;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.ParserGrammar
 * JD-Core Version:    0.6.0
 */