package antlr;

import antlr.collections.AST;
import antlr.collections.impl.BitSet;
import antlr.debug.MessageListener;
import antlr.debug.ParserListener;
import antlr.debug.ParserMatchListener;
import antlr.debug.ParserTokenListener;
import antlr.debug.SemanticPredicateListener;
import antlr.debug.SyntacticPredicateListener;
import antlr.debug.TraceListener;
import java.io.PrintStream;
import java.util.Hashtable;

public abstract class Parser
{
  protected ParserSharedInputState inputState;
  protected String[] tokenNames;
  protected AST returnAST;
  protected ASTFactory astFactory = null;
  protected Hashtable tokenTypeToASTClassMap = null;
  private boolean ignoreInvalidDebugCalls = false;
  protected int traceDepth = 0;

  public Parser()
  {
    this(new ParserSharedInputState());
  }

  public Parser(ParserSharedInputState paramParserSharedInputState)
  {
    this.inputState = paramParserSharedInputState;
  }

  public Hashtable getTokenTypeToASTClassMap()
  {
    return this.tokenTypeToASTClassMap;
  }

  public void addMessageListener(MessageListener paramMessageListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addMessageListener() is only valid if parser built for debugging");
  }

  public void addParserListener(ParserListener paramParserListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addParserListener() is only valid if parser built for debugging");
  }

  public void addParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addParserMatchListener() is only valid if parser built for debugging");
  }

  public void addParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addParserTokenListener() is only valid if parser built for debugging");
  }

  public void addSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addSemanticPredicateListener() is only valid if parser built for debugging");
  }

  public void addSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addSyntacticPredicateListener() is only valid if parser built for debugging");
  }

  public void addTraceListener(TraceListener paramTraceListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("addTraceListener() is only valid if parser built for debugging");
  }

  public abstract void consume()
    throws TokenStreamException;

  public void consumeUntil(int paramInt)
    throws TokenStreamException
  {
    while ((LA(1) != 1) && (LA(1) != paramInt))
      consume();
  }

  public void consumeUntil(BitSet paramBitSet)
    throws TokenStreamException
  {
    while ((LA(1) != 1) && (!paramBitSet.member(LA(1))))
      consume();
  }

  protected void defaultDebuggingSetup(TokenStream paramTokenStream, TokenBuffer paramTokenBuffer)
  {
  }

  public AST getAST()
  {
    return this.returnAST;
  }

  public ASTFactory getASTFactory()
  {
    return this.astFactory;
  }

  public String getFilename()
  {
    return this.inputState.filename;
  }

  public ParserSharedInputState getInputState()
  {
    return this.inputState;
  }

  public void setInputState(ParserSharedInputState paramParserSharedInputState)
  {
    this.inputState = paramParserSharedInputState;
  }

  public String getTokenName(int paramInt)
  {
    return this.tokenNames[paramInt];
  }

  public String[] getTokenNames()
  {
    return this.tokenNames;
  }

  public boolean isDebugMode()
  {
    return false;
  }

  public abstract int LA(int paramInt)
    throws TokenStreamException;

  public abstract Token LT(int paramInt)
    throws TokenStreamException;

  public int mark()
  {
    return this.inputState.input.mark();
  }

  public void match(int paramInt)
    throws MismatchedTokenException, TokenStreamException
  {
    if (LA(1) != paramInt)
      throw new MismatchedTokenException(this.tokenNames, LT(1), paramInt, false, getFilename());
    consume();
  }

  public void match(BitSet paramBitSet)
    throws MismatchedTokenException, TokenStreamException
  {
    if (!paramBitSet.member(LA(1)))
      throw new MismatchedTokenException(this.tokenNames, LT(1), paramBitSet, false, getFilename());
    consume();
  }

  public void matchNot(int paramInt)
    throws MismatchedTokenException, TokenStreamException
  {
    if (LA(1) == paramInt)
      throw new MismatchedTokenException(this.tokenNames, LT(1), paramInt, true, getFilename());
    consume();
  }

  /** @deprecated */
  public static void panic()
  {
    System.err.println("Parser: panic");
    System.exit(1);
  }

  public void removeMessageListener(MessageListener paramMessageListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new RuntimeException("removeMessageListener() is only valid if parser built for debugging");
  }

  public void removeParserListener(ParserListener paramParserListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new RuntimeException("removeParserListener() is only valid if parser built for debugging");
  }

  public void removeParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new RuntimeException("removeParserMatchListener() is only valid if parser built for debugging");
  }

  public void removeParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new RuntimeException("removeParserTokenListener() is only valid if parser built for debugging");
  }

  public void removeSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("removeSemanticPredicateListener() is only valid if parser built for debugging");
  }

  public void removeSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new IllegalArgumentException("removeSyntacticPredicateListener() is only valid if parser built for debugging");
  }

  public void removeTraceListener(TraceListener paramTraceListener)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new RuntimeException("removeTraceListener() is only valid if parser built for debugging");
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    System.err.println(paramRecognitionException);
  }

  public void reportError(String paramString)
  {
    if (getFilename() == null)
      System.err.println("error: " + paramString);
    else
      System.err.println(getFilename() + ": error: " + paramString);
  }

  public void reportWarning(String paramString)
  {
    if (getFilename() == null)
      System.err.println("warning: " + paramString);
    else
      System.err.println(getFilename() + ": warning: " + paramString);
  }

  public void recover(RecognitionException paramRecognitionException, BitSet paramBitSet)
    throws TokenStreamException
  {
    consume();
    consumeUntil(paramBitSet);
  }

  public void rewind(int paramInt)
  {
    this.inputState.input.rewind(paramInt);
  }

  public void setASTFactory(ASTFactory paramASTFactory)
  {
    this.astFactory = paramASTFactory;
  }

  public void setASTNodeClass(String paramString)
  {
    this.astFactory.setASTNodeType(paramString);
  }

  /** @deprecated */
  public void setASTNodeType(String paramString)
  {
    setASTNodeClass(paramString);
  }

  public void setDebugMode(boolean paramBoolean)
  {
    if (!this.ignoreInvalidDebugCalls)
      throw new RuntimeException("setDebugMode() only valid if parser built for debugging");
  }

  public void setFilename(String paramString)
  {
    this.inputState.filename = paramString;
  }

  public void setIgnoreInvalidDebugCalls(boolean paramBoolean)
  {
    this.ignoreInvalidDebugCalls = paramBoolean;
  }

  public void setTokenBuffer(TokenBuffer paramTokenBuffer)
  {
    this.inputState.input = paramTokenBuffer;
  }

  public void traceIndent()
  {
    for (int i = 0; i < this.traceDepth; i++)
      System.out.print(" ");
  }

  public void traceIn(String paramString)
    throws TokenStreamException
  {
    this.traceDepth += 1;
    traceIndent();
    System.out.println("> " + paramString + "; LA(1)==" + LT(1).getText() + (this.inputState.guessing > 0 ? " [guessing]" : ""));
  }

  public void traceOut(String paramString)
    throws TokenStreamException
  {
    traceIndent();
    System.out.println("< " + paramString + "; LA(1)==" + LT(1).getText() + (this.inputState.guessing > 0 ? " [guessing]" : ""));
    this.traceDepth -= 1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.Parser
 * JD-Core Version:    0.6.0
 */