package antlr;

public class NoViableAltForCharException extends RecognitionException
{
  public char foundChar;

  public NoViableAltForCharException(char paramChar, CharScanner paramCharScanner)
  {
    super("NoViableAlt", paramCharScanner.getFilename(), paramCharScanner.getLine(), paramCharScanner.getColumn());
    this.foundChar = paramChar;
  }

  /** @deprecated */
  public NoViableAltForCharException(char paramChar, String paramString, int paramInt)
  {
    this(paramChar, paramString, paramInt, -1);
  }

  public NoViableAltForCharException(char paramChar, String paramString, int paramInt1, int paramInt2)
  {
    super("NoViableAlt", paramString, paramInt1, paramInt2);
    this.foundChar = paramChar;
  }

  public String getMessage()
  {
    String str = "unexpected char: ";
    if ((this.foundChar >= ' ') && (this.foundChar <= '~'))
    {
      str = str + '\'';
      str = str + this.foundChar;
      str = str + '\'';
    }
    else
    {
      str = str + "0x" + Integer.toHexString(this.foundChar).toUpperCase();
    }
    return str;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.NoViableAltForCharException
 * JD-Core Version:    0.6.0
 */