package antlr;

import antlr.actions.java.ActionLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class JavaCodeGenerator extends CodeGenerator
{
  public static final int NO_MAPPING = -999;
  public static final int CONTINUE_LAST_MAPPING = -888;
  private JavaCodeGeneratorPrintWriterManager printWriterManager;
  private int defaultLine = -999;
  protected int syntacticPredLevel = 0;
  protected boolean genAST = false;
  protected boolean saveText = false;
  String labeledElementType;
  String labeledElementASTType;
  String labeledElementInit;
  String commonExtraArgs;
  String commonExtraParams;
  String commonLocalVars;
  String lt1Value;
  String exceptionThrown;
  String throwNoViable;
  RuleBlock currentRule;
  String currentASTResult;
  Hashtable treeVariableMap = new Hashtable();
  Hashtable declaredASTVariables = new Hashtable();
  int astVarNumber = 1;
  protected static final String NONUNIQUE = new String();
  public static final int caseSizeThreshold = 127;
  private Vector semPreds;

  public JavaCodeGenerator()
  {
    this.charFormatter = new JavaCharFormatter();
  }

  protected void printAction(String paramString)
  {
    printAction(paramString, this.defaultLine);
  }

  protected void printAction(String paramString, int paramInt)
  {
    getPrintWriterManager().startMapping(paramInt);
    super.printAction(paramString);
    getPrintWriterManager().endMapping();
  }

  public void println(String paramString)
  {
    println(paramString, this.defaultLine);
  }

  public void println(String paramString, int paramInt)
  {
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().startSingleSourceLineMapping(paramInt);
    super.println(paramString);
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().endMapping();
  }

  protected void print(String paramString)
  {
    print(paramString, this.defaultLine);
  }

  protected void print(String paramString, int paramInt)
  {
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().startMapping(paramInt);
    super.print(paramString);
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().endMapping();
  }

  protected void _print(String paramString)
  {
    _print(paramString, this.defaultLine);
  }

  protected void _print(String paramString, int paramInt)
  {
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().startMapping(paramInt);
    super._print(paramString);
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().endMapping();
  }

  protected void _println(String paramString)
  {
    _println(paramString, this.defaultLine);
  }

  protected void _println(String paramString, int paramInt)
  {
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().startMapping(paramInt);
    super._println(paramString);
    if ((paramInt > 0) || (paramInt == -888))
      getPrintWriterManager().endMapping();
  }

  protected int addSemPred(String paramString)
  {
    this.semPreds.appendElement(paramString);
    return this.semPreds.size() - 1;
  }

  public void exitIfError()
  {
    if (this.antlrTool.hasError())
      this.antlrTool.fatalError("Exiting due to errors.");
  }

  public void gen()
  {
    try
    {
      Enumeration localEnumeration = this.behavior.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        localObject = (Grammar)localEnumeration.nextElement();
        ((Grammar)localObject).setGrammarAnalyzer(this.analyzer);
        ((Grammar)localObject).setCodeGenerator(this);
        this.analyzer.setGrammar((Grammar)localObject);
        setupGrammarParameters((Grammar)localObject);
        ((Grammar)localObject).generate();
        exitIfError();
      }
      Object localObject = this.behavior.tokenManagers.elements();
      while (((Enumeration)localObject).hasMoreElements())
      {
        TokenManager localTokenManager = (TokenManager)((Enumeration)localObject).nextElement();
        if (!localTokenManager.isReadOnly())
        {
          genTokenTypes(localTokenManager);
          genTokenInterchange(localTokenManager);
        }
        exitIfError();
      }
    }
    catch (IOException localIOException)
    {
      this.antlrTool.reportException(localIOException, null);
    }
  }

  public void gen(ActionElement paramActionElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramActionElement.getLine();
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("genAction(" + paramActionElement + ")");
      if (paramActionElement.isSemPred)
      {
        genSemPred(paramActionElement.actionText, paramActionElement.line);
      }
      else
      {
        if (this.grammar.hasSyntacticPredicate)
        {
          println("if ( inputState.guessing==0 ) {");
          this.tabs += 1;
        }
        ActionTransInfo localActionTransInfo = new ActionTransInfo();
        String str = processActionForSpecialSymbols(paramActionElement.actionText, paramActionElement.getLine(), this.currentRule, localActionTransInfo);
        if (localActionTransInfo.refRuleRoot != null)
          println(localActionTransInfo.refRuleRoot + " = (" + this.labeledElementASTType + ")currentAST.root;");
        printAction(str);
        if (localActionTransInfo.assignToRoot)
        {
          println("currentAST.root = " + localActionTransInfo.refRuleRoot + ";");
          println("currentAST.child = " + localActionTransInfo.refRuleRoot + "!=null &&" + localActionTransInfo.refRuleRoot + ".getFirstChild()!=null ?", -999);
          this.tabs += 1;
          println(localActionTransInfo.refRuleRoot + ".getFirstChild() : " + localActionTransInfo.refRuleRoot + ";");
          this.tabs -= 1;
          println("currentAST.advanceChildToEnd();");
        }
        if (this.grammar.hasSyntacticPredicate)
        {
          this.tabs -= 1;
          println("}", -999);
        }
      }
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(AlternativeBlock paramAlternativeBlock)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen(" + paramAlternativeBlock + ")");
    println("{", -999);
    genBlockPreamble(paramAlternativeBlock);
    genBlockInitAction(paramAlternativeBlock);
    String str = this.currentASTResult;
    if (paramAlternativeBlock.getLabel() != null)
      this.currentASTResult = paramAlternativeBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramAlternativeBlock);
    JavaBlockFinishingInfo localJavaBlockFinishingInfo = genCommonBlock(paramAlternativeBlock, true);
    genBlockFinish(localJavaBlockFinishingInfo, this.throwNoViable, paramAlternativeBlock.getLine());
    println("}", -999);
    this.currentASTResult = str;
  }

  public void gen(BlockEndElement paramBlockEndElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRuleEnd(" + paramBlockEndElement + ")");
  }

  public void gen(CharLiteralElement paramCharLiteralElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genChar(" + paramCharLiteralElement + ")");
    if (paramCharLiteralElement.getLabel() != null)
      println(paramCharLiteralElement.getLabel() + " = " + this.lt1Value + ";", paramCharLiteralElement.getLine());
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramCharLiteralElement.getAutoGenType() == 1));
    genMatch(paramCharLiteralElement);
    this.saveText = bool;
  }

  public void gen(CharRangeElement paramCharRangeElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramCharRangeElement.getLine();
      if ((paramCharRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
        println(paramCharRangeElement.getLabel() + " = " + this.lt1Value + ";");
      int j = ((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramCharRangeElement.getAutoGenType() == 3)) ? 1 : 0;
      if (j != 0)
        println("_saveIndex=text.length();");
      println("matchRange(" + paramCharRangeElement.beginText + "," + paramCharRangeElement.endText + ");");
      if (j != 0)
        println("text.setLength(_saveIndex);");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      if (paramLexerGrammar.debuggingOutput)
        this.semPreds = new Vector();
      setGrammar(paramLexerGrammar);
      if (!(this.grammar instanceof LexerGrammar))
        this.antlrTool.panic("Internal error generating lexer");
      this.currentOutput = getPrintWriterManager().setupOutput(this.antlrTool, this.grammar);
      this.genAST = false;
      this.saveText = true;
      this.tabs = 0;
      genHeader();
      try
      {
        this.defaultLine = this.behavior.getHeaderActionLine("");
        println(this.behavior.getHeaderAction(""));
      }
      finally
      {
        this.defaultLine = -999;
      }
      println("import java.io.InputStream;");
      println("import antlr.TokenStreamException;");
      println("import antlr.TokenStreamIOException;");
      println("import antlr.TokenStreamRecognitionException;");
      println("import antlr.CharStreamException;");
      println("import antlr.CharStreamIOException;");
      println("import antlr.ANTLRException;");
      println("import java.io.Reader;");
      println("import java.util.Hashtable;");
      println("import antlr." + this.grammar.getSuperClass() + ";");
      println("import antlr.InputBuffer;");
      println("import antlr.ByteBuffer;");
      println("import antlr.CharBuffer;");
      println("import antlr.Token;");
      println("import antlr.CommonToken;");
      println("import antlr.RecognitionException;");
      println("import antlr.NoViableAltForCharException;");
      println("import antlr.MismatchedCharException;");
      println("import antlr.TokenStream;");
      println("import antlr.ANTLRHashString;");
      println("import antlr.LexerSharedInputState;");
      println("import antlr.collections.impl.BitSet;");
      println("import antlr.SemanticException;");
      println(this.grammar.preambleAction.getText());
      String str = null;
      if (this.grammar.superClass != null)
        str = this.grammar.superClass;
      else
        str = "antlr." + this.grammar.getSuperClass();
      if (this.grammar.comment != null)
        _println(this.grammar.comment);
      Object localObject2 = "public";
      Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
      if (localToken != null)
      {
        localObject3 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
        if (localObject3 != null)
          localObject2 = localObject3;
      }
      print((String)localObject2 + " ");
      print("class " + this.grammar.getClassName() + " extends " + str);
      println(" implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix + ", TokenStream");
      Object localObject3 = (Token)this.grammar.options.get("classHeaderSuffix");
      if (localObject3 != null)
      {
        localObject4 = StringUtils.stripFrontBack(((Token)localObject3).getText(), "\"", "\"");
        if (localObject4 != null)
          print(", " + (String)localObject4);
      }
      println(" {");
      print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null), this.grammar.classMemberAction.getLine());
      println("public " + this.grammar.getClassName() + "(InputStream in) {");
      this.tabs += 1;
      println("this(new ByteBuffer(in));");
      this.tabs -= 1;
      println("}");
      println("public " + this.grammar.getClassName() + "(Reader in) {");
      this.tabs += 1;
      println("this(new CharBuffer(in));");
      this.tabs -= 1;
      println("}");
      println("public " + this.grammar.getClassName() + "(InputBuffer ib) {");
      this.tabs += 1;
      if (this.grammar.debuggingOutput)
        println("this(new LexerSharedInputState(new antlr.debug.DebuggingInputBuffer(ib)));");
      else
        println("this(new LexerSharedInputState(ib));");
      this.tabs -= 1;
      println("}");
      println("public " + this.grammar.getClassName() + "(LexerSharedInputState state) {");
      this.tabs += 1;
      println("super(state);");
      if (this.grammar.debuggingOutput)
      {
        println("  ruleNames  = _ruleNames;");
        println("  semPredNames = _semPredNames;");
        println("  setupDebugging();");
      }
      println("caseSensitiveLiterals = " + paramLexerGrammar.caseSensitiveLiterals + ";");
      println("setCaseSensitive(" + paramLexerGrammar.caseSensitive + ");");
      println("literals = new Hashtable();");
      Object localObject4 = this.grammar.tokenManager.getTokenSymbolKeys();
      Object localObject6;
      while (((Enumeration)localObject4).hasMoreElements())
      {
        localObject5 = (String)((Enumeration)localObject4).nextElement();
        if (((String)localObject5).charAt(0) != '"')
          continue;
        TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol((String)localObject5);
        if (!(localTokenSymbol instanceof StringLiteralSymbol))
          continue;
        localObject6 = (StringLiteralSymbol)localTokenSymbol;
        println("literals.put(new ANTLRHashString(" + ((StringLiteralSymbol)localObject6).getId() + ", this), new Integer(" + ((StringLiteralSymbol)localObject6).getTokenType() + "));");
      }
      this.tabs -= 1;
      println("}");
      if (this.grammar.debuggingOutput)
      {
        println("private static final String _ruleNames[] = {");
        localObject5 = this.grammar.rules.elements();
        j = 0;
        while (((Enumeration)localObject5).hasMoreElements())
        {
          localObject6 = (GrammarSymbol)((Enumeration)localObject5).nextElement();
          if (!(localObject6 instanceof RuleSymbol))
            continue;
          println("  \"" + ((RuleSymbol)localObject6).getId() + "\",");
        }
        println("};");
      }
      genNextToken();
      Object localObject5 = this.grammar.rules.elements();
      int j = 0;
      while (((Enumeration)localObject5).hasMoreElements())
      {
        localObject6 = (RuleSymbol)((Enumeration)localObject5).nextElement();
        if (!((RuleSymbol)localObject6).getId().equals("mnextToken"))
          genRule((RuleSymbol)localObject6, false, j++);
        exitIfError();
      }
      if (this.grammar.debuggingOutput)
        genSemPredMap();
      genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
      println("");
      println("}");
      getPrintWriterManager().finishOutput();
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(OneOrMoreBlock paramOneOrMoreBlock)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramOneOrMoreBlock.getLine();
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("gen+(" + paramOneOrMoreBlock + ")");
      println("{", -999);
      genBlockPreamble(paramOneOrMoreBlock);
      String str2;
      if (paramOneOrMoreBlock.getLabel() != null)
        str2 = "_cnt_" + paramOneOrMoreBlock.getLabel();
      else
        str2 = "_cnt" + paramOneOrMoreBlock.ID;
      println("int " + str2 + "=0;");
      String str1;
      if (paramOneOrMoreBlock.getLabel() != null)
        str1 = paramOneOrMoreBlock.getLabel();
      else
        str1 = "_loop" + paramOneOrMoreBlock.ID;
      println(str1 + ":");
      println("do {");
      this.tabs += 1;
      genBlockInitAction(paramOneOrMoreBlock);
      String str3 = this.currentASTResult;
      if (paramOneOrMoreBlock.getLabel() != null)
        this.currentASTResult = paramOneOrMoreBlock.getLabel();
      boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramOneOrMoreBlock);
      int j = 0;
      int k = this.grammar.maxk;
      if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramOneOrMoreBlock.exitCache[paramOneOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
      {
        j = 1;
        k = paramOneOrMoreBlock.exitLookaheadDepth;
      }
      else if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth == 2147483647))
      {
        j = 1;
      }
      if (j != 0)
      {
        if (this.DEBUG_CODE_GENERATOR)
          System.out.println("nongreedy (...)+ loop; exit depth is " + paramOneOrMoreBlock.exitLookaheadDepth);
        localObject1 = getLookaheadTestExpression(paramOneOrMoreBlock.exitCache, k);
        println("// nongreedy exit test", -999);
        println("if ( " + str2 + ">=1 && " + (String)localObject1 + ") break " + str1 + ";", -888);
      }
      Object localObject1 = genCommonBlock(paramOneOrMoreBlock, false);
      genBlockFinish((JavaBlockFinishingInfo)localObject1, "if ( " + str2 + ">=1 ) { break " + str1 + "; } else {" + this.throwNoViable + "}", paramOneOrMoreBlock.getLine());
      println(str2 + "++;");
      this.tabs -= 1;
      println("} while (true);");
      println("}");
      this.currentASTResult = str3;
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(ParserGrammar paramParserGrammar)
    throws IOException
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      if (paramParserGrammar.debuggingOutput)
        this.semPreds = new Vector();
      setGrammar(paramParserGrammar);
      if (!(this.grammar instanceof ParserGrammar))
        this.antlrTool.panic("Internal error generating parser");
      this.currentOutput = getPrintWriterManager().setupOutput(this.antlrTool, this.grammar);
      this.genAST = this.grammar.buildAST;
      this.tabs = 0;
      genHeader();
      try
      {
        this.defaultLine = this.behavior.getHeaderActionLine("");
        println(this.behavior.getHeaderAction(""));
      }
      finally
      {
        this.defaultLine = -999;
      }
      println("import antlr.TokenBuffer;");
      println("import antlr.TokenStreamException;");
      println("import antlr.TokenStreamIOException;");
      println("import antlr.ANTLRException;");
      println("import antlr." + this.grammar.getSuperClass() + ";");
      println("import antlr.Token;");
      println("import antlr.TokenStream;");
      println("import antlr.RecognitionException;");
      println("import antlr.NoViableAltException;");
      println("import antlr.MismatchedTokenException;");
      println("import antlr.SemanticException;");
      println("import antlr.ParserSharedInputState;");
      println("import antlr.collections.impl.BitSet;");
      if (this.genAST)
      {
        println("import antlr.collections.AST;");
        println("import java.util.Hashtable;");
        println("import antlr.ASTFactory;");
        println("import antlr.ASTPair;");
        println("import antlr.collections.impl.ASTArray;");
      }
      println(this.grammar.preambleAction.getText());
      String str = null;
      if (this.grammar.superClass != null)
        str = this.grammar.superClass;
      else
        str = "antlr." + this.grammar.getSuperClass();
      if (this.grammar.comment != null)
        _println(this.grammar.comment);
      Object localObject2 = "public";
      Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
      if (localToken != null)
      {
        localObject3 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
        if (localObject3 != null)
          localObject2 = localObject3;
      }
      print((String)localObject2 + " ");
      print("class " + this.grammar.getClassName() + " extends " + str);
      println("       implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
      Object localObject3 = (Token)this.grammar.options.get("classHeaderSuffix");
      if (localObject3 != null)
      {
        localObject4 = StringUtils.stripFrontBack(((Token)localObject3).getText(), "\"", "\"");
        if (localObject4 != null)
          print(", " + (String)localObject4);
      }
      println(" {");
      GrammarSymbol localGrammarSymbol;
      if (this.grammar.debuggingOutput)
      {
        println("private static final String _ruleNames[] = {");
        localObject4 = this.grammar.rules.elements();
        j = 0;
        while (((Enumeration)localObject4).hasMoreElements())
        {
          localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject4).nextElement();
          if (!(localGrammarSymbol instanceof RuleSymbol))
            continue;
          println("  \"" + ((RuleSymbol)localGrammarSymbol).getId() + "\",");
        }
        println("};");
      }
      print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null), this.grammar.classMemberAction.getLine());
      println("");
      println("protected " + this.grammar.getClassName() + "(TokenBuffer tokenBuf, int k) {");
      println("  super(tokenBuf,k);");
      println("  tokenNames = _tokenNames;");
      if (this.grammar.debuggingOutput)
      {
        println("  ruleNames  = _ruleNames;");
        println("  semPredNames = _semPredNames;");
        println("  setupDebugging(tokenBuf);");
      }
      if (this.grammar.buildAST)
      {
        println("  buildTokenTypeASTClassMap();");
        println("  astFactory = new ASTFactory(getTokenTypeToASTClassMap());");
      }
      println("}");
      println("");
      println("public " + this.grammar.getClassName() + "(TokenBuffer tokenBuf) {");
      println("  this(tokenBuf," + this.grammar.maxk + ");");
      println("}");
      println("");
      println("protected " + this.grammar.getClassName() + "(TokenStream lexer, int k) {");
      println("  super(lexer,k);");
      println("  tokenNames = _tokenNames;");
      if (this.grammar.debuggingOutput)
      {
        println("  ruleNames  = _ruleNames;");
        println("  semPredNames = _semPredNames;");
        println("  setupDebugging(lexer);");
      }
      if (this.grammar.buildAST)
      {
        println("  buildTokenTypeASTClassMap();");
        println("  astFactory = new ASTFactory(getTokenTypeToASTClassMap());");
      }
      println("}");
      println("");
      println("public " + this.grammar.getClassName() + "(TokenStream lexer) {");
      println("  this(lexer," + this.grammar.maxk + ");");
      println("}");
      println("");
      println("public " + this.grammar.getClassName() + "(ParserSharedInputState state) {");
      println("  super(state," + this.grammar.maxk + ");");
      println("  tokenNames = _tokenNames;");
      if (this.grammar.buildAST)
      {
        println("  buildTokenTypeASTClassMap();");
        println("  astFactory = new ASTFactory(getTokenTypeToASTClassMap());");
      }
      println("}");
      println("");
      Object localObject4 = this.grammar.rules.elements();
      int j = 0;
      while (((Enumeration)localObject4).hasMoreElements())
      {
        localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject4).nextElement();
        if ((localGrammarSymbol instanceof RuleSymbol))
        {
          RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
          genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, j++);
        }
        exitIfError();
      }
      genTokenStrings();
      if (this.grammar.buildAST)
        genTokenASTNodeMap();
      genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
      if (this.grammar.debuggingOutput)
        genSemPredMap();
      println("");
      println("}");
      getPrintWriterManager().finishOutput();
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(RuleRefElement paramRuleRefElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramRuleRefElement.getLine();
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("genRR(" + paramRuleRefElement + ")");
      RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
      if ((localRuleSymbol == null) || (!localRuleSymbol.isDefined()))
      {
        this.antlrTool.error("Rule '" + paramRuleRefElement.targetRule + "' is not defined", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
        return;
      }
      if (!(localRuleSymbol instanceof RuleSymbol))
      {
        this.antlrTool.error("'" + paramRuleRefElement.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
        return;
      }
      genErrorTryForElement(paramRuleRefElement);
      if (((this.grammar instanceof TreeWalkerGrammar)) && (paramRuleRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
        println(paramRuleRefElement.getLabel() + " = _t==ASTNULL ? null : " + this.lt1Value + ";");
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
        println("_saveIndex=text.length();");
      printTabs();
      if (paramRuleRefElement.idAssign != null)
      {
        if (localRuleSymbol.block.returnAction == null)
          this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' has no return type", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
        _print(paramRuleRefElement.idAssign + "=");
      }
      else if ((!(this.grammar instanceof LexerGrammar)) && (this.syntacticPredLevel == 0) && (localRuleSymbol.block.returnAction != null))
      {
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' returns a value", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      }
      GenRuleInvocation(paramRuleRefElement);
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
        println("text.setLength(_saveIndex);");
      if (this.syntacticPredLevel == 0)
      {
        int j = (this.grammar.hasSyntacticPredicate) && (((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null)) || ((this.genAST) && (paramRuleRefElement.getAutoGenType() == 1))) ? 1 : 0;
        if ((j == 0) || ((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null)))
          println(paramRuleRefElement.getLabel() + "_AST = (" + this.labeledElementASTType + ")returnAST;");
        if (this.genAST)
          switch (paramRuleRefElement.getAutoGenType())
          {
          case 1:
            println("astFactory.addASTChild(currentAST, returnAST);");
            break;
          case 2:
            this.antlrTool.error("Internal: encountered ^ after rule reference");
            break;
          }
        if (((this.grammar instanceof LexerGrammar)) && (paramRuleRefElement.getLabel() != null))
          println(paramRuleRefElement.getLabel() + "=_returnToken;");
        if (j == 0);
      }
      genErrorCatchForElement(paramRuleRefElement);
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(StringLiteralElement paramStringLiteralElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genString(" + paramStringLiteralElement + ")");
    if ((paramStringLiteralElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramStringLiteralElement.getLabel() + " = " + this.lt1Value + ";", paramStringLiteralElement.getLine());
    genElementAST(paramStringLiteralElement);
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramStringLiteralElement.getAutoGenType() == 1));
    genMatch(paramStringLiteralElement);
    this.saveText = bool;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling();", paramStringLiteralElement.getLine());
  }

  public void gen(TokenRangeElement paramTokenRangeElement)
  {
    genErrorTryForElement(paramTokenRangeElement);
    if ((paramTokenRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRangeElement.getLabel() + " = " + this.lt1Value + ";", paramTokenRangeElement.getLine());
    genElementAST(paramTokenRangeElement);
    println("matchRange(" + paramTokenRangeElement.beginText + "," + paramTokenRangeElement.endText + ");", paramTokenRangeElement.getLine());
    genErrorCatchForElement(paramTokenRangeElement);
  }

  public void gen(TokenRefElement paramTokenRefElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genTokenRef(" + paramTokenRefElement + ")");
    if ((this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Token reference found in lexer");
    genErrorTryForElement(paramTokenRefElement);
    if ((paramTokenRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRefElement.getLabel() + " = " + this.lt1Value + ";", paramTokenRefElement.getLine());
    genElementAST(paramTokenRefElement);
    genMatch(paramTokenRefElement);
    genErrorCatchForElement(paramTokenRefElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling();", paramTokenRefElement.getLine());
  }

  public void gen(TreeElement paramTreeElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramTreeElement.getLine();
      println("AST __t" + paramTreeElement.ID + " = _t;");
      if (paramTreeElement.root.getLabel() != null)
        println(paramTreeElement.root.getLabel() + " = _t==ASTNULL ? null :(" + this.labeledElementASTType + ")_t;", paramTreeElement.root.getLine());
      if (paramTreeElement.root.getAutoGenType() == 3)
      {
        this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
        paramTreeElement.root.setAutoGenType(1);
      }
      if (paramTreeElement.root.getAutoGenType() == 2)
      {
        this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
        paramTreeElement.root.setAutoGenType(1);
      }
      genElementAST(paramTreeElement.root);
      if (this.grammar.buildAST)
      {
        println("ASTPair __currentAST" + paramTreeElement.ID + " = currentAST.copy();");
        println("currentAST.root = currentAST.child;");
        println("currentAST.child = null;");
      }
      if ((paramTreeElement.root instanceof WildcardElement))
        println("if ( _t==null ) throw new MismatchedTokenException();", paramTreeElement.root.getLine());
      else
        genMatch(paramTreeElement.root);
      println("_t = _t.getFirstChild();");
      for (int j = 0; j < paramTreeElement.getAlternatives().size(); j++)
      {
        Alternative localAlternative = paramTreeElement.getAlternativeAt(j);
        for (AlternativeElement localAlternativeElement = localAlternative.head; localAlternativeElement != null; localAlternativeElement = localAlternativeElement.next)
          localAlternativeElement.generate();
      }
      if (this.grammar.buildAST)
        println("currentAST = __currentAST" + paramTreeElement.ID + ";");
      println("_t = __t" + paramTreeElement.ID + ";");
      println("_t = _t.getNextSibling();");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      setGrammar(paramTreeWalkerGrammar);
      if (!(this.grammar instanceof TreeWalkerGrammar))
        this.antlrTool.panic("Internal error generating tree-walker");
      this.currentOutput = getPrintWriterManager().setupOutput(this.antlrTool, this.grammar);
      this.genAST = this.grammar.buildAST;
      this.tabs = 0;
      genHeader();
      try
      {
        this.defaultLine = this.behavior.getHeaderActionLine("");
        println(this.behavior.getHeaderAction(""));
      }
      finally
      {
        this.defaultLine = -999;
      }
      println("import antlr." + this.grammar.getSuperClass() + ";");
      println("import antlr.Token;");
      println("import antlr.collections.AST;");
      println("import antlr.RecognitionException;");
      println("import antlr.ANTLRException;");
      println("import antlr.NoViableAltException;");
      println("import antlr.MismatchedTokenException;");
      println("import antlr.SemanticException;");
      println("import antlr.collections.impl.BitSet;");
      println("import antlr.ASTPair;");
      println("import antlr.collections.impl.ASTArray;");
      println(this.grammar.preambleAction.getText());
      String str1 = null;
      if (this.grammar.superClass != null)
        str1 = this.grammar.superClass;
      else
        str1 = "antlr." + this.grammar.getSuperClass();
      println("");
      if (this.grammar.comment != null)
        _println(this.grammar.comment);
      Object localObject2 = "public";
      Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
      if (localToken != null)
      {
        localObject3 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
        if (localObject3 != null)
          localObject2 = localObject3;
      }
      print((String)localObject2 + " ");
      print("class " + this.grammar.getClassName() + " extends " + str1);
      println("       implements " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
      Object localObject3 = (Token)this.grammar.options.get("classHeaderSuffix");
      if (localObject3 != null)
      {
        localObject4 = StringUtils.stripFrontBack(((Token)localObject3).getText(), "\"", "\"");
        if (localObject4 != null)
          print(", " + (String)localObject4);
      }
      println(" {");
      print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null), this.grammar.classMemberAction.getLine());
      println("public " + this.grammar.getClassName() + "() {");
      this.tabs += 1;
      println("tokenNames = _tokenNames;");
      this.tabs -= 1;
      println("}");
      println("");
      Object localObject4 = this.grammar.rules.elements();
      int j = 0;
      String str2 = "";
      while (((Enumeration)localObject4).hasMoreElements())
      {
        GrammarSymbol localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject4).nextElement();
        if ((localGrammarSymbol instanceof RuleSymbol))
        {
          RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
          genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, j++);
        }
        exitIfError();
      }
      genTokenStrings();
      genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
      println("}");
      println("");
      getPrintWriterManager().finishOutput();
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(WildcardElement paramWildcardElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramWildcardElement.getLine();
      if ((paramWildcardElement.getLabel() != null) && (this.syntacticPredLevel == 0))
        println(paramWildcardElement.getLabel() + " = " + this.lt1Value + ";");
      genElementAST(paramWildcardElement);
      if ((this.grammar instanceof TreeWalkerGrammar))
      {
        println("if ( _t==null ) throw new MismatchedTokenException();");
      }
      else if ((this.grammar instanceof LexerGrammar))
      {
        if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
          println("_saveIndex=text.length();");
        println("matchNot(EOF_CHAR);");
        if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
          println("text.setLength(_saveIndex);");
      }
      else
      {
        println("matchNot(" + getValueString(1) + ");");
      }
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_t = _t.getNextSibling();");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void gen(ZeroOrMoreBlock paramZeroOrMoreBlock)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramZeroOrMoreBlock.getLine();
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("gen*(" + paramZeroOrMoreBlock + ")");
      println("{");
      genBlockPreamble(paramZeroOrMoreBlock);
      String str1;
      if (paramZeroOrMoreBlock.getLabel() != null)
        str1 = paramZeroOrMoreBlock.getLabel();
      else
        str1 = "_loop" + paramZeroOrMoreBlock.ID;
      println(str1 + ":");
      println("do {");
      this.tabs += 1;
      genBlockInitAction(paramZeroOrMoreBlock);
      String str2 = this.currentASTResult;
      if (paramZeroOrMoreBlock.getLabel() != null)
        this.currentASTResult = paramZeroOrMoreBlock.getLabel();
      boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramZeroOrMoreBlock);
      int j = 0;
      int k = this.grammar.maxk;
      if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramZeroOrMoreBlock.exitCache[paramZeroOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
      {
        j = 1;
        k = paramZeroOrMoreBlock.exitLookaheadDepth;
      }
      else if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth == 2147483647))
      {
        j = 1;
      }
      if (j != 0)
      {
        if (this.DEBUG_CODE_GENERATOR)
          System.out.println("nongreedy (...)* loop; exit depth is " + paramZeroOrMoreBlock.exitLookaheadDepth);
        localObject1 = getLookaheadTestExpression(paramZeroOrMoreBlock.exitCache, k);
        println("// nongreedy exit test");
        println("if (" + (String)localObject1 + ") break " + str1 + ";");
      }
      Object localObject1 = genCommonBlock(paramZeroOrMoreBlock, false);
      genBlockFinish((JavaBlockFinishingInfo)localObject1, "break " + str1 + ";", paramZeroOrMoreBlock.getLine());
      this.tabs -= 1;
      println("} while (true);");
      println("}");
      this.currentASTResult = str2;
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  protected void genAlt(Alternative paramAlternative, AlternativeBlock paramAlternativeBlock)
  {
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternative.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternative.getAutoGen()));
    Hashtable localHashtable = this.treeVariableMap;
    this.treeVariableMap = new Hashtable();
    if (paramAlternative.exceptionSpec != null)
    {
      println("try {      // for error handling", paramAlternative.head.getLine());
      this.tabs += 1;
    }
    for (AlternativeElement localAlternativeElement = paramAlternative.head; !(localAlternativeElement instanceof BlockEndElement); localAlternativeElement = localAlternativeElement.next)
      localAlternativeElement.generate();
    if (this.genAST)
      if ((paramAlternativeBlock instanceof RuleBlock))
      {
        RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
        if (this.grammar.hasSyntacticPredicate);
        println(localRuleBlock.getRuleName() + "_AST = (" + this.labeledElementASTType + ")currentAST.root;", -888);
        if (!this.grammar.hasSyntacticPredicate);
      }
      else if (paramAlternativeBlock.getLabel() != null)
      {
        this.antlrTool.warning("Labeled subrules not yet supported", this.grammar.getFilename(), paramAlternativeBlock.getLine(), paramAlternativeBlock.getColumn());
      }
    if (paramAlternative.exceptionSpec != null)
    {
      this.tabs -= 1;
      println("}", -999);
      genErrorHandler(paramAlternative.exceptionSpec);
    }
    this.genAST = bool1;
    this.saveText = bool2;
    this.treeVariableMap = localHashtable;
  }

  protected void genBitsets(Vector paramVector, int paramInt)
  {
    println("", -999);
    for (int i = 0; i < paramVector.size(); i++)
    {
      BitSet localBitSet = (BitSet)paramVector.elementAt(i);
      localBitSet.growToInclude(paramInt);
      genBitSet(localBitSet, i);
    }
  }

  private void genBitSet(BitSet paramBitSet, int paramInt)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      println("private static final long[] mk" + getBitsetName(paramInt) + "() {");
      int j = paramBitSet.lengthInLongWords();
      if (j < 8)
      {
        println("\tlong[] data = { " + paramBitSet.toStringOfWords() + "};");
      }
      else
      {
        println("\tlong[] data = new long[" + j + "];");
        long[] arrayOfLong = paramBitSet.toPackedArray();
        int k = 0;
        while (k < arrayOfLong.length)
        {
          if (arrayOfLong[k] == 0L)
          {
            k++;
            continue;
          }
          if ((k + 1 == arrayOfLong.length) || (arrayOfLong[k] != arrayOfLong[(k + 1)]))
          {
            println("\tdata[" + k + "]=" + arrayOfLong[k] + "L;");
            k++;
            continue;
          }
          for (int m = k + 1; (m < arrayOfLong.length) && (arrayOfLong[m] == arrayOfLong[k]); m++);
          println("\tfor (int i = " + k + "; i<=" + (m - 1) + "; i++) { data[i]=" + arrayOfLong[k] + "L; }");
          k = m;
        }
      }
      println("\treturn data;");
      println("}");
      println("public static final BitSet " + getBitsetName(paramInt) + " = new BitSet(" + "mk" + getBitsetName(paramInt) + "()" + ");");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  private void genBlockFinish(JavaBlockFinishingInfo paramJavaBlockFinishingInfo, String paramString, int paramInt)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramInt;
      if ((paramJavaBlockFinishingInfo.needAnErrorClause) && ((paramJavaBlockFinishingInfo.generatedAnIf) || (paramJavaBlockFinishingInfo.generatedSwitch)))
      {
        if (paramJavaBlockFinishingInfo.generatedAnIf)
          println("else {");
        else
          println("{");
        this.tabs += 1;
        println(paramString);
        this.tabs -= 1;
        println("}");
      }
      if (paramJavaBlockFinishingInfo.postscript != null)
        println(paramJavaBlockFinishingInfo.postscript);
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  protected void genBlockInitAction(AlternativeBlock paramAlternativeBlock)
  {
    if (paramAlternativeBlock.initAction != null)
      printAction(processActionForSpecialSymbols(paramAlternativeBlock.initAction, paramAlternativeBlock.getLine(), this.currentRule, null), paramAlternativeBlock.getLine());
  }

  protected void genBlockPreamble(AlternativeBlock paramAlternativeBlock)
  {
    if ((paramAlternativeBlock instanceof RuleBlock))
    {
      RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
      if (localRuleBlock.labeledElements != null)
        for (int i = 0; i < localRuleBlock.labeledElements.size(); i++)
        {
          AlternativeElement localAlternativeElement = (AlternativeElement)localRuleBlock.labeledElements.elementAt(i);
          int j = this.defaultLine;
          try
          {
            this.defaultLine = localAlternativeElement.getLine();
            if (((localAlternativeElement instanceof RuleRefElement)) || (((localAlternativeElement instanceof AlternativeBlock)) && (!(localAlternativeElement instanceof RuleBlock)) && (!(localAlternativeElement instanceof SynPredBlock))))
            {
              if ((!(localAlternativeElement instanceof RuleRefElement)) && (((AlternativeBlock)localAlternativeElement).not) && (this.analyzer.subruleCanBeInverted((AlternativeBlock)localAlternativeElement, this.grammar instanceof LexerGrammar)))
              {
                println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
                if (this.grammar.buildAST)
                  genASTDeclaration(localAlternativeElement);
              }
              else
              {
                if (this.grammar.buildAST)
                  genASTDeclaration(localAlternativeElement);
                if ((this.grammar instanceof LexerGrammar))
                  println("Token " + localAlternativeElement.getLabel() + "=null;");
                if ((this.grammar instanceof TreeWalkerGrammar))
                  println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
              }
            }
            else
            {
              println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
              if (this.grammar.buildAST)
                if (((localAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)localAlternativeElement).getASTNodeType() != null))
                {
                  GrammarAtom localGrammarAtom = (GrammarAtom)localAlternativeElement;
                  genASTDeclaration(localAlternativeElement, localGrammarAtom.getASTNodeType());
                }
                else
                {
                  genASTDeclaration(localAlternativeElement);
                }
            }
          }
          finally
          {
            this.defaultLine = j;
          }
        }
    }
  }

  protected void genCases(BitSet paramBitSet, int paramInt)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramInt;
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("genCases(" + paramBitSet + ")");
      int[] arrayOfInt = paramBitSet.toArray();
      int j = (this.grammar instanceof LexerGrammar) ? 4 : 1;
      int k = 1;
      int m = 1;
      for (int n = 0; n < arrayOfInt.length; n++)
      {
        if (k == 1)
          print("");
        else
          _print("  ");
        _print("case " + getValueString(arrayOfInt[n]) + ":");
        if (k == j)
        {
          _println("");
          m = 1;
          k = 1;
        }
        else
        {
          k++;
          m = 0;
        }
      }
      if (m == 0)
        _println("");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public JavaBlockFinishingInfo genCommonBlock(AlternativeBlock paramAlternativeBlock, boolean paramBoolean)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramAlternativeBlock.getLine();
      int j = 0;
      int k = 0;
      int m = 0;
      JavaBlockFinishingInfo localJavaBlockFinishingInfo1 = new JavaBlockFinishingInfo();
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("genCommonBlock(" + paramAlternativeBlock + ")");
      boolean bool1 = this.genAST;
      this.genAST = ((this.genAST) && (paramAlternativeBlock.getAutoGen()));
      boolean bool2 = this.saveText;
      this.saveText = ((this.saveText) && (paramAlternativeBlock.getAutoGen()));
      Object localObject1;
      Object localObject2;
      Object localObject3;
      if ((paramAlternativeBlock.not) && (this.analyzer.subruleCanBeInverted(paramAlternativeBlock, this.grammar instanceof LexerGrammar)))
      {
        if (this.DEBUG_CODE_GENERATOR)
          System.out.println("special case: ~(subrule)");
        localObject1 = this.analyzer.look(1, paramAlternativeBlock);
        if ((paramAlternativeBlock.getLabel() != null) && (this.syntacticPredLevel == 0))
          println(paramAlternativeBlock.getLabel() + " = " + this.lt1Value + ";");
        genElementAST(paramAlternativeBlock);
        localObject2 = "";
        if ((this.grammar instanceof TreeWalkerGrammar))
          localObject2 = "_t,";
        println("match(" + (String)localObject2 + getBitsetName(markBitsetForGen(((Lookahead)localObject1).fset)) + ");");
        if ((this.grammar instanceof TreeWalkerGrammar))
          println("_t = _t.getNextSibling();");
        localObject3 = localJavaBlockFinishingInfo1;
        return localObject3;
      }
      if (paramAlternativeBlock.getAlternatives().size() == 1)
      {
        localObject1 = paramAlternativeBlock.getAlternativeAt(0);
        if (((Alternative)localObject1).synPred != null)
          this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), paramAlternativeBlock.getAlternativeAt(0).synPred.getLine(), paramAlternativeBlock.getAlternativeAt(0).synPred.getColumn());
        if (paramBoolean)
        {
          if (((Alternative)localObject1).semPred != null)
            genSemPred(((Alternative)localObject1).semPred, paramAlternativeBlock.line);
          genAlt((Alternative)localObject1, paramAlternativeBlock);
          localObject2 = localJavaBlockFinishingInfo1;
          return localObject2;
        }
      }
      int n = 0;
      for (int i1 = 0; i1 < paramAlternativeBlock.getAlternatives().size(); i1++)
      {
        localObject3 = paramAlternativeBlock.getAlternativeAt(i1);
        if (!suitableForCaseExpression((Alternative)localObject3))
          continue;
        n++;
      }
      Object localObject4;
      if (n >= this.makeSwitchThreshold)
      {
        String str1 = lookaheadString(1);
        k = 1;
        if ((this.grammar instanceof TreeWalkerGrammar))
          println("if (_t==null) _t=ASTNULL;");
        println("switch ( " + str1 + ") {");
        for (i3 = 0; i3 < paramAlternativeBlock.alternatives.size(); i3++)
        {
          Alternative localAlternative = paramAlternativeBlock.getAlternativeAt(i3);
          if (!suitableForCaseExpression(localAlternative))
            continue;
          localObject4 = localAlternative.cache[1];
          if ((((Lookahead)localObject4).fset.degree() == 0) && (!((Lookahead)localObject4).containsEpsilon()))
          {
            this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), localAlternative.head.getLine(), localAlternative.head.getColumn());
          }
          else
          {
            genCases(((Lookahead)localObject4).fset, localAlternative.head.getLine());
            println("{", localAlternative.head.getLine());
            this.tabs += 1;
            genAlt(localAlternative, paramAlternativeBlock);
            println("break;", -999);
            this.tabs -= 1;
            println("}", -999);
          }
        }
        println("default:");
        this.tabs += 1;
      }
      int i2 = (this.grammar instanceof LexerGrammar) ? this.grammar.maxk : 0;
      for (int i3 = i2; i3 >= 0; i3--)
      {
        if (this.DEBUG_CODE_GENERATOR)
          System.out.println("checking depth " + i3);
        for (i4 = 0; i4 < paramAlternativeBlock.alternatives.size(); i4++)
        {
          localObject4 = paramAlternativeBlock.getAlternativeAt(i4);
          if (this.DEBUG_CODE_GENERATOR)
            System.out.println("genAlt: " + i4);
          if ((k != 0) && (suitableForCaseExpression((Alternative)localObject4)))
          {
            if (!this.DEBUG_CODE_GENERATOR)
              continue;
            System.out.println("ignoring alt because it was in the switch");
          }
          else
          {
            boolean bool3 = false;
            String str3;
            if ((this.grammar instanceof LexerGrammar))
            {
              i5 = ((Alternative)localObject4).lookaheadDepth;
              if (i5 == 2147483647);
              for (i5 = this.grammar.maxk; (i5 >= 1) && (localObject4.cache[i5].containsEpsilon()); i5--);
              if (i5 != i3)
              {
                if (!this.DEBUG_CODE_GENERATOR)
                  continue;
                System.out.println("ignoring alt because effectiveDepth!=altDepth;" + i5 + "!=" + i3);
                continue;
              }
              bool3 = lookaheadIsEmpty((Alternative)localObject4, i5);
              str3 = getLookaheadTestExpression((Alternative)localObject4, i5);
            }
            else
            {
              bool3 = lookaheadIsEmpty((Alternative)localObject4, this.grammar.maxk);
              str3 = getLookaheadTestExpression((Alternative)localObject4, this.grammar.maxk);
            }
            int i5 = this.defaultLine;
            try
            {
              this.defaultLine = ((Alternative)localObject4).head.getLine();
              if ((localObject4.cache[1].fset.degree() > 127) && (suitableForCaseExpression((Alternative)localObject4)))
              {
                if (j == 0)
                  println("if " + str3 + " {");
                else
                  println("else if " + str3 + " {");
              }
              else if ((bool3) && (((Alternative)localObject4).semPred == null) && (((Alternative)localObject4).synPred == null))
              {
                if (j == 0)
                  println("{");
                else
                  println("else {");
                localJavaBlockFinishingInfo1.needAnErrorClause = false;
              }
              else
              {
                if (((Alternative)localObject4).semPred != null)
                {
                  ActionTransInfo localActionTransInfo = new ActionTransInfo();
                  String str4 = processActionForSpecialSymbols(((Alternative)localObject4).semPred, paramAlternativeBlock.line, this.currentRule, localActionTransInfo);
                  if ((((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))) && (this.grammar.debuggingOutput))
                    str3 = "(" + str3 + "&& fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING," + addSemPred(this.charFormatter.escapeString(str4)) + "," + str4 + "))";
                  else
                    str3 = "(" + str3 + "&&(" + str4 + "))";
                }
                if (j > 0)
                {
                  if (((Alternative)localObject4).synPred != null)
                  {
                    println("else {", ((Alternative)localObject4).synPred.getLine());
                    this.tabs += 1;
                    genSynPred(((Alternative)localObject4).synPred, str3);
                    m++;
                  }
                  else
                  {
                    println("else if " + str3 + " {");
                  }
                }
                else if (((Alternative)localObject4).synPred != null)
                {
                  genSynPred(((Alternative)localObject4).synPred, str3);
                }
                else
                {
                  if ((this.grammar instanceof TreeWalkerGrammar))
                    println("if (_t==null) _t=ASTNULL;");
                  println("if " + str3 + " {");
                }
              }
            }
            finally
            {
              this.defaultLine = i5;
            }
            j++;
            this.tabs += 1;
            genAlt((Alternative)localObject4, paramAlternativeBlock);
            this.tabs -= 1;
            println("}");
          }
        }
      }
      String str2 = "";
      for (int i4 = 1; i4 <= m; i4++)
        str2 = str2 + "}";
      this.genAST = bool1;
      this.saveText = bool2;
      if (k != 0)
      {
        this.tabs -= 1;
        localJavaBlockFinishingInfo1.postscript = (str2 + "}");
        localJavaBlockFinishingInfo1.generatedSwitch = true;
        localJavaBlockFinishingInfo1.generatedAnIf = (j > 0);
      }
      else
      {
        localJavaBlockFinishingInfo1.postscript = str2;
        localJavaBlockFinishingInfo1.generatedSwitch = false;
        localJavaBlockFinishingInfo1.generatedAnIf = (j > 0);
      }
      JavaBlockFinishingInfo localJavaBlockFinishingInfo2 = localJavaBlockFinishingInfo1;
      return localJavaBlockFinishingInfo2;
    }
    finally
    {
      this.defaultLine = i;
    }
    throw localObject6;
  }

  private static boolean suitableForCaseExpression(Alternative paramAlternative)
  {
    return (paramAlternative.lookaheadDepth == 1) && (paramAlternative.semPred == null) && (!paramAlternative.cache[1].containsEpsilon()) && (paramAlternative.cache[1].fset.degree() <= 127);
  }

  private void genElementAST(AlternativeElement paramAlternativeElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramAlternativeElement.getLine();
      if (((this.grammar instanceof TreeWalkerGrammar)) && (!this.grammar.buildAST))
      {
        if (paramAlternativeElement.getLabel() == null)
        {
          String str1 = this.lt1Value;
          String str2 = "tmp" + this.astVarNumber + "_AST";
          this.astVarNumber += 1;
          mapTreeVariable(paramAlternativeElement, str2);
          println(this.labeledElementASTType + " " + str2 + "_in = " + str1 + ";");
        }
        return;
      }
      if ((this.grammar.buildAST) && (this.syntacticPredLevel == 0))
      {
        int j = (this.genAST) && ((paramAlternativeElement.getLabel() != null) || (paramAlternativeElement.getAutoGenType() != 3)) ? 1 : 0;
        if ((paramAlternativeElement.getAutoGenType() != 3) && ((paramAlternativeElement instanceof TokenRefElement)))
          j = 1;
        int k = (this.grammar.hasSyntacticPredicate) && (j != 0) ? 1 : 0;
        String str3;
        String str4;
        if (paramAlternativeElement.getLabel() != null)
        {
          str3 = paramAlternativeElement.getLabel();
          str4 = paramAlternativeElement.getLabel();
        }
        else
        {
          str3 = this.lt1Value;
          str4 = "tmp" + this.astVarNumber;
          this.astVarNumber += 1;
        }
        if (j != 0)
          if ((paramAlternativeElement instanceof GrammarAtom))
          {
            localObject1 = (GrammarAtom)paramAlternativeElement;
            if (((GrammarAtom)localObject1).getASTNodeType() != null)
              genASTDeclaration(paramAlternativeElement, str4, ((GrammarAtom)localObject1).getASTNodeType());
            else
              genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
          }
          else
          {
            genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
          }
        Object localObject1 = str4 + "_AST";
        mapTreeVariable(paramAlternativeElement, (String)localObject1);
        if ((this.grammar instanceof TreeWalkerGrammar))
          println(this.labeledElementASTType + " " + (String)localObject1 + "_in = null;");
        if ((k == 0) || (paramAlternativeElement.getLabel() != null))
          if ((paramAlternativeElement instanceof GrammarAtom))
            println((String)localObject1 + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + ";");
          else
            println((String)localObject1 + " = " + getASTCreateString(str3) + ";");
        if ((paramAlternativeElement.getLabel() == null) && (j != 0))
        {
          str3 = this.lt1Value;
          if ((paramAlternativeElement instanceof GrammarAtom))
            println((String)localObject1 + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + ";");
          else
            println((String)localObject1 + " = " + getASTCreateString(str3) + ";");
          if ((this.grammar instanceof TreeWalkerGrammar))
            println((String)localObject1 + "_in = " + str3 + ";");
        }
        if (this.genAST)
          switch (paramAlternativeElement.getAutoGenType())
          {
          case 1:
            println("astFactory.addASTChild(currentAST, " + (String)localObject1 + ");");
            break;
          case 2:
            println("astFactory.makeASTRoot(currentAST, " + (String)localObject1 + ");");
            break;
          }
        if (k == 0);
      }
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  private void genErrorCatchForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      this.tabs -= 1;
      println("}", paramAlternativeElement.getLine());
      genErrorHandler(localExceptionSpec);
    }
  }

  private void genErrorHandler(ExceptionSpec paramExceptionSpec)
  {
    for (int i = 0; i < paramExceptionSpec.handlers.size(); i++)
    {
      ExceptionHandler localExceptionHandler = (ExceptionHandler)paramExceptionSpec.handlers.elementAt(i);
      int j = this.defaultLine;
      try
      {
        this.defaultLine = localExceptionHandler.action.getLine();
        println("catch (" + localExceptionHandler.exceptionTypeAndName.getText() + ") {", localExceptionHandler.exceptionTypeAndName.getLine());
        this.tabs += 1;
        if (this.grammar.hasSyntacticPredicate)
        {
          println("if (inputState.guessing==0) {");
          this.tabs += 1;
        }
        ActionTransInfo localActionTransInfo = new ActionTransInfo();
        printAction(processActionForSpecialSymbols(localExceptionHandler.action.getText(), localExceptionHandler.action.getLine(), this.currentRule, localActionTransInfo));
        if (this.grammar.hasSyntacticPredicate)
        {
          this.tabs -= 1;
          println("} else {");
          this.tabs += 1;
          println("throw " + extractIdOfAction(localExceptionHandler.exceptionTypeAndName) + ";");
          this.tabs -= 1;
          println("}");
        }
        this.tabs -= 1;
        println("}");
      }
      finally
      {
        this.defaultLine = j;
      }
    }
  }

  private void genErrorTryForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      println("try { // for error handling", paramAlternativeElement.getLine());
      this.tabs += 1;
    }
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement)
  {
    genASTDeclaration(paramAlternativeElement, this.labeledElementASTType);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString)
  {
    genASTDeclaration(paramAlternativeElement, paramAlternativeElement.getLabel(), paramString);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString1, String paramString2)
  {
    if (this.declaredASTVariables.contains(paramAlternativeElement))
      return;
    println(paramString2 + " " + paramString1 + "_AST = null;");
    this.declaredASTVariables.put(paramAlternativeElement, paramAlternativeElement);
  }

  protected void genHeader()
  {
    println("// $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".java\"$", -999);
  }

  private void genLiteralsTest()
  {
    println("_ttype = testLiteralsTable(_ttype);");
  }

  private void genLiteralsTestForPartialToken()
  {
    println("_ttype = testLiteralsTable(new String(text.getBuffer(),_begin,text.length()-_begin),_ttype);");
  }

  protected void genMatch(BitSet paramBitSet)
  {
  }

  protected void genMatch(GrammarAtom paramGrammarAtom)
  {
    if ((paramGrammarAtom instanceof StringLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        genMatchUsingAtomTokenType(paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof CharLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        this.antlrTool.error("cannot ref character literals in grammar: " + paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof TokenRefElement))
      genMatchUsingAtomText(paramGrammarAtom);
    else if ((paramGrammarAtom instanceof WildcardElement))
      gen((WildcardElement)paramGrammarAtom);
  }

  protected void genMatchUsingAtomText(GrammarAtom paramGrammarAtom)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramGrammarAtom.getLine();
      String str = "";
      if ((this.grammar instanceof TreeWalkerGrammar))
        str = "_t,";
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
        println("_saveIndex=text.length();");
      print(paramGrammarAtom.not ? "matchNot(" : "match(");
      _print(str, -999);
      if (paramGrammarAtom.atomText.equals("EOF"))
        _print("Token.EOF_TYPE");
      else
        _print(paramGrammarAtom.atomText);
      _println(");");
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
        println("text.setLength(_saveIndex);");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  protected void genMatchUsingAtomTokenType(GrammarAtom paramGrammarAtom)
  {
    String str1 = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      str1 = "_t,";
    Object localObject = null;
    String str2 = str1 + getValueString(paramGrammarAtom.getType());
    println((paramGrammarAtom.not ? "matchNot(" : "match(") + str2 + ");", paramGrammarAtom.getLine());
  }

  public void genNextToken()
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      int j = 0;
      for (int k = 0; k < this.grammar.rules.size(); k++)
      {
        localRuleSymbol1 = (RuleSymbol)this.grammar.rules.elementAt(k);
        if ((!localRuleSymbol1.isDefined()) || (!localRuleSymbol1.access.equals("public")))
          continue;
        j = 1;
        break;
      }
      if (j == 0)
      {
        println("");
        println("public Token nextToken() throws TokenStreamException {");
        println("\ttry {uponEOF();}");
        println("\tcatch(CharStreamIOException csioe) {");
        println("\t\tthrow new TokenStreamIOException(csioe.io);");
        println("\t}");
        println("\tcatch(CharStreamException cse) {");
        println("\t\tthrow new TokenStreamException(cse.getMessage());");
        println("\t}");
        println("\treturn new CommonToken(Token.EOF_TYPE, \"\");");
        println("}");
        println("");
        return;
      }
      RuleBlock localRuleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
      RuleSymbol localRuleSymbol1 = new RuleSymbol("mnextToken");
      localRuleSymbol1.setDefined();
      localRuleSymbol1.setBlock(localRuleBlock);
      localRuleSymbol1.access = "private";
      this.grammar.define(localRuleSymbol1);
      boolean bool = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
      String str1 = null;
      if (((LexerGrammar)this.grammar).filterMode)
        str1 = ((LexerGrammar)this.grammar).filterRule;
      println("");
      println("public Token nextToken() throws TokenStreamException {");
      this.tabs += 1;
      println("Token theRetToken=null;");
      _println("tryAgain:");
      println("for (;;) {");
      this.tabs += 1;
      println("Token _token = null;");
      println("int _ttype = Token.INVALID_TYPE;");
      if (((LexerGrammar)this.grammar).filterMode)
      {
        println("setCommitToPath(false);");
        if (str1 != null)
        {
          if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(str1)))
          {
            this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
          }
          else
          {
            RuleSymbol localRuleSymbol2 = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(str1));
            if (!localRuleSymbol2.isDefined())
              this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
            else if (localRuleSymbol2.access.equals("public"))
              this.grammar.antlrTool.error("Filter rule " + str1 + " must be protected");
          }
          println("int _m;");
          println("_m = mark();");
        }
      }
      println("resetText();");
      println("try {   // for char stream error handling");
      this.tabs += 1;
      println("try {   // for lexical error handling");
      this.tabs += 1;
      for (int m = 0; m < localRuleBlock.getAlternatives().size(); m++)
      {
        localObject1 = localRuleBlock.getAlternativeAt(m);
        if (!localObject1.cache[1].containsEpsilon())
          continue;
        localObject2 = (RuleRefElement)((Alternative)localObject1).head;
        String str3 = CodeGenerator.decodeLexerRuleName(((RuleRefElement)localObject2).targetRule);
        this.antlrTool.warning("public lexical rule " + str3 + " is optional (can match \"nothing\")");
      }
      String str2 = System.getProperty("line.separator");
      Object localObject1 = genCommonBlock(localRuleBlock, false);
      Object localObject2 = "if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}";
      localObject2 = (String)localObject2 + str2 + "\t\t\t\t";
      if (((LexerGrammar)this.grammar).filterMode)
      {
        if (str1 == null)
          localObject2 = (String)localObject2 + "else {consume(); continue tryAgain;}";
        else
          localObject2 = (String)localObject2 + "else {" + str2 + "\t\t\t\t\tcommit();" + str2 + "\t\t\t\t\ttry {m" + str1 + "(false);}" + str2 + "\t\t\t\t\tcatch(RecognitionException e) {" + str2 + "\t\t\t\t\t\t// catastrophic failure" + str2 + "\t\t\t\t\t\treportError(e);" + str2 + "\t\t\t\t\t\tconsume();" + str2 + "\t\t\t\t\t}" + str2 + "\t\t\t\t\tcontinue tryAgain;" + str2 + "\t\t\t\t}";
      }
      else
        localObject2 = (String)localObject2 + "else {" + this.throwNoViable + "}";
      genBlockFinish((JavaBlockFinishingInfo)localObject1, (String)localObject2, localRuleBlock.getLine());
      if ((((LexerGrammar)this.grammar).filterMode) && (str1 != null))
        println("commit();");
      println("if ( _returnToken==null ) continue tryAgain; // found SKIP token");
      println("_ttype = _returnToken.getType();");
      if (((LexerGrammar)this.grammar).getTestLiterals())
        genLiteralsTest();
      println("_returnToken.setType(_ttype);");
      println("return _returnToken;");
      this.tabs -= 1;
      println("}");
      println("catch (RecognitionException e) {");
      this.tabs += 1;
      if (((LexerGrammar)this.grammar).filterMode)
        if (str1 == null)
        {
          println("if ( !getCommitToPath() ) {consume(); continue tryAgain;}");
        }
        else
        {
          println("if ( !getCommitToPath() ) {");
          this.tabs += 1;
          println("rewind(_m);");
          println("resetText();");
          println("try {m" + str1 + "(false);}");
          println("catch(RecognitionException ee) {");
          println("\t// horrendous failure: error in filter rule");
          println("\treportError(ee);");
          println("\tconsume();");
          println("}");
          println("continue tryAgain;");
          this.tabs -= 1;
          println("}");
        }
      if (localRuleBlock.getDefaultErrorHandler())
      {
        println("reportError(e);");
        println("consume();");
      }
      else
      {
        println("throw new TokenStreamRecognitionException(e);");
      }
      this.tabs -= 1;
      println("}");
      this.tabs -= 1;
      println("}");
      println("catch (CharStreamException cse) {");
      println("\tif ( cse instanceof CharStreamIOException ) {");
      println("\t\tthrow new TokenStreamIOException(((CharStreamIOException)cse).io);");
      println("\t}");
      println("\telse {");
      println("\t\tthrow new TokenStreamException(cse.getMessage());");
      println("\t}");
      println("}");
      this.tabs -= 1;
      println("}");
      this.tabs -= 1;
      println("}");
      println("");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void genRule(RuleSymbol paramRuleSymbol, boolean paramBoolean, int paramInt)
  {
    this.tabs = 1;
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRule(" + paramRuleSymbol.getId() + ")");
    if (!paramRuleSymbol.isDefined())
    {
      this.antlrTool.error("undefined rule: " + paramRuleSymbol.getId());
      return;
    }
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    int i = this.defaultLine;
    try
    {
      this.defaultLine = localRuleBlock.getLine();
      this.currentRule = localRuleBlock;
      this.currentASTResult = paramRuleSymbol.getId();
      this.declaredASTVariables.clear();
      boolean bool1 = this.genAST;
      this.genAST = ((this.genAST) && (localRuleBlock.getAutoGen()));
      this.saveText = localRuleBlock.getAutoGen();
      if (paramRuleSymbol.comment != null)
        _println(paramRuleSymbol.comment);
      print(paramRuleSymbol.access + " final ");
      if (localRuleBlock.returnAction != null)
        _print(extractTypeOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + " ");
      else
        _print("void ");
      _print(paramRuleSymbol.getId() + "(");
      _print(this.commonExtraParams);
      if ((this.commonExtraParams.length() != 0) && (localRuleBlock.argAction != null))
        _print(",");
      if (localRuleBlock.argAction != null)
      {
        _println("");
        this.tabs += 1;
        println(localRuleBlock.argAction);
        this.tabs -= 1;
        print(")");
      }
      else
      {
        _print(")");
      }
      _print(" throws " + this.exceptionThrown);
      if ((this.grammar instanceof ParserGrammar))
        _print(", TokenStreamException");
      else if ((this.grammar instanceof LexerGrammar))
        _print(", CharStreamException, TokenStreamException");
      if (localRuleBlock.throwsSpec != null)
        if ((this.grammar instanceof LexerGrammar))
          this.antlrTool.error("user-defined throws spec not allowed (yet) for lexer rule " + localRuleBlock.ruleName);
        else
          _print(", " + localRuleBlock.throwsSpec);
      _println(" {");
      this.tabs += 1;
      if (localRuleBlock.returnAction != null)
        println(localRuleBlock.returnAction + ";");
      println(this.commonLocalVars);
      if (this.grammar.traceRules)
        if ((this.grammar instanceof TreeWalkerGrammar))
          println("traceIn(\"" + paramRuleSymbol.getId() + "\",_t);");
        else
          println("traceIn(\"" + paramRuleSymbol.getId() + "\");");
      if ((this.grammar instanceof LexerGrammar))
      {
        if (paramRuleSymbol.getId().equals("mEOF"))
          println("_ttype = Token.EOF_TYPE;");
        else
          println("_ttype = " + paramRuleSymbol.getId().substring(1) + ";");
        println("int _saveIndex;");
      }
      if (this.grammar.debuggingOutput)
        if ((this.grammar instanceof ParserGrammar))
          println("fireEnterRule(" + paramInt + ",0);");
        else if ((this.grammar instanceof LexerGrammar))
          println("fireEnterRule(" + paramInt + ",_ttype);");
      if ((this.grammar.debuggingOutput) || (this.grammar.traceRules))
      {
        println("try { // debugging");
        this.tabs += 1;
      }
      if ((this.grammar instanceof TreeWalkerGrammar))
        println(this.labeledElementASTType + " " + paramRuleSymbol.getId() + "_AST_in = (_t == ASTNULL) ? null : (" + this.labeledElementASTType + ")_t;", -999);
      if (this.grammar.buildAST)
      {
        println("returnAST = null;");
        println("ASTPair currentAST = new ASTPair();");
        println(this.labeledElementASTType + " " + paramRuleSymbol.getId() + "_AST = null;");
      }
      genBlockPreamble(localRuleBlock);
      genBlockInitAction(localRuleBlock);
      println("");
      ExceptionSpec localExceptionSpec = localRuleBlock.findExceptionSpec("");
      if ((localExceptionSpec != null) || (localRuleBlock.getDefaultErrorHandler()))
      {
        println("try {      // for error handling");
        this.tabs += 1;
      }
      Object localObject1;
      if (localRuleBlock.alternatives.size() == 1)
      {
        Alternative localAlternative = localRuleBlock.getAlternativeAt(0);
        localObject1 = localAlternative.semPred;
        if (localObject1 != null)
          genSemPred((String)localObject1, this.currentRule.line);
        if (localAlternative.synPred != null)
          this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), localAlternative.synPred.getLine(), localAlternative.synPred.getColumn());
        genAlt(localAlternative, localRuleBlock);
      }
      else
      {
        boolean bool2 = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
        localObject1 = genCommonBlock(localRuleBlock, false);
        genBlockFinish((JavaBlockFinishingInfo)localObject1, this.throwNoViable, localRuleBlock.getLine());
      }
      if ((localExceptionSpec != null) || (localRuleBlock.getDefaultErrorHandler()))
      {
        this.tabs -= 1;
        println("}");
      }
      if (localExceptionSpec != null)
      {
        genErrorHandler(localExceptionSpec);
      }
      else if (localRuleBlock.getDefaultErrorHandler())
      {
        println("catch (" + this.exceptionThrown + " ex) {");
        this.tabs += 1;
        if (this.grammar.hasSyntacticPredicate)
        {
          println("if (inputState.guessing==0) {");
          this.tabs += 1;
        }
        println("reportError(ex);");
        if (!(this.grammar instanceof TreeWalkerGrammar))
        {
          Lookahead localLookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, localRuleBlock.endNode);
          localObject1 = getBitsetName(markBitsetForGen(localLookahead.fset));
          println("recover(ex," + (String)localObject1 + ");");
        }
        else
        {
          println("if (_t!=null) {_t = _t.getNextSibling();}");
        }
        if (this.grammar.hasSyntacticPredicate)
        {
          this.tabs -= 1;
          println("} else {");
          println("  throw ex;");
          println("}");
        }
        this.tabs -= 1;
        println("}");
      }
      if (this.grammar.buildAST)
        println("returnAST = " + paramRuleSymbol.getId() + "_AST;");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_retTree = _t;");
      if (localRuleBlock.getTestLiterals())
        if (paramRuleSymbol.access.equals("protected"))
          genLiteralsTestForPartialToken();
        else
          genLiteralsTest();
      if ((this.grammar instanceof LexerGrammar))
      {
        println("if ( _createToken && _token==null && _ttype!=Token.SKIP ) {");
        println("\t_token = makeToken(_ttype);");
        println("\t_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));");
        println("}");
        println("_returnToken = _token;");
      }
      if (localRuleBlock.returnAction != null)
        println("return " + extractIdOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + ";");
      if ((this.grammar.debuggingOutput) || (this.grammar.traceRules))
      {
        this.tabs -= 1;
        println("} finally { // debugging");
        this.tabs += 1;
        if (this.grammar.debuggingOutput)
          if ((this.grammar instanceof ParserGrammar))
            println("fireExitRule(" + paramInt + ",0);");
          else if ((this.grammar instanceof LexerGrammar))
            println("fireExitRule(" + paramInt + ",_ttype);");
        if (this.grammar.traceRules)
          if ((this.grammar instanceof TreeWalkerGrammar))
            println("traceOut(\"" + paramRuleSymbol.getId() + "\",_t);");
          else
            println("traceOut(\"" + paramRuleSymbol.getId() + "\");");
        this.tabs -= 1;
        println("}");
      }
      this.tabs -= 1;
      println("}");
      println("");
      this.genAST = bool1;
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  private void GenRuleInvocation(RuleRefElement paramRuleRefElement)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramRuleRefElement.getLine();
      getPrintWriterManager().startSingleSourceLineMapping(paramRuleRefElement.getLine());
      _print(paramRuleRefElement.targetRule + "(");
      getPrintWriterManager().endMapping();
      if ((this.grammar instanceof LexerGrammar))
      {
        if (paramRuleRefElement.getLabel() != null)
          _print("true");
        else
          _print("false");
        if ((this.commonExtraArgs.length() != 0) || (paramRuleRefElement.args != null))
          _print(",");
      }
      _print(this.commonExtraArgs);
      if ((this.commonExtraArgs.length() != 0) && (paramRuleRefElement.args != null))
        _print(",");
      RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
      if (paramRuleRefElement.args != null)
      {
        ActionTransInfo localActionTransInfo = new ActionTransInfo();
        String str = processActionForSpecialSymbols(paramRuleRefElement.args, 0, this.currentRule, localActionTransInfo);
        if ((localActionTransInfo.assignToRoot) || (localActionTransInfo.refRuleRoot != null))
          this.antlrTool.error("Arguments of rule reference '" + paramRuleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName(), this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
        _print(str);
        if (localRuleSymbol.block.argAction == null)
          this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' accepts no arguments", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      }
      else if (localRuleSymbol.block.argAction != null)
      {
        this.antlrTool.warning("Missing parameters on reference to rule " + paramRuleRefElement.targetRule, this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      }
      _println(");");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_t = _retTree;");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  protected void genSemPred(String paramString, int paramInt)
  {
    ActionTransInfo localActionTransInfo = new ActionTransInfo();
    paramString = processActionForSpecialSymbols(paramString, paramInt, this.currentRule, localActionTransInfo);
    String str = this.charFormatter.escapeString(paramString);
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      paramString = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + addSemPred(str) + "," + paramString + ")";
    println("if (!(" + paramString + "))", paramInt);
    println("  throw new SemanticException(\"" + str + "\");", paramInt);
  }

  protected void genSemPredMap()
  {
    Enumeration localEnumeration = this.semPreds.elements();
    println("private String _semPredNames[] = {", -999);
    while (localEnumeration.hasMoreElements())
      println("\"" + localEnumeration.nextElement() + "\",", -999);
    println("};", -999);
  }

  protected void genSynPred(SynPredBlock paramSynPredBlock, String paramString)
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = paramSynPredBlock.getLine();
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("gen=>(" + paramSynPredBlock + ")");
      println("boolean synPredMatched" + paramSynPredBlock.ID + " = false;");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("if (_t==null) _t=ASTNULL;");
      println("if (" + paramString + ") {");
      this.tabs += 1;
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("AST __t" + paramSynPredBlock.ID + " = _t;");
      else
        println("int _m" + paramSynPredBlock.ID + " = mark();");
      println("synPredMatched" + paramSynPredBlock.ID + " = true;");
      println("inputState.guessing++;");
      if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
        println("fireSyntacticPredicateStarted();");
      this.syntacticPredLevel += 1;
      println("try {");
      this.tabs += 1;
      gen(paramSynPredBlock);
      this.tabs -= 1;
      println("}");
      println("catch (" + this.exceptionThrown + " pe) {");
      this.tabs += 1;
      println("synPredMatched" + paramSynPredBlock.ID + " = false;");
      this.tabs -= 1;
      println("}");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_t = __t" + paramSynPredBlock.ID + ";");
      else
        println("rewind(_m" + paramSynPredBlock.ID + ");");
      _println("inputState.guessing--;");
      if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      {
        println("if (synPredMatched" + paramSynPredBlock.ID + ")");
        println("  fireSyntacticPredicateSucceeded();");
        println("else");
        println("  fireSyntacticPredicateFailed();");
      }
      this.syntacticPredLevel -= 1;
      this.tabs -= 1;
      println("}");
      println("if ( synPredMatched" + paramSynPredBlock.ID + " ) {");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public void genTokenStrings()
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      println("");
      println("public static final String[] _tokenNames = {");
      this.tabs += 1;
      Vector localVector = this.grammar.tokenManager.getVocabulary();
      for (int j = 0; j < localVector.size(); j++)
      {
        String str = (String)localVector.elementAt(j);
        if (str == null)
          str = "<" + String.valueOf(j) + ">";
        if ((!str.startsWith("\"")) && (!str.startsWith("<")))
        {
          TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str);
          if ((localTokenSymbol != null) && (localTokenSymbol.getParaphrase() != null))
            str = StringUtils.stripFrontBack(localTokenSymbol.getParaphrase(), "\"", "\"");
        }
        print(this.charFormatter.literalString(str));
        if (j != localVector.size() - 1)
          _print(",");
        _println("");
      }
      this.tabs -= 1;
      println("};");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  protected void genTokenASTNodeMap()
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      println("");
      println("protected void buildTokenTypeASTClassMap() {");
      this.tabs += 1;
      int j = 0;
      int k = 0;
      Vector localVector = this.grammar.tokenManager.getVocabulary();
      for (int m = 0; m < localVector.size(); m++)
      {
        String str = (String)localVector.elementAt(m);
        if (str == null)
          continue;
        TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str);
        if ((localTokenSymbol == null) || (localTokenSymbol.getASTNodeType() == null))
          continue;
        k++;
        if (j == 0)
        {
          println("tokenTypeToASTClassMap = new Hashtable();");
          j = 1;
        }
        println("tokenTypeToASTClassMap.put(new Integer(" + localTokenSymbol.getTokenType() + "), " + localTokenSymbol.getASTNodeType() + ".class);");
      }
      if (k == 0)
        println("tokenTypeToASTClassMap=null;");
      this.tabs -= 1;
      println("};");
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  protected void genTokenTypes(TokenManager paramTokenManager)
    throws IOException
  {
    int i = this.defaultLine;
    try
    {
      this.defaultLine = -999;
      this.currentOutput = getPrintWriterManager().setupOutput(this.antlrTool, paramTokenManager.getName() + TokenTypesFileSuffix);
      this.tabs = 0;
      genHeader();
      try
      {
        this.defaultLine = this.behavior.getHeaderActionLine("");
        println(this.behavior.getHeaderAction(""));
      }
      finally
      {
        this.defaultLine = -999;
      }
      println("public interface " + paramTokenManager.getName() + TokenTypesFileSuffix + " {");
      this.tabs += 1;
      Vector localVector = paramTokenManager.getVocabulary();
      println("int EOF = 1;");
      println("int NULL_TREE_LOOKAHEAD = 3;");
      for (int j = 4; j < localVector.size(); j++)
      {
        String str1 = (String)localVector.elementAt(j);
        if (str1 == null)
          continue;
        if (str1.startsWith("\""))
        {
          StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)paramTokenManager.getTokenSymbol(str1);
          if (localStringLiteralSymbol == null)
          {
            this.antlrTool.panic("String literal " + str1 + " not in symbol table");
          }
          else if (localStringLiteralSymbol.label != null)
          {
            println("int " + localStringLiteralSymbol.label + " = " + j + ";");
          }
          else
          {
            String str2 = mangleLiteral(str1);
            if (str2 != null)
            {
              println("int " + str2 + " = " + j + ";");
              localStringLiteralSymbol.label = str2;
            }
            else
            {
              println("// " + str1 + " = " + j);
            }
          }
        }
        else
        {
          if (str1.startsWith("<"))
            continue;
          println("int " + str1 + " = " + j + ";");
        }
      }
      this.tabs -= 1;
      println("}");
      getPrintWriterManager().finishOutput();
      exitIfError();
    }
    finally
    {
      this.defaultLine = i;
    }
  }

  public String getASTCreateString(Vector paramVector)
  {
    if (paramVector.size() == 0)
      return "";
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append("(" + this.labeledElementASTType + ")astFactory.make( (new ASTArray(" + paramVector.size() + "))");
    for (int i = 0; i < paramVector.size(); i++)
      localStringBuffer.append(".add(" + paramVector.elementAt(i) + ")");
    localStringBuffer.append(")");
    return localStringBuffer.toString();
  }

  public String getASTCreateString(GrammarAtom paramGrammarAtom, String paramString)
  {
    if ((paramGrammarAtom != null) && (paramGrammarAtom.getASTNodeType() != null))
      return "(" + paramGrammarAtom.getASTNodeType() + ")" + "astFactory.create(" + paramString + ",\"" + paramGrammarAtom.getASTNodeType() + "\")";
    return getASTCreateString(paramString);
  }

  public String getASTCreateString(String paramString)
  {
    if (paramString == null)
      paramString = "";
    int i = 0;
    for (int j = 0; j < paramString.length(); j++)
    {
      if (paramString.charAt(j) != ',')
        continue;
      i++;
    }
    if (i < 2)
    {
      j = paramString.indexOf(',');
      int k = paramString.lastIndexOf(',');
      String str1 = paramString;
      if (i > 0)
        str1 = paramString.substring(0, j);
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str1);
      if (localTokenSymbol != null)
      {
        String str2 = localTokenSymbol.getASTNodeType();
        String str3 = "";
        if (i == 0)
          str3 = ",\"\"";
        if (str2 != null)
          return "(" + str2 + ")" + "astFactory.create(" + paramString + str3 + ",\"" + str2 + "\")";
      }
      if (this.labeledElementASTType.equals("AST"))
        return "astFactory.create(" + paramString + ")";
      return "(" + this.labeledElementASTType + ")" + "astFactory.create(" + paramString + ")";
    }
    return "(" + this.labeledElementASTType + ")astFactory.create(" + paramString + ")";
  }

  protected String getLookaheadTestExpression(Lookahead[] paramArrayOfLookahead, int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    int i = 1;
    localStringBuffer.append("(");
    for (int j = 1; j <= paramInt; j++)
    {
      BitSet localBitSet = paramArrayOfLookahead[j].fset;
      if (i == 0)
        localStringBuffer.append(") && (");
      i = 0;
      if (paramArrayOfLookahead[j].containsEpsilon())
        localStringBuffer.append("true");
      else
        localStringBuffer.append(getLookaheadTestTerm(j, localBitSet));
    }
    localStringBuffer.append(")");
    return localStringBuffer.toString();
  }

  protected String getLookaheadTestExpression(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    if (paramInt == 0)
      return "( true )";
    return "(" + getLookaheadTestExpression(paramAlternative.cache, i) + ")";
  }

  protected String getLookaheadTestTerm(int paramInt, BitSet paramBitSet)
  {
    String str1 = lookaheadString(paramInt);
    int[] arrayOfInt = paramBitSet.toArray();
    if (elementsAreRange(arrayOfInt))
      return getRangeExpression(paramInt, arrayOfInt);
    int i = paramBitSet.degree();
    if (i == 0)
      return "true";
    if (i >= this.bitsetTestThreshold)
    {
      j = markBitsetForGen(paramBitSet);
      return getBitsetName(j) + ".member(" + str1 + ")";
    }
    StringBuffer localStringBuffer = new StringBuffer();
    for (int j = 0; j < arrayOfInt.length; j++)
    {
      String str2 = getValueString(arrayOfInt[j]);
      if (j > 0)
        localStringBuffer.append("||");
      localStringBuffer.append(str1);
      localStringBuffer.append("==");
      localStringBuffer.append(str2);
    }
    return localStringBuffer.toString();
  }

  public String getRangeExpression(int paramInt, int[] paramArrayOfInt)
  {
    if (!elementsAreRange(paramArrayOfInt))
      this.antlrTool.panic("getRangeExpression called with non-range");
    int i = paramArrayOfInt[0];
    int j = paramArrayOfInt[(paramArrayOfInt.length - 1)];
    return "(" + lookaheadString(paramInt) + " >= " + getValueString(i) + " && " + lookaheadString(paramInt) + " <= " + getValueString(j) + ")";
  }

  private String getValueString(int paramInt)
  {
    Object localObject;
    if ((this.grammar instanceof LexerGrammar))
    {
      localObject = this.charFormatter.literalChar(paramInt);
    }
    else
    {
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbolAt(paramInt);
      if (localTokenSymbol == null)
        return "" + paramInt;
      String str1 = localTokenSymbol.getId();
      if ((localTokenSymbol instanceof StringLiteralSymbol))
      {
        StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)localTokenSymbol;
        String str2 = localStringLiteralSymbol.getLabel();
        if (str2 != null)
        {
          localObject = str2;
        }
        else
        {
          localObject = mangleLiteral(str1);
          if (localObject == null)
            localObject = String.valueOf(paramInt);
        }
      }
      else
      {
        localObject = str1;
      }
    }
    return (String)localObject;
  }

  protected boolean lookaheadIsEmpty(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    for (int j = 1; (j <= i) && (j <= paramInt); j++)
    {
      BitSet localBitSet = paramAlternative.cache[j].fset;
      if (localBitSet.degree() != 0)
        return false;
    }
    return true;
  }

  private String lookaheadString(int paramInt)
  {
    if ((this.grammar instanceof TreeWalkerGrammar))
      return "_t.getType()";
    return "LA(" + paramInt + ")";
  }

  private String mangleLiteral(String paramString)
  {
    String str = this.antlrTool.literalsPrefix;
    for (int i = 1; i < paramString.length() - 1; i++)
    {
      if ((!Character.isLetter(paramString.charAt(i))) && (paramString.charAt(i) != '_'))
        return null;
      str = str + paramString.charAt(i);
    }
    if (this.antlrTool.upperCaseMangledLiterals)
      str = str.toUpperCase();
    return str;
  }

  public String mapTreeId(String paramString, ActionTransInfo paramActionTransInfo)
  {
    if (this.currentRule == null)
      return paramString;
    int i = 0;
    String str1 = paramString;
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (!this.grammar.buildAST)
      {
        i = 1;
      }
      else if ((str1.length() > 3) && (str1.lastIndexOf("_in") == str1.length() - 3))
      {
        str1 = str1.substring(0, str1.length() - 3);
        i = 1;
      }
    Object localObject;
    for (int j = 0; j < this.currentRule.labeledElements.size(); j++)
    {
      localObject = (AlternativeElement)this.currentRule.labeledElements.elementAt(j);
      if (((AlternativeElement)localObject).getLabel().equals(str1))
        return str1 + "_AST";
    }
    String str2 = (String)this.treeVariableMap.get(str1);
    if (str2 != null)
    {
      if (str2 == NONUNIQUE)
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      if (str2.equals(this.currentRule.getRuleName()))
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      return i != 0 ? str2 + "_in" : str2;
    }
    if (str1.equals(this.currentRule.getRuleName()))
    {
      localObject = str1 + "_AST";
      if ((paramActionTransInfo != null) && (i == 0))
        paramActionTransInfo.refRuleRoot = ((String)localObject);
      return localObject;
    }
    return (String)str1;
  }

  private void mapTreeVariable(AlternativeElement paramAlternativeElement, String paramString)
  {
    if ((paramAlternativeElement instanceof TreeElement))
    {
      mapTreeVariable(((TreeElement)paramAlternativeElement).root, paramString);
      return;
    }
    String str = null;
    if (paramAlternativeElement.getLabel() == null)
      if ((paramAlternativeElement instanceof TokenRefElement))
        str = ((TokenRefElement)paramAlternativeElement).atomText;
      else if ((paramAlternativeElement instanceof RuleRefElement))
        str = ((RuleRefElement)paramAlternativeElement).targetRule;
    if (str != null)
      if (this.treeVariableMap.get(str) != null)
      {
        this.treeVariableMap.remove(str);
        this.treeVariableMap.put(str, NONUNIQUE);
      }
      else
      {
        this.treeVariableMap.put(str, paramString);
      }
  }

  protected String processActionForSpecialSymbols(String paramString, int paramInt, RuleBlock paramRuleBlock, ActionTransInfo paramActionTransInfo)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return null;
    if (this.grammar == null)
      return paramString;
    if (((this.grammar.buildAST) && (paramString.indexOf('#') != -1)) || ((this.grammar instanceof TreeWalkerGrammar)) || ((((this.grammar instanceof LexerGrammar)) || ((this.grammar instanceof ParserGrammar))) && (paramString.indexOf('$') != -1)))
    {
      ActionLexer localActionLexer = new ActionLexer(paramString, paramRuleBlock, this, paramActionTransInfo);
      localActionLexer.setLineOffset(paramInt);
      localActionLexer.setFilename(this.grammar.getFilename());
      localActionLexer.setTool(this.antlrTool);
      try
      {
        localActionLexer.mACTION(true);
        paramString = localActionLexer.getTokenObject().getText();
      }
      catch (RecognitionException localRecognitionException)
      {
        localActionLexer.reportError(localRecognitionException);
        return paramString;
      }
      catch (TokenStreamException localTokenStreamException)
      {
        this.antlrTool.panic("Error reading action:" + paramString);
        return paramString;
      }
      catch (CharStreamException localCharStreamException)
      {
        this.antlrTool.panic("Error reading action:" + paramString);
        return paramString;
      }
    }
    return paramString;
  }

  private void setupGrammarParameters(Grammar paramGrammar)
  {
    Token localToken;
    String str;
    if ((paramGrammar instanceof ParserGrammar))
    {
      this.labeledElementASTType = "AST";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
            this.labeledElementASTType = str;
        }
      }
      this.labeledElementType = "Token ";
      this.labeledElementInit = "null";
      this.commonExtraArgs = "";
      this.commonExtraParams = "";
      this.commonLocalVars = "";
      this.lt1Value = "LT(1)";
      this.exceptionThrown = "RecognitionException";
      this.throwNoViable = "throw new NoViableAltException(LT(1), getFilename());";
    }
    else if ((paramGrammar instanceof LexerGrammar))
    {
      this.labeledElementType = "char ";
      this.labeledElementInit = "'\\0'";
      this.commonExtraArgs = "";
      this.commonExtraParams = "boolean _createToken";
      this.commonLocalVars = "int _ttype; Token _token=null; int _begin=text.length();";
      this.lt1Value = "LA(1)";
      this.exceptionThrown = "RecognitionException";
      this.throwNoViable = "throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine(), getColumn());";
    }
    else if ((paramGrammar instanceof TreeWalkerGrammar))
    {
      this.labeledElementASTType = "AST";
      this.labeledElementType = "AST";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            this.labeledElementASTType = str;
            this.labeledElementType = str;
          }
        }
      }
      if (!paramGrammar.hasOption("ASTLabelType"))
        paramGrammar.setOption("ASTLabelType", new Token(6, "AST"));
      this.labeledElementInit = "null";
      this.commonExtraArgs = "_t";
      this.commonExtraParams = "AST _t";
      this.commonLocalVars = "";
      this.lt1Value = ("(" + this.labeledElementASTType + ")_t");
      this.exceptionThrown = "RecognitionException";
      this.throwNoViable = "throw new NoViableAltException(_t);";
    }
    else
    {
      this.antlrTool.panic("Unknown grammar type");
    }
  }

  public JavaCodeGeneratorPrintWriterManager getPrintWriterManager()
  {
    if (this.printWriterManager == null)
      this.printWriterManager = new DefaultJavaCodeGeneratorPrintWriterManager();
    return this.printWriterManager;
  }

  public void setPrintWriterManager(JavaCodeGeneratorPrintWriterManager paramJavaCodeGeneratorPrintWriterManager)
  {
    this.printWriterManager = paramJavaCodeGeneratorPrintWriterManager;
  }

  public void setTool(Tool paramTool)
  {
    super.setTool(paramTool);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.JavaCodeGenerator
 * JD-Core Version:    0.6.0
 */