package antlr;

class JavaCharFormatter
  implements CharFormatter
{
  public String escapeChar(int paramInt, boolean paramBoolean)
  {
    switch (paramInt)
    {
    case 10:
      return "\\n";
    case 9:
      return "\\t";
    case 13:
      return "\\r";
    case 92:
      return "\\\\";
    case 39:
      return paramBoolean ? "\\'" : "'";
    case 34:
      return paramBoolean ? "\"" : "\\\"";
    }
    if ((paramInt < 32) || (paramInt > 126))
    {
      if ((0 <= paramInt) && (paramInt <= 15))
        return "\\u000" + Integer.toString(paramInt, 16);
      if ((16 <= paramInt) && (paramInt <= 255))
        return "\\u00" + Integer.toString(paramInt, 16);
      if ((256 <= paramInt) && (paramInt <= 4095))
        return "\\u0" + Integer.toString(paramInt, 16);
      return "\\u" + Integer.toString(paramInt, 16);
    }
    return String.valueOf((char)paramInt);
  }

  public String escapeString(String paramString)
  {
    String str = new String();
    for (int i = 0; i < paramString.length(); i++)
      str = str + escapeChar(paramString.charAt(i), false);
    return str;
  }

  public String literalChar(int paramInt)
  {
    return "'" + escapeChar(paramInt, true) + "'";
  }

  public String literalString(String paramString)
  {
    return "\"" + escapeString(paramString) + "\"";
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.JavaCharFormatter
 * JD-Core Version:    0.6.0
 */