package antlr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager extends SimpleTokenManager
  implements Cloneable
{
  private String filename;
  protected Grammar grammar;

  ImportVocabTokenManager(Grammar paramGrammar, String paramString1, String paramString2, Tool paramTool)
  {
    super(paramString2, paramTool);
    this.grammar = paramGrammar;
    this.filename = paramString1;
    File localFile = new File(this.filename);
    if (!localFile.exists())
    {
      localFile = new File(this.antlrTool.getOutputDirectory(), this.filename);
      if (!localFile.exists())
        this.antlrTool.panic("Cannot find importVocab file '" + this.filename + "'");
    }
    setReadOnly(true);
    try
    {
      BufferedReader localBufferedReader = new BufferedReader(new FileReader(localFile));
      ANTLRTokdefLexer localANTLRTokdefLexer = new ANTLRTokdefLexer(localBufferedReader);
      ANTLRTokdefParser localANTLRTokdefParser = new ANTLRTokdefParser(localANTLRTokdefLexer);
      localANTLRTokdefParser.setTool(this.antlrTool);
      localANTLRTokdefParser.setFilename(this.filename);
      localANTLRTokdefParser.file(this);
    }
    catch (FileNotFoundException localFileNotFoundException)
    {
      this.antlrTool.panic("Cannot find importVocab file '" + this.filename + "'");
    }
    catch (RecognitionException localRecognitionException)
    {
      this.antlrTool.panic("Error parsing importVocab file '" + this.filename + "': " + localRecognitionException.toString());
    }
    catch (TokenStreamException localTokenStreamException)
    {
      this.antlrTool.panic("Error reading importVocab file '" + this.filename + "'");
    }
  }

  public Object clone()
  {
    ImportVocabTokenManager localImportVocabTokenManager = (ImportVocabTokenManager)super.clone();
    localImportVocabTokenManager.filename = this.filename;
    localImportVocabTokenManager.grammar = this.grammar;
    return localImportVocabTokenManager;
  }

  public void define(TokenSymbol paramTokenSymbol)
  {
    super.define(paramTokenSymbol);
  }

  public void define(String paramString, int paramInt)
  {
    Object localObject = null;
    if (paramString.startsWith("\""))
      localObject = new StringLiteralSymbol(paramString);
    else
      localObject = new TokenSymbol(paramString);
    ((TokenSymbol)localObject).setTokenType(paramInt);
    super.define((TokenSymbol)localObject);
    this.maxToken = (paramInt + 1 > this.maxToken ? paramInt + 1 : this.maxToken);
  }

  public boolean isReadOnly()
  {
    return this.readOnly;
  }

  public int nextTokenType()
  {
    return super.nextTokenType();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.ImportVocabTokenManager
 * JD-Core Version:    0.6.0
 */