package antlr;

import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class HTMLCodeGenerator extends CodeGenerator
{
  protected int syntacticPredLevel = 0;
  protected boolean doingLexRules = false;
  protected boolean firstElementInAlt;
  protected AlternativeElement prevAltElem = null;

  public HTMLCodeGenerator()
  {
    this.charFormatter = new JavaCharFormatter();
  }

  static String HTMLEncode(String paramString)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    int i = 0;
    int j = paramString.length();
    while (i < j)
    {
      char c = paramString.charAt(i);
      if (c == '&')
        localStringBuffer.append("&amp;");
      else if (c == '"')
        localStringBuffer.append("&quot;");
      else if (c == '\'')
        localStringBuffer.append("&#039;");
      else if (c == '<')
        localStringBuffer.append("&lt;");
      else if (c == '>')
        localStringBuffer.append("&gt;");
      else
        localStringBuffer.append(c);
      i++;
    }
    return localStringBuffer.toString();
  }

  public void gen()
  {
    try
    {
      Enumeration localEnumeration = this.behavior.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        Grammar localGrammar = (Grammar)localEnumeration.nextElement();
        localGrammar.setCodeGenerator(this);
        localGrammar.generate();
        if (!this.antlrTool.hasError())
          continue;
        this.antlrTool.fatalError("Exiting due to errors.");
      }
    }
    catch (IOException localIOException)
    {
      this.antlrTool.reportException(localIOException, null);
    }
  }

  public void gen(ActionElement paramActionElement)
  {
  }

  public void gen(AlternativeBlock paramAlternativeBlock)
  {
    genGenericBlock(paramAlternativeBlock, "");
  }

  public void gen(BlockEndElement paramBlockEndElement)
  {
  }

  public void gen(CharLiteralElement paramCharLiteralElement)
  {
    if (paramCharLiteralElement.not)
      _print("~");
    _print(HTMLEncode(paramCharLiteralElement.atomText) + " ");
  }

  public void gen(CharRangeElement paramCharRangeElement)
  {
    print(paramCharRangeElement.beginText + ".." + paramCharRangeElement.endText + " ");
  }

  public void gen(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    setGrammar(paramLexerGrammar);
    this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
    this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
    this.tabs = 0;
    this.doingLexRules = true;
    genHeader();
    println("");
    if (this.grammar.comment != null)
      _println(HTMLEncode(this.grammar.comment));
    println("Definition of lexer " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
    genNextToken();
    Enumeration localEnumeration = this.grammar.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      RuleSymbol localRuleSymbol = (RuleSymbol)localEnumeration.nextElement();
      if (localRuleSymbol.id.equals("mnextToken"))
        continue;
      genRule(localRuleSymbol);
    }
    this.currentOutput.close();
    this.currentOutput = null;
    this.doingLexRules = false;
  }

  public void gen(OneOrMoreBlock paramOneOrMoreBlock)
  {
    genGenericBlock(paramOneOrMoreBlock, "+");
  }

  public void gen(ParserGrammar paramParserGrammar)
    throws IOException
  {
    setGrammar(paramParserGrammar);
    this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
    this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
    this.tabs = 0;
    genHeader();
    println("");
    if (this.grammar.comment != null)
      _println(HTMLEncode(this.grammar.comment));
    println("Definition of parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
    Enumeration localEnumeration = this.grammar.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      println("");
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
      if (!(localGrammarSymbol instanceof RuleSymbol))
        continue;
      genRule((RuleSymbol)localGrammarSymbol);
    }
    this.tabs -= 1;
    println("");
    genTail();
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void gen(RuleRefElement paramRuleRefElement)
  {
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    _print("<a href=\"" + this.grammar.getClassName() + ".html#" + paramRuleRefElement.targetRule + "\">");
    _print(paramRuleRefElement.targetRule);
    _print("</a>");
    _print(" ");
  }

  public void gen(StringLiteralElement paramStringLiteralElement)
  {
    if (paramStringLiteralElement.not)
      _print("~");
    _print(HTMLEncode(paramStringLiteralElement.atomText));
    _print(" ");
  }

  public void gen(TokenRangeElement paramTokenRangeElement)
  {
    print(paramTokenRangeElement.beginText + ".." + paramTokenRangeElement.endText + " ");
  }

  public void gen(TokenRefElement paramTokenRefElement)
  {
    if (paramTokenRefElement.not)
      _print("~");
    _print(paramTokenRefElement.atomText);
    _print(" ");
  }

  public void gen(TreeElement paramTreeElement)
  {
    print(paramTreeElement + " ");
  }

  public void gen(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    setGrammar(paramTreeWalkerGrammar);
    this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
    this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
    this.tabs = 0;
    genHeader();
    println("");
    println("");
    if (this.grammar.comment != null)
      _println(HTMLEncode(this.grammar.comment));
    println("Definition of tree parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
    println("");
    this.tabs += 1;
    Enumeration localEnumeration = this.grammar.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      println("");
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
      if (!(localGrammarSymbol instanceof RuleSymbol))
        continue;
      genRule((RuleSymbol)localGrammarSymbol);
    }
    this.tabs -= 1;
    println("");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void gen(WildcardElement paramWildcardElement)
  {
    _print(". ");
  }

  public void gen(ZeroOrMoreBlock paramZeroOrMoreBlock)
  {
    genGenericBlock(paramZeroOrMoreBlock, "*");
  }

  protected void genAlt(Alternative paramAlternative)
  {
    if (paramAlternative.getTreeSpecifier() != null)
      _print(paramAlternative.getTreeSpecifier().getText());
    this.prevAltElem = null;
    for (AlternativeElement localAlternativeElement = paramAlternative.head; !(localAlternativeElement instanceof BlockEndElement); localAlternativeElement = localAlternativeElement.next)
    {
      localAlternativeElement.generate();
      this.firstElementInAlt = false;
      this.prevAltElem = localAlternativeElement;
    }
  }

  public void genCommonBlock(AlternativeBlock paramAlternativeBlock)
  {
    for (int i = 0; i < paramAlternativeBlock.alternatives.size(); i++)
    {
      Alternative localAlternative = paramAlternativeBlock.getAlternativeAt(i);
      AlternativeElement localAlternativeElement = localAlternative.head;
      if ((i > 0) && (paramAlternativeBlock.alternatives.size() > 1))
      {
        _println("");
        print("|\t");
      }
      boolean bool = this.firstElementInAlt;
      this.firstElementInAlt = true;
      this.tabs += 1;
      genAlt(localAlternative);
      this.tabs -= 1;
      this.firstElementInAlt = bool;
    }
  }

  public void genFollowSetForRuleBlock(RuleBlock paramRuleBlock)
  {
    Lookahead localLookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, paramRuleBlock.endNode);
    printSet(this.grammar.maxk, 1, localLookahead);
  }

  protected void genGenericBlock(AlternativeBlock paramAlternativeBlock, String paramString)
  {
    if (paramAlternativeBlock.alternatives.size() > 1)
    {
      if (!this.firstElementInAlt)
      {
        if ((this.prevAltElem == null) || (!(this.prevAltElem instanceof AlternativeBlock)) || (((AlternativeBlock)this.prevAltElem).alternatives.size() == 1))
        {
          _println("");
          print("(\t");
        }
        else
        {
          _print("(\t");
        }
      }
      else
        _print("(\t");
    }
    else
      _print("( ");
    genCommonBlock(paramAlternativeBlock);
    if (paramAlternativeBlock.alternatives.size() > 1)
    {
      _println("");
      print(")" + paramString + " ");
      if (!(paramAlternativeBlock.next instanceof BlockEndElement))
      {
        _println("");
        print("");
      }
    }
    else
    {
      _print(")" + paramString + " ");
    }
  }

  protected void genHeader()
  {
    println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
    println("<HTML>");
    println("<HEAD>");
    println("<TITLE>Grammar " + this.antlrTool.grammarFile + "</TITLE>");
    println("</HEAD>");
    println("<BODY>");
    println("<table summary=\"\" border=\"1\" cellpadding=\"5\">");
    println("<tr>");
    println("<td>");
    println("<font size=\"+2\">Grammar " + this.grammar.getClassName() + "</font><br>");
    println("<a href=\"http://www.ANTLR.org\">ANTLR</a>-generated HTML file from " + this.antlrTool.grammarFile);
    println("<p>");
    println("Terence Parr, <a href=\"http://www.magelang.com\">MageLang Institute</a>");
    println("<br>ANTLR Version " + Tool.version + "; 1989-2005");
    println("</td>");
    println("</tr>");
    println("</table>");
    println("<PRE>");
  }

  protected void genLookaheadSetForAlt(Alternative paramAlternative)
  {
    if ((this.doingLexRules) && (paramAlternative.cache[1].containsEpsilon()))
    {
      println("MATCHES ALL");
      return;
    }
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    for (int j = 1; j <= i; j++)
    {
      Lookahead localLookahead = paramAlternative.cache[j];
      printSet(i, j, localLookahead);
    }
  }

  public void genLookaheadSetForBlock(AlternativeBlock paramAlternativeBlock)
  {
    int i = 0;
    Object localObject;
    for (int j = 0; j < paramAlternativeBlock.alternatives.size(); j++)
    {
      localObject = paramAlternativeBlock.getAlternativeAt(j);
      if (((Alternative)localObject).lookaheadDepth == 2147483647)
      {
        i = this.grammar.maxk;
        break;
      }
      if (i >= ((Alternative)localObject).lookaheadDepth)
        continue;
      i = ((Alternative)localObject).lookaheadDepth;
    }
    for (j = 1; j <= i; j++)
    {
      localObject = this.grammar.theLLkAnalyzer.look(j, paramAlternativeBlock);
      printSet(i, j, (Lookahead)localObject);
    }
  }

  public void genNextToken()
  {
    println("");
    println("/** Lexer nextToken rule:");
    println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
    println(" *  lexer rules.  It logically consists of one big alternative block with");
    println(" *  each user-defined rule being an alternative.");
    println(" */");
    RuleBlock localRuleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
    RuleSymbol localRuleSymbol = new RuleSymbol("mnextToken");
    localRuleSymbol.setDefined();
    localRuleSymbol.setBlock(localRuleBlock);
    localRuleSymbol.access = "private";
    this.grammar.define(localRuleSymbol);
    genCommonBlock(localRuleBlock);
  }

  public void genRule(RuleSymbol paramRuleSymbol)
  {
    if ((paramRuleSymbol == null) || (!paramRuleSymbol.isDefined()))
      return;
    println("");
    if (paramRuleSymbol.comment != null)
      _println(HTMLEncode(paramRuleSymbol.comment));
    if ((paramRuleSymbol.access.length() != 0) && (!paramRuleSymbol.access.equals("public")))
      _print(paramRuleSymbol.access + " ");
    _print("<a name=\"" + paramRuleSymbol.getId() + "\">");
    _print(paramRuleSymbol.getId());
    _print("</a>");
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    _println("");
    this.tabs += 1;
    print(":\t");
    genCommonBlock(localRuleBlock);
    _println("");
    println(";");
    this.tabs -= 1;
  }

  protected void genSynPred(SynPredBlock paramSynPredBlock)
  {
    this.syntacticPredLevel += 1;
    genGenericBlock(paramSynPredBlock, " =>");
    this.syntacticPredLevel -= 1;
  }

  public void genTail()
  {
    println("</PRE>");
    println("</BODY>");
    println("</HTML>");
  }

  protected void genTokenTypes(TokenManager paramTokenManager)
    throws IOException
  {
    this.antlrTool.reportProgress("Generating " + paramTokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
    this.currentOutput = this.antlrTool.openOutputFile(paramTokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
    this.tabs = 0;
    genHeader();
    println("");
    println("*** Tokens used by the parser");
    println("This is a list of the token numeric values and the corresponding");
    println("token identifiers.  Some tokens are literals, and because of that");
    println("they have no identifiers.  Literals are double-quoted.");
    this.tabs += 1;
    Vector localVector = paramTokenManager.getVocabulary();
    for (int i = 4; i < localVector.size(); i++)
    {
      String str = (String)localVector.elementAt(i);
      if (str == null)
        continue;
      println(str + " = " + i);
    }
    this.tabs -= 1;
    println("*** End of tokens used by the parser");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public String getASTCreateString(Vector paramVector)
  {
    return null;
  }

  public String getASTCreateString(GrammarAtom paramGrammarAtom, String paramString)
  {
    return null;
  }

  public String mapTreeId(String paramString, ActionTransInfo paramActionTransInfo)
  {
    return paramString;
  }

  protected String processActionForSpecialSymbols(String paramString, int paramInt, RuleBlock paramRuleBlock, ActionTransInfo paramActionTransInfo)
  {
    return paramString;
  }

  public void printSet(int paramInt1, int paramInt2, Lookahead paramLookahead)
  {
    int i = 5;
    int[] arrayOfInt = paramLookahead.fset.toArray();
    if (paramInt1 != 1)
      print("k==" + paramInt2 + ": {");
    else
      print("{ ");
    if (arrayOfInt.length > i)
    {
      _println("");
      this.tabs += 1;
      print("");
    }
    int j = 0;
    for (int k = 0; k < arrayOfInt.length; k++)
    {
      j++;
      if (j > i)
      {
        _println("");
        print("");
        j = 0;
      }
      if (this.doingLexRules)
        _print(this.charFormatter.literalChar(arrayOfInt[k]));
      else
        _print((String)this.grammar.tokenManager.getVocabulary().elementAt(arrayOfInt[k]));
      if (k == arrayOfInt.length - 1)
        continue;
      _print(", ");
    }
    if (arrayOfInt.length > i)
    {
      _println("");
      this.tabs -= 1;
      print("");
    }
    _println(" }");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.HTMLCodeGenerator
 * JD-Core Version:    0.6.0
 */