package antlr;

import antlr.collections.impl.BitSet;

class DefaultToolErrorHandler
  implements ToolErrorHandler
{
  private final Tool antlrTool;
  CharFormatter javaCharFormatter = new JavaCharFormatter();

  DefaultToolErrorHandler(Tool paramTool)
  {
    this.antlrTool = paramTool;
  }

  private void dumpSets(String[] paramArrayOfString, int paramInt1, Grammar paramGrammar, boolean paramBoolean, int paramInt2, Lookahead[] paramArrayOfLookahead)
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    for (int i = 1; i <= paramInt2; i++)
    {
      localStringBuffer.append("k==").append(i).append(':');
      if (paramBoolean)
      {
        String str = paramArrayOfLookahead[i].fset.toStringWithRanges(",", this.javaCharFormatter);
        if (paramArrayOfLookahead[i].containsEpsilon())
        {
          localStringBuffer.append("<end-of-token>");
          if (str.length() > 0)
            localStringBuffer.append(',');
        }
        localStringBuffer.append(str);
      }
      else
      {
        localStringBuffer.append(paramArrayOfLookahead[i].fset.toString(",", paramGrammar.tokenManager.getVocabulary()));
      }
      paramArrayOfString[(paramInt1++)] = localStringBuffer.toString();
      localStringBuffer.setLength(0);
    }
  }

  public void warnAltAmbiguity(Grammar paramGrammar, AlternativeBlock paramAlternativeBlock, boolean paramBoolean, int paramInt1, Lookahead[] paramArrayOfLookahead, int paramInt2, int paramInt3)
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    if (((paramAlternativeBlock instanceof RuleBlock)) && (((RuleBlock)paramAlternativeBlock).isLexerAutoGenRule()))
    {
      localObject = paramAlternativeBlock.getAlternativeAt(paramInt2);
      Alternative localAlternative = paramAlternativeBlock.getAlternativeAt(paramInt3);
      RuleRefElement localRuleRefElement1 = (RuleRefElement)((Alternative)localObject).head;
      RuleRefElement localRuleRefElement2 = (RuleRefElement)localAlternative.head;
      String str1 = CodeGenerator.reverseLexerRuleName(localRuleRefElement1.targetRule);
      String str2 = CodeGenerator.reverseLexerRuleName(localRuleRefElement2.targetRule);
      localStringBuffer.append("lexical nondeterminism between rules ");
      localStringBuffer.append(str1).append(" and ").append(str2).append(" upon");
    }
    else
    {
      if (paramBoolean)
        localStringBuffer.append("lexical ");
      localStringBuffer.append("nondeterminism between alts ");
      localStringBuffer.append(paramInt2 + 1).append(" and ");
      localStringBuffer.append(paramInt3 + 1).append(" of block upon");
    }
    Object localObject = new String[paramInt1 + 1];
    localObject[0] = localStringBuffer.toString();
    dumpSets(localObject, 1, paramGrammar, paramBoolean, paramInt1, paramArrayOfLookahead);
    this.antlrTool.warning(localObject, paramGrammar.getFilename(), paramAlternativeBlock.getLine(), paramAlternativeBlock.getColumn());
  }

  public void warnAltExitAmbiguity(Grammar paramGrammar, BlockWithImpliedExitPath paramBlockWithImpliedExitPath, boolean paramBoolean, int paramInt1, Lookahead[] paramArrayOfLookahead, int paramInt2)
  {
    String[] arrayOfString = new String[paramInt1 + 2];
    arrayOfString[0] = ((paramBoolean ? "lexical " : "") + "nondeterminism upon");
    dumpSets(arrayOfString, 1, paramGrammar, paramBoolean, paramInt1, paramArrayOfLookahead);
    arrayOfString[(paramInt1 + 1)] = ("between alt " + (paramInt2 + 1) + " and exit branch of block");
    this.antlrTool.warning(arrayOfString, paramGrammar.getFilename(), paramBlockWithImpliedExitPath.getLine(), paramBlockWithImpliedExitPath.getColumn());
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.DefaultToolErrorHandler
 * JD-Core Version:    0.6.0
 */