package antlr;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class DefaultJavaCodeGeneratorPrintWriterManager
  implements JavaCodeGeneratorPrintWriterManager
{
  private Grammar grammar;
  private PrintWriterWithSMAP smapOutput;
  private PrintWriter currentOutput;
  private Tool tool;
  private Map sourceMaps = new HashMap();
  private String currentFileName;

  public PrintWriter setupOutput(Tool paramTool, Grammar paramGrammar)
    throws IOException
  {
    return setupOutput(paramTool, paramGrammar, null);
  }

  public PrintWriter setupOutput(Tool paramTool, String paramString)
    throws IOException
  {
    return setupOutput(paramTool, null, paramString);
  }

  public PrintWriter setupOutput(Tool paramTool, Grammar paramGrammar, String paramString)
    throws IOException
  {
    this.tool = paramTool;
    this.grammar = paramGrammar;
    if (paramString == null)
      paramString = paramGrammar.getClassName();
    this.smapOutput = new PrintWriterWithSMAP(paramTool.openOutputFile(paramString + ".java"));
    this.currentFileName = (paramString + ".java");
    this.currentOutput = this.smapOutput;
    return this.currentOutput;
  }

  public void startMapping(int paramInt)
  {
    this.smapOutput.startMapping(paramInt);
  }

  public void startSingleSourceLineMapping(int paramInt)
  {
    this.smapOutput.startSingleSourceLineMapping(paramInt);
  }

  public void endMapping()
  {
    this.smapOutput.endMapping();
  }

  public void finishOutput()
    throws IOException
  {
    this.currentOutput.close();
    if (this.grammar != null)
    {
      PrintWriter localPrintWriter = this.tool.openOutputFile(this.grammar.getClassName() + ".smap");
      String str = this.grammar.getFilename();
      str = str.replace('\\', '/');
      int i = str.lastIndexOf('/');
      if (i != -1)
        str = str.substring(i + 1);
      this.smapOutput.dump(localPrintWriter, this.grammar.getClassName(), str);
      this.sourceMaps.put(this.currentFileName, this.smapOutput.getSourceMap());
    }
    this.currentOutput = null;
  }

  public Map getSourceMaps()
  {
    return this.sourceMaps;
  }

  public int getCurrentOutputLine()
  {
    return this.smapOutput.getCurrentOutputLine();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.DefaultJavaCodeGeneratorPrintWriterManager
 * JD-Core Version:    0.6.0
 */