package antlr;

import antlr.actions.cpp.ActionLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class CppCodeGenerator extends CodeGenerator
{
  boolean DEBUG_CPP_CODE_GENERATOR = false;
  protected int syntacticPredLevel = 0;
  protected boolean genAST = false;
  protected boolean saveText = false;
  protected boolean genHashLines = true;
  protected boolean noConstructors = false;
  protected int outputLine;
  protected String outputFile;
  boolean usingCustomAST = false;
  String labeledElementType;
  String labeledElementASTType;
  String labeledElementASTInit;
  String labeledElementInit;
  String commonExtraArgs;
  String commonExtraParams;
  String commonLocalVars;
  String lt1Value;
  String exceptionThrown;
  String throwNoViable;
  RuleBlock currentRule;
  String currentASTResult;
  Hashtable treeVariableMap = new Hashtable();
  Hashtable declaredASTVariables = new Hashtable();
  int astVarNumber = 1;
  protected static final String NONUNIQUE = new String();
  public static final int caseSizeThreshold = 127;
  private Vector semPreds;
  private Vector astTypes;
  private static String namespaceStd = "ANTLR_USE_NAMESPACE(std)";
  private static String namespaceAntlr = "ANTLR_USE_NAMESPACE(antlr)";
  private static NameSpace nameSpace = null;
  private static final String preIncludeCpp = "pre_include_cpp";
  private static final String preIncludeHpp = "pre_include_hpp";
  private static final String postIncludeCpp = "post_include_cpp";
  private static final String postIncludeHpp = "post_include_hpp";

  public CppCodeGenerator()
  {
    this.charFormatter = new CppCharFormatter();
  }

  protected int addSemPred(String paramString)
  {
    this.semPreds.appendElement(paramString);
    return this.semPreds.size() - 1;
  }

  public void exitIfError()
  {
    if (this.antlrTool.hasError())
      this.antlrTool.fatalError("Exiting due to errors.");
  }

  protected int countLines(String paramString)
  {
    int i = 0;
    for (int j = 0; j < paramString.length(); j++)
    {
      if (paramString.charAt(j) != '\n')
        continue;
      i++;
    }
    return i;
  }

  protected void _print(String paramString)
  {
    if (paramString != null)
    {
      this.outputLine += countLines(paramString);
      this.currentOutput.print(paramString);
    }
  }

  protected void _printAction(String paramString)
  {
    if (paramString != null)
    {
      this.outputLine += countLines(paramString) + 1;
      super._printAction(paramString);
    }
  }

  public void printAction(Token paramToken)
  {
    if (paramToken != null)
    {
      genLineNo(paramToken.getLine());
      printTabs();
      _printAction(processActionForSpecialSymbols(paramToken.getText(), paramToken.getLine(), null, null));
      genLineNo2();
    }
  }

  public void printHeaderAction(String paramString)
  {
    Token localToken = (Token)this.behavior.headerActions.get(paramString);
    if (localToken != null)
    {
      genLineNo(localToken.getLine());
      println(processActionForSpecialSymbols(localToken.getText(), localToken.getLine(), null, null));
      genLineNo2();
    }
  }

  protected void _println(String paramString)
  {
    if (paramString != null)
    {
      this.outputLine += countLines(paramString) + 1;
      this.currentOutput.println(paramString);
    }
  }

  protected void println(String paramString)
  {
    if (paramString != null)
    {
      printTabs();
      this.outputLine += countLines(paramString) + 1;
      this.currentOutput.println(paramString);
    }
  }

  public void genLineNo(int paramInt)
  {
    if (paramInt == 0)
      paramInt++;
    if (this.genHashLines)
      _println("#line " + paramInt + " \"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"");
  }

  public void genLineNo(GrammarElement paramGrammarElement)
  {
    if (paramGrammarElement != null)
      genLineNo(paramGrammarElement.getLine());
  }

  public void genLineNo(Token paramToken)
  {
    if (paramToken != null)
      genLineNo(paramToken.getLine());
  }

  public void genLineNo2()
  {
    if (this.genHashLines)
      _println("#line " + (this.outputLine + 1) + " \"" + this.outputFile + "\"");
  }

  private boolean charIsDigit(String paramString, int paramInt)
  {
    return (paramInt < paramString.length()) && (Character.isDigit(paramString.charAt(paramInt)));
  }

  private String convertJavaToCppString(String paramString, boolean paramBoolean)
  {
    String str1 = new String();
    String str2 = paramString;
    int i = 0;
    int j = 0;
    if (paramBoolean)
    {
      if ((!paramString.startsWith("'")) || (!paramString.endsWith("'")))
        this.antlrTool.error("Invalid character literal: '" + paramString + "'");
    }
    else if ((!paramString.startsWith("\"")) || (!paramString.endsWith("\"")))
      this.antlrTool.error("Invalid character string: '" + paramString + "'");
    str2 = paramString.substring(1, paramString.length() - 1);
    String str3 = "";
    int k = 255;
    if ((this.grammar instanceof LexerGrammar))
    {
      k = ((LexerGrammar)this.grammar).charVocabulary.size() - 1;
      if (k > 255)
        str3 = "L";
    }
    while (i < str2.length())
    {
      if (str2.charAt(i) == '\\')
      {
        if (str2.length() == i + 1)
          this.antlrTool.error("Invalid escape in char literal: '" + paramString + "' looking at '" + str2.substring(i) + "'");
        switch (str2.charAt(i + 1))
        {
        case 'a':
          j = 7;
          i += 2;
          break;
        case 'b':
          j = 8;
          i += 2;
          break;
        case 't':
          j = 9;
          i += 2;
          break;
        case 'n':
          j = 10;
          i += 2;
          break;
        case 'f':
          j = 12;
          i += 2;
          break;
        case 'r':
          j = 13;
          i += 2;
          break;
        case '"':
        case '\'':
        case '\\':
          j = str2.charAt(i + 1);
          i += 2;
          break;
        case 'u':
          if (i + 5 < str2.length())
          {
            j = Character.digit(str2.charAt(i + 2), 16) * 16 * 16 * 16 + Character.digit(str2.charAt(i + 3), 16) * 16 * 16 + Character.digit(str2.charAt(i + 4), 16) * 16 + Character.digit(str2.charAt(i + 5), 16);
            i += 6;
            break label918;
          }
          this.antlrTool.error("Invalid escape in char literal: '" + paramString + "' looking at '" + str2.substring(i) + "'");
          break;
        case '0':
        case '1':
        case '2':
        case '3':
          if (charIsDigit(str2, i + 2))
          {
            if (charIsDigit(str2, i + 3))
            {
              j = (str2.charAt(i + 1) - '0') * 8 * 8 + (str2.charAt(i + 2) - '0') * 8 + (str2.charAt(i + 3) - '0');
              i += 4;
              break label918;
            }
            j = (str2.charAt(i + 1) - '0') * 8 + (str2.charAt(i + 2) - '0');
            i += 3;
            break label918;
          }
          j = str2.charAt(i + 1) - '0';
          i += 2;
          break;
        case '4':
        case '5':
        case '6':
        case '7':
          if (charIsDigit(str2, i + 2))
          {
            j = (str2.charAt(i + 1) - '0') * 8 + (str2.charAt(i + 2) - '0');
            i += 3;
          }
          else
          {
            j = str2.charAt(i + 1) - '0';
            i += 2;
          }
        }
        this.antlrTool.error("Unhandled escape in char literal: '" + paramString + "' looking at '" + str2.substring(i) + "'");
        j = 0;
      }
      else
      {
        j = str2.charAt(i++);
      }
      label918: if (((this.grammar instanceof LexerGrammar)) && (j > k))
      {
        String str4;
        if ((32 <= j) && (j < 127))
          str4 = this.charFormatter.escapeChar(j, true);
        else
          str4 = "0x" + Integer.toString(j, 16);
        this.antlrTool.error("Character out of range in " + (paramBoolean ? "char literal" : "string constant") + ": '" + str2 + "'");
        this.antlrTool.error("Vocabulary size: " + k + " Character " + str4);
      }
      if (paramBoolean)
      {
        if (i != str2.length())
          this.antlrTool.error("Invalid char literal: '" + paramString + "'");
        if (k <= 255)
        {
          if ((j <= 255) && ((j & 0x80) != 0))
          {
            str1 = "static_cast<unsigned char>('" + this.charFormatter.escapeChar(j, true) + "')";
            continue;
          }
          str1 = "'" + this.charFormatter.escapeChar(j, true) + "'";
          continue;
        }
        str1 = "L'" + this.charFormatter.escapeChar(j, true) + "'";
        continue;
      }
      str1 = str1 + this.charFormatter.escapeChar(j, true);
    }
    if (!paramBoolean)
      str1 = str3 + "\"" + str1 + "\"";
    return str1;
  }

  public void gen()
  {
    try
    {
      Enumeration localEnumeration = this.behavior.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        localObject = (Grammar)localEnumeration.nextElement();
        if (((Grammar)localObject).debuggingOutput)
          this.antlrTool.error(((Grammar)localObject).getFilename() + ": C++ mode does not support -debug");
        ((Grammar)localObject).setGrammarAnalyzer(this.analyzer);
        ((Grammar)localObject).setCodeGenerator(this);
        this.analyzer.setGrammar((Grammar)localObject);
        setupGrammarParameters((Grammar)localObject);
        ((Grammar)localObject).generate();
        exitIfError();
      }
      Object localObject = this.behavior.tokenManagers.elements();
      while (((Enumeration)localObject).hasMoreElements())
      {
        TokenManager localTokenManager = (TokenManager)((Enumeration)localObject).nextElement();
        if (!localTokenManager.isReadOnly())
        {
          genTokenTypes(localTokenManager);
          genTokenInterchange(localTokenManager);
        }
        exitIfError();
      }
    }
    catch (IOException localIOException)
    {
      this.antlrTool.reportException(localIOException, null);
    }
  }

  public void gen(ActionElement paramActionElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genAction(" + paramActionElement + ")");
    if (paramActionElement.isSemPred)
    {
      genSemPred(paramActionElement.actionText, paramActionElement.line);
    }
    else
    {
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if ( inputState->guessing==0 ) {");
        this.tabs += 1;
      }
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      String str = processActionForSpecialSymbols(paramActionElement.actionText, paramActionElement.getLine(), this.currentRule, localActionTransInfo);
      if (localActionTransInfo.refRuleRoot != null)
        println(localActionTransInfo.refRuleRoot + " = " + this.labeledElementASTType + "(currentAST.root);");
      genLineNo(paramActionElement);
      printAction(str);
      genLineNo2();
      if (localActionTransInfo.assignToRoot)
      {
        println("currentAST.root = " + localActionTransInfo.refRuleRoot + ";");
        println("if ( " + localActionTransInfo.refRuleRoot + "!=" + this.labeledElementASTInit + " &&");
        this.tabs += 1;
        println(localActionTransInfo.refRuleRoot + "->getFirstChild() != " + this.labeledElementASTInit + " )");
        println("  currentAST.child = " + localActionTransInfo.refRuleRoot + "->getFirstChild();");
        this.tabs -= 1;
        println("else");
        this.tabs += 1;
        println("currentAST.child = " + localActionTransInfo.refRuleRoot + ";");
        this.tabs -= 1;
        println("currentAST.advanceChildToEnd();");
      }
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("}");
      }
    }
  }

  public void gen(AlternativeBlock paramAlternativeBlock)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("gen(" + paramAlternativeBlock + ")");
    println("{");
    genBlockPreamble(paramAlternativeBlock);
    genBlockInitAction(paramAlternativeBlock);
    String str = this.currentASTResult;
    if (paramAlternativeBlock.getLabel() != null)
      this.currentASTResult = paramAlternativeBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramAlternativeBlock);
    CppBlockFinishingInfo localCppBlockFinishingInfo = genCommonBlock(paramAlternativeBlock, true);
    genBlockFinish(localCppBlockFinishingInfo, this.throwNoViable);
    println("}");
    this.currentASTResult = str;
  }

  public void gen(BlockEndElement paramBlockEndElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genRuleEnd(" + paramBlockEndElement + ")");
  }

  public void gen(CharLiteralElement paramCharLiteralElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genChar(" + paramCharLiteralElement + ")");
    if (!(this.grammar instanceof LexerGrammar))
      this.antlrTool.error("cannot ref character literals in grammar: " + paramCharLiteralElement);
    if (paramCharLiteralElement.getLabel() != null)
      println(paramCharLiteralElement.getLabel() + " = " + this.lt1Value + ";");
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramCharLiteralElement.getAutoGenType() == 1));
    if ((!this.saveText) || (paramCharLiteralElement.getAutoGenType() == 3))
      println("_saveIndex = text.length();");
    print(paramCharLiteralElement.not ? "matchNot(" : "match(");
    _print(convertJavaToCppString(paramCharLiteralElement.atomText, true));
    _println(" /* charlit */ );");
    if ((!this.saveText) || (paramCharLiteralElement.getAutoGenType() == 3))
      println("text.erase(_saveIndex);");
    this.saveText = bool;
  }

  public void gen(CharRangeElement paramCharRangeElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genCharRangeElement(" + paramCharRangeElement.beginText + ".." + paramCharRangeElement.endText + ")");
    if (!(this.grammar instanceof LexerGrammar))
      this.antlrTool.error("cannot ref character range in grammar: " + paramCharRangeElement);
    if ((paramCharRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramCharRangeElement.getLabel() + " = " + this.lt1Value + ";");
    int i = ((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramCharRangeElement.getAutoGenType() == 3)) ? 1 : 0;
    if (i != 0)
      println("_saveIndex=text.length();");
    println("matchRange(" + convertJavaToCppString(paramCharRangeElement.beginText, true) + "," + convertJavaToCppString(paramCharRangeElement.endText, true) + ");");
    if (i != 0)
      println("text.erase(_saveIndex);");
  }

  public void gen(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    if (paramLexerGrammar.debuggingOutput)
      this.semPreds = new Vector();
    if (paramLexerGrammar.charVocabulary.size() > 256)
      this.antlrTool.warning(paramLexerGrammar.getFilename() + ": Vocabularies of this size still experimental in C++ mode (vocabulary size now: " + paramLexerGrammar.charVocabulary.size() + ")");
    setGrammar(paramLexerGrammar);
    if (!(this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Internal error generating lexer");
    genBody(paramLexerGrammar);
    genInclude(paramLexerGrammar);
  }

  public void gen(OneOrMoreBlock paramOneOrMoreBlock)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("gen+(" + paramOneOrMoreBlock + ")");
    println("{ // ( ... )+");
    genBlockPreamble(paramOneOrMoreBlock);
    String str2;
    if (paramOneOrMoreBlock.getLabel() != null)
      str2 = "_cnt_" + paramOneOrMoreBlock.getLabel();
    else
      str2 = "_cnt" + paramOneOrMoreBlock.ID;
    println("int " + str2 + "=0;");
    String str1;
    if (paramOneOrMoreBlock.getLabel() != null)
      str1 = paramOneOrMoreBlock.getLabel();
    else
      str1 = "_loop" + paramOneOrMoreBlock.ID;
    println("for (;;) {");
    this.tabs += 1;
    genBlockInitAction(paramOneOrMoreBlock);
    String str3 = this.currentASTResult;
    if (paramOneOrMoreBlock.getLabel() != null)
      this.currentASTResult = paramOneOrMoreBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramOneOrMoreBlock);
    int i = 0;
    int j = this.grammar.maxk;
    if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramOneOrMoreBlock.exitCache[paramOneOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
    {
      i = 1;
      j = paramOneOrMoreBlock.exitLookaheadDepth;
    }
    else if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth == 2147483647))
    {
      i = 1;
    }
    if (i != 0)
    {
      if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
        System.out.println("nongreedy (...)+ loop; exit depth is " + paramOneOrMoreBlock.exitLookaheadDepth);
      localObject = getLookaheadTestExpression(paramOneOrMoreBlock.exitCache, j);
      println("// nongreedy exit test");
      println("if ( " + str2 + ">=1 && " + (String)localObject + ") goto " + str1 + ";");
    }
    Object localObject = genCommonBlock(paramOneOrMoreBlock, false);
    genBlockFinish((CppBlockFinishingInfo)localObject, "if ( " + str2 + ">=1 ) { goto " + str1 + "; } else {" + this.throwNoViable + "}");
    println(str2 + "++;");
    this.tabs -= 1;
    println("}");
    println(str1 + ":;");
    println("}  // ( ... )+");
    this.currentASTResult = str3;
  }

  public void gen(ParserGrammar paramParserGrammar)
    throws IOException
  {
    if (paramParserGrammar.debuggingOutput)
      this.semPreds = new Vector();
    setGrammar(paramParserGrammar);
    if (!(this.grammar instanceof ParserGrammar))
      this.antlrTool.panic("Internal error generating parser");
    genBody(paramParserGrammar);
    genInclude(paramParserGrammar);
  }

  public void gen(RuleRefElement paramRuleRefElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genRR(" + paramRuleRefElement + ")");
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    if ((localRuleSymbol == null) || (!localRuleSymbol.isDefined()))
    {
      this.antlrTool.error("Rule '" + paramRuleRefElement.targetRule + "' is not defined", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      return;
    }
    if (!(localRuleSymbol instanceof RuleSymbol))
    {
      this.antlrTool.error("'" + paramRuleRefElement.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      return;
    }
    genErrorTryForElement(paramRuleRefElement);
    if (((this.grammar instanceof TreeWalkerGrammar)) && (paramRuleRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramRuleRefElement.getLabel() + " = (_t == ASTNULL) ? " + this.labeledElementASTInit + " : " + this.lt1Value + ";");
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
      println("_saveIndex = text.length();");
    printTabs();
    if (paramRuleRefElement.idAssign != null)
    {
      if (localRuleSymbol.block.returnAction == null)
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' has no return type", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      _print(paramRuleRefElement.idAssign + "=");
    }
    else if ((!(this.grammar instanceof LexerGrammar)) && (this.syntacticPredLevel == 0) && (localRuleSymbol.block.returnAction != null))
    {
      this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' returns a value", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    GenRuleInvocation(paramRuleRefElement);
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
      println("text.erase(_saveIndex);");
    if (this.syntacticPredLevel == 0)
    {
      int i = (this.grammar.hasSyntacticPredicate) && (((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null)) || ((this.genAST) && (paramRuleRefElement.getAutoGenType() == 1))) ? 1 : 0;
      if (i != 0)
      {
        println("if (inputState->guessing==0) {");
        this.tabs += 1;
      }
      if ((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null))
        println(paramRuleRefElement.getLabel() + "_AST = returnAST;");
      if (this.genAST)
        switch (paramRuleRefElement.getAutoGenType())
        {
        case 1:
          if (this.usingCustomAST)
            println("astFactory->addASTChild(currentAST, " + namespaceAntlr + "RefAST(returnAST));");
          else
            println("astFactory->addASTChild( currentAST, returnAST );");
          break;
        case 2:
          this.antlrTool.error("Internal: encountered ^ after rule reference");
          break;
        }
      if (((this.grammar instanceof LexerGrammar)) && (paramRuleRefElement.getLabel() != null))
        println(paramRuleRefElement.getLabel() + "=_returnToken;");
      if (i != 0)
      {
        this.tabs -= 1;
        println("}");
      }
    }
    genErrorCatchForElement(paramRuleRefElement);
  }

  public void gen(StringLiteralElement paramStringLiteralElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genString(" + paramStringLiteralElement + ")");
    if ((paramStringLiteralElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramStringLiteralElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramStringLiteralElement);
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramStringLiteralElement.getAutoGenType() == 1));
    genMatch(paramStringLiteralElement);
    this.saveText = bool;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t->getNextSibling();");
  }

  public void gen(TokenRangeElement paramTokenRangeElement)
  {
    genErrorTryForElement(paramTokenRangeElement);
    if ((paramTokenRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRangeElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramTokenRangeElement);
    println("matchRange(" + paramTokenRangeElement.beginText + "," + paramTokenRangeElement.endText + ");");
    genErrorCatchForElement(paramTokenRangeElement);
  }

  public void gen(TokenRefElement paramTokenRefElement)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genTokenRef(" + paramTokenRefElement + ")");
    if ((this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Token reference found in lexer");
    genErrorTryForElement(paramTokenRefElement);
    if ((paramTokenRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRefElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramTokenRefElement);
    genMatch(paramTokenRefElement);
    genErrorCatchForElement(paramTokenRefElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t->getNextSibling();");
  }

  public void gen(TreeElement paramTreeElement)
  {
    println(this.labeledElementType + " __t" + paramTreeElement.ID + " = _t;");
    if (paramTreeElement.root.getLabel() != null)
      println(paramTreeElement.root.getLabel() + " = (_t == " + this.labeledElementType + "(ASTNULL)) ? " + this.labeledElementASTInit + " : _t;");
    if (paramTreeElement.root.getAutoGenType() == 3)
    {
      this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
      paramTreeElement.root.setAutoGenType(1);
    }
    if (paramTreeElement.root.getAutoGenType() == 2)
    {
      this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
      paramTreeElement.root.setAutoGenType(1);
    }
    genElementAST(paramTreeElement.root);
    if (this.grammar.buildAST)
    {
      println(namespaceAntlr + "ASTPair __currentAST" + paramTreeElement.ID + " = currentAST;");
      println("currentAST.root = currentAST.child;");
      println("currentAST.child = " + this.labeledElementASTInit + ";");
    }
    if ((paramTreeElement.root instanceof WildcardElement))
      println("if ( _t == ASTNULL ) throw " + namespaceAntlr + "MismatchedTokenException();");
    else
      genMatch(paramTreeElement.root);
    println("_t = _t->getFirstChild();");
    for (int i = 0; i < paramTreeElement.getAlternatives().size(); i++)
    {
      Alternative localAlternative = paramTreeElement.getAlternativeAt(i);
      for (AlternativeElement localAlternativeElement = localAlternative.head; localAlternativeElement != null; localAlternativeElement = localAlternativeElement.next)
        localAlternativeElement.generate();
    }
    if (this.grammar.buildAST)
      println("currentAST = __currentAST" + paramTreeElement.ID + ";");
    println("_t = __t" + paramTreeElement.ID + ";");
    println("_t = _t->getNextSibling();");
  }

  public void gen(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    setGrammar(paramTreeWalkerGrammar);
    if (!(this.grammar instanceof TreeWalkerGrammar))
      this.antlrTool.panic("Internal error generating tree-walker");
    genBody(paramTreeWalkerGrammar);
    genInclude(paramTreeWalkerGrammar);
  }

  public void gen(WildcardElement paramWildcardElement)
  {
    if ((paramWildcardElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramWildcardElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramWildcardElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
    {
      println("if ( _t == " + this.labeledElementASTInit + " ) throw " + namespaceAntlr + "MismatchedTokenException();");
    }
    else if ((this.grammar instanceof LexerGrammar))
    {
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
        println("_saveIndex = text.length();");
      println("matchNot(EOF/*_CHAR*/);");
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
        println("text.erase(_saveIndex);");
    }
    else
    {
      println("matchNot(" + getValueString(1) + ");");
    }
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t->getNextSibling();");
  }

  public void gen(ZeroOrMoreBlock paramZeroOrMoreBlock)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("gen*(" + paramZeroOrMoreBlock + ")");
    println("{ // ( ... )*");
    genBlockPreamble(paramZeroOrMoreBlock);
    String str1;
    if (paramZeroOrMoreBlock.getLabel() != null)
      str1 = paramZeroOrMoreBlock.getLabel();
    else
      str1 = "_loop" + paramZeroOrMoreBlock.ID;
    println("for (;;) {");
    this.tabs += 1;
    genBlockInitAction(paramZeroOrMoreBlock);
    String str2 = this.currentASTResult;
    if (paramZeroOrMoreBlock.getLabel() != null)
      this.currentASTResult = paramZeroOrMoreBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramZeroOrMoreBlock);
    int i = 0;
    int j = this.grammar.maxk;
    if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramZeroOrMoreBlock.exitCache[paramZeroOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
    {
      i = 1;
      j = paramZeroOrMoreBlock.exitLookaheadDepth;
    }
    else if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth == 2147483647))
    {
      i = 1;
    }
    if (i != 0)
    {
      if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
        System.out.println("nongreedy (...)* loop; exit depth is " + paramZeroOrMoreBlock.exitLookaheadDepth);
      localObject = getLookaheadTestExpression(paramZeroOrMoreBlock.exitCache, j);
      println("// nongreedy exit test");
      println("if (" + (String)localObject + ") goto " + str1 + ";");
    }
    Object localObject = genCommonBlock(paramZeroOrMoreBlock, false);
    genBlockFinish((CppBlockFinishingInfo)localObject, "goto " + str1 + ";");
    this.tabs -= 1;
    println("}");
    println(str1 + ":;");
    println("} // ( ... )*");
    this.currentASTResult = str2;
  }

  protected void genAlt(Alternative paramAlternative, AlternativeBlock paramAlternativeBlock)
  {
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternative.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternative.getAutoGen()));
    Hashtable localHashtable = this.treeVariableMap;
    this.treeVariableMap = new Hashtable();
    if (paramAlternative.exceptionSpec != null)
    {
      println("try {      // for error handling");
      this.tabs += 1;
    }
    for (AlternativeElement localAlternativeElement = paramAlternative.head; !(localAlternativeElement instanceof BlockEndElement); localAlternativeElement = localAlternativeElement.next)
      localAlternativeElement.generate();
    if (this.genAST)
      if ((paramAlternativeBlock instanceof RuleBlock))
      {
        RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
        if (this.usingCustomAST)
          println(localRuleBlock.getRuleName() + "_AST = " + this.labeledElementASTType + "(currentAST.root);");
        else
          println(localRuleBlock.getRuleName() + "_AST = currentAST.root;");
      }
      else if (paramAlternativeBlock.getLabel() != null)
      {
        this.antlrTool.warning("Labeled subrules are not implemented", this.grammar.getFilename(), paramAlternativeBlock.getLine(), paramAlternativeBlock.getColumn());
      }
    if (paramAlternative.exceptionSpec != null)
    {
      this.tabs -= 1;
      println("}");
      genErrorHandler(paramAlternative.exceptionSpec);
    }
    this.genAST = bool1;
    this.saveText = bool2;
    this.treeVariableMap = localHashtable;
  }

  protected void genBitsets(Vector paramVector, int paramInt, String paramString)
  {
    TokenManager localTokenManager = this.grammar.tokenManager;
    println("");
    for (int i = 0; i < paramVector.size(); i++)
    {
      BitSet localBitSet = (BitSet)paramVector.elementAt(i);
      localBitSet.growToInclude(paramInt);
      println("const unsigned long " + paramString + getBitsetName(i) + "_data_" + "[] = { " + localBitSet.toStringOfHalfWords() + " };");
      String str = "// ";
      for (int j = 0; j < localTokenManager.getVocabulary().size(); j++)
      {
        if (!localBitSet.member(j))
          continue;
        if ((this.grammar instanceof LexerGrammar))
        {
          if ((32 <= j) && (j < 127) && (j != 92))
            str = str + this.charFormatter.escapeChar(j, true) + " ";
          else
            str = str + "0x" + Integer.toString(j, 16) + " ";
        }
        else
          str = str + localTokenManager.getTokenStringAt(j) + " ";
        if (str.length() <= 70)
          continue;
        println(str);
        str = "// ";
      }
      if (str != "// ")
        println(str);
      println("const " + namespaceAntlr + "BitSet " + paramString + getBitsetName(i) + "(" + getBitsetName(i) + "_data_," + localBitSet.size() / 32 + ");");
    }
  }

  protected void genBitsetsHeader(Vector paramVector, int paramInt)
  {
    println("");
    for (int i = 0; i < paramVector.size(); i++)
    {
      BitSet localBitSet = (BitSet)paramVector.elementAt(i);
      localBitSet.growToInclude(paramInt);
      println("static const unsigned long " + getBitsetName(i) + "_data_" + "[];");
      println("static const " + namespaceAntlr + "BitSet " + getBitsetName(i) + ";");
    }
  }

  private void genBlockFinish(CppBlockFinishingInfo paramCppBlockFinishingInfo, String paramString)
  {
    if ((paramCppBlockFinishingInfo.needAnErrorClause) && ((paramCppBlockFinishingInfo.generatedAnIf) || (paramCppBlockFinishingInfo.generatedSwitch)))
    {
      if (paramCppBlockFinishingInfo.generatedAnIf)
        println("else {");
      else
        println("{");
      this.tabs += 1;
      println(paramString);
      this.tabs -= 1;
      println("}");
    }
    if (paramCppBlockFinishingInfo.postscript != null)
      println(paramCppBlockFinishingInfo.postscript);
  }

  protected void genBlockInitAction(AlternativeBlock paramAlternativeBlock)
  {
    if (paramAlternativeBlock.initAction != null)
    {
      genLineNo(paramAlternativeBlock);
      printAction(processActionForSpecialSymbols(paramAlternativeBlock.initAction, paramAlternativeBlock.line, this.currentRule, null));
      genLineNo2();
    }
  }

  protected void genBlockPreamble(AlternativeBlock paramAlternativeBlock)
  {
    if ((paramAlternativeBlock instanceof RuleBlock))
    {
      RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
      if (localRuleBlock.labeledElements != null)
        for (int i = 0; i < localRuleBlock.labeledElements.size(); i++)
        {
          AlternativeElement localAlternativeElement = (AlternativeElement)localRuleBlock.labeledElements.elementAt(i);
          if (((localAlternativeElement instanceof RuleRefElement)) || (((localAlternativeElement instanceof AlternativeBlock)) && (!(localAlternativeElement instanceof RuleBlock)) && (!(localAlternativeElement instanceof SynPredBlock))))
          {
            if ((!(localAlternativeElement instanceof RuleRefElement)) && (((AlternativeBlock)localAlternativeElement).not) && (this.analyzer.subruleCanBeInverted((AlternativeBlock)localAlternativeElement, this.grammar instanceof LexerGrammar)))
            {
              println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
              if (!this.grammar.buildAST)
                continue;
              genASTDeclaration(localAlternativeElement);
            }
            else
            {
              if (this.grammar.buildAST)
                genASTDeclaration(localAlternativeElement);
              if ((this.grammar instanceof LexerGrammar))
                println(namespaceAntlr + "RefToken " + localAlternativeElement.getLabel() + ";");
              if (!(this.grammar instanceof TreeWalkerGrammar))
                continue;
              println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
            }
          }
          else
          {
            println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
            if (!this.grammar.buildAST)
              continue;
            if (((localAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)localAlternativeElement).getASTNodeType() != null))
            {
              GrammarAtom localGrammarAtom = (GrammarAtom)localAlternativeElement;
              genASTDeclaration(localAlternativeElement, "Ref" + localGrammarAtom.getASTNodeType());
            }
            else
            {
              genASTDeclaration(localAlternativeElement);
            }
          }
        }
    }
  }

  public void genBody(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    this.outputFile = (this.grammar.getClassName() + ".cpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.genAST = false;
    this.saveText = true;
    this.tabs = 0;
    genHeader(this.outputFile);
    printHeaderAction("pre_include_cpp");
    println("#include \"" + this.grammar.getClassName() + ".hpp\"");
    println("#include <antlr/CharBuffer.hpp>");
    println("#include <antlr/TokenStreamException.hpp>");
    println("#include <antlr/TokenStreamIOException.hpp>");
    println("#include <antlr/TokenStreamRecognitionException.hpp>");
    println("#include <antlr/CharStreamException.hpp>");
    println("#include <antlr/CharStreamIOException.hpp>");
    println("#include <antlr/NoViableAltForCharException.hpp>");
    if (this.grammar.debuggingOutput)
      println("#include <antlr/DebuggingInputBuffer.hpp>");
    println("");
    printHeaderAction("post_include_cpp");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    printAction(this.grammar.preambleAction);
    String str = null;
    if (this.grammar.superClass != null)
    {
      str = this.grammar.superClass;
    }
    else
    {
      str = this.grammar.getSuperClass();
      if (str.lastIndexOf('.') != -1)
        str = str.substring(str.lastIndexOf('.') + 1);
      str = namespaceAntlr + str;
    }
    if (this.noConstructors)
    {
      println("#if 0");
      println("// constructor creation turned of with 'noConstructor' option");
    }
    println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "(" + namespaceStd + "istream& in)");
    this.tabs += 1;
    if (this.grammar.debuggingOutput)
      println(": " + str + "(new " + namespaceAntlr + "DebuggingInputBuffer(new " + namespaceAntlr + "CharBuffer(in))," + paramLexerGrammar.caseSensitive + ")");
    else
      println(": " + str + "(new " + namespaceAntlr + "CharBuffer(in)," + paramLexerGrammar.caseSensitive + ")");
    this.tabs -= 1;
    println("{");
    this.tabs += 1;
    if (this.grammar.debuggingOutput)
    {
      println("setRuleNames(_ruleNames);");
      println("setSemPredNames(_semPredNames);");
      println("setupDebugging();");
    }
    println("initLiterals();");
    this.tabs -= 1;
    println("}");
    println("");
    println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "(" + namespaceAntlr + "InputBuffer& ib)");
    this.tabs += 1;
    if (this.grammar.debuggingOutput)
      println(": " + str + "(new " + namespaceAntlr + "DebuggingInputBuffer(ib)," + paramLexerGrammar.caseSensitive + ")");
    else
      println(": " + str + "(ib," + paramLexerGrammar.caseSensitive + ")");
    this.tabs -= 1;
    println("{");
    this.tabs += 1;
    if (this.grammar.debuggingOutput)
    {
      println("setRuleNames(_ruleNames);");
      println("setSemPredNames(_semPredNames);");
      println("setupDebugging();");
    }
    println("initLiterals();");
    this.tabs -= 1;
    println("}");
    println("");
    println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "(const " + namespaceAntlr + "LexerSharedInputState& state)");
    this.tabs += 1;
    println(": " + str + "(state," + paramLexerGrammar.caseSensitive + ")");
    this.tabs -= 1;
    println("{");
    this.tabs += 1;
    if (this.grammar.debuggingOutput)
    {
      println("setRuleNames(_ruleNames);");
      println("setSemPredNames(_semPredNames);");
      println("setupDebugging();");
    }
    println("initLiterals();");
    this.tabs -= 1;
    println("}");
    println("");
    if (this.noConstructors)
    {
      println("// constructor creation turned of with 'noConstructor' option");
      println("#endif");
    }
    println("void " + this.grammar.getClassName() + "::initLiterals()");
    println("{");
    this.tabs += 1;
    Enumeration localEnumeration = this.grammar.tokenManager.getTokenSymbolKeys();
    Object localObject2;
    while (localEnumeration.hasMoreElements())
    {
      localObject1 = (String)localEnumeration.nextElement();
      if (((String)localObject1).charAt(0) != '"')
        continue;
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol((String)localObject1);
      if (!(localTokenSymbol instanceof StringLiteralSymbol))
        continue;
      localObject2 = (StringLiteralSymbol)localTokenSymbol;
      println("literals[" + ((StringLiteralSymbol)localObject2).getId() + "] = " + ((StringLiteralSymbol)localObject2).getTokenType() + ";");
    }
    this.tabs -= 1;
    println("}");
    if (this.grammar.debuggingOutput)
    {
      println("const char* " + this.grammar.getClassName() + "::_ruleNames[] = {");
      this.tabs += 1;
      localObject1 = this.grammar.rules.elements();
      i = 0;
      while (((Enumeration)localObject1).hasMoreElements())
      {
        localObject2 = (GrammarSymbol)((Enumeration)localObject1).nextElement();
        if (!(localObject2 instanceof RuleSymbol))
          continue;
        println("\"" + ((RuleSymbol)localObject2).getId() + "\",");
      }
      println("0");
      this.tabs -= 1;
      println("};");
    }
    genNextToken();
    Object localObject1 = this.grammar.rules.elements();
    int i = 0;
    while (((Enumeration)localObject1).hasMoreElements())
    {
      localObject2 = (RuleSymbol)((Enumeration)localObject1).nextElement();
      if (!((RuleSymbol)localObject2).getId().equals("mnextToken"))
        genRule((RuleSymbol)localObject2, false, i++, this.grammar.getClassName() + "::");
      exitIfError();
    }
    if (this.grammar.debuggingOutput)
      genSemPredMap(this.grammar.getClassName() + "::");
    genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size(), this.grammar.getClassName() + "::");
    println("");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void genInitFactory(Grammar paramGrammar)
  {
    String str1 = "factory ";
    if (!paramGrammar.buildAST)
      str1 = "";
    println("void " + paramGrammar.getClassName() + "::initializeASTFactory( " + namespaceAntlr + "ASTFactory& " + str1 + ")");
    println("{");
    this.tabs += 1;
    if (paramGrammar.buildAST)
    {
      TokenManager localTokenManager = this.grammar.tokenManager;
      Enumeration localEnumeration = localTokenManager.getTokenSymbolKeys();
      Object localObject;
      while (localEnumeration.hasMoreElements())
      {
        String str2 = (String)localEnumeration.nextElement();
        localObject = localTokenManager.getTokenSymbol(str2);
        if (((TokenSymbol)localObject).getASTNodeType() == null)
          continue;
        this.astTypes.ensureCapacity(((TokenSymbol)localObject).getTokenType());
        String str3 = (String)this.astTypes.elementAt(((TokenSymbol)localObject).getTokenType());
        if (str3 == null)
        {
          this.astTypes.setElementAt(((TokenSymbol)localObject).getASTNodeType(), ((TokenSymbol)localObject).getTokenType());
          continue;
        }
        if (((TokenSymbol)localObject).getASTNodeType().equals(str3))
          continue;
        this.antlrTool.warning("Token " + str2 + " taking most specific AST type", this.grammar.getFilename(), 1, 1);
        this.antlrTool.warning("  using " + str3 + " ignoring " + ((TokenSymbol)localObject).getASTNodeType(), this.grammar.getFilename(), 1, 1);
      }
      for (int i = 0; i < this.astTypes.size(); i++)
      {
        localObject = (String)this.astTypes.elementAt(i);
        if (localObject == null)
          continue;
        println("factory.registerFactory(" + i + ", \"" + (String)localObject + "\", " + (String)localObject + "::factory);");
      }
      println("factory.setMaxNodeType(" + this.grammar.tokenManager.maxTokenType() + ");");
    }
    this.tabs -= 1;
    println("}");
  }

  public void genBody(ParserGrammar paramParserGrammar)
    throws IOException
  {
    this.outputFile = (this.grammar.getClassName() + ".cpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    genHeader(this.outputFile);
    printHeaderAction("pre_include_cpp");
    println("#include \"" + this.grammar.getClassName() + ".hpp\"");
    println("#include <antlr/NoViableAltException.hpp>");
    println("#include <antlr/SemanticException.hpp>");
    println("#include <antlr/ASTFactory.hpp>");
    printHeaderAction("post_include_cpp");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    printAction(this.grammar.preambleAction);
    String str = null;
    if (this.grammar.superClass != null)
    {
      str = this.grammar.superClass;
    }
    else
    {
      str = this.grammar.getSuperClass();
      if (str.lastIndexOf('.') != -1)
        str = str.substring(str.lastIndexOf('.') + 1);
      str = namespaceAntlr + str;
    }
    GrammarSymbol localGrammarSymbol;
    if (this.grammar.debuggingOutput)
    {
      println("const char* " + this.grammar.getClassName() + "::_ruleNames[] = {");
      this.tabs += 1;
      localEnumeration = this.grammar.rules.elements();
      i = 0;
      while (localEnumeration.hasMoreElements())
      {
        localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
        if (!(localGrammarSymbol instanceof RuleSymbol))
          continue;
        println("\"" + ((RuleSymbol)localGrammarSymbol).getId() + "\",");
      }
      println("0");
      this.tabs -= 1;
      println("};");
    }
    if (this.noConstructors)
    {
      println("#if 0");
      println("// constructor creation turned of with 'noConstructor' option");
    }
    print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
    println("(" + namespaceAntlr + "TokenBuffer& tokenBuf, int k)");
    println(": " + str + "(tokenBuf,k)");
    println("{");
    println("}");
    println("");
    print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
    println("(" + namespaceAntlr + "TokenBuffer& tokenBuf)");
    println(": " + str + "(tokenBuf," + this.grammar.maxk + ")");
    println("{");
    println("}");
    println("");
    print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
    println("(" + namespaceAntlr + "TokenStream& lexer, int k)");
    println(": " + str + "(lexer,k)");
    println("{");
    println("}");
    println("");
    print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
    println("(" + namespaceAntlr + "TokenStream& lexer)");
    println(": " + str + "(lexer," + this.grammar.maxk + ")");
    println("{");
    println("}");
    println("");
    print(this.grammar.getClassName() + "::" + this.grammar.getClassName());
    println("(const " + namespaceAntlr + "ParserSharedInputState& state)");
    println(": " + str + "(state," + this.grammar.maxk + ")");
    println("{");
    println("}");
    println("");
    if (this.noConstructors)
    {
      println("// constructor creation turned of with 'noConstructor' option");
      println("#endif");
    }
    this.astTypes = new Vector();
    Enumeration localEnumeration = this.grammar.rules.elements();
    int i = 0;
    while (localEnumeration.hasMoreElements())
    {
      localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, i++, this.grammar.getClassName() + "::");
      }
      exitIfError();
    }
    genInitFactory(paramParserGrammar);
    genTokenStrings(this.grammar.getClassName() + "::");
    genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType(), this.grammar.getClassName() + "::");
    if (this.grammar.debuggingOutput)
      genSemPredMap(this.grammar.getClassName() + "::");
    println("");
    println("");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void genBody(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    this.outputFile = (this.grammar.getClassName() + ".cpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    genHeader(this.outputFile);
    printHeaderAction("pre_include_cpp");
    println("#include \"" + this.grammar.getClassName() + ".hpp\"");
    println("#include <antlr/Token.hpp>");
    println("#include <antlr/AST.hpp>");
    println("#include <antlr/NoViableAltException.hpp>");
    println("#include <antlr/MismatchedTokenException.hpp>");
    println("#include <antlr/SemanticException.hpp>");
    println("#include <antlr/BitSet.hpp>");
    printHeaderAction("post_include_cpp");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    printAction(this.grammar.preambleAction);
    String str1 = null;
    if (this.grammar.superClass != null)
    {
      str1 = this.grammar.superClass;
    }
    else
    {
      str1 = this.grammar.getSuperClass();
      if (str1.lastIndexOf('.') != -1)
        str1 = str1.substring(str1.lastIndexOf('.') + 1);
      str1 = namespaceAntlr + str1;
    }
    if (this.noConstructors)
    {
      println("#if 0");
      println("// constructor creation turned of with 'noConstructor' option");
    }
    println(this.grammar.getClassName() + "::" + this.grammar.getClassName() + "()");
    println("\t: " + namespaceAntlr + "TreeParser() {");
    this.tabs += 1;
    this.tabs -= 1;
    println("}");
    if (this.noConstructors)
    {
      println("// constructor creation turned of with 'noConstructor' option");
      println("#endif");
    }
    println("");
    this.astTypes = new Vector();
    Enumeration localEnumeration = this.grammar.rules.elements();
    int i = 0;
    String str2 = "";
    while (localEnumeration.hasMoreElements())
    {
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)localEnumeration.nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, i++, this.grammar.getClassName() + "::");
      }
      exitIfError();
    }
    genInitFactory(this.grammar);
    genTokenStrings(this.grammar.getClassName() + "::");
    genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType(), this.grammar.getClassName() + "::");
    println("");
    println("");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  protected void genCases(BitSet paramBitSet)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genCases(" + paramBitSet + ")");
    int[] arrayOfInt = paramBitSet.toArray();
    int i = 1;
    int j = 1;
    int k = 1;
    for (int m = 0; m < arrayOfInt.length; m++)
    {
      if (j == 1)
        print("");
      else
        _print("  ");
      _print("case " + getValueString(arrayOfInt[m]) + ":");
      if (j == i)
      {
        _println("");
        k = 1;
        j = 1;
      }
      else
      {
        j++;
        k = 0;
      }
    }
    if (k == 0)
      _println("");
  }

  public CppBlockFinishingInfo genCommonBlock(AlternativeBlock paramAlternativeBlock, boolean paramBoolean)
  {
    int i = 0;
    int j = 0;
    int k = 0;
    CppBlockFinishingInfo localCppBlockFinishingInfo = new CppBlockFinishingInfo();
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genCommonBlk(" + paramAlternativeBlock + ")");
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternativeBlock.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternativeBlock.getAutoGen()));
    Object localObject1;
    if ((paramAlternativeBlock.not) && (this.analyzer.subruleCanBeInverted(paramAlternativeBlock, this.grammar instanceof LexerGrammar)))
    {
      localObject1 = this.analyzer.look(1, paramAlternativeBlock);
      if ((paramAlternativeBlock.getLabel() != null) && (this.syntacticPredLevel == 0))
        println(paramAlternativeBlock.getLabel() + " = " + this.lt1Value + ";");
      genElementAST(paramAlternativeBlock);
      String str1 = "";
      if ((this.grammar instanceof TreeWalkerGrammar))
        if (this.usingCustomAST)
          str1 = namespaceAntlr + "RefAST" + "(_t),";
        else
          str1 = "_t,";
      println("match(" + str1 + getBitsetName(markBitsetForGen(((Lookahead)localObject1).fset)) + ");");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_t = _t->getNextSibling();");
      return localCppBlockFinishingInfo;
    }
    if (paramAlternativeBlock.getAlternatives().size() == 1)
    {
      localObject1 = paramAlternativeBlock.getAlternativeAt(0);
      if (((Alternative)localObject1).synPred != null)
        this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), paramAlternativeBlock.getAlternativeAt(0).synPred.getLine(), paramAlternativeBlock.getAlternativeAt(0).synPred.getColumn());
      if (paramBoolean)
      {
        if (((Alternative)localObject1).semPred != null)
          genSemPred(((Alternative)localObject1).semPred, paramAlternativeBlock.line);
        genAlt((Alternative)localObject1, paramAlternativeBlock);
        return localCppBlockFinishingInfo;
      }
    }
    int m = 0;
    for (int n = 0; n < paramAlternativeBlock.getAlternatives().size(); n++)
    {
      Alternative localAlternative1 = paramAlternativeBlock.getAlternativeAt(n);
      if (!suitableForCaseExpression(localAlternative1))
        continue;
      m++;
    }
    Object localObject2;
    if (m >= this.makeSwitchThreshold)
    {
      String str2 = lookaheadString(1);
      j = 1;
      if ((this.grammar instanceof TreeWalkerGrammar))
      {
        println("if (_t == " + this.labeledElementASTInit + " )");
        this.tabs += 1;
        println("_t = ASTNULL;");
        this.tabs -= 1;
      }
      println("switch ( " + str2 + ") {");
      for (i2 = 0; i2 < paramAlternativeBlock.alternatives.size(); i2++)
      {
        Alternative localAlternative2 = paramAlternativeBlock.getAlternativeAt(i2);
        if (!suitableForCaseExpression(localAlternative2))
          continue;
        localObject2 = localAlternative2.cache[1];
        if ((((Lookahead)localObject2).fset.degree() == 0) && (!((Lookahead)localObject2).containsEpsilon()))
        {
          this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), localAlternative2.head.getLine(), localAlternative2.head.getColumn());
        }
        else
        {
          genCases(((Lookahead)localObject2).fset);
          println("{");
          this.tabs += 1;
          genAlt(localAlternative2, paramAlternativeBlock);
          println("break;");
          this.tabs -= 1;
          println("}");
        }
      }
      println("default:");
      this.tabs += 1;
    }
    int i1 = (this.grammar instanceof LexerGrammar) ? this.grammar.maxk : 0;
    for (int i2 = i1; i2 >= 0; i2--)
    {
      if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
        System.out.println("checking depth " + i2);
      for (i3 = 0; i3 < paramAlternativeBlock.alternatives.size(); i3++)
      {
        localObject2 = paramAlternativeBlock.getAlternativeAt(i3);
        if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
          System.out.println("genAlt: " + i3);
        if ((j != 0) && (suitableForCaseExpression((Alternative)localObject2)))
        {
          if ((!this.DEBUG_CODE_GENERATOR) && (!this.DEBUG_CPP_CODE_GENERATOR))
            continue;
          System.out.println("ignoring alt because it was in the switch");
        }
        else
        {
          boolean bool3 = false;
          String str4;
          if ((this.grammar instanceof LexerGrammar))
          {
            int i4 = ((Alternative)localObject2).lookaheadDepth;
            if (i4 == 2147483647);
            for (i4 = this.grammar.maxk; (i4 >= 1) && (localObject2.cache[i4].containsEpsilon()); i4--);
            if (i4 != i2)
            {
              if ((!this.DEBUG_CODE_GENERATOR) && (!this.DEBUG_CPP_CODE_GENERATOR))
                continue;
              System.out.println("ignoring alt because effectiveDepth!=altDepth;" + i4 + "!=" + i2);
              continue;
            }
            bool3 = lookaheadIsEmpty((Alternative)localObject2, i4);
            str4 = getLookaheadTestExpression((Alternative)localObject2, i4);
          }
          else
          {
            bool3 = lookaheadIsEmpty((Alternative)localObject2, this.grammar.maxk);
            str4 = getLookaheadTestExpression((Alternative)localObject2, this.grammar.maxk);
          }
          if ((localObject2.cache[1].fset.degree() > 127) && (suitableForCaseExpression((Alternative)localObject2)))
          {
            if (i == 0)
            {
              if ((this.grammar instanceof TreeWalkerGrammar))
              {
                println("if (_t == " + this.labeledElementASTInit + " )");
                this.tabs += 1;
                println("_t = ASTNULL;");
                this.tabs -= 1;
              }
              println("if " + str4 + " {");
            }
            else
            {
              println("else if " + str4 + " {");
            }
          }
          else if ((bool3) && (((Alternative)localObject2).semPred == null) && (((Alternative)localObject2).synPred == null))
          {
            if (i == 0)
              println("{");
            else
              println("else {");
            localCppBlockFinishingInfo.needAnErrorClause = false;
          }
          else
          {
            if (((Alternative)localObject2).semPred != null)
            {
              ActionTransInfo localActionTransInfo = new ActionTransInfo();
              String str5 = processActionForSpecialSymbols(((Alternative)localObject2).semPred, paramAlternativeBlock.line, this.currentRule, localActionTransInfo);
              if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
                str4 = "(" + str4 + "&& fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.PREDICTING," + addSemPred(this.charFormatter.escapeString(str5)) + "," + str5 + "))";
              else
                str4 = "(" + str4 + "&&(" + str5 + "))";
            }
            if (i > 0)
            {
              if (((Alternative)localObject2).synPred != null)
              {
                println("else {");
                this.tabs += 1;
                genSynPred(((Alternative)localObject2).synPred, str4);
                k++;
              }
              else
              {
                println("else if " + str4 + " {");
              }
            }
            else if (((Alternative)localObject2).synPred != null)
            {
              genSynPred(((Alternative)localObject2).synPred, str4);
            }
            else
            {
              if ((this.grammar instanceof TreeWalkerGrammar))
              {
                println("if (_t == " + this.labeledElementASTInit + " )");
                this.tabs += 1;
                println("_t = ASTNULL;");
                this.tabs -= 1;
              }
              println("if " + str4 + " {");
            }
          }
          i++;
          this.tabs += 1;
          genAlt((Alternative)localObject2, paramAlternativeBlock);
          this.tabs -= 1;
          println("}");
        }
      }
    }
    String str3 = "";
    for (int i3 = 1; i3 <= k; i3++)
    {
      this.tabs -= 1;
      str3 = str3 + "}";
    }
    this.genAST = bool1;
    this.saveText = bool2;
    if (j != 0)
    {
      this.tabs -= 1;
      localCppBlockFinishingInfo.postscript = (str3 + "}");
      localCppBlockFinishingInfo.generatedSwitch = true;
      localCppBlockFinishingInfo.generatedAnIf = (i > 0);
    }
    else
    {
      localCppBlockFinishingInfo.postscript = str3;
      localCppBlockFinishingInfo.generatedSwitch = false;
      localCppBlockFinishingInfo.generatedAnIf = (i > 0);
    }
    return (CppBlockFinishingInfo)(CppBlockFinishingInfo)localCppBlockFinishingInfo;
  }

  private static boolean suitableForCaseExpression(Alternative paramAlternative)
  {
    return (paramAlternative.lookaheadDepth == 1) && (paramAlternative.semPred == null) && (!paramAlternative.cache[1].containsEpsilon()) && (paramAlternative.cache[1].fset.degree() <= 127);
  }

  private void genElementAST(AlternativeElement paramAlternativeElement)
  {
    if (((this.grammar instanceof TreeWalkerGrammar)) && (!this.grammar.buildAST))
    {
      if (paramAlternativeElement.getLabel() == null)
      {
        String str1 = this.lt1Value;
        String str2 = "tmp" + this.astVarNumber + "_AST";
        this.astVarNumber += 1;
        mapTreeVariable(paramAlternativeElement, str2);
        println(this.labeledElementASTType + " " + str2 + "_in = " + str1 + ";");
      }
      return;
    }
    if ((this.grammar.buildAST) && (this.syntacticPredLevel == 0))
    {
      int i = (this.genAST) && ((paramAlternativeElement.getLabel() != null) || (paramAlternativeElement.getAutoGenType() != 3)) ? 1 : 0;
      if ((paramAlternativeElement.getAutoGenType() != 3) && ((paramAlternativeElement instanceof TokenRefElement)))
        i = 1;
      int j = (this.grammar.hasSyntacticPredicate) && (i != 0) ? 1 : 0;
      String str3;
      String str4;
      if (paramAlternativeElement.getLabel() != null)
      {
        str3 = paramAlternativeElement.getLabel();
        str4 = paramAlternativeElement.getLabel();
      }
      else
      {
        str3 = this.lt1Value;
        str4 = "tmp" + this.astVarNumber;
        this.astVarNumber += 1;
      }
      if (i != 0)
        if ((paramAlternativeElement instanceof GrammarAtom))
        {
          localObject = (GrammarAtom)paramAlternativeElement;
          if (((GrammarAtom)localObject).getASTNodeType() != null)
            genASTDeclaration(paramAlternativeElement, str4, "Ref" + ((GrammarAtom)localObject).getASTNodeType());
          else
            genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
        }
        else
        {
          genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
        }
      Object localObject = str4 + "_AST";
      mapTreeVariable(paramAlternativeElement, (String)localObject);
      if ((this.grammar instanceof TreeWalkerGrammar))
        println(this.labeledElementASTType + " " + (String)localObject + "_in = " + this.labeledElementASTInit + ";");
      if (j != 0)
      {
        println("if ( inputState->guessing == 0 ) {");
        this.tabs += 1;
      }
      if (paramAlternativeElement.getLabel() != null)
        if ((paramAlternativeElement instanceof GrammarAtom))
          println((String)localObject + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + ";");
        else
          println((String)localObject + " = " + getASTCreateString(str3) + ";");
      if ((paramAlternativeElement.getLabel() == null) && (i != 0))
      {
        str3 = this.lt1Value;
        if ((paramAlternativeElement instanceof GrammarAtom))
          println((String)localObject + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + ";");
        else
          println((String)localObject + " = " + getASTCreateString(str3) + ";");
        if ((this.grammar instanceof TreeWalkerGrammar))
          println((String)localObject + "_in = " + str3 + ";");
      }
      if (this.genAST)
        switch (paramAlternativeElement.getAutoGenType())
        {
        case 1:
          if ((this.usingCustomAST) || (((paramAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)paramAlternativeElement).getASTNodeType() != null)))
            println("astFactory->addASTChild(currentAST, " + namespaceAntlr + "RefAST(" + (String)localObject + "));");
          else
            println("astFactory->addASTChild(currentAST, " + (String)localObject + ");");
          break;
        case 2:
          if ((this.usingCustomAST) || (((paramAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)paramAlternativeElement).getASTNodeType() != null)))
            println("astFactory->makeASTRoot(currentAST, " + namespaceAntlr + "RefAST(" + (String)localObject + "));");
          else
            println("astFactory->makeASTRoot(currentAST, " + (String)localObject + ");");
          break;
        }
      if (j != 0)
      {
        this.tabs -= 1;
        println("}");
      }
    }
  }

  private void genErrorCatchForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      this.tabs -= 1;
      println("}");
      genErrorHandler(localExceptionSpec);
    }
  }

  private void genErrorHandler(ExceptionSpec paramExceptionSpec)
  {
    for (int i = 0; i < paramExceptionSpec.handlers.size(); i++)
    {
      ExceptionHandler localExceptionHandler = (ExceptionHandler)paramExceptionSpec.handlers.elementAt(i);
      println("catch (" + localExceptionHandler.exceptionTypeAndName.getText() + ") {");
      this.tabs += 1;
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if (inputState->guessing==0) {");
        this.tabs += 1;
      }
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      genLineNo(localExceptionHandler.action);
      printAction(processActionForSpecialSymbols(localExceptionHandler.action.getText(), localExceptionHandler.action.getLine(), this.currentRule, localActionTransInfo));
      genLineNo2();
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("} else {");
        this.tabs += 1;
        println("throw;");
        this.tabs -= 1;
        println("}");
      }
      this.tabs -= 1;
      println("}");
    }
  }

  private void genErrorTryForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      println("try { // for error handling");
      this.tabs += 1;
    }
  }

  protected void genHeader(String paramString)
  {
    println("/* $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + paramString + "\"$ */");
  }

  public void genInclude(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    this.outputFile = (this.grammar.getClassName() + ".hpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.genAST = false;
    this.saveText = true;
    this.tabs = 0;
    println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
    println("#define INC_" + this.grammar.getClassName() + "_hpp_");
    println("");
    printHeaderAction("pre_include_hpp");
    println("#include <antlr/config.hpp>");
    genHeader(this.outputFile);
    println("#include <antlr/CommonToken.hpp>");
    println("#include <antlr/InputBuffer.hpp>");
    println("#include <antlr/BitSet.hpp>");
    println("#include \"" + this.grammar.tokenManager.getName() + TokenTypesFileSuffix + ".hpp\"");
    String str = null;
    if (this.grammar.superClass != null)
    {
      str = this.grammar.superClass;
      println("\n// Include correct superclass header with a header statement for example:");
      println("// header \"post_include_hpp\" {");
      println("// #include \"" + str + ".hpp\"");
      println("// }");
      println("// Or....");
      println("// header {");
      println("// #include \"" + str + ".hpp\"");
      println("// }\n");
    }
    else
    {
      str = this.grammar.getSuperClass();
      if (str.lastIndexOf('.') != -1)
        str = str.substring(str.lastIndexOf('.') + 1);
      println("#include <antlr/" + str + ".hpp>");
      str = namespaceAntlr + str;
    }
    printHeaderAction("post_include_hpp");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    printHeaderAction("");
    if (this.grammar.comment != null)
      _println(this.grammar.comment);
    print("class CUSTOM_API " + this.grammar.getClassName() + " : public " + str);
    println(", public " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
    Token localToken = (Token)this.grammar.options.get("classHeaderSuffix");
    if (localToken != null)
    {
      localObject = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject != null)
        print(", " + (String)localObject);
    }
    println("{");
    if (this.grammar.classMemberAction != null)
    {
      genLineNo(this.grammar.classMemberAction);
      print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
      genLineNo2();
    }
    this.tabs = 0;
    println("private:");
    this.tabs = 1;
    println("void initLiterals();");
    this.tabs = 0;
    println("public:");
    this.tabs = 1;
    println("bool getCaseSensitiveLiterals() const");
    println("{");
    this.tabs += 1;
    println("return " + paramLexerGrammar.caseSensitiveLiterals + ";");
    this.tabs -= 1;
    println("}");
    this.tabs = 0;
    println("public:");
    this.tabs = 1;
    if (this.noConstructors)
    {
      this.tabs = 0;
      println("#if 0");
      println("// constructor creation turned of with 'noConstructor' option");
      this.tabs = 1;
    }
    println(this.grammar.getClassName() + "(" + namespaceStd + "istream& in);");
    println(this.grammar.getClassName() + "(" + namespaceAntlr + "InputBuffer& ib);");
    println(this.grammar.getClassName() + "(const " + namespaceAntlr + "LexerSharedInputState& state);");
    if (this.noConstructors)
    {
      this.tabs = 0;
      println("// constructor creation turned of with 'noConstructor' option");
      println("#endif");
      this.tabs = 1;
    }
    println(namespaceAntlr + "RefToken nextToken();");
    Object localObject = this.grammar.rules.elements();
    while (((Enumeration)localObject).hasMoreElements())
    {
      RuleSymbol localRuleSymbol = (RuleSymbol)((Enumeration)localObject).nextElement();
      if (!localRuleSymbol.getId().equals("mnextToken"))
        genRuleHeader(localRuleSymbol, false);
      exitIfError();
    }
    this.tabs = 0;
    println("private:");
    this.tabs = 1;
    if (this.grammar.debuggingOutput)
      println("static const char* _ruleNames[];");
    if (this.grammar.debuggingOutput)
      println("static const char* _semPredNames[];");
    genBitsetsHeader(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
    this.tabs = 0;
    println("};");
    println("");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void genInclude(ParserGrammar paramParserGrammar)
    throws IOException
  {
    this.outputFile = (this.grammar.getClassName() + ".hpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
    println("#define INC_" + this.grammar.getClassName() + "_hpp_");
    println("");
    printHeaderAction("pre_include_hpp");
    println("#include <antlr/config.hpp>");
    genHeader(this.outputFile);
    println("#include <antlr/TokenStream.hpp>");
    println("#include <antlr/TokenBuffer.hpp>");
    println("#include \"" + this.grammar.tokenManager.getName() + TokenTypesFileSuffix + ".hpp\"");
    String str = null;
    if (this.grammar.superClass != null)
    {
      str = this.grammar.superClass;
      println("\n// Include correct superclass header with a header statement for example:");
      println("// header \"post_include_hpp\" {");
      println("// #include \"" + str + ".hpp\"");
      println("// }");
      println("// Or....");
      println("// header {");
      println("// #include \"" + str + ".hpp\"");
      println("// }\n");
    }
    else
    {
      str = this.grammar.getSuperClass();
      if (str.lastIndexOf('.') != -1)
        str = str.substring(str.lastIndexOf('.') + 1);
      println("#include <antlr/" + str + ".hpp>");
      str = namespaceAntlr + str;
    }
    println("");
    printHeaderAction("post_include_hpp");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    printHeaderAction("");
    if (this.grammar.comment != null)
      _println(this.grammar.comment);
    print("class CUSTOM_API " + this.grammar.getClassName() + " : public " + str);
    println(", public " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
    Token localToken = (Token)this.grammar.options.get("classHeaderSuffix");
    if (localToken != null)
    {
      localObject = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject != null)
        print(", " + (String)localObject);
    }
    println("{");
    if (this.grammar.debuggingOutput)
      println("public: static const char* _ruleNames[];");
    if (this.grammar.classMemberAction != null)
    {
      genLineNo(this.grammar.classMemberAction.getLine());
      print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
      genLineNo2();
    }
    println("public:");
    this.tabs = 1;
    println("void initializeASTFactory( " + namespaceAntlr + "ASTFactory& factory );");
    this.tabs = 0;
    if (this.noConstructors)
    {
      println("#if 0");
      println("// constructor creation turned of with 'noConstructor' option");
    }
    println("protected:");
    this.tabs = 1;
    println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenBuffer& tokenBuf, int k);");
    this.tabs = 0;
    println("public:");
    this.tabs = 1;
    println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenBuffer& tokenBuf);");
    this.tabs = 0;
    println("protected:");
    this.tabs = 1;
    println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenStream& lexer, int k);");
    this.tabs = 0;
    println("public:");
    this.tabs = 1;
    println(this.grammar.getClassName() + "(" + namespaceAntlr + "TokenStream& lexer);");
    println(this.grammar.getClassName() + "(const " + namespaceAntlr + "ParserSharedInputState& state);");
    if (this.noConstructors)
    {
      this.tabs = 0;
      println("// constructor creation turned of with 'noConstructor' option");
      println("#endif");
      this.tabs = 1;
    }
    println("int getNumTokens() const");
    println("{");
    this.tabs += 1;
    println("return " + this.grammar.getClassName() + "::NUM_TOKENS;");
    this.tabs -= 1;
    println("}");
    println("const char* getTokenName( int type ) const");
    println("{");
    this.tabs += 1;
    println("if( type > getNumTokens() ) return 0;");
    println("return " + this.grammar.getClassName() + "::tokenNames[type];");
    this.tabs -= 1;
    println("}");
    println("const char* const* getTokenNames() const");
    println("{");
    this.tabs += 1;
    println("return " + this.grammar.getClassName() + "::tokenNames;");
    this.tabs -= 1;
    println("}");
    Object localObject = this.grammar.rules.elements();
    while (((Enumeration)localObject).hasMoreElements())
    {
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject).nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRuleHeader(localRuleSymbol, localRuleSymbol.references.size() == 0);
      }
      exitIfError();
    }
    this.tabs = 0;
    println("public:");
    this.tabs = 1;
    println(namespaceAntlr + "RefAST getAST()");
    println("{");
    if (this.usingCustomAST)
    {
      this.tabs += 1;
      println("return " + namespaceAntlr + "RefAST(returnAST);");
      this.tabs -= 1;
    }
    else
    {
      this.tabs += 1;
      println("return returnAST;");
      this.tabs -= 1;
    }
    println("}");
    println("");
    this.tabs = 0;
    println("protected:");
    this.tabs = 1;
    println(this.labeledElementASTType + " returnAST;");
    this.tabs = 0;
    println("private:");
    this.tabs = 1;
    println("static const char* tokenNames[];");
    _println("#ifndef NO_STATIC_CONSTS");
    println("static const int NUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size() + ";");
    _println("#else");
    println("enum {");
    println("\tNUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size());
    println("};");
    _println("#endif");
    genBitsetsHeader(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
    if (this.grammar.debuggingOutput)
      println("static const char* _semPredNames[];");
    this.tabs = 0;
    println("};");
    println("");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void genInclude(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    this.outputFile = (this.grammar.getClassName() + ".hpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    println("#ifndef INC_" + this.grammar.getClassName() + "_hpp_");
    println("#define INC_" + this.grammar.getClassName() + "_hpp_");
    println("");
    printHeaderAction("pre_include_hpp");
    println("#include <antlr/config.hpp>");
    println("#include \"" + this.grammar.tokenManager.getName() + TokenTypesFileSuffix + ".hpp\"");
    genHeader(this.outputFile);
    String str1 = null;
    if (this.grammar.superClass != null)
    {
      str1 = this.grammar.superClass;
      println("\n// Include correct superclass header with a header statement for example:");
      println("// header \"post_include_hpp\" {");
      println("// #include \"" + str1 + ".hpp\"");
      println("// }");
      println("// Or....");
      println("// header {");
      println("// #include \"" + str1 + ".hpp\"");
      println("// }\n");
    }
    else
    {
      str1 = this.grammar.getSuperClass();
      if (str1.lastIndexOf('.') != -1)
        str1 = str1.substring(str1.lastIndexOf('.') + 1);
      println("#include <antlr/" + str1 + ".hpp>");
      str1 = namespaceAntlr + str1;
    }
    println("");
    printHeaderAction("post_include_hpp");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    printHeaderAction("");
    if (this.grammar.comment != null)
      _println(this.grammar.comment);
    print("class CUSTOM_API " + this.grammar.getClassName() + " : public " + str1);
    println(", public " + this.grammar.tokenManager.getName() + TokenTypesFileSuffix);
    Token localToken = (Token)this.grammar.options.get("classHeaderSuffix");
    if (localToken != null)
    {
      localObject = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject != null)
        print(", " + (String)localObject);
    }
    println("{");
    if (this.grammar.classMemberAction != null)
    {
      genLineNo(this.grammar.classMemberAction.getLine());
      print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
      genLineNo2();
    }
    this.tabs = 0;
    println("public:");
    if (this.noConstructors)
    {
      println("#if 0");
      println("// constructor creation turned of with 'noConstructor' option");
    }
    this.tabs = 1;
    println(this.grammar.getClassName() + "();");
    if (this.noConstructors)
    {
      this.tabs = 0;
      println("#endif");
      this.tabs = 1;
    }
    println("static void initializeASTFactory( " + namespaceAntlr + "ASTFactory& factory );");
    println("int getNumTokens() const");
    println("{");
    this.tabs += 1;
    println("return " + this.grammar.getClassName() + "::NUM_TOKENS;");
    this.tabs -= 1;
    println("}");
    println("const char* getTokenName( int type ) const");
    println("{");
    this.tabs += 1;
    println("if( type > getNumTokens() ) return 0;");
    println("return " + this.grammar.getClassName() + "::tokenNames[type];");
    this.tabs -= 1;
    println("}");
    println("const char* const* getTokenNames() const");
    println("{");
    this.tabs += 1;
    println("return " + this.grammar.getClassName() + "::tokenNames;");
    this.tabs -= 1;
    println("}");
    Object localObject = this.grammar.rules.elements();
    String str2 = "";
    while (((Enumeration)localObject).hasMoreElements())
    {
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject).nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRuleHeader(localRuleSymbol, localRuleSymbol.references.size() == 0);
      }
      exitIfError();
    }
    this.tabs = 0;
    println("public:");
    this.tabs = 1;
    println(namespaceAntlr + "RefAST getAST()");
    println("{");
    if (this.usingCustomAST)
    {
      this.tabs += 1;
      println("return " + namespaceAntlr + "RefAST(returnAST);");
      this.tabs -= 1;
    }
    else
    {
      this.tabs += 1;
      println("return returnAST;");
      this.tabs -= 1;
    }
    println("}");
    println("");
    this.tabs = 0;
    println("protected:");
    this.tabs = 1;
    println(this.labeledElementASTType + " returnAST;");
    println(this.labeledElementASTType + " _retTree;");
    this.tabs = 0;
    println("private:");
    this.tabs = 1;
    println("static const char* tokenNames[];");
    _println("#ifndef NO_STATIC_CONSTS");
    println("static const int NUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size() + ";");
    _println("#else");
    println("enum {");
    println("\tNUM_TOKENS = " + this.grammar.tokenManager.getVocabulary().size());
    println("};");
    _println("#endif");
    genBitsetsHeader(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
    this.tabs = 0;
    println("};");
    println("");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    println("#endif /*INC_" + this.grammar.getClassName() + "_hpp_*/");
    this.currentOutput.close();
    this.currentOutput = null;
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement)
  {
    genASTDeclaration(paramAlternativeElement, this.labeledElementASTType);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString)
  {
    genASTDeclaration(paramAlternativeElement, paramAlternativeElement.getLabel(), paramString);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString1, String paramString2)
  {
    if (this.declaredASTVariables.contains(paramAlternativeElement))
      return;
    String str = this.labeledElementASTInit;
    if (((paramAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)paramAlternativeElement).getASTNodeType() != null))
      str = "Ref" + ((GrammarAtom)paramAlternativeElement).getASTNodeType() + "(" + this.labeledElementASTInit + ")";
    println(paramString2 + " " + paramString1 + "_AST = " + str + ";");
    this.declaredASTVariables.put(paramAlternativeElement, paramAlternativeElement);
  }

  private void genLiteralsTest()
  {
    println("_ttype = testLiteralsTable(_ttype);");
  }

  private void genLiteralsTestForPartialToken()
  {
    println("_ttype = testLiteralsTable(text.substr(_begin, text.length()-_begin),_ttype);");
  }

  protected void genMatch(BitSet paramBitSet)
  {
  }

  protected void genMatch(GrammarAtom paramGrammarAtom)
  {
    if ((paramGrammarAtom instanceof StringLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        genMatchUsingAtomTokenType(paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof CharLiteralElement))
      this.antlrTool.error("cannot ref character literals in grammar: " + paramGrammarAtom);
    else if ((paramGrammarAtom instanceof TokenRefElement))
      genMatchUsingAtomTokenType(paramGrammarAtom);
    else if ((paramGrammarAtom instanceof WildcardElement))
      gen((WildcardElement)paramGrammarAtom);
  }

  protected void genMatchUsingAtomText(GrammarAtom paramGrammarAtom)
  {
    String str1 = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (this.usingCustomAST)
        str1 = namespaceAntlr + "RefAST" + "(_t),";
      else
        str1 = "_t,";
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
      println("_saveIndex = text.length();");
    print(paramGrammarAtom.not ? "matchNot(" : "match(");
    _print(str1);
    if (paramGrammarAtom.atomText.equals("EOF"))
    {
      _print(namespaceAntlr + "Token::EOF_TYPE");
    }
    else if ((this.grammar instanceof LexerGrammar))
    {
      String str2 = convertJavaToCppString(paramGrammarAtom.atomText, false);
      _print(str2);
    }
    else
    {
      _print(paramGrammarAtom.atomText);
    }
    _println(");");
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
      println("text.erase(_saveIndex);");
  }

  protected void genMatchUsingAtomTokenType(GrammarAtom paramGrammarAtom)
  {
    String str1 = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (this.usingCustomAST)
        str1 = namespaceAntlr + "RefAST" + "(_t),";
      else
        str1 = "_t,";
    String str2 = str1 + getValueString(paramGrammarAtom.getType());
    println((paramGrammarAtom.not ? "matchNot(" : "match(") + str2 + ");");
  }

  public void genNextToken()
  {
    int i = 0;
    for (int j = 0; j < this.grammar.rules.size(); j++)
    {
      localRuleSymbol1 = (RuleSymbol)this.grammar.rules.elementAt(j);
      if ((!localRuleSymbol1.isDefined()) || (!localRuleSymbol1.access.equals("public")))
        continue;
      i = 1;
      break;
    }
    if (i == 0)
    {
      println("");
      println(namespaceAntlr + "RefToken " + this.grammar.getClassName() + "::nextToken() { return " + namespaceAntlr + "RefToken(new " + namespaceAntlr + "CommonToken(" + namespaceAntlr + "Token::EOF_TYPE, \"\")); }");
      println("");
      return;
    }
    RuleBlock localRuleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
    RuleSymbol localRuleSymbol1 = new RuleSymbol("mnextToken");
    localRuleSymbol1.setDefined();
    localRuleSymbol1.setBlock(localRuleBlock);
    localRuleSymbol1.access = "private";
    this.grammar.define(localRuleSymbol1);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
    String str1 = null;
    if (((LexerGrammar)this.grammar).filterMode)
      str1 = ((LexerGrammar)this.grammar).filterRule;
    println("");
    println(namespaceAntlr + "RefToken " + this.grammar.getClassName() + "::nextToken()");
    println("{");
    this.tabs += 1;
    println(namespaceAntlr + "RefToken theRetToken;");
    println("for (;;) {");
    this.tabs += 1;
    println(namespaceAntlr + "RefToken theRetToken;");
    println("int _ttype = " + namespaceAntlr + "Token::INVALID_TYPE;");
    if (((LexerGrammar)this.grammar).filterMode)
    {
      println("setCommitToPath(false);");
      if (str1 != null)
      {
        if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(str1)))
        {
          this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
        }
        else
        {
          RuleSymbol localRuleSymbol2 = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(str1));
          if (!localRuleSymbol2.isDefined())
            this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
          else if (localRuleSymbol2.access.equals("public"))
            this.grammar.antlrTool.error("Filter rule " + str1 + " must be protected");
        }
        println("int _m;");
        println("_m = mark();");
      }
    }
    println("resetText();");
    println("try {   // for lexical and char stream error handling");
    this.tabs += 1;
    for (int k = 0; k < localRuleBlock.getAlternatives().size(); k++)
    {
      localObject = localRuleBlock.getAlternativeAt(k);
      if (!localObject.cache[1].containsEpsilon())
        continue;
      this.antlrTool.warning("found optional path in nextToken()");
    }
    String str2 = System.getProperty("line.separator");
    Object localObject = genCommonBlock(localRuleBlock, false);
    String str3 = "if (LA(1)==EOF_CHAR)" + str2 + "\t\t\t\t{" + str2 + "\t\t\t\t\tuponEOF();" + str2 + "\t\t\t\t\t_returnToken = makeToken(" + namespaceAntlr + "Token::EOF_TYPE);" + str2 + "\t\t\t\t}";
    str3 = str3 + str2 + "\t\t\t\t";
    if (((LexerGrammar)this.grammar).filterMode)
    {
      if (str1 == null)
        str3 = str3 + "else {consume(); goto tryAgain;}";
      else
        str3 = str3 + "else {" + str2 + "\t\t\t\t\tcommit();" + str2 + "\t\t\t\t\ttry {m" + str1 + "(false);}" + str2 + "\t\t\t\t\tcatch(" + namespaceAntlr + "RecognitionException& e) {" + str2 + "\t\t\t\t\t\t// catastrophic failure" + str2 + "\t\t\t\t\t\treportError(e);" + str2 + "\t\t\t\t\t\tconsume();" + str2 + "\t\t\t\t\t}" + str2 + "\t\t\t\t\tgoto tryAgain;" + str2 + "\t\t\t\t}";
    }
    else
      str3 = str3 + "else {" + this.throwNoViable + "}";
    genBlockFinish((CppBlockFinishingInfo)localObject, str3);
    if ((((LexerGrammar)this.grammar).filterMode) && (str1 != null))
      println("commit();");
    println("if ( !_returnToken )" + str2 + "\t\t\t\tgoto tryAgain; // found SKIP token" + str2);
    println("_ttype = _returnToken->getType();");
    if (((LexerGrammar)this.grammar).getTestLiterals())
      genLiteralsTest();
    println("_returnToken->setType(_ttype);");
    println("return _returnToken;");
    this.tabs -= 1;
    println("}");
    println("catch (" + namespaceAntlr + "RecognitionException& e) {");
    this.tabs += 1;
    if (((LexerGrammar)this.grammar).filterMode)
      if (str1 == null)
      {
        println("if ( !getCommitToPath() ) {");
        this.tabs += 1;
        println("consume();");
        println("goto tryAgain;");
        this.tabs -= 1;
        println("}");
      }
      else
      {
        println("if ( !getCommitToPath() ) {");
        this.tabs += 1;
        println("rewind(_m);");
        println("resetText();");
        println("try {m" + str1 + "(false);}");
        println("catch(" + namespaceAntlr + "RecognitionException& ee) {");
        println("\t// horrendous failure: error in filter rule");
        println("\treportError(ee);");
        println("\tconsume();");
        println("}");
        this.tabs -= 1;
        println("}");
        println("else");
      }
    if (localRuleBlock.getDefaultErrorHandler())
    {
      println("{");
      this.tabs += 1;
      println("reportError(e);");
      println("consume();");
      this.tabs -= 1;
      println("}");
    }
    else
    {
      this.tabs += 1;
      println("throw " + namespaceAntlr + "TokenStreamRecognitionException(e);");
      this.tabs -= 1;
    }
    this.tabs -= 1;
    println("}");
    println("catch (" + namespaceAntlr + "CharStreamIOException& csie) {");
    println("\tthrow " + namespaceAntlr + "TokenStreamIOException(csie.io);");
    println("}");
    println("catch (" + namespaceAntlr + "CharStreamException& cse) {");
    println("\tthrow " + namespaceAntlr + "TokenStreamException(cse.getMessage());");
    println("}");
    _println("tryAgain:;");
    this.tabs -= 1;
    println("}");
    this.tabs -= 1;
    println("}");
    println("");
  }

  public void genRule(RuleSymbol paramRuleSymbol, boolean paramBoolean, int paramInt, String paramString)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genRule(" + paramRuleSymbol.getId() + ")");
    if (!paramRuleSymbol.isDefined())
    {
      this.antlrTool.error("undefined rule: " + paramRuleSymbol.getId());
      return;
    }
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    this.currentRule = localRuleBlock;
    this.currentASTResult = paramRuleSymbol.getId();
    this.declaredASTVariables.clear();
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (localRuleBlock.getAutoGen()));
    this.saveText = localRuleBlock.getAutoGen();
    if (paramRuleSymbol.comment != null)
      _println(paramRuleSymbol.comment);
    if (localRuleBlock.returnAction != null)
      _print(extractTypeOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + " ");
    else
      _print("void ");
    _print(paramString + paramRuleSymbol.getId() + "(");
    _print(this.commonExtraParams);
    if ((this.commonExtraParams.length() != 0) && (localRuleBlock.argAction != null))
      _print(",");
    Object localObject2;
    Object localObject3;
    if (localRuleBlock.argAction != null)
    {
      _println("");
      this.tabs += 1;
      localObject1 = localRuleBlock.argAction;
      localObject2 = "";
      localObject3 = "";
      int i = ((String)localObject1).indexOf('=');
      if (i != -1)
      {
        int j = 0;
        while ((j != -1) && (i != -1))
        {
          localObject2 = (String)localObject2 + (String)localObject3 + ((String)localObject1).substring(0, i).trim();
          localObject3 = ", ";
          j = ((String)localObject1).indexOf(',', i);
          if (j == -1)
            continue;
          localObject1 = ((String)localObject1).substring(j + 1).trim();
          i = ((String)localObject1).indexOf('=');
          if (i != -1)
            continue;
          localObject2 = (String)localObject2 + (String)localObject3 + (String)localObject1;
        }
      }
      localObject2 = localObject1;
      println((String)localObject2);
      this.tabs -= 1;
      print(") ");
    }
    else
    {
      _print(") ");
    }
    _println("{");
    this.tabs += 1;
    if (this.grammar.traceRules)
      if ((this.grammar instanceof TreeWalkerGrammar))
      {
        if (this.usingCustomAST)
          println("Tracer traceInOut(this,\"" + paramRuleSymbol.getId() + "\"," + namespaceAntlr + "RefAST" + "(_t));");
        else
          println("Tracer traceInOut(this,\"" + paramRuleSymbol.getId() + "\",_t);");
      }
      else
        println("Tracer traceInOut(this, \"" + paramRuleSymbol.getId() + "\");");
    if (localRuleBlock.returnAction != null)
    {
      genLineNo(localRuleBlock);
      println(localRuleBlock.returnAction + ";");
      genLineNo2();
    }
    if (!this.commonLocalVars.equals(""))
      println(this.commonLocalVars);
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramRuleSymbol.getId().equals("mEOF"))
        println("_ttype = " + namespaceAntlr + "Token::EOF_TYPE;");
      else
        println("_ttype = " + paramRuleSymbol.getId().substring(1) + ";");
      println(namespaceStd + "string::size_type _saveIndex;");
    }
    if (this.grammar.debuggingOutput)
      if ((this.grammar instanceof ParserGrammar))
        println("fireEnterRule(" + paramInt + ",0);");
      else if ((this.grammar instanceof LexerGrammar))
        println("fireEnterRule(" + paramInt + ",_ttype);");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println(this.labeledElementASTType + " " + paramRuleSymbol.getId() + "_AST_in = (_t == " + this.labeledElementASTType + "(ASTNULL)) ? " + this.labeledElementASTInit + " : _t;");
    if (this.grammar.buildAST)
    {
      println("returnAST = " + this.labeledElementASTInit + ";");
      println(namespaceAntlr + "ASTPair currentAST;");
      println(this.labeledElementASTType + " " + paramRuleSymbol.getId() + "_AST = " + this.labeledElementASTInit + ";");
    }
    genBlockPreamble(localRuleBlock);
    genBlockInitAction(localRuleBlock);
    println("");
    Object localObject1 = localRuleBlock.findExceptionSpec("");
    if ((localObject1 != null) || (localRuleBlock.getDefaultErrorHandler()))
    {
      println("try {      // for error handling");
      this.tabs += 1;
    }
    if (localRuleBlock.alternatives.size() == 1)
    {
      localObject2 = localRuleBlock.getAlternativeAt(0);
      localObject3 = ((Alternative)localObject2).semPred;
      if (localObject3 != null)
        genSemPred((String)localObject3, this.currentRule.line);
      if (((Alternative)localObject2).synPred != null)
        this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), ((Alternative)localObject2).synPred.getLine(), ((Alternative)localObject2).synPred.getColumn());
      genAlt((Alternative)localObject2, localRuleBlock);
    }
    else
    {
      boolean bool2 = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
      localObject3 = genCommonBlock(localRuleBlock, false);
      genBlockFinish((CppBlockFinishingInfo)localObject3, this.throwNoViable);
    }
    if ((localObject1 != null) || (localRuleBlock.getDefaultErrorHandler()))
    {
      this.tabs -= 1;
      println("}");
    }
    if (localObject1 != null)
    {
      genErrorHandler((ExceptionSpec)localObject1);
    }
    else if (localRuleBlock.getDefaultErrorHandler())
    {
      println("catch (" + this.exceptionThrown + "& ex) {");
      this.tabs += 1;
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if( inputState->guessing == 0 ) {");
        this.tabs += 1;
      }
      println("reportError(ex);");
      if (!(this.grammar instanceof TreeWalkerGrammar))
      {
        Lookahead localLookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, localRuleBlock.endNode);
        localObject3 = getBitsetName(markBitsetForGen(localLookahead.fset));
        println("recover(ex," + (String)localObject3 + ");");
      }
      else
      {
        println("if ( _t != " + this.labeledElementASTInit + " )");
        this.tabs += 1;
        println("_t = _t->getNextSibling();");
        this.tabs -= 1;
      }
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("} else {");
        this.tabs += 1;
        println("throw;");
        this.tabs -= 1;
        println("}");
      }
      this.tabs -= 1;
      println("}");
    }
    if (this.grammar.buildAST)
      println("returnAST = " + paramRuleSymbol.getId() + "_AST;");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_retTree = _t;");
    if (localRuleBlock.getTestLiterals())
      if (paramRuleSymbol.access.equals("protected"))
        genLiteralsTestForPartialToken();
      else
        genLiteralsTest();
    if ((this.grammar instanceof LexerGrammar))
    {
      println("if ( _createToken && _token==" + namespaceAntlr + "nullToken && _ttype!=" + namespaceAntlr + "Token::SKIP ) {");
      println("   _token = makeToken(_ttype);");
      println("   _token->setText(text.substr(_begin, text.length()-_begin));");
      println("}");
      println("_returnToken = _token;");
      println("_saveIndex=0;");
    }
    if (localRuleBlock.returnAction != null)
      println("return " + extractIdOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + ";");
    this.tabs -= 1;
    println("}");
    println("");
    this.genAST = bool1;
  }

  public void genRuleHeader(RuleSymbol paramRuleSymbol, boolean paramBoolean)
  {
    this.tabs = 1;
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("genRuleHeader(" + paramRuleSymbol.getId() + ")");
    if (!paramRuleSymbol.isDefined())
    {
      this.antlrTool.error("undefined rule: " + paramRuleSymbol.getId());
      return;
    }
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    this.currentRule = localRuleBlock;
    this.currentASTResult = paramRuleSymbol.getId();
    boolean bool = this.genAST;
    this.genAST = ((this.genAST) && (localRuleBlock.getAutoGen()));
    this.saveText = localRuleBlock.getAutoGen();
    print(paramRuleSymbol.access + ": ");
    if (localRuleBlock.returnAction != null)
      _print(extractTypeOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + " ");
    else
      _print("void ");
    _print(paramRuleSymbol.getId() + "(");
    _print(this.commonExtraParams);
    if ((this.commonExtraParams.length() != 0) && (localRuleBlock.argAction != null))
      _print(",");
    if (localRuleBlock.argAction != null)
    {
      _println("");
      this.tabs += 1;
      println(localRuleBlock.argAction);
      this.tabs -= 1;
      print(")");
    }
    else
    {
      _print(")");
    }
    _println(";");
    this.tabs -= 1;
    this.genAST = bool;
  }

  private void GenRuleInvocation(RuleRefElement paramRuleRefElement)
  {
    _print(paramRuleRefElement.targetRule + "(");
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramRuleRefElement.getLabel() != null)
        _print("true");
      else
        _print("false");
      if ((this.commonExtraArgs.length() != 0) || (paramRuleRefElement.args != null))
        _print(",");
    }
    _print(this.commonExtraArgs);
    if ((this.commonExtraArgs.length() != 0) && (paramRuleRefElement.args != null))
      _print(",");
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    if (paramRuleRefElement.args != null)
    {
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      String str = processActionForSpecialSymbols(paramRuleRefElement.args, paramRuleRefElement.line, this.currentRule, localActionTransInfo);
      if ((localActionTransInfo.assignToRoot) || (localActionTransInfo.refRuleRoot != null))
        this.antlrTool.error("Arguments of rule reference '" + paramRuleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName() + " on line " + paramRuleRefElement.getLine());
      _print(str);
      if (localRuleSymbol.block.argAction == null)
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' accepts no arguments", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    _println(");");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _retTree;");
  }

  protected void genSemPred(String paramString, int paramInt)
  {
    ActionTransInfo localActionTransInfo = new ActionTransInfo();
    paramString = processActionForSpecialSymbols(paramString, paramInt, this.currentRule, localActionTransInfo);
    String str = this.charFormatter.escapeString(paramString);
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      paramString = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + addSemPred(str) + "," + paramString + ")";
    println("if (!(" + paramString + "))");
    this.tabs += 1;
    println("throw " + namespaceAntlr + "SemanticException(\"" + str + "\");");
    this.tabs -= 1;
  }

  protected void genSemPredMap(String paramString)
  {
    Enumeration localEnumeration = this.semPreds.elements();
    println("const char* " + paramString + "_semPredNames[] = {");
    this.tabs += 1;
    while (localEnumeration.hasMoreElements())
      println("\"" + localEnumeration.nextElement() + "\",");
    println("0");
    this.tabs -= 1;
    println("};");
  }

  protected void genSynPred(SynPredBlock paramSynPredBlock, String paramString)
  {
    if ((this.DEBUG_CODE_GENERATOR) || (this.DEBUG_CPP_CODE_GENERATOR))
      System.out.println("gen=>(" + paramSynPredBlock + ")");
    println("bool synPredMatched" + paramSynPredBlock.ID + " = false;");
    println("if (" + paramString + ") {");
    this.tabs += 1;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println(this.labeledElementType + " __t" + paramSynPredBlock.ID + " = _t;");
    else
      println("int _m" + paramSynPredBlock.ID + " = mark();");
    println("synPredMatched" + paramSynPredBlock.ID + " = true;");
    println("inputState->guessing++;");
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      println("fireSyntacticPredicateStarted();");
    this.syntacticPredLevel += 1;
    println("try {");
    this.tabs += 1;
    gen(paramSynPredBlock);
    this.tabs -= 1;
    println("}");
    println("catch (" + this.exceptionThrown + "& pe) {");
    this.tabs += 1;
    println("synPredMatched" + paramSynPredBlock.ID + " = false;");
    this.tabs -= 1;
    println("}");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = __t" + paramSynPredBlock.ID + ";");
    else
      println("rewind(_m" + paramSynPredBlock.ID + ");");
    println("inputState->guessing--;");
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
    {
      println("if (synPredMatched" + paramSynPredBlock.ID + ")");
      println("  fireSyntacticPredicateSucceeded();");
      println("else");
      println("  fireSyntacticPredicateFailed();");
    }
    this.syntacticPredLevel -= 1;
    this.tabs -= 1;
    println("}");
    println("if ( synPredMatched" + paramSynPredBlock.ID + " ) {");
  }

  public void genTokenStrings(String paramString)
  {
    println("const char* " + paramString + "tokenNames[] = {");
    this.tabs += 1;
    Vector localVector = this.grammar.tokenManager.getVocabulary();
    for (int i = 0; i < localVector.size(); i++)
    {
      String str = (String)localVector.elementAt(i);
      if (str == null)
        str = "<" + String.valueOf(i) + ">";
      if ((!str.startsWith("\"")) && (!str.startsWith("<")))
      {
        TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str);
        if ((localTokenSymbol != null) && (localTokenSymbol.getParaphrase() != null))
          str = StringUtils.stripFrontBack(localTokenSymbol.getParaphrase(), "\"", "\"");
      }
      print(this.charFormatter.literalString(str));
      _println(",");
    }
    println("0");
    this.tabs -= 1;
    println("};");
  }

  protected void genTokenTypes(TokenManager paramTokenManager)
    throws IOException
  {
    this.outputFile = (paramTokenManager.getName() + TokenTypesFileSuffix + ".hpp");
    this.outputLine = 1;
    this.currentOutput = this.antlrTool.openOutputFile(this.outputFile);
    this.tabs = 0;
    println("#ifndef INC_" + paramTokenManager.getName() + TokenTypesFileSuffix + "_hpp_");
    println("#define INC_" + paramTokenManager.getName() + TokenTypesFileSuffix + "_hpp_");
    println("");
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    genHeader(this.outputFile);
    println("");
    println("#ifndef CUSTOM_API");
    println("# define CUSTOM_API");
    println("#endif");
    println("");
    println("#ifdef __cplusplus");
    println("struct CUSTOM_API " + paramTokenManager.getName() + TokenTypesFileSuffix + " {");
    println("#endif");
    this.tabs += 1;
    println("enum {");
    this.tabs += 1;
    Vector localVector = paramTokenManager.getVocabulary();
    println("EOF_ = 1,");
    for (int i = 4; i < localVector.size(); i++)
    {
      String str1 = (String)localVector.elementAt(i);
      if (str1 == null)
        continue;
      if (str1.startsWith("\""))
      {
        StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)paramTokenManager.getTokenSymbol(str1);
        if (localStringLiteralSymbol == null)
        {
          this.antlrTool.panic("String literal " + str1 + " not in symbol table");
        }
        else if (localStringLiteralSymbol.label != null)
        {
          println(localStringLiteralSymbol.label + " = " + i + ",");
        }
        else
        {
          String str2 = mangleLiteral(str1);
          if (str2 != null)
          {
            println(str2 + " = " + i + ",");
            localStringLiteralSymbol.label = str2;
          }
          else
          {
            println("// " + str1 + " = " + i);
          }
        }
      }
      else
      {
        if (str1.startsWith("<"))
          continue;
        println(str1 + " = " + i + ",");
      }
    }
    println("NULL_TREE_LOOKAHEAD = 3");
    this.tabs -= 1;
    println("};");
    this.tabs -= 1;
    println("#ifdef __cplusplus");
    println("};");
    println("#endif");
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    println("#endif /*INC_" + paramTokenManager.getName() + TokenTypesFileSuffix + "_hpp_*/");
    this.currentOutput.close();
    this.currentOutput = null;
    exitIfError();
  }

  public String processStringForASTConstructor(String paramString)
  {
    if ((this.usingCustomAST) && (((this.grammar instanceof TreeWalkerGrammar)) || ((this.grammar instanceof ParserGrammar))) && (!this.grammar.tokenManager.tokenDefined(paramString)))
      return namespaceAntlr + "RefAST(" + paramString + ")";
    return paramString;
  }

  public String getASTCreateString(Vector paramVector)
  {
    if (paramVector.size() == 0)
      return "";
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(this.labeledElementASTType + "(astFactory->make((new " + namespaceAntlr + "ASTArray(" + paramVector.size() + "))");
    for (int i = 0; i < paramVector.size(); i++)
      localStringBuffer.append("->add(" + paramVector.elementAt(i) + ")");
    localStringBuffer.append("))");
    return localStringBuffer.toString();
  }

  public String getASTCreateString(GrammarAtom paramGrammarAtom, String paramString)
  {
    if ((paramGrammarAtom != null) && (paramGrammarAtom.getASTNodeType() != null))
    {
      this.astTypes.ensureCapacity(paramGrammarAtom.getType());
      String str = (String)this.astTypes.elementAt(paramGrammarAtom.getType());
      if (str == null)
      {
        this.astTypes.setElementAt(paramGrammarAtom.getASTNodeType(), paramGrammarAtom.getType());
      }
      else if (!paramGrammarAtom.getASTNodeType().equals(str))
      {
        this.antlrTool.warning("Attempt to redefine AST type for " + paramGrammarAtom.getText(), this.grammar.getFilename(), paramGrammarAtom.getLine(), paramGrammarAtom.getColumn());
        this.antlrTool.warning(" from \"" + str + "\" to \"" + paramGrammarAtom.getASTNodeType() + "\" sticking to \"" + str + "\"", this.grammar.getFilename(), paramGrammarAtom.getLine(), paramGrammarAtom.getColumn());
      }
      else
      {
        this.astTypes.setElementAt(paramGrammarAtom.getASTNodeType(), paramGrammarAtom.getType());
      }
      return "astFactory->create(" + paramString + ")";
    }
    boolean bool = false;
    if (paramString.indexOf(',') != -1)
      bool = this.grammar.tokenManager.tokenDefined(paramString.substring(0, paramString.indexOf(',')));
    if ((this.usingCustomAST) && ((this.grammar instanceof TreeWalkerGrammar)) && (!this.grammar.tokenManager.tokenDefined(paramString)) && (!bool))
      return "astFactory->create(" + namespaceAntlr + "RefAST(" + paramString + "))";
    return "astFactory->create(" + paramString + ")";
  }

  public String getASTCreateString(String paramString)
  {
    if (this.usingCustomAST)
      return this.labeledElementASTType + "(astFactory->create(" + namespaceAntlr + "RefAST(" + paramString + ")))";
    return "astFactory->create(" + paramString + ")";
  }

  protected String getLookaheadTestExpression(Lookahead[] paramArrayOfLookahead, int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    int i = 1;
    localStringBuffer.append("(");
    for (int j = 1; j <= paramInt; j++)
    {
      BitSet localBitSet = paramArrayOfLookahead[j].fset;
      if (i == 0)
        localStringBuffer.append(") && (");
      i = 0;
      if (paramArrayOfLookahead[j].containsEpsilon())
        localStringBuffer.append("true");
      else
        localStringBuffer.append(getLookaheadTestTerm(j, localBitSet));
    }
    localStringBuffer.append(")");
    return localStringBuffer.toString();
  }

  protected String getLookaheadTestExpression(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    if (paramInt == 0)
      return "true";
    return "(" + getLookaheadTestExpression(paramAlternative.cache, i) + ")";
  }

  protected String getLookaheadTestTerm(int paramInt, BitSet paramBitSet)
  {
    String str1 = lookaheadString(paramInt);
    int[] arrayOfInt = paramBitSet.toArray();
    if (elementsAreRange(arrayOfInt))
      return getRangeExpression(paramInt, arrayOfInt);
    int i = paramBitSet.degree();
    if (i == 0)
      return "true";
    if (i >= this.bitsetTestThreshold)
    {
      j = markBitsetForGen(paramBitSet);
      return getBitsetName(j) + ".member(" + str1 + ")";
    }
    StringBuffer localStringBuffer = new StringBuffer();
    for (int j = 0; j < arrayOfInt.length; j++)
    {
      String str2 = getValueString(arrayOfInt[j]);
      if (j > 0)
        localStringBuffer.append(" || ");
      localStringBuffer.append(str1);
      localStringBuffer.append(" == ");
      localStringBuffer.append(str2);
    }
    return localStringBuffer.toString();
  }

  public String getRangeExpression(int paramInt, int[] paramArrayOfInt)
  {
    if (!elementsAreRange(paramArrayOfInt))
      this.antlrTool.panic("getRangeExpression called with non-range");
    int i = paramArrayOfInt[0];
    int j = paramArrayOfInt[(paramArrayOfInt.length - 1)];
    return "(" + lookaheadString(paramInt) + " >= " + getValueString(i) + " && " + lookaheadString(paramInt) + " <= " + getValueString(j) + ")";
  }

  private String getValueString(int paramInt)
  {
    Object localObject;
    if ((this.grammar instanceof LexerGrammar))
    {
      localObject = this.charFormatter.literalChar(paramInt);
    }
    else
    {
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbolAt(paramInt);
      if (localTokenSymbol == null)
        return "" + paramInt;
      String str1 = localTokenSymbol.getId();
      if ((localTokenSymbol instanceof StringLiteralSymbol))
      {
        StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)localTokenSymbol;
        String str2 = localStringLiteralSymbol.getLabel();
        if (str2 != null)
        {
          localObject = str2;
        }
        else
        {
          localObject = mangleLiteral(str1);
          if (localObject == null)
            localObject = String.valueOf(paramInt);
        }
      }
      else if (str1.equals("EOF"))
      {
        localObject = namespaceAntlr + "Token::EOF_TYPE";
      }
      else
      {
        localObject = str1;
      }
    }
    return (String)localObject;
  }

  protected boolean lookaheadIsEmpty(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    for (int j = 1; (j <= i) && (j <= paramInt); j++)
    {
      BitSet localBitSet = paramAlternative.cache[j].fset;
      if (localBitSet.degree() != 0)
        return false;
    }
    return true;
  }

  private String lookaheadString(int paramInt)
  {
    if ((this.grammar instanceof TreeWalkerGrammar))
      return "_t->getType()";
    return "LA(" + paramInt + ")";
  }

  private String mangleLiteral(String paramString)
  {
    String str = this.antlrTool.literalsPrefix;
    for (int i = 1; i < paramString.length() - 1; i++)
    {
      if ((!Character.isLetter(paramString.charAt(i))) && (paramString.charAt(i) != '_'))
        return null;
      str = str + paramString.charAt(i);
    }
    if (this.antlrTool.upperCaseMangledLiterals)
      str = str.toUpperCase();
    return str;
  }

  public String mapTreeId(String paramString, ActionTransInfo paramActionTransInfo)
  {
    if (this.currentRule == null)
      return paramString;
    int i = 0;
    String str1 = paramString;
    if ((this.grammar instanceof TreeWalkerGrammar))
    {
      if (!this.grammar.buildAST)
        i = 1;
      if ((str1.length() > 3) && (str1.lastIndexOf("_in") == str1.length() - 3))
      {
        str1 = str1.substring(0, str1.length() - 3);
        i = 1;
      }
    }
    Object localObject;
    for (int j = 0; j < this.currentRule.labeledElements.size(); j++)
    {
      localObject = (AlternativeElement)this.currentRule.labeledElements.elementAt(j);
      if (((AlternativeElement)localObject).getLabel().equals(str1))
        return str1 + "_AST";
    }
    String str2 = (String)this.treeVariableMap.get(str1);
    if (str2 != null)
    {
      if (str2 == NONUNIQUE)
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      if (str2.equals(this.currentRule.getRuleName()))
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      return i != 0 ? str2 + "_in" : str2;
    }
    if (str1.equals(this.currentRule.getRuleName()))
    {
      localObject = str1 + "_AST";
      if ((paramActionTransInfo != null) && (i == 0))
        paramActionTransInfo.refRuleRoot = ((String)localObject);
      return localObject;
    }
    return (String)str1;
  }

  private void mapTreeVariable(AlternativeElement paramAlternativeElement, String paramString)
  {
    if ((paramAlternativeElement instanceof TreeElement))
    {
      mapTreeVariable(((TreeElement)paramAlternativeElement).root, paramString);
      return;
    }
    String str = null;
    if (paramAlternativeElement.getLabel() == null)
      if ((paramAlternativeElement instanceof TokenRefElement))
        str = ((TokenRefElement)paramAlternativeElement).atomText;
      else if ((paramAlternativeElement instanceof RuleRefElement))
        str = ((RuleRefElement)paramAlternativeElement).targetRule;
    if (str != null)
      if (this.treeVariableMap.get(str) != null)
      {
        this.treeVariableMap.remove(str);
        this.treeVariableMap.put(str, NONUNIQUE);
      }
      else
      {
        this.treeVariableMap.put(str, paramString);
      }
  }

  protected String processActionForSpecialSymbols(String paramString, int paramInt, RuleBlock paramRuleBlock, ActionTransInfo paramActionTransInfo)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return null;
    if (this.grammar == null)
      return paramString;
    if (((this.grammar.buildAST) && (paramString.indexOf('#') != -1)) || ((this.grammar instanceof TreeWalkerGrammar)) || ((((this.grammar instanceof LexerGrammar)) || ((this.grammar instanceof ParserGrammar))) && (paramString.indexOf('$') != -1)))
    {
      ActionLexer localActionLexer = new ActionLexer(paramString, paramRuleBlock, this, paramActionTransInfo);
      localActionLexer.setLineOffset(paramInt);
      localActionLexer.setFilename(this.grammar.getFilename());
      localActionLexer.setTool(this.antlrTool);
      try
      {
        localActionLexer.mACTION(true);
        paramString = localActionLexer.getTokenObject().getText();
      }
      catch (RecognitionException localRecognitionException)
      {
        localActionLexer.reportError(localRecognitionException);
        return paramString;
      }
      catch (TokenStreamException localTokenStreamException)
      {
        this.antlrTool.panic("Error reading action:" + paramString);
        return paramString;
      }
      catch (CharStreamException localCharStreamException)
      {
        this.antlrTool.panic("Error reading action:" + paramString);
        return paramString;
      }
    }
    return paramString;
  }

  private String fixNameSpaceOption(String paramString)
  {
    paramString = StringUtils.stripFrontBack(paramString, "\"", "\"");
    if ((paramString.length() > 2) && (!paramString.substring(paramString.length() - 2, paramString.length()).equals("::")))
      paramString = paramString + "::";
    return paramString;
  }

  private void setupGrammarParameters(Grammar paramGrammar)
  {
    Token localToken;
    String str;
    if (((paramGrammar instanceof ParserGrammar)) || ((paramGrammar instanceof LexerGrammar)) || ((paramGrammar instanceof TreeWalkerGrammar)))
    {
      if (this.antlrTool.nameSpace != null)
        nameSpace = this.antlrTool.nameSpace;
      if (this.antlrTool.namespaceStd != null)
        namespaceStd = fixNameSpaceOption(this.antlrTool.namespaceStd);
      if (this.antlrTool.namespaceAntlr != null)
        namespaceAntlr = fixNameSpaceOption(this.antlrTool.namespaceAntlr);
      this.genHashLines = this.antlrTool.genHashLines;
      if (paramGrammar.hasOption("namespace"))
      {
        localToken = paramGrammar.getOption("namespace");
        if (localToken != null)
          nameSpace = new NameSpace(localToken.getText());
      }
      if (paramGrammar.hasOption("namespaceAntlr"))
      {
        localToken = paramGrammar.getOption("namespaceAntlr");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            if ((str.length() > 2) && (!str.substring(str.length() - 2, str.length()).equals("::")))
              str = str + "::";
            namespaceAntlr = str;
          }
        }
      }
      if (paramGrammar.hasOption("namespaceStd"))
      {
        localToken = paramGrammar.getOption("namespaceStd");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            if ((str.length() > 2) && (!str.substring(str.length() - 2, str.length()).equals("::")))
              str = str + "::";
            namespaceStd = str;
          }
        }
      }
      if (paramGrammar.hasOption("genHashLines"))
      {
        localToken = paramGrammar.getOption("genHashLines");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          this.genHashLines = str.equals("true");
        }
      }
      this.noConstructors = this.antlrTool.noConstructors;
      if (paramGrammar.hasOption("noConstructors"))
      {
        localToken = paramGrammar.getOption("noConstructors");
        if ((localToken != null) && (!localToken.getText().equals("true")) && (!localToken.getText().equals("false")))
          this.antlrTool.error("noConstructors option must be true or false", this.antlrTool.getGrammarFile(), localToken.getLine(), localToken.getColumn());
        this.noConstructors = localToken.getText().equals("true");
      }
    }
    if ((paramGrammar instanceof ParserGrammar))
    {
      this.labeledElementASTType = (namespaceAntlr + "RefAST");
      this.labeledElementASTInit = (namespaceAntlr + "nullAST");
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            this.usingCustomAST = true;
            this.labeledElementASTType = str;
            this.labeledElementASTInit = (str + "(" + namespaceAntlr + "nullAST)");
          }
        }
      }
      this.labeledElementType = (namespaceAntlr + "RefToken ");
      this.labeledElementInit = (namespaceAntlr + "nullToken");
      this.commonExtraArgs = "";
      this.commonExtraParams = "";
      this.commonLocalVars = "";
      this.lt1Value = "LT(1)";
      this.exceptionThrown = (namespaceAntlr + "RecognitionException");
      this.throwNoViable = ("throw " + namespaceAntlr + "NoViableAltException(LT(1), getFilename());");
    }
    else if ((paramGrammar instanceof LexerGrammar))
    {
      this.labeledElementType = "char ";
      this.labeledElementInit = "'\\0'";
      this.commonExtraArgs = "";
      this.commonExtraParams = "bool _createToken";
      this.commonLocalVars = ("int _ttype; " + namespaceAntlr + "RefToken _token; " + namespaceStd + "string::size_type _begin = text.length();");
      this.lt1Value = "LA(1)";
      this.exceptionThrown = (namespaceAntlr + "RecognitionException");
      this.throwNoViable = ("throw " + namespaceAntlr + "NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());");
    }
    else if ((paramGrammar instanceof TreeWalkerGrammar))
    {
      this.labeledElementInit = (namespaceAntlr + "nullAST");
      this.labeledElementASTInit = (namespaceAntlr + "nullAST");
      this.labeledElementASTType = (namespaceAntlr + "RefAST");
      this.labeledElementType = (namespaceAntlr + "RefAST");
      this.commonExtraParams = (namespaceAntlr + "RefAST _t");
      this.throwNoViable = ("throw " + namespaceAntlr + "NoViableAltException(_t);");
      this.lt1Value = "_t";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            this.usingCustomAST = true;
            this.labeledElementASTType = str;
            this.labeledElementType = str;
            this.labeledElementInit = (str + "(" + namespaceAntlr + "nullAST)");
            this.labeledElementASTInit = this.labeledElementInit;
            this.commonExtraParams = (str + " _t");
            this.throwNoViable = ("throw " + namespaceAntlr + "NoViableAltException(" + namespaceAntlr + "RefAST(_t));");
            this.lt1Value = "_t";
          }
        }
      }
      if (!paramGrammar.hasOption("ASTLabelType"))
        paramGrammar.setOption("ASTLabelType", new Token(6, namespaceAntlr + "RefAST"));
      this.commonExtraArgs = "_t";
      this.commonLocalVars = "";
      this.exceptionThrown = (namespaceAntlr + "RecognitionException");
    }
    else
    {
      this.antlrTool.panic("Unknown grammar type");
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.CppCodeGenerator
 * JD-Core Version:    0.6.0
 */