package antlr;

import antlr.collections.impl.BitSet;
import java.io.PrintStream;
import java.util.Hashtable;

public abstract class CharScanner
  implements TokenStream
{
  static final char NO_CHAR = '\000';
  public static final char EOF_CHAR = '￿';
  protected ANTLRStringBuffer text = new ANTLRStringBuffer();
  protected boolean saveConsumedInput = true;
  protected Class tokenObjectClass;
  protected boolean caseSensitive = true;
  protected boolean caseSensitiveLiterals = true;
  protected Hashtable literals;
  protected int tabsize = 8;
  protected Token _returnToken = null;
  protected ANTLRHashString hashString = new ANTLRHashString(this);
  protected LexerSharedInputState inputState;
  protected boolean commitToPath = false;
  protected int traceDepth = 0;

  public CharScanner()
  {
    setTokenObjectClass("antlr.CommonToken");
  }

  public CharScanner(InputBuffer paramInputBuffer)
  {
    this();
    this.inputState = new LexerSharedInputState(paramInputBuffer);
  }

  public CharScanner(LexerSharedInputState paramLexerSharedInputState)
  {
    this();
    this.inputState = paramLexerSharedInputState;
  }

  public void append(char paramChar)
  {
    if (this.saveConsumedInput)
      this.text.append(paramChar);
  }

  public void append(String paramString)
  {
    if (this.saveConsumedInput)
      this.text.append(paramString);
  }

  public void commit()
  {
    this.inputState.input.commit();
  }

  public void consume()
    throws CharStreamException
  {
    if (this.inputState.guessing == 0)
    {
      char c = LA(1);
      if (this.caseSensitive)
        append(c);
      else
        append(this.inputState.input.LA(1));
      if (c == '\t')
        tab();
      else
        this.inputState.column += 1;
    }
    this.inputState.input.consume();
  }

  public void consumeUntil(int paramInt)
    throws CharStreamException
  {
    while ((LA(1) != 65535) && (LA(1) != paramInt))
      consume();
  }

  public void consumeUntil(BitSet paramBitSet)
    throws CharStreamException
  {
    while ((LA(1) != 65535) && (!paramBitSet.member(LA(1))))
      consume();
  }

  public boolean getCaseSensitive()
  {
    return this.caseSensitive;
  }

  public final boolean getCaseSensitiveLiterals()
  {
    return this.caseSensitiveLiterals;
  }

  public int getColumn()
  {
    return this.inputState.column;
  }

  public void setColumn(int paramInt)
  {
    this.inputState.column = paramInt;
  }

  public boolean getCommitToPath()
  {
    return this.commitToPath;
  }

  public String getFilename()
  {
    return this.inputState.filename;
  }

  public InputBuffer getInputBuffer()
  {
    return this.inputState.input;
  }

  public LexerSharedInputState getInputState()
  {
    return this.inputState;
  }

  public void setInputState(LexerSharedInputState paramLexerSharedInputState)
  {
    this.inputState = paramLexerSharedInputState;
  }

  public int getLine()
  {
    return this.inputState.line;
  }

  public String getText()
  {
    return this.text.toString();
  }

  public Token getTokenObject()
  {
    return this._returnToken;
  }

  public char LA(int paramInt)
    throws CharStreamException
  {
    if (this.caseSensitive)
      return this.inputState.input.LA(paramInt);
    return toLower(this.inputState.input.LA(paramInt));
  }

  protected Token makeToken(int paramInt)
  {
    try
    {
      Token localToken = (Token)this.tokenObjectClass.newInstance();
      localToken.setType(paramInt);
      localToken.setColumn(this.inputState.tokenStartColumn);
      localToken.setLine(this.inputState.tokenStartLine);
      return localToken;
    }
    catch (InstantiationException localInstantiationException)
    {
      panic("can't instantiate token: " + this.tokenObjectClass);
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
      panic("Token class is not accessible" + this.tokenObjectClass);
    }
    return Token.badToken;
  }

  public int mark()
  {
    return this.inputState.input.mark();
  }

  public void match(char paramChar)
    throws MismatchedCharException, CharStreamException
  {
    if (LA(1) != paramChar)
      throw new MismatchedCharException(LA(1), paramChar, false, this);
    consume();
  }

  public void match(BitSet paramBitSet)
    throws MismatchedCharException, CharStreamException
  {
    if (!paramBitSet.member(LA(1)))
      throw new MismatchedCharException(LA(1), paramBitSet, false, this);
    consume();
  }

  public void match(String paramString)
    throws MismatchedCharException, CharStreamException
  {
    int i = paramString.length();
    for (int j = 0; j < i; j++)
    {
      if (LA(1) != paramString.charAt(j))
        throw new MismatchedCharException(LA(1), paramString.charAt(j), false, this);
      consume();
    }
  }

  public void matchNot(char paramChar)
    throws MismatchedCharException, CharStreamException
  {
    if (LA(1) == paramChar)
      throw new MismatchedCharException(LA(1), paramChar, true, this);
    consume();
  }

  public void matchRange(char paramChar1, char paramChar2)
    throws MismatchedCharException, CharStreamException
  {
    if ((LA(1) < paramChar1) || (LA(1) > paramChar2))
      throw new MismatchedCharException(LA(1), paramChar1, paramChar2, false, this);
    consume();
  }

  public void newline()
  {
    this.inputState.line += 1;
    this.inputState.column = 1;
  }

  public void tab()
  {
    int i = getColumn();
    int j = ((i - 1) / this.tabsize + 1) * this.tabsize + 1;
    setColumn(j);
  }

  public void setTabSize(int paramInt)
  {
    this.tabsize = paramInt;
  }

  public int getTabSize()
  {
    return this.tabsize;
  }

  public void panic()
  {
    System.err.println("CharScanner: panic");
    Utils.error("");
  }

  public void panic(String paramString)
  {
    System.err.println("CharScanner; panic: " + paramString);
    Utils.error(paramString);
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    System.err.println(paramRecognitionException);
  }

  public void reportError(String paramString)
  {
    if (getFilename() == null)
      System.err.println("error: " + paramString);
    else
      System.err.println(getFilename() + ": error: " + paramString);
  }

  public void reportWarning(String paramString)
  {
    if (getFilename() == null)
      System.err.println("warning: " + paramString);
    else
      System.err.println(getFilename() + ": warning: " + paramString);
  }

  public void resetText()
  {
    this.text.setLength(0);
    this.inputState.tokenStartColumn = this.inputState.column;
    this.inputState.tokenStartLine = this.inputState.line;
  }

  public void rewind(int paramInt)
  {
    this.inputState.input.rewind(paramInt);
  }

  public void setCaseSensitive(boolean paramBoolean)
  {
    this.caseSensitive = paramBoolean;
  }

  public void setCommitToPath(boolean paramBoolean)
  {
    this.commitToPath = paramBoolean;
  }

  public void setFilename(String paramString)
  {
    this.inputState.filename = paramString;
  }

  public void setLine(int paramInt)
  {
    this.inputState.line = paramInt;
  }

  public void setText(String paramString)
  {
    resetText();
    this.text.append(paramString);
  }

  public void setTokenObjectClass(String paramString)
  {
    try
    {
      this.tokenObjectClass = Utils.loadClass(paramString);
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      panic("ClassNotFoundException: " + paramString);
    }
  }

  public int testLiteralsTable(int paramInt)
  {
    this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
    Integer localInteger = (Integer)this.literals.get(this.hashString);
    if (localInteger != null)
      paramInt = localInteger.intValue();
    return paramInt;
  }

  public int testLiteralsTable(String paramString, int paramInt)
  {
    ANTLRHashString localANTLRHashString = new ANTLRHashString(paramString, this);
    Integer localInteger = (Integer)this.literals.get(localANTLRHashString);
    if (localInteger != null)
      paramInt = localInteger.intValue();
    return paramInt;
  }

  public char toLower(char paramChar)
  {
    return Character.toLowerCase(paramChar);
  }

  public void traceIndent()
  {
    for (int i = 0; i < this.traceDepth; i++)
      System.out.print(" ");
  }

  public void traceIn(String paramString)
    throws CharStreamException
  {
    this.traceDepth += 1;
    traceIndent();
    System.out.println("> lexer " + paramString + "; c==" + LA(1));
  }

  public void traceOut(String paramString)
    throws CharStreamException
  {
    traceIndent();
    System.out.println("< lexer " + paramString + "; c==" + LA(1));
    this.traceDepth -= 1;
  }

  public void uponEOF()
    throws TokenStreamException, CharStreamException
  {
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.CharScanner
 * JD-Core Version:    0.6.0
 */