package antlr;

import antlr.collections.impl.BitSet;

class CharRangeElement extends AlternativeElement
{
  String label;
  protected char begin = '\000';
  protected char end = '\000';
  protected String beginText;
  protected String endText;

  public CharRangeElement(LexerGrammar paramLexerGrammar, Token paramToken1, Token paramToken2, int paramInt)
  {
    super(paramLexerGrammar);
    this.begin = (char)ANTLRLexer.tokenTypeForCharLiteral(paramToken1.getText());
    this.beginText = paramToken1.getText();
    this.end = (char)ANTLRLexer.tokenTypeForCharLiteral(paramToken2.getText());
    this.endText = paramToken2.getText();
    this.line = paramToken1.getLine();
    for (int i = this.begin; i <= this.end; i++)
      paramLexerGrammar.charVocabulary.add(i);
    this.autoGenType = paramInt;
  }

  public void generate()
  {
    this.grammar.generator.gen(this);
  }

  public String getLabel()
  {
    return this.label;
  }

  public Lookahead look(int paramInt)
  {
    return this.grammar.theLLkAnalyzer.look(paramInt, this);
  }

  public void setLabel(String paramString)
  {
    this.label = paramString;
  }

  public String toString()
  {
    if (this.label != null)
      return " " + this.label + ":" + this.beginText + ".." + this.endText;
    return " " + this.beginText + ".." + this.endText;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.CharRangeElement
 * JD-Core Version:    0.6.0
 */