/*     */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.Callable;
/*     */ import EDU.oswego.cs.dl.util.concurrent.FutureResult;
/*     */ import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
/*     */ import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
/*     */ import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
/*     */ import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import javax.swing.SwingUtilities;
/*     */ 
/*     */ public abstract class SwingWorker extends ThreadFactoryUser
/*     */   implements Runnable
/*     */ {
/* 119 */   private static final ThreadFactory FACTORY = new ThreadFactory() {
/*     */     public Thread newThread(Runnable command) {
/* 121 */       Thread t = new Thread(command);
/* 122 */       t.setPriority(2);
/* 123 */       return t;
/*     */     }
/* 119 */   };
/*     */ 
/* 128 */   private final FutureResult result = new FutureResult();
/*     */   private final long timeout;
/*     */   private Thread thread;
/*     */ 
/*     */   public SwingWorker()
/*     */   {
/* 138 */     this(FACTORY, 0L);
/*     */   }
/*     */ 
/*     */   public SwingWorker(long msecs)
/*     */   {
/* 147 */     this(FACTORY, msecs);
/*     */   }
/*     */ 
/*     */   protected SwingWorker(ThreadFactory factory, long msecs)
/*     */   {
/* 157 */     setThreadFactory(factory);
/* 158 */     if (msecs < 0L) {
/* 159 */       throw new IllegalArgumentException("timeout=" + msecs);
/*     */     }
/* 161 */     this.timeout = msecs;
/*     */   }
/*     */ 
/*     */   protected abstract Object construct()
/*     */     throws Exception;
/*     */ 
/*     */   protected void finished()
/*     */   {
/*     */   }
/*     */ 
/*     */   public long getTimeout()
/*     */   {
/* 181 */     return this.timeout;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 191 */     Callable function = new Callable() {
/*     */       public Object call() throws Exception {
/* 193 */         return SwingWorker.this.construct();
/*     */       }
/*     */     };
/* 197 */     Runnable doFinished = new Runnable() {
/*     */       public void run() {
/* 199 */         SwingWorker.this.finished();
/*     */       }
/*     */     };
/* 204 */     long msecs = getTimeout();
/* 205 */     if (msecs != 0L) {
/* 206 */       TimedCallable tc = new TimedCallable(function, msecs);
/* 207 */       tc.setThreadFactory(getThreadFactory());
/* 208 */       function = tc;
/*     */     }
/*     */ 
/* 211 */     this.result.setter(function).run();
/* 212 */     SwingUtilities.invokeLater(doFinished);
/*     */   }
/*     */ 
/*     */   public synchronized void start()
/*     */   {
/* 219 */     if (this.thread == null) {
/* 220 */       this.thread = getThreadFactory().newThread(this);
/*     */     }
/* 222 */     this.thread.start();
/*     */   }
/*     */ 
/*     */   public synchronized void interrupt()
/*     */   {
/* 229 */     if (this.thread != null)
/*     */     {
/*     */       try
/*     */       {
/* 233 */         this.thread.interrupt(); } catch (Exception localException) {
/*     */       }
/*     */     }
/* 235 */     this.result.setException(new InterruptedException());
/*     */   }
/*     */ 
/*     */   public Object get()
/*     */     throws InterruptedException, InvocationTargetException
/*     */   {
/* 249 */     return this.result.get();
/*     */   }
/*     */ 
/*     */   public Object timedGet(long msecs)
/*     */     throws TimeoutException, InterruptedException, InvocationTargetException
/*     */   {
/* 262 */     return this.result.timedGet(msecs);
/*     */   }
/*     */ 
/*     */   public InvocationTargetException getException()
/*     */   {
/* 273 */     return this.result.getException();
/*     */   }
/*     */ 
/*     */   public boolean isReady()
/*     */   {
/* 283 */     return this.result.isReady();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.SwingWorker
 * JD-Core Version:    0.6.0
 */