/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WriterPreferenceReadWriteLock
/*     */   implements ReadWriteLock
/*     */ {
/*  37 */   protected long activeReaders_ = 0L;
/*  38 */   protected Thread activeWriter_ = null;
/*  39 */   protected long waitingReaders_ = 0L;
/*  40 */   protected long waitingWriters_ = 0L;
/*     */ 
/*  43 */   protected final ReaderLock readerLock_ = new ReaderLock();
/*  44 */   protected final WriterLock writerLock_ = new WriterLock();
/*     */ 
/*  46 */   public Sync writeLock() { return this.writerLock_; } 
/*  47 */   public Sync readLock() { return this.readerLock_;
/*     */   }
/*     */ 
/*     */   protected synchronized void cancelledWaitingReader()
/*     */   {
/*  56 */     this.waitingReaders_ -= 1L; } 
/*  57 */   protected synchronized void cancelledWaitingWriter() { this.waitingWriters_ -= 1L;
/*     */   }
/*     */ 
/*     */   protected boolean allowReader()
/*     */   {
/*  62 */     return (this.activeWriter_ == null) && (this.waitingWriters_ == 0L);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean startRead()
/*     */   {
/*  67 */     boolean allowRead = allowReader();
/*  68 */     if (allowRead) this.activeReaders_ += 1L;
/*  69 */     return allowRead;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean startWrite()
/*     */   {
/*  77 */     boolean allowWrite = (this.activeWriter_ == null) && (this.activeReaders_ == 0L);
/*  78 */     if (allowWrite) this.activeWriter_ = Thread.currentThread();
/*  79 */     return allowWrite;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean startReadFromNewReader()
/*     */   {
/*  91 */     boolean pass = startRead();
/*  92 */     if (!pass) this.waitingReaders_ += 1L;
/*  93 */     return pass;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean startWriteFromNewWriter() {
/*  97 */     boolean pass = startWrite();
/*  98 */     if (!pass) this.waitingWriters_ += 1L;
/*  99 */     return pass;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean startReadFromWaitingReader() {
/* 103 */     boolean pass = startRead();
/* 104 */     if (pass) this.waitingReaders_ -= 1L;
/* 105 */     return pass;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean startWriteFromWaitingWriter() {
/* 109 */     boolean pass = startWrite();
/* 110 */     if (pass) this.waitingWriters_ -= 1L;
/* 111 */     return pass;
/*     */   }
/*     */ 
/*     */   protected synchronized Signaller endRead()
/*     */   {
/* 119 */     if ((--this.activeReaders_ == 0L) && (this.waitingWriters_ > 0L)) {
/* 120 */       return this.writerLock_;
/*     */     }
/* 122 */     return null;
/*     */   }
/*     */ 
/*     */   protected synchronized Signaller endWrite()
/*     */   {
/* 131 */     this.activeWriter_ = null;
/* 132 */     if ((this.waitingReaders_ > 0L) && (allowReader()))
/* 133 */       return this.readerLock_;
/* 134 */     if (this.waitingWriters_ > 0L) {
/* 135 */       return this.writerLock_;
/*     */     }
/* 137 */     return null;
/*     */   }
/*     */ 
/*     */   protected class ReaderLock extends WriterPreferenceReadWriteLock.Signaller
/*     */     implements Sync
/*     */   {
/*     */     protected ReaderLock()
/*     */     {
/* 154 */       super();
/*     */     }
/*     */     public void acquire() throws InterruptedException {
/* 157 */       if (Thread.interrupted()) throw new InterruptedException();
/* 158 */       InterruptedException ie = null;
/* 159 */       synchronized (this) {
/* 160 */         if (!WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
/*     */           try {
/*     */             do
/* 163 */               wait();
/* 164 */             while (!WriterPreferenceReadWriteLock.this.startReadFromWaitingReader());
/* 165 */             return;
/*     */           }
/*     */           catch (InterruptedException ex) {
/* 168 */             WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
/* 169 */             ie = ex;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 175 */       if (ie != null)
/*     */       {
/* 179 */         WriterPreferenceReadWriteLock.this.writerLock_.signalWaiters();
/* 180 */         throw ie;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void release()
/*     */     {
/* 186 */       WriterPreferenceReadWriteLock.Signaller s = WriterPreferenceReadWriteLock.this.endRead();
/* 187 */       if (s != null) s.signalWaiters(); 
/*     */     }
/*     */ 
/*     */     synchronized void signalWaiters()
/*     */     {
/* 191 */       notifyAll();
/*     */     }
/*     */     public boolean attempt(long msecs) throws InterruptedException {
/* 194 */       if (Thread.interrupted()) throw new InterruptedException();
/* 195 */       InterruptedException ie = null;
/* 196 */       synchronized (this) {
/* 197 */         if (msecs <= 0L)
/* 198 */           return WriterPreferenceReadWriteLock.this.startRead();
/* 199 */         if (WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
/* 200 */           return true;
/*     */         }
/* 202 */         long waitTime = msecs;
/* 203 */         long start = System.currentTimeMillis();
/*     */         while (true) {
/*     */           try { wait(waitTime);
/*     */           } catch (InterruptedException ex) {
/* 207 */             WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
/* 208 */             ie = ex;
/* 209 */             break;
/*     */           }
/* 211 */           if (WriterPreferenceReadWriteLock.this.startReadFromWaitingReader()) {
/* 212 */             return true;
/*     */           }
/* 214 */           waitTime = msecs - (System.currentTimeMillis() - start);
/* 215 */           if (waitTime <= 0L) {
/* 216 */             WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 224 */       WriterPreferenceReadWriteLock.this.writerLock_.signalWaiters();
/* 225 */       if (ie != null) throw ie;
/* 226 */       return false; } 
/*     */   }
/*     */   protected abstract class Signaller { protected Signaller() {  }
/*     */ 
/*     */     abstract void signalWaiters(); }
/*     */ 
/* 231 */   protected class WriterLock extends WriterPreferenceReadWriteLock.Signaller implements Sync { protected WriterLock() { super(); }
/*     */ 
/*     */     public void acquire() throws InterruptedException {
/* 234 */       if (Thread.interrupted()) throw new InterruptedException();
/* 235 */       InterruptedException ie = null;
/* 236 */       synchronized (this) {
/* 237 */         if (!WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
/*     */           try {
/*     */             do
/* 240 */               wait();
/* 241 */             while (!WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter());
/* 242 */             return;
/*     */           }
/*     */           catch (InterruptedException ex) {
/* 245 */             WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
/* 246 */             notify();
/* 247 */             ie = ex;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 253 */       if (ie != null)
/*     */       {
/* 257 */         WriterPreferenceReadWriteLock.this.readerLock_.signalWaiters();
/* 258 */         throw ie;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void release() {
/* 263 */       WriterPreferenceReadWriteLock.Signaller s = WriterPreferenceReadWriteLock.this.endWrite();
/* 264 */       if (s != null) s.signalWaiters(); 
/*     */     }
/*     */ 
/*     */     synchronized void signalWaiters() {
/* 267 */       notify();
/*     */     }
/*     */     public boolean attempt(long msecs) throws InterruptedException {
/* 270 */       if (Thread.interrupted()) throw new InterruptedException();
/* 271 */       InterruptedException ie = null;
/* 272 */       synchronized (this) {
/* 273 */         if (msecs <= 0L)
/* 274 */           return WriterPreferenceReadWriteLock.this.startWrite();
/* 275 */         if (WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
/* 276 */           return true;
/*     */         }
/* 278 */         long waitTime = msecs;
/* 279 */         long start = System.currentTimeMillis();
/*     */         while (true) {
/*     */           try { wait(waitTime);
/*     */           } catch (InterruptedException ex) {
/* 283 */             WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
/* 284 */             notify();
/* 285 */             ie = ex;
/* 286 */             break;
/*     */           }
/* 288 */           if (WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter()) {
/* 289 */             return true;
/*     */           }
/* 291 */           waitTime = msecs - (System.currentTimeMillis() - start);
/* 292 */           if (waitTime <= 0L) {
/* 293 */             WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
/* 294 */             notify();
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 302 */       WriterPreferenceReadWriteLock.this.readerLock_.signalWaiters();
/* 303 */       if (ie != null) throw ie;
/* 304 */       return false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock
 * JD-Core Version:    0.6.0
 */