/*    */ package EDU.oswego.cs.dl.util.concurrent;
/*    */ 
/*    */ public class WaitableRef extends SynchronizedRef
/*    */ {
/*    */   public WaitableRef(Object initialValue)
/*    */   {
/* 29 */     super(initialValue);
/*    */   }
/*    */ 
/*    */   public WaitableRef(Object initialValue, Object lock)
/*    */   {
/* 37 */     super(initialValue, lock);
/*    */   }
/*    */ 
/*    */   public Object set(Object newValue) {
/* 41 */     synchronized (this.lock_) {
/* 42 */       this.lock_.notifyAll();
/* 43 */       return super.set(newValue);
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean commit(Object assumedValue, Object newValue) {
/* 48 */     synchronized (this.lock_) {
/* 49 */       boolean success = super.commit(assumedValue, newValue);
/* 50 */       if (success) this.lock_.notifyAll();
/* 51 */       return success;
/*    */     }
/*    */   }
/*    */ 
/*    */   public void whenNull(Runnable action)
/*    */     throws InterruptedException
/*    */   {
/* 61 */     synchronized (this.lock_) {
/* 62 */       while (this.value_ != null) this.lock_.wait();
/* 63 */       if (action != null) action.run();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void whenNotNull(Runnable action)
/*    */     throws InterruptedException
/*    */   {
/* 72 */     synchronized (this.lock_) {
/* 73 */       while (this.value_ == null) this.lock_.wait();
/* 74 */       if (action != null) action.run();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void whenEqual(Object c, Runnable action)
/*    */     throws InterruptedException
/*    */   {
/* 84 */     synchronized (this.lock_) {
/* 85 */       while (this.value_ != c) this.lock_.wait();
/* 86 */       if (action != null) action.run();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void whenNotEqual(Object c, Runnable action)
/*    */     throws InterruptedException
/*    */   {
/* 95 */     synchronized (this.lock_) {
/* 96 */       while (this.value_ == c) this.lock_.wait();
/* 97 */       if (action != null) action.run();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitableRef
 * JD-Core Version:    0.6.0
 */