/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WaitableLong extends SynchronizedLong
/*     */ {
/*     */   public WaitableLong(long initialValue)
/*     */   {
/*  30 */     super(initialValue);
/*     */   }
/*     */ 
/*     */   public WaitableLong(long initialValue, Object lock)
/*     */   {
/*  38 */     super(initialValue, lock);
/*     */   }
/*     */ 
/*     */   public long set(long newValue)
/*     */   {
/*  43 */     synchronized (this.lock_) {
/*  44 */       this.lock_.notifyAll();
/*  45 */       return super.set(newValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(long assumedValue, long newValue) {
/*  50 */     synchronized (this.lock_) {
/*  51 */       boolean success = super.commit(assumedValue, newValue);
/*  52 */       if (success) this.lock_.notifyAll();
/*  53 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long increment() {
/*  58 */     synchronized (this.lock_) {
/*  59 */       this.lock_.notifyAll();
/*  60 */       return super.increment();
/*     */     }
/*     */   }
/*     */ 
/*     */   public long decrement() {
/*  65 */     synchronized (this.lock_) {
/*  66 */       this.lock_.notifyAll();
/*  67 */       return super.decrement();
/*     */     }
/*     */   }
/*     */ 
/*     */   public long add(long amount) {
/*  72 */     synchronized (this.lock_) {
/*  73 */       this.lock_.notifyAll();
/*  74 */       return super.add(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public long subtract(long amount) {
/*  79 */     synchronized (this.lock_) {
/*  80 */       this.lock_.notifyAll();
/*  81 */       return super.subtract(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public long multiply(long factor) {
/*  86 */     synchronized (this.lock_) {
/*  87 */       this.lock_.notifyAll();
/*  88 */       return super.multiply(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public long divide(long factor) {
/*  93 */     synchronized (this.lock_) {
/*  94 */       this.lock_.notifyAll();
/*  95 */       return super.divide(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public long complement()
/*     */   {
/* 104 */     synchronized (this.lock_) {
/* 105 */       this.value_ ^= -1L;
/* 106 */       this.lock_.notifyAll();
/* 107 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long and(long b)
/*     */   {
/* 116 */     synchronized (this.lock_) {
/* 117 */       this.value_ &= b;
/* 118 */       this.lock_.notifyAll();
/* 119 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long or(long b)
/*     */   {
/* 128 */     synchronized (this.lock_) {
/* 129 */       this.value_ |= b;
/* 130 */       this.lock_.notifyAll();
/* 131 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long xor(long b)
/*     */   {
/* 141 */     synchronized (this.lock_) {
/* 142 */       this.value_ ^= b;
/* 143 */       this.lock_.notifyAll();
/* 144 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenEqual(long c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 155 */     synchronized (this.lock_) {
/* 156 */       while (this.value_ != c) this.lock_.wait();
/* 157 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenNotEqual(long c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 166 */     synchronized (this.lock_) {
/* 167 */       while (this.value_ == c) this.lock_.wait();
/* 168 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLessEqual(long c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 177 */     synchronized (this.lock_) {
/* 178 */       while (this.value_ > c) this.lock_.wait();
/* 179 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLess(long c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 188 */     synchronized (this.lock_) {
/* 189 */       while (this.value_ >= c) this.lock_.wait();
/* 190 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreaterEqual(long c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 199 */     synchronized (this.lock_) {
/* 200 */       while (this.value_ < c) this.lock_.wait();
/* 201 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreater(long c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 210 */     synchronized (this.lock_) {
/* 211 */       while (this.value_ <= c) this.lock_.wait();
/* 212 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitableLong
 * JD-Core Version:    0.6.0
 */