/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WaitableDouble extends SynchronizedDouble
/*     */ {
/*     */   public WaitableDouble(double initialValue)
/*     */   {
/*  29 */     super(initialValue);
/*     */   }
/*     */ 
/*     */   public WaitableDouble(double initialValue, Object lock)
/*     */   {
/*  37 */     super(initialValue, lock);
/*     */   }
/*     */ 
/*     */   public double set(double newValue)
/*     */   {
/*  42 */     synchronized (this.lock_) {
/*  43 */       this.lock_.notifyAll();
/*  44 */       return super.set(newValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(double assumedValue, double newValue) {
/*  49 */     synchronized (this.lock_) {
/*  50 */       boolean success = super.commit(assumedValue, newValue);
/*  51 */       if (success) this.lock_.notifyAll();
/*  52 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public double add(double amount)
/*     */   {
/*  58 */     synchronized (this.lock_) {
/*  59 */       this.lock_.notifyAll();
/*  60 */       return super.add(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public double subtract(double amount) {
/*  65 */     synchronized (this.lock_) {
/*  66 */       this.lock_.notifyAll();
/*  67 */       return super.subtract(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public double multiply(double factor) {
/*  72 */     synchronized (this.lock_) {
/*  73 */       this.lock_.notifyAll();
/*  74 */       return super.multiply(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public double divide(double factor) {
/*  79 */     synchronized (this.lock_) {
/*  80 */       this.lock_.notifyAll();
/*  81 */       return super.divide(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenEqual(double c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/*  92 */     synchronized (this.lock_) {
/*  93 */       while (this.value_ != c) this.lock_.wait();
/*  94 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenNotEqual(double c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 103 */     synchronized (this.lock_) {
/* 104 */       while (this.value_ == c) this.lock_.wait();
/* 105 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLessEqual(double c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 114 */     synchronized (this.lock_) {
/* 115 */       while (this.value_ > c) this.lock_.wait();
/* 116 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLess(double c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 125 */     synchronized (this.lock_) {
/* 126 */       while (this.value_ >= c) this.lock_.wait();
/* 127 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreaterEqual(double c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 136 */     synchronized (this.lock_) {
/* 137 */       while (this.value_ < c) this.lock_.wait();
/* 138 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreater(double c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 147 */     synchronized (this.lock_) {
/* 148 */       while (this.value_ <= c) this.lock_.wait();
/* 149 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitableDouble
 * JD-Core Version:    0.6.0
 */