/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedChar extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected char value_;
/*     */ 
/*     */   public SynchronizedChar(char initialValue)
/*     */   {
/*  32 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedChar(char initialValue, Object lock)
/*     */   {
/*  40 */     super(lock);
/*  41 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final char get()
/*     */   {
/*  47 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public char set(char newValue)
/*     */   {
/*  55 */     synchronized (this.lock_) {
/*  56 */       char old = this.value_;
/*  57 */       this.value_ = newValue;
/*  58 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(char assumedValue, char newValue)
/*     */   {
/*  67 */     synchronized (this.lock_) {
/*  68 */       boolean success = assumedValue == this.value_;
/*  69 */       if (success) this.value_ = newValue;
/*  70 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public char swap(SynchronizedChar other)
/*     */   {
/*  86 */     if (other == this) return get();
/*  87 */     SynchronizedChar fst = this;
/*  88 */     SynchronizedChar snd = other;
/*  89 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  90 */       fst = other;
/*  91 */       snd = this;
/*     */     }
/*  93 */     synchronized (fst.lock_) {
/*  94 */       synchronized (snd.lock_) {
/*  95 */         fst.set(snd.set(fst.get()));
/*  96 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public char add(char amount)
/*     */   {
/* 106 */     synchronized (this.lock_) {
/* 107 */       return this.value_ = (char)(this.value_ + amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public char subtract(char amount)
/*     */   {
/* 116 */     synchronized (this.lock_) {
/* 117 */       return this.value_ = (char)(this.value_ - amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized char multiply(char factor)
/*     */   {
/* 126 */     synchronized (this.lock_) {
/* 127 */       return this.value_ = (char)(this.value_ * factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public char divide(char factor)
/*     */   {
/* 136 */     synchronized (this.lock_) {
/* 137 */       return this.value_ = (char)(this.value_ / factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(char other) {
/* 142 */     char val = get();
/* 143 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedChar other) {
/* 147 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 151 */     return compareTo((SynchronizedChar)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 155 */     if ((other != null) && 
/* 156 */       ((other instanceof SynchronizedChar))) {
/* 157 */       return get() == ((SynchronizedChar)other).get();
/*     */     }
/* 159 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 163 */     return get();
/*     */   }
/*     */   public String toString() {
/* 166 */     return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedChar
 * JD-Core Version:    0.6.0
 */