/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ 
/*     */ public class SyncList extends SyncCollection
/*     */   implements List
/*     */ {
/*     */   public SyncList(List list, Sync sync)
/*     */   {
/*  38 */     super(list, sync);
/*     */   }
/*     */ 
/*     */   public SyncList(List list, ReadWriteLock rwl)
/*     */   {
/*  46 */     super(list, rwl.readLock(), rwl.writeLock());
/*     */   }
/*     */ 
/*     */   public SyncList(List list, Sync readLock, Sync writeLock)
/*     */   {
/*  54 */     super(list, readLock, writeLock);
/*     */   }
/*     */ 
/*     */   protected List baseList()
/*     */   {
/*  59 */     return (List)this.c_;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/*  64 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  66 */       int i = this.c_.hashCode();
/*     */       return i;
/*     */     }
/*     */     finally {
/*  69 */       afterRead(wasInterrupted);
/*  70 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o) {
/*  74 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  76 */       boolean bool1 = this.c_.equals(o);
/*     */       return bool1;
/*     */     }
/*     */     finally {
/*  79 */       afterRead(wasInterrupted);
/*  80 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object get(int index) {
/*  84 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  86 */       Object localObject2 = baseList().get(index);
/*     */       return localObject2;
/*     */     }
/*     */     finally {
/*  89 */       afterRead(wasInterrupted);
/*  90 */     }throw localObject1;
/*     */   }
/*     */ 
/*     */   public int indexOf(Object o) {
/*  94 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  96 */       int i = baseList().indexOf(o);
/*     */       return i;
/*     */     }
/*     */     finally {
/*  99 */       afterRead(wasInterrupted);
/* 100 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public int lastIndexOf(Object o)
/*     */   {
/* 105 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 107 */       int i = baseList().lastIndexOf(o);
/*     */       return i;
/*     */     }
/*     */     finally {
/* 110 */       afterRead(wasInterrupted);
/* 111 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public List subList(int fromIndex, int toIndex)
/*     */   {
/* 117 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 119 */       SyncList localSyncList = new SyncList(baseList().subList(fromIndex, toIndex), this.rd_, this.wr_);
/*     */       return localSyncList;
/*     */     }
/*     */     finally {
/* 122 */       afterRead(wasInterrupted);
/* 123 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object set(int index, Object o) {
/*     */     try {
/* 128 */       this.wr_.acquire();
/*     */       try {
/* 130 */         Object localObject2 = baseList().set(index, o);
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 133 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 137 */       Thread.currentThread().interrupt();
/* 138 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object remove(int index)
/*     */   {
/*     */     try
/*     */     {
/* 145 */       this.wr_.acquire();
/*     */       try {
/* 147 */         Object localObject2 = baseList().remove(index);
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 150 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 154 */       Thread.currentThread().interrupt();
/* 155 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void add(int index, Object o)
/*     */   {
/*     */     try {
/* 161 */       this.wr_.acquire();
/*     */       try {
/* 163 */         baseList().add(index, o);
/*     */       }
/*     */       finally {
/* 166 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 170 */       Thread.currentThread().interrupt();
/* 171 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean addAll(int index, Collection coll) {
/*     */     try {
/* 177 */       this.wr_.acquire();
/*     */       try {
/* 179 */         boolean bool = baseList().addAll(index, coll);
/*     */         return bool;
/*     */       }
/*     */       finally {
/* 182 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 186 */       Thread.currentThread().interrupt();
/* 187 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public ListIterator unprotectedListIterator()
/*     */   {
/* 192 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 194 */       ListIterator localListIterator = baseList().listIterator();
/*     */       return localListIterator;
/*     */     }
/*     */     finally {
/* 197 */       afterRead(wasInterrupted);
/* 198 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public ListIterator listIterator() {
/* 202 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 204 */       SyncCollectionListIterator localSyncCollectionListIterator = new SyncCollectionListIterator((Iterator)baseList().listIterator());
/*     */       return localSyncCollectionListIterator;
/*     */     }
/*     */     finally {
/* 207 */       afterRead(wasInterrupted);
/* 208 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public ListIterator unprotectedListIterator(int index) {
/* 212 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 214 */       ListIterator localListIterator = baseList().listIterator(index);
/*     */       return localListIterator;
/*     */     }
/*     */     finally {
/* 217 */       afterRead(wasInterrupted);
/* 218 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public ListIterator listIterator(int index) {
/* 222 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 224 */       SyncCollectionListIterator localSyncCollectionListIterator = new SyncCollectionListIterator((Iterator)baseList().listIterator(index));
/*     */       return localSyncCollectionListIterator;
/*     */     }
/*     */     finally {
/* 227 */       afterRead(wasInterrupted);
/* 228 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public class SyncCollectionListIterator extends SyncCollection.SyncCollectionIterator implements ListIterator
/*     */   {
/*     */     SyncCollectionListIterator(Iterator baseIterator)
/*     */     {
/* 235 */       super(baseIterator);
/*     */     }
/*     */ 
/*     */     protected ListIterator baseListIterator() {
/* 239 */       return (ListIterator)this.baseIterator_;
/*     */     }
/*     */ 
/*     */     public boolean hasPrevious() {
/* 243 */       boolean wasInterrupted = SyncList.this.beforeRead();
/*     */       try {
/* 245 */         boolean bool1 = baseListIterator().hasPrevious();
/*     */         return bool1;
/*     */       }
/*     */       finally {
/* 248 */         SyncList.this.afterRead(wasInterrupted);
/* 249 */       }throw localObject;
/*     */     }
/*     */ 
/*     */     public Object previous() {
/* 253 */       boolean wasInterrupted = SyncList.this.beforeRead();
/*     */       try {
/* 255 */         Object localObject2 = baseListIterator().previous();
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 258 */         SyncList.this.afterRead(wasInterrupted);
/* 259 */       }throw localObject1;
/*     */     }
/*     */ 
/*     */     public int nextIndex() {
/* 263 */       boolean wasInterrupted = SyncList.this.beforeRead();
/*     */       try {
/* 265 */         int i = baseListIterator().nextIndex();
/*     */         return i;
/*     */       }
/*     */       finally {
/* 268 */         SyncList.this.afterRead(wasInterrupted);
/* 269 */       }throw localObject;
/*     */     }
/*     */ 
/*     */     public int previousIndex()
/*     */     {
/* 274 */       boolean wasInterrupted = SyncList.this.beforeRead();
/*     */       try {
/* 276 */         int i = baseListIterator().previousIndex();
/*     */         return i;
/*     */       }
/*     */       finally {
/* 279 */         SyncList.this.afterRead(wasInterrupted);
/* 280 */       }throw localObject;
/*     */     }
/*     */ 
/*     */     public void set(Object o)
/*     */     {
/*     */       try {
/* 286 */         SyncList.this.wr_.acquire();
/*     */         try {
/* 288 */           baseListIterator().set(o);
/*     */         }
/*     */         finally {
/* 291 */           SyncList.this.wr_.release();
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex) {
/* 295 */         Thread.currentThread().interrupt();
/* 296 */         throw new UnsupportedOperationException();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void add(Object o) {
/*     */       try {
/* 302 */         SyncList.this.wr_.acquire();
/*     */         try {
/* 304 */           baseListIterator().add(o);
/*     */         }
/*     */         finally {
/* 307 */           SyncList.this.wr_.release();
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex) {
/* 311 */         Thread.currentThread().interrupt();
/* 312 */         throw new UnsupportedOperationException();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SyncList
 * JD-Core Version:    0.6.0
 */