/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class SyncCollection
/*     */   implements Collection
/*     */ {
/*     */   protected final Collection c_;
/*     */   protected final Sync rd_;
/*     */   protected final Sync wr_;
/* 193 */   protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);
/*     */ 
/*     */   public SyncCollection(Collection collection, Sync sync)
/*     */   {
/* 207 */     this(collection, sync, sync);
/*     */   }
/*     */ 
/*     */   public SyncCollection(Collection collection, ReadWriteLock rwl)
/*     */   {
/* 222 */     this(collection, rwl.readLock(), rwl.writeLock());
/*     */   }
/*     */ 
/*     */   public SyncCollection(Collection collection, Sync readLock, Sync writeLock)
/*     */   {
/* 230 */     this.c_ = collection;
/* 231 */     this.rd_ = readLock;
/* 232 */     this.wr_ = writeLock;
/*     */   }
/*     */ 
/*     */   public Sync readerSync()
/*     */   {
/* 240 */     return this.rd_;
/*     */   }
/*     */ 
/*     */   public Sync writerSync()
/*     */   {
/* 248 */     return this.wr_;
/*     */   }
/*     */ 
/*     */   public long syncFailures()
/*     */   {
/* 255 */     return this.syncFailures_.get();
/*     */   }
/*     */ 
/*     */   protected boolean beforeRead()
/*     */   {
/*     */     try
/*     */     {
/* 262 */       this.rd_.acquire();
/* 263 */       return false;
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 266 */       this.syncFailures_.increment();
/* 267 */     }return true;
/*     */   }
/*     */ 
/*     */   protected void afterRead(boolean wasInterrupted)
/*     */   {
/* 273 */     if (wasInterrupted) {
/* 274 */       Thread.currentThread().interrupt();
/*     */     }
/*     */     else
/* 277 */       this.rd_.release();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 283 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 285 */       int i = this.c_.size();
/*     */       return i;
/*     */     }
/*     */     finally {
/* 288 */       afterRead(wasInterrupted);
/* 289 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty() {
/* 293 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 295 */       boolean bool1 = this.c_.isEmpty();
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 298 */       afterRead(wasInterrupted);
/* 299 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o) {
/* 303 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 305 */       boolean bool1 = this.c_.contains(o);
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 308 */       afterRead(wasInterrupted);
/* 309 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object[] toArray() {
/* 313 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 315 */       Object[] arrayOfObject = this.c_.toArray();
/*     */       return arrayOfObject;
/*     */     }
/*     */     finally {
/* 318 */       afterRead(wasInterrupted);
/* 319 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a) {
/* 323 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 325 */       Object[] arrayOfObject = this.c_.toArray(a);
/*     */       return arrayOfObject;
/*     */     }
/*     */     finally {
/* 328 */       afterRead(wasInterrupted);
/* 329 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection coll) {
/* 333 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 335 */       boolean bool1 = this.c_.containsAll(coll);
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 338 */       afterRead(wasInterrupted);
/* 339 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean add(Object o)
/*     */   {
/*     */     try {
/* 345 */       this.wr_.acquire();
/*     */       try {
/* 347 */         boolean bool = this.c_.add(o);
/*     */         return bool;
/*     */       }
/*     */       finally {
/* 350 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 354 */       Thread.currentThread().interrupt();
/* 355 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/*     */     try {
/* 361 */       this.wr_.acquire();
/*     */       try {
/* 363 */         boolean bool = this.c_.remove(o);
/*     */         return bool;
/*     */       }
/*     */       finally {
/* 366 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 370 */       Thread.currentThread().interrupt();
/* 371 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection coll)
/*     */   {
/*     */     try {
/* 377 */       this.wr_.acquire();
/*     */       try {
/* 379 */         boolean bool = this.c_.addAll(coll);
/*     */         return bool;
/*     */       }
/*     */       finally {
/* 382 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 386 */       Thread.currentThread().interrupt();
/* 387 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection coll)
/*     */   {
/*     */     try {
/* 393 */       this.wr_.acquire();
/*     */       try {
/* 395 */         boolean bool = this.c_.removeAll(coll);
/*     */         return bool;
/*     */       }
/*     */       finally {
/* 398 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 402 */       Thread.currentThread().interrupt();
/* 403 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection coll)
/*     */   {
/*     */     try
/*     */     {
/* 410 */       this.wr_.acquire();
/*     */       try {
/* 412 */         boolean bool = this.c_.retainAll(coll);
/*     */         return bool;
/*     */       }
/*     */       finally {
/* 415 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 419 */       Thread.currentThread().interrupt();
/* 420 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*     */     try
/*     */     {
/* 427 */       this.wr_.acquire();
/*     */       try {
/* 429 */         this.c_.clear();
/*     */       }
/*     */       finally {
/* 432 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 436 */       Thread.currentThread().interrupt();
/* 437 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Iterator unprotectedIterator()
/*     */   {
/* 444 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 446 */       Iterator localIterator = this.c_.iterator();
/*     */       return localIterator;
/*     */     }
/*     */     finally {
/* 449 */       afterRead(wasInterrupted);
/* 450 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Iterator iterator() {
/* 454 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 456 */       SyncCollectionIterator localSyncCollectionIterator = new SyncCollectionIterator(this.c_.iterator());
/*     */       return localSyncCollectionIterator;
/*     */     }
/*     */     finally {
/* 459 */       afterRead(wasInterrupted);
/* 460 */     }throw localObject;
/*     */   }
/*     */   public class SyncCollectionIterator implements Iterator {
/*     */     protected final Iterator baseIterator_;
/*     */ 
/*     */     SyncCollectionIterator(Iterator baseIterator) {
/* 467 */       this.baseIterator_ = baseIterator;
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/* 471 */       boolean wasInterrupted = SyncCollection.this.beforeRead();
/*     */       try {
/* 473 */         boolean bool1 = this.baseIterator_.hasNext();
/*     */         return bool1;
/*     */       }
/*     */       finally {
/* 476 */         SyncCollection.this.afterRead(wasInterrupted);
/* 477 */       }throw localObject;
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 481 */       boolean wasInterrupted = SyncCollection.this.beforeRead();
/*     */       try {
/* 483 */         Object localObject2 = this.baseIterator_.next();
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 486 */         SyncCollection.this.afterRead(wasInterrupted);
/* 487 */       }throw localObject1;
/*     */     }
/*     */ 
/*     */     public void remove() {
/*     */       try {
/* 492 */         SyncCollection.this.wr_.acquire();
/*     */         try {
/* 494 */           this.baseIterator_.remove();
/*     */         }
/*     */         finally {
/* 497 */           SyncCollection.this.wr_.release();
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex) {
/* 501 */         Thread.currentThread().interrupt();
/* 502 */         throw new UnsupportedOperationException();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SyncCollection
 * JD-Core Version:    0.6.0
 */