/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class Semaphore
/*     */   implements Sync
/*     */ {
/*     */   protected long permits_;
/*     */ 
/*     */   public Semaphore(long initialPermits)
/*     */   {
/* 100 */     this.permits_ = initialPermits;
/*     */   }
/*     */ 
/*     */   public void acquire() throws InterruptedException
/*     */   {
/* 105 */     if (Thread.interrupted()) throw new InterruptedException();
/* 106 */     synchronized (this) {
/*     */       try {
/* 108 */         while (this.permits_ <= 0L) wait();
/* 109 */         this.permits_ -= 1L;
/*     */       }
/*     */       catch (InterruptedException ex) {
/* 112 */         notify();
/* 113 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs) throws InterruptedException
/*     */   {
/* 120 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 122 */     synchronized (this) {
/* 123 */       if (this.permits_ > 0L) {
/* 124 */         this.permits_ -= 1L;
/* 125 */         return true;
/*     */       }
/* 127 */       if (msecs <= 0L)
/* 128 */         return false;
/*     */       try
/*     */       {
/* 131 */         long startTime = System.currentTimeMillis();
/* 132 */         long waitTime = msecs;
/*     */         do
/*     */         {
/* 135 */           wait(waitTime);
/* 136 */           if (this.permits_ > 0L) {
/* 137 */             this.permits_ -= 1L;
/* 138 */             return true;
/*     */           }
/*     */ 
/* 141 */           waitTime = msecs - (System.currentTimeMillis() - startTime);
/* 142 */         }while (waitTime > 0L);
/* 143 */         return false;
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 148 */         notify();
/* 149 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void release()
/*     */   {
/* 157 */     this.permits_ += 1L;
/* 158 */     notify();
/*     */   }
/*     */ 
/*     */   public synchronized void release(long n)
/*     */   {
/* 173 */     if (n < 0L) throw new IllegalArgumentException("Negative argument");
/*     */ 
/* 175 */     this.permits_ += n;
/* 176 */     for (long i = 0L; i < n; i += 1L) notify();
/*     */   }
/*     */ 
/*     */   public synchronized long permits()
/*     */   {
/* 185 */     return this.permits_;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.Semaphore
 * JD-Core Version:    0.6.0
 */