/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class Rendezvous
/*     */   implements Barrier
/*     */ {
/*     */   protected final int parties_;
/* 153 */   protected boolean broken_ = false;
/*     */ 
/* 158 */   protected int entries_ = 0;
/*     */ 
/* 163 */   protected long departures_ = 0L;
/*     */   protected final Semaphore entryGate_;
/*     */   protected final Object[] slots_;
/*     */   protected RendezvousFunction rendezvousFunction_;
/*     */ 
/*     */   public Rendezvous(int parties)
/*     */   {
/* 188 */     this(parties, new Rotator());
/*     */   }
/*     */ 
/*     */   public Rendezvous(int parties, RendezvousFunction function)
/*     */   {
/* 198 */     if (parties <= 0) throw new IllegalArgumentException();
/* 199 */     this.parties_ = parties;
/* 200 */     this.rendezvousFunction_ = function;
/* 201 */     this.entryGate_ = new WaiterPreferenceSemaphore(parties);
/* 202 */     this.slots_ = new Object[parties];
/*     */   }
/*     */ 
/*     */   public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction function)
/*     */   {
/* 216 */     RendezvousFunction old = this.rendezvousFunction_;
/* 217 */     this.rendezvousFunction_ = function;
/* 218 */     return old;
/*     */   }
/*     */   public int parties() {
/* 221 */     return this.parties_;
/*     */   }
/* 223 */   public synchronized boolean broken() { return this.broken_;
/*     */   }
/*     */ 
/*     */   public void restart()
/*     */   {
/*     */     while (true)
/*     */     {
/* 238 */       synchronized (this) {
/* 239 */         if (this.entries_ != 0) {
/* 240 */           notifyAll();
/*     */         }
/*     */         else {
/* 243 */           this.broken_ = false;
/* 244 */           return;
/*     */         }
/*     */       }
/* 247 */       Thread.yield();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object rendezvous(Object x)
/*     */     throws InterruptedException, BrokenBarrierException
/*     */   {
/* 279 */     return doRendezvous(x, false, 0L);
/*     */   }
/*     */ 
/*     */   public Object attemptRendezvous(Object x, long msecs)
/*     */     throws InterruptedException, TimeoutException, BrokenBarrierException
/*     */   {
/* 314 */     return doRendezvous(x, true, msecs);
/*     */   }
/*     */ 
/*     */   protected Object doRendezvous(Object x, boolean timed, long msecs)
/*     */     throws InterruptedException, TimeoutException, BrokenBarrierException
/*     */   {
/*     */     long startTime;
/* 324 */     if (timed) {
/* 325 */       long startTime = System.currentTimeMillis();
/* 326 */       if (!this.entryGate_.attempt(msecs))
/* 327 */         throw new TimeoutException(msecs);
/*     */     }
/*     */     else
/*     */     {
/* 331 */       startTime = 0L;
/* 332 */       this.entryGate_.acquire();
/*     */     }
/*     */ 
/* 335 */     synchronized (this) { Object y = null;
/*     */ 
/* 339 */       int index = this.entries_++;
/* 340 */       this.slots_[index] = x;
/*     */       label333: int i;
/*     */       try { if (this.entries_ == this.parties_)
/*     */         {
/* 346 */           this.departures_ = this.entries_;
/* 347 */           notifyAll();
/*     */           try
/*     */           {
/* 350 */             if ((this.broken_) || (this.rendezvousFunction_ == null)) break label333; this.rendezvousFunction_.rendezvousFunction(this.slots_);
/*     */           }
/*     */           catch (RuntimeException ex) {
/* 354 */             this.broken_ = true;
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/*     */           do
/*     */           {
/* 362 */             long timeLeft = 0L;
/* 363 */             if (timed) {
/* 364 */               timeLeft = msecs - (System.currentTimeMillis() - startTime);
/* 365 */               if (timeLeft <= 0L) {
/* 366 */                 this.broken_ = true;
/* 367 */                 this.departures_ = this.entries_;
/* 368 */                 notifyAll();
/* 369 */                 throw new TimeoutException(msecs);
/*     */               }
/*     */             }
/*     */             try
/*     */             {
/* 374 */               wait(timeLeft);
/*     */             }
/*     */             catch (InterruptedException ex) {
/* 377 */               if ((this.broken_) || (this.departures_ > 0L)) {
/* 378 */                 Thread.currentThread().interrupt();
/* 379 */                 break label333;
/*     */               }
/*     */ 
/* 382 */               this.broken_ = true;
/* 383 */               this.departures_ = this.entries_;
/* 384 */               notifyAll();
/* 385 */               throw ex;
/*     */             }
/* 361 */             if (this.broken_) break; 
/* 361 */           }while (this.departures_ < 1L);
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 395 */         y = this.slots_[index];
/*     */ 
/* 398 */         if (--this.departures_ <= 0L) {
/* 399 */           for (int i = 0; i < this.slots_.length; i++) this.slots_[i] = null;
/* 400 */           this.entryGate_.release(this.entries_);
/* 401 */           this.entries_ = 0;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 406 */       if (this.broken_) {
/* 407 */         throw new BrokenBarrierException(index);
/*     */       }
/* 409 */       return y;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface RendezvousFunction
/*     */   {
/*     */     public abstract void rendezvousFunction(Object[] paramArrayOfObject);
/*     */   }
/*     */ 
/*     */   public static class Rotator
/*     */     implements Rendezvous.RendezvousFunction
/*     */   {
/*     */     public void rendezvousFunction(Object[] objects)
/*     */     {
/* 142 */       int lastIdx = objects.length - 1;
/* 143 */       Object first = objects[0];
/* 144 */       for (int i = 0; i < lastIdx; i++) objects[i] = objects[(i + 1)];
/* 145 */       objects[lastIdx] = first;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.Rendezvous
 * JD-Core Version:    0.6.0
 */