/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public abstract class QueuedSemaphore extends Semaphore
/*     */ {
/*     */   protected final WaitQueue wq_;
/*     */ 
/*     */   QueuedSemaphore(WaitQueue q, long initialPermits)
/*     */   {
/*  30 */     super(initialPermits);
/*  31 */     this.wq_ = q;
/*     */   }
/*     */ 
/*     */   public void acquire() throws InterruptedException {
/*  35 */     if (Thread.interrupted()) throw new InterruptedException();
/*  36 */     if (precheck()) return;
/*  37 */     QueuedSemaphore.WaitQueue.WaitNode w = new QueuedSemaphore.WaitQueue.WaitNode();
/*  38 */     w.doWait(this);
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs) throws InterruptedException {
/*  42 */     if (Thread.interrupted()) throw new InterruptedException();
/*  43 */     if (precheck()) return true;
/*  44 */     if (msecs <= 0L) return false;
/*     */ 
/*  46 */     QueuedSemaphore.WaitQueue.WaitNode w = new QueuedSemaphore.WaitQueue.WaitNode();
/*  47 */     return w.doTimedWait(this, msecs);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean precheck() {
/*  51 */     boolean pass = this.permits_ > 0L;
/*  52 */     if (pass) this.permits_ -= 1L;
/*  53 */     return pass;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean recheck(QueuedSemaphore.WaitQueue.WaitNode w) {
/*  57 */     boolean pass = this.permits_ > 0L;
/*  58 */     if (pass) this.permits_ -= 1L; else
/*  59 */       this.wq_.insert(w);
/*  60 */     return pass;
/*     */   }
/*     */ 
/*     */   protected synchronized QueuedSemaphore.WaitQueue.WaitNode getSignallee()
/*     */   {
/*  65 */     QueuedSemaphore.WaitQueue.WaitNode w = this.wq_.extract();
/*  66 */     if (w == null) this.permits_ += 1L;
/*  67 */     return w;
/*     */   }
/*     */   public void release() {
/*     */     QueuedSemaphore.WaitQueue.WaitNode w;
/*     */     do { w = getSignallee();
/*  73 */       if (w == null) return; 
/*     */     }
/*  74 */     while (!w.signal());
/*     */   }
/*     */ 
/*     */   public void release(long n)
/*     */   {
/*  80 */     if (n < 0L) throw new IllegalArgumentException("Negative argument");
/*     */ 
/*  82 */     for (long i = 0L; i < n; i += 1L) release();
/*     */   }
/*     */ 
/*     */   protected static abstract class WaitQueue
/*     */   {
/*     */     protected abstract void insert(WaitNode paramWaitNode);
/*     */ 
/*     */     protected abstract WaitNode extract();
/*     */ 
/*     */     protected static class WaitNode
/*     */     {
/*  96 */       boolean waiting = true;
/*  97 */       WaitNode next = null;
/*     */ 
/*     */       protected synchronized boolean signal() {
/* 100 */         boolean signalled = this.waiting;
/* 101 */         if (signalled) {
/* 102 */           this.waiting = false;
/* 103 */           notify();
/*     */         }
/* 105 */         return signalled;
/*     */       }
/*     */ 
/*     */       protected synchronized boolean doTimedWait(QueuedSemaphore sem, long msecs)
/*     */         throws InterruptedException
/*     */       {
/* 111 */         if ((sem.recheck(this)) || (!this.waiting))
/* 112 */           return true;
/* 113 */         if (msecs <= 0L) {
/* 114 */           this.waiting = false;
/* 115 */           return false;
/*     */         }
/*     */ 
/* 118 */         long waitTime = msecs;
/* 119 */         long start = System.currentTimeMillis();
/*     */         try
/*     */         {
/*     */           do {
/* 123 */             wait(waitTime);
/* 124 */             if (!this.waiting) {
/* 125 */               return true;
/*     */             }
/* 127 */             waitTime = msecs - (System.currentTimeMillis() - start);
/* 128 */           }while (waitTime > 0L);
/* 129 */           this.waiting = false;
/* 130 */           return false;
/*     */         }
/*     */         catch (InterruptedException ex)
/*     */         {
/* 136 */           if (this.waiting) {
/* 137 */             this.waiting = false;
/* 138 */             throw ex;
/*     */           }
/*     */ 
/* 141 */           Thread.currentThread().interrupt();
/* 142 */         }return true;
/*     */       }
/*     */ 
/*     */       protected synchronized void doWait(QueuedSemaphore sem)
/*     */         throws InterruptedException
/*     */       {
/* 150 */         if (!sem.recheck(this))
/*     */           try {
/* 152 */             while (this.waiting) wait(); 
/*     */           }
/*     */           catch (InterruptedException ex)
/*     */           {
/* 155 */             if (this.waiting) {
/* 156 */               this.waiting = false;
/* 157 */               throw ex;
/*     */             }
/*     */ 
/* 160 */             Thread.currentThread().interrupt();
/* 161 */             return;
/*     */           }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.QueuedSemaphore
 * JD-Core Version:    0.6.0
 */