/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class PooledExecutor extends ThreadFactoryUser
/*     */   implements Executor
/*     */ {
/*     */   public static final int DEFAULT_MAXIMUMPOOLSIZE = 2147483647;
/*     */   public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
/*     */   public static final long DEFAULT_KEEPALIVETIME = 60000L;
/* 358 */   protected int maximumPoolSize_ = 2147483647;
/*     */ 
/* 361 */   protected int minimumPoolSize_ = 1;
/*     */ 
/* 364 */   protected int poolSize_ = 0;
/*     */ 
/* 367 */   protected long keepAliveTime_ = 60000L;
/*     */ 
/* 373 */   protected boolean shutdown_ = false;
/*     */   protected final Channel handOff_;
/*     */   protected final Map threads_;
/*     */   protected BlockedExecutionHandler blockedExecutionHandler_;
/*     */ 
/*     */   public PooledExecutor()
/*     */   {
/* 396 */     this(new SynchronousChannel(), 2147483647);
/*     */   }
/*     */ 
/*     */   public PooledExecutor(int maxPoolSize)
/*     */   {
/* 405 */     this(new SynchronousChannel(), maxPoolSize);
/*     */   }
/*     */ 
/*     */   public PooledExecutor(Channel channel)
/*     */   {
/* 414 */     this(channel, 2147483647);
/*     */   }
/*     */ 
/*     */   public PooledExecutor(Channel channel, int maxPoolSize)
/*     */   {
/* 423 */     this.maximumPoolSize_ = maxPoolSize;
/* 424 */     this.handOff_ = channel;
/* 425 */     runWhenBlocked();
/* 426 */     this.threads_ = new HashMap();
/*     */   }
/*     */ 
/*     */   public synchronized int getMaximumPoolSize()
/*     */   {
/* 435 */     return this.maximumPoolSize_;
/*     */   }
/*     */ 
/*     */   public synchronized void setMaximumPoolSize(int newMaximum)
/*     */   {
/* 449 */     if (newMaximum <= 0) throw new IllegalArgumentException();
/* 450 */     this.maximumPoolSize_ = newMaximum;
/*     */   }
/*     */ 
/*     */   public synchronized int getMinimumPoolSize()
/*     */   {
/* 460 */     return this.minimumPoolSize_;
/*     */   }
/*     */ 
/*     */   public synchronized void setMinimumPoolSize(int newMinimum)
/*     */   {
/* 471 */     if (newMinimum < 0) throw new IllegalArgumentException();
/* 472 */     this.minimumPoolSize_ = newMinimum;
/*     */   }
/*     */ 
/*     */   public synchronized int getPoolSize()
/*     */   {
/* 481 */     return this.poolSize_;
/*     */   }
/*     */ 
/*     */   public synchronized long getKeepAliveTime()
/*     */   {
/* 490 */     return this.keepAliveTime_;
/*     */   }
/*     */ 
/*     */   public synchronized void setKeepAliveTime(long msecs)
/*     */   {
/* 499 */     this.keepAliveTime_ = msecs;
/*     */   }
/*     */ 
/*     */   public synchronized BlockedExecutionHandler getBlockedExecutionHandler()
/*     */   {
/* 504 */     return this.blockedExecutionHandler_;
/*     */   }
/*     */ 
/*     */   public synchronized void setBlockedExecutionHandler(BlockedExecutionHandler h)
/*     */   {
/* 509 */     this.blockedExecutionHandler_ = h;
/*     */   }
/*     */ 
/*     */   protected void addThread(Runnable command)
/*     */   {
/* 517 */     Worker worker = new Worker(command);
/* 518 */     Thread thread = getThreadFactory().newThread(worker);
/* 519 */     this.threads_.put(worker, thread);
/* 520 */     this.poolSize_ += 1;
/* 521 */     thread.start();
/*     */   }
/*     */ 
/*     */   public int createThreads(int numberOfThreads)
/*     */   {
/* 530 */     int ncreated = 0;
/* 531 */     for (int i = 0; i < numberOfThreads; i++)
/* 532 */       synchronized (this) {
/* 533 */         if (this.poolSize_ < this.maximumPoolSize_) {
/* 534 */           addThread(null);
/* 535 */           ncreated++;
/*     */         }
/*     */         else {
/* 538 */           break;
/*     */         }
/*     */       }
/* 541 */     return ncreated;
/*     */   }
/*     */ 
/*     */   public synchronized void interruptAll()
/*     */   {
/* 552 */     for (Iterator it = this.threads_.values().iterator(); it.hasNext(); ) {
/* 553 */       Thread t = (Thread)it.next();
/* 554 */       t.interrupt();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void shutdownNow()
/*     */   {
/* 564 */     shutdownNow(new DiscardWhenBlocked());
/*     */   }
/*     */ 
/*     */   public synchronized void shutdownNow(BlockedExecutionHandler handler)
/*     */   {
/* 574 */     setBlockedExecutionHandler(handler);
/* 575 */     this.shutdown_ = true;
/* 576 */     this.minimumPoolSize_ = (this.maximumPoolSize_ = 0);
/* 577 */     interruptAll();
/*     */   }
/*     */ 
/*     */   public void shutdownAfterProcessingCurrentlyQueuedTasks()
/*     */   {
/* 586 */     shutdownAfterProcessingCurrentlyQueuedTasks(new DiscardWhenBlocked());
/*     */   }
/*     */ 
/*     */   public void shutdownAfterProcessingCurrentlyQueuedTasks(BlockedExecutionHandler handler)
/*     */   {
/* 596 */     synchronized (this) {
/* 597 */       setBlockedExecutionHandler(handler);
/* 598 */       this.shutdown_ = true;
/* 599 */       if (this.poolSize_ == 0) {
/* 600 */         this.minimumPoolSize_ = (this.maximumPoolSize_ = 0);
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 606 */       Runnable r = new Runnable() { public void run() { PooledExecutor.this.interruptAll();
/*     */         }
/*     */       };
/* 607 */       this.handOff_.offer(r, 0L);
/*     */     }
/*     */     catch (InterruptedException ie) {
/* 610 */       Thread.currentThread().interrupt();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized boolean isTerminatedAfterShutdown()
/*     */   {
/* 619 */     return (this.shutdown_) && (this.poolSize_ == 0);
/*     */   }
/*     */ 
/*     */   public synchronized boolean awaitTerminationAfterShutdown(long maxWaitTime)
/*     */     throws InterruptedException
/*     */   {
/* 634 */     if (!this.shutdown_)
/* 635 */       throw new IllegalStateException();
/* 636 */     if (this.poolSize_ == 0)
/* 637 */       return true;
/* 638 */     long waitTime = maxWaitTime;
/* 639 */     if (waitTime <= 0L)
/* 640 */       return false;
/* 641 */     long start = System.currentTimeMillis();
/*     */     do {
/* 643 */       wait(waitTime);
/* 644 */       if (this.poolSize_ == 0)
/* 645 */         return true;
/* 646 */       waitTime = maxWaitTime - (System.currentTimeMillis() - start);
/* 647 */     }while (waitTime > 0L);
/* 648 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized void awaitTerminationAfterShutdown()
/*     */     throws InterruptedException
/*     */   {
/* 661 */     if (!this.shutdown_)
/* 662 */       throw new IllegalStateException();
/*     */     do
/* 664 */       wait();
/* 663 */     while (this.poolSize_ > 0);
/*     */   }
/*     */ 
/*     */   public List drain()
/*     */   {
/* 685 */     boolean wasInterrupted = false;
/* 686 */     Vector tasks = new Vector();
/*     */     while (true) {
/*     */       try {
/* 689 */         Object x = this.handOff_.poll(0L);
/* 690 */         if (x == null) {
/*     */           break;
/*     */         }
/* 693 */         tasks.addElement(x); continue;
/*     */       }
/*     */       catch (InterruptedException ex) {
/* 696 */         wasInterrupted = true;
/*     */       }
/*     */     }
/* 699 */     if (wasInterrupted) Thread.currentThread().interrupt();
/* 700 */     return tasks;
/*     */   }
/*     */ 
/*     */   protected synchronized void workerDone(Worker w)
/*     */   {
/* 707 */     this.threads_.remove(w);
/* 708 */     if ((--this.poolSize_ == 0) && (this.shutdown_)) {
/* 709 */       this.maximumPoolSize_ = (this.minimumPoolSize_ = 0);
/* 710 */       notifyAll();
/*     */     }
/*     */ 
/* 714 */     if ((this.poolSize_ == 0) || (this.poolSize_ < this.minimumPoolSize_))
/*     */       try {
/* 716 */         Runnable r = (Runnable)this.handOff_.poll(0L);
/* 717 */         if ((r != null) && (!this.shutdown_))
/* 718 */           addThread(r);
/*     */       } catch (InterruptedException ie) {
/* 720 */         return;
/*     */       }
/*     */   }
/*     */ 
/*     */   protected Runnable getTask()
/*     */     throws InterruptedException
/*     */   {
/*     */     long waitTime;
/* 730 */     synchronized (this) {
/* 731 */       if (this.poolSize_ > this.maximumPoolSize_)
/* 732 */         return null;
/* 733 */       waitTime = this.shutdown_ ? 0L : this.keepAliveTime_;
/*     */     }
/*     */     long waitTime;
/* 735 */     if (waitTime >= 0L) {
/* 736 */       return (Runnable)this.handOff_.poll(waitTime);
/*     */     }
/* 738 */     return (Runnable)this.handOff_.take();
/*     */   }
/*     */ 
/*     */   public void runWhenBlocked()
/*     */   {
/* 801 */     setBlockedExecutionHandler(new RunWhenBlocked());
/*     */   }
/*     */ 
/*     */   public void waitWhenBlocked()
/*     */   {
/* 822 */     setBlockedExecutionHandler(new WaitWhenBlocked());
/*     */   }
/*     */ 
/*     */   public void discardWhenBlocked()
/*     */   {
/* 837 */     setBlockedExecutionHandler(new DiscardWhenBlocked());
/*     */   }
/*     */ 
/*     */   public void abortWhenBlocked()
/*     */   {
/* 853 */     setBlockedExecutionHandler(new AbortWhenBlocked());
/*     */   }
/*     */ 
/*     */   public void discardOldestWhenBlocked()
/*     */   {
/* 877 */     setBlockedExecutionHandler(new DiscardOldestWhenBlocked());
/*     */   }
/*     */ 
/*     */   public void execute(Runnable command)
/*     */     throws InterruptedException
/*     */   {
/*     */     do {
/* 887 */       synchronized (this) {
/* 888 */         if (!this.shutdown_) {
/* 889 */           int size = this.poolSize_;
/*     */ 
/* 892 */           if (size < this.minimumPoolSize_) {
/* 893 */             addThread(command);
/* 894 */             return;
/*     */           }
/*     */ 
/* 898 */           if (this.handOff_.offer(command, 0L)) {
/* 899 */             return;
/*     */           }
/*     */ 
/* 903 */           if (size < this.maximumPoolSize_) {
/* 904 */             addThread(command);
/* 905 */             return;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 911 */     while (!getBlockedExecutionHandler().blockedAction(command));
/*     */   }
/*     */ 
/*     */   protected class AbortWhenBlocked
/*     */     implements PooledExecutor.BlockedExecutionHandler
/*     */   {
/*     */     protected AbortWhenBlocked()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean blockedAction(Runnable command)
/*     */     {
/* 844 */       throw new RuntimeException("Pool is blocked");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface BlockedExecutionHandler
/*     */   {
/*     */     public abstract boolean blockedAction(Runnable paramRunnable)
/*     */       throws InterruptedException;
/*     */   }
/*     */ 
/*     */   protected class DiscardOldestWhenBlocked
/*     */     implements PooledExecutor.BlockedExecutionHandler
/*     */   {
/*     */     protected DiscardOldestWhenBlocked()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean blockedAction(Runnable command)
/*     */       throws InterruptedException
/*     */     {
/* 865 */       PooledExecutor.this.handOff_.poll(0L);
/* 866 */       if (!PooledExecutor.this.handOff_.offer(command, 0L))
/* 867 */         command.run();
/* 868 */       return true;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class DiscardWhenBlocked
/*     */     implements PooledExecutor.BlockedExecutionHandler
/*     */   {
/*     */     protected DiscardWhenBlocked()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean blockedAction(Runnable command)
/*     */     {
/* 828 */       return true;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class RunWhenBlocked
/*     */     implements PooledExecutor.BlockedExecutionHandler
/*     */   {
/*     */     protected RunWhenBlocked()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean blockedAction(Runnable command)
/*     */     {
/* 790 */       command.run();
/* 791 */       return true;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class WaitWhenBlocked
/*     */     implements PooledExecutor.BlockedExecutionHandler
/*     */   {
/*     */     protected WaitWhenBlocked()
/*     */     {
/*     */     }
/*     */ 
/*     */     public boolean blockedAction(Runnable command)
/*     */       throws InterruptedException
/*     */     {
/* 807 */       synchronized (PooledExecutor.this) {
/* 808 */         if (PooledExecutor.this.shutdown_)
/* 809 */           return true;
/*     */       }
/* 811 */       PooledExecutor.this.handOff_.put(command);
/* 812 */       return true;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class Worker
/*     */     implements Runnable
/*     */   {
/*     */     protected Runnable firstTask_;
/*     */ 
/*     */     protected Worker(Runnable firstTask)
/*     */     {
/* 748 */       this.firstTask_ = firstTask;
/*     */     }
/*     */     public void run() {
/*     */       try {
/* 752 */         Runnable task = this.firstTask_;
/* 753 */         this.firstTask_ = null;
/*     */ 
/* 755 */         if (task != null) {
/* 756 */           task.run();
/* 757 */           task = null;
/*     */         }
/*     */ 
/* 760 */         while ((task = PooledExecutor.this.getTask()) != null) {
/* 761 */           task.run();
/* 762 */           task = null;
/*     */         }
/*     */       } catch (InterruptedException localInterruptedException) {
/*     */       }
/*     */       finally {
/* 767 */         PooledExecutor.this.workerDone(this);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.PooledExecutor
 * JD-Core Version:    0.6.0
 */