/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class ObservableSync
/*     */   implements Sync
/*     */ {
/*  58 */   protected final CopyOnWriteArraySet observers_ = new CopyOnWriteArraySet();
/*     */   protected Object arg_;
/*     */ 
/*     */   public ObservableSync(Object notificationArgument)
/*     */   {
/*  68 */     this.arg_ = notificationArgument;
/*     */   }
/*     */ 
/*     */   public synchronized Object getNotificationArgument()
/*     */   {
/*  75 */     return this.arg_;
/*     */   }
/*     */ 
/*     */   public synchronized Object setNotificationArgument(Object notificationArg)
/*     */   {
/*  84 */     Object old = this.arg_;
/*  85 */     this.arg_ = notificationArg;
/*  86 */     return old;
/*     */   }
/*     */ 
/*     */   public void acquire()
/*     */   {
/*  92 */     Object arg = getNotificationArgument();
/*  93 */     for (Iterator it = this.observers_.iterator(); it.hasNext(); )
/*  94 */       ((SyncObserver)it.next()).onAcquire(arg);
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs)
/*     */   {
/*  99 */     acquire();
/* 100 */     return true;
/*     */   }
/*     */ 
/*     */   public void release() {
/* 104 */     Object arg = getNotificationArgument();
/* 105 */     for (Iterator it = this.observers_.iterator(); it.hasNext(); )
/* 106 */       ((SyncObserver)it.next()).onRelease(arg);
/*     */   }
/*     */ 
/*     */   public void attach(SyncObserver obs)
/*     */   {
/* 114 */     this.observers_.add(obs);
/*     */   }
/*     */ 
/*     */   public void detach(SyncObserver obs)
/*     */   {
/* 119 */     this.observers_.remove(obs);
/*     */   }
/*     */ 
/*     */   public Iterator observers()
/*     */   {
/* 127 */     return this.observers_.iterator();
/*     */   }
/*     */ 
/*     */   public static abstract interface SyncObserver
/*     */   {
/*     */     public abstract void onAcquire(Object paramObject);
/*     */ 
/*     */     public abstract void onRelease(Object paramObject);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.ObservableSync
 * JD-Core Version:    0.6.0
 */