/*    */ package EDU.oswego.cs.dl.util.concurrent;
/*    */ 
/*    */ public class LayeredSync
/*    */   implements Sync
/*    */ {
/*    */   protected final Sync outer_;
/*    */   protected final Sync inner_;
/*    */ 
/*    */   public LayeredSync(Sync outer, Sync inner)
/*    */   {
/* 43 */     this.outer_ = outer;
/* 44 */     this.inner_ = inner;
/*    */   }
/*    */ 
/*    */   public void acquire() throws InterruptedException {
/* 48 */     this.outer_.acquire();
/*    */     try {
/* 50 */       this.inner_.acquire();
/*    */     }
/*    */     catch (InterruptedException ex) {
/* 53 */       this.outer_.release();
/* 54 */       throw ex;
/*    */     }
/*    */   }
/*    */ 
/*    */   public boolean attempt(long msecs) throws InterruptedException
/*    */   {
/* 60 */     long start = msecs <= 0L ? 0L : System.currentTimeMillis();
/* 61 */     long waitTime = msecs;
/*    */ 
/* 63 */     if (this.outer_.attempt(waitTime)) {
/*    */       try {
/* 65 */         if (msecs > 0L)
/* 66 */           waitTime = msecs - (System.currentTimeMillis() - start);
/* 67 */         if (this.inner_.attempt(waitTime)) {
/* 68 */           return true;
/*    */         }
/* 70 */         this.outer_.release();
/* 71 */         return false;
/*    */       }
/*    */       catch (InterruptedException ex)
/*    */       {
/* 75 */         this.outer_.release();
/* 76 */         throw ex;
/*    */       }
/*    */     }
/*    */ 
/* 80 */     return false;
/*    */   }
/*    */ 
/*    */   public void release() {
/* 84 */     this.inner_.release();
/* 85 */     this.outer_.release();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.LayeredSync
 * JD-Core Version:    0.6.0
 */