/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class CondVar
/*     */ {
/*     */   protected final Sync mutex_;
/*     */ 
/*     */   public CondVar(Sync mutex)
/*     */   {
/* 150 */     this.mutex_ = mutex;
/*     */   }
/*     */ 
/*     */   public void await()
/*     */     throws InterruptedException
/*     */   {
/* 165 */     if (Thread.interrupted()) throw new InterruptedException(); try
/*     */     {
/* 167 */       synchronized (this) {
/* 168 */         this.mutex_.release();
/*     */         try {
/* 170 */           wait();
/*     */         }
/*     */         catch (InterruptedException ex) {
/* 173 */           notify();
/* 174 */           throw ex;
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 180 */       boolean interrupted = false;
/*     */       while (true) {
/*     */         try {
/* 183 */           this.mutex_.acquire();
/*     */         }
/*     */         catch (InterruptedException ex)
/*     */         {
/* 187 */           interrupted = true;
/*     */         }
/*     */       }
/* 190 */       if (interrupted)
/* 191 */         Thread.currentThread().interrupt();
/*     */     }
/* 180 */     boolean interrupted = false;
/*     */     while (true) {
/*     */       try {
/* 183 */         this.mutex_.acquire();
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 187 */         interrupted = true;
/*     */       }
/*     */     }
/* 190 */     if (interrupted)
/* 191 */       Thread.currentThread().interrupt();
/*     */   }
/*     */ 
/*     */   public boolean timedwait(long msecs)
/*     */     throws InterruptedException
/*     */   {
/* 214 */     if (Thread.interrupted()) throw new InterruptedException();
/* 215 */     boolean success = false;
/*     */     try {
/* 217 */       synchronized (this) {
/* 218 */         this.mutex_.release();
/*     */         try {
/* 220 */           if (msecs > 0L) {
/* 221 */             long start = System.currentTimeMillis();
/* 222 */             wait(msecs);
/* 223 */             success = System.currentTimeMillis() - start <= msecs;
/*     */           }
/*     */         }
/*     */         catch (InterruptedException ex) {
/* 227 */           notify();
/* 228 */           throw ex;
/*     */         }
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 234 */       boolean interrupted = false;
/*     */       while (true) {
/*     */         try {
/* 237 */           this.mutex_.acquire();
/*     */         }
/*     */         catch (InterruptedException ex)
/*     */         {
/* 241 */           interrupted = true;
/*     */         }
/*     */       }
/* 244 */       if (interrupted)
/* 245 */         Thread.currentThread().interrupt();
/*     */     }
/* 234 */     boolean interrupted = false;
/*     */     while (true) {
/*     */       try {
/* 237 */         this.mutex_.acquire();
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 241 */         interrupted = true;
/*     */       }
/*     */     }
/* 244 */     if (interrupted) {
/* 245 */       Thread.currentThread().interrupt();
/*     */     }
/*     */ 
/* 248 */     return success;
/*     */   }
/*     */ 
/*     */   public synchronized void signal()
/*     */   {
/* 257 */     notify();
/*     */   }
/*     */ 
/*     */   public synchronized void broadcast()
/*     */   {
/* 262 */     notifyAll();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.CondVar
 * JD-Core Version:    0.6.0
 */