/*      */ package EDU.oswego.cs.dl.util.concurrent;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.util.AbstractCollection;
/*      */ import java.util.AbstractMap;
/*      */ import java.util.AbstractSet;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Set;
/*      */ 
/*      */ public class ConcurrentReaderHashMap extends AbstractMap
/*      */   implements Map, Cloneable, Serializable
/*      */ {
/*  189 */   protected final BarrierLock barrierLock = new BarrierLock();
/*      */   protected transient Object lastWrite;
/*  224 */   public static int DEFAULT_INITIAL_CAPACITY = 32;
/*      */   private static final int MINIMUM_CAPACITY = 4;
/*      */   private static final int MAXIMUM_CAPACITY = 1073741824;
/*      */   public static final float DEFAULT_LOAD_FACTOR = 0.75F;
/*      */   protected transient Entry[] table;
/*      */   protected transient int count;
/*      */   protected int threshold;
/*      */   protected float loadFactor;
/*  868 */   protected transient Set keySet = null;
/*  869 */   protected transient Set entrySet = null;
/*  870 */   protected transient Collection values = null;
/*      */ 
/*      */   protected final void recordModification(Object x)
/*      */   {
/*  203 */     synchronized (this.barrierLock) {
/*  204 */       this.lastWrite = x;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected final Entry[] getTableForReading()
/*      */   {
/*  214 */     synchronized (this.barrierLock) {
/*  215 */       return this.table;
/*      */     }
/*      */   }
/*      */ 
/*      */   private int p2capacity(int initialCapacity)
/*      */   {
/*  279 */     int cap = initialCapacity;
/*      */     int result;
/*      */     int result;
/*  283 */     if ((cap > 1073741824) || (cap < 0)) {
/*  284 */       result = 1073741824;
/*      */     } else {
/*  286 */       result = 4;
/*  287 */       while (result < cap)
/*  288 */         result <<= 1;
/*      */     }
/*  290 */     return result;
/*      */   }
/*      */ 
/*      */   private static int hash(Object x)
/*      */   {
/*  299 */     int h = x.hashCode();
/*      */ 
/*  303 */     return (h << 7) - h + (h >>> 9) + (h >>> 17);
/*      */   }
/*      */ 
/*      */   protected boolean eq(Object x, Object y)
/*      */   {
/*  310 */     return (x == y) || (x.equals(y));
/*      */   }
/*      */ 
/*      */   public ConcurrentReaderHashMap(int initialCapacity, float loadFactor)
/*      */   {
/*  326 */     if (loadFactor <= 0.0F)
/*  327 */       throw new IllegalArgumentException("Illegal Load factor: " + 
/*  328 */         loadFactor);
/*  329 */     this.loadFactor = loadFactor;
/*      */ 
/*  331 */     int cap = p2capacity(initialCapacity);
/*      */ 
/*  333 */     this.table = new Entry[cap];
/*  334 */     this.threshold = (int)(cap * loadFactor);
/*      */   }
/*      */ 
/*      */   public ConcurrentReaderHashMap(int initialCapacity)
/*      */   {
/*  349 */     this(initialCapacity, 0.75F);
/*      */   }
/*      */ 
/*      */   public ConcurrentReaderHashMap()
/*      */   {
/*  358 */     this(DEFAULT_INITIAL_CAPACITY, 0.75F);
/*      */   }
/*      */ 
/*      */   public ConcurrentReaderHashMap(Map t)
/*      */   {
/*  369 */     this(Math.max((int)(t.size() / 0.75F) + 1, 16), 
/*  369 */       0.75F);
/*  370 */     putAll(t);
/*      */   }
/*      */ 
/*      */   public synchronized int size()
/*      */   {
/*  380 */     return this.count;
/*      */   }
/*      */ 
/*      */   public synchronized boolean isEmpty()
/*      */   {
/*  390 */     return this.count == 0;
/*      */   }
/*      */ 
/*      */   public Object get(Object key)
/*      */   {
/*  411 */     int hash = hash(key);
/*      */ 
/*  422 */     Entry[] tab = this.table;
/*  423 */     int index = hash & tab.length - 1;
/*  424 */     Entry first = tab[index];
/*  425 */     Entry e = first;
/*      */     while (true)
/*      */     {
/*  428 */       if (e == null)
/*      */       {
/*  433 */         Entry[] reread = getTableForReading();
/*  434 */         if ((tab == reread) && (first == tab[index])) {
/*  435 */           return null;
/*      */         }
/*      */ 
/*  438 */         tab = reread;
/*  439 */         e = first = tab[(index = hash & tab.length - 1)]; continue;
/*      */       }
/*      */ 
/*  444 */       if ((e.hash == hash) && (eq(key, e.key))) {
/*  445 */         Object value = e.value;
/*  446 */         if (value != null) {
/*  447 */           return value;
/*      */         }
/*      */ 
/*  454 */         synchronized (this) {
/*  455 */           tab = this.table;
/*      */         }
/*  457 */         e = first = tab[(index = hash & tab.length - 1)]; continue;
/*      */       }
/*      */ 
/*  461 */       e = e.next;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean containsKey(Object key)
/*      */   {
/*  480 */     return get(key) != null;
/*      */   }
/*      */ 
/*      */   public Object put(Object key, Object value)
/*      */   {
/*  502 */     if (value == null) {
/*  503 */       throw new NullPointerException();
/*      */     }
/*  505 */     int hash = hash(key);
/*  506 */     Entry[] tab = this.table;
/*  507 */     int index = hash & tab.length - 1;
/*  508 */     Entry first = tab[index];
/*      */ 
/*  511 */     for (Entry e = first; e != null; e = e.next) {
/*  512 */       if ((e.hash == hash) && (eq(key, e.key)))
/*      */         break;
/*      */     }
/*  515 */     synchronized (this) {
/*  516 */       if (tab == this.table) {
/*  517 */         if (e == null)
/*      */         {
/*  519 */           if (first == tab[index])
/*      */           {
/*  521 */             Entry newEntry = new Entry(hash, key, value, first);
/*  522 */             tab[index] = newEntry;
/*  523 */             if (++this.count >= this.threshold) rehash(); else
/*  524 */               recordModification(newEntry);
/*  525 */             return null;
/*      */           }
/*      */         }
/*      */         else {
/*  529 */           Object oldValue = e.value;
/*  530 */           if ((first == tab[index]) && (oldValue != null)) {
/*  531 */             e.value = value;
/*  532 */             return oldValue;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  538 */       return sput(key, value, hash);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Object sput(Object key, Object value, int hash)
/*      */   {
/*  549 */     Entry[] tab = this.table;
/*  550 */     int index = hash & tab.length - 1;
/*  551 */     Entry first = tab[index];
/*  552 */     Entry e = first;
/*      */     while (true)
/*      */     {
/*  555 */       if (e == null) {
/*  556 */         Entry newEntry = new Entry(hash, key, value, first);
/*  557 */         tab[index] = newEntry;
/*  558 */         if (++this.count >= this.threshold) rehash(); else
/*  559 */           recordModification(newEntry);
/*  560 */         return null;
/*      */       }
/*  562 */       if ((e.hash == hash) && (eq(key, e.key))) {
/*  563 */         Object oldValue = e.value;
/*  564 */         e.value = value;
/*  565 */         return oldValue;
/*      */       }
/*      */ 
/*  568 */       e = e.next;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void rehash()
/*      */   {
/*  579 */     Entry[] oldTable = this.table;
/*  580 */     int oldCapacity = oldTable.length;
/*  581 */     if (oldCapacity >= 1073741824) {
/*  582 */       this.threshold = 2147483647;
/*  583 */       return;
/*      */     }
/*      */ 
/*  586 */     int newCapacity = oldCapacity << 1;
/*  587 */     int mask = newCapacity - 1;
/*  588 */     this.threshold = (int)(newCapacity * this.loadFactor);
/*      */ 
/*  590 */     Entry[] newTable = new Entry[newCapacity];
/*      */ 
/*  605 */     for (int i = 0; i < oldCapacity; i++)
/*      */     {
/*  608 */       Entry e = oldTable[i];
/*      */ 
/*  610 */       if (e != null) {
/*  611 */         int idx = e.hash & mask;
/*  612 */         Entry next = e.next;
/*      */ 
/*  615 */         if (next == null) {
/*  616 */           newTable[idx] = e;
/*      */         }
/*      */         else
/*      */         {
/*  620 */           Entry lastRun = e;
/*  621 */           int lastIdx = idx;
/*  622 */           for (Entry last = next; last != null; last = last.next) {
/*  623 */             int k = last.hash & mask;
/*  624 */             if (k != lastIdx) {
/*  625 */               lastIdx = k;
/*  626 */               lastRun = last;
/*      */             }
/*      */           }
/*  629 */           newTable[lastIdx] = lastRun;
/*      */ 
/*  632 */           for (Entry p = e; p != lastRun; p = p.next) {
/*  633 */             int k = p.hash & mask;
/*  634 */             newTable[k] = 
/*  635 */               new Entry(p.hash, p.key, 
/*  635 */               p.value, newTable[k]);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  641 */     this.table = newTable;
/*  642 */     recordModification(newTable);
/*      */   }
/*      */ 
/*      */   public Object remove(Object key)
/*      */   {
/*  668 */     int hash = hash(key);
/*  669 */     Entry[] tab = this.table;
/*  670 */     int index = hash & tab.length - 1;
/*  671 */     Entry first = tab[index];
/*  672 */     Entry e = first;
/*      */ 
/*  674 */     for (e = first; e != null; e = e.next) {
/*  675 */       if ((e.hash == hash) && (eq(key, e.key))) {
/*      */         break;
/*      */       }
/*      */     }
/*  679 */     synchronized (this) {
/*  680 */       if (tab == this.table) {
/*  681 */         if (e == null) {
/*  682 */           if (first == tab[index])
/*  683 */             return null;
/*      */         }
/*      */         else {
/*  686 */           Object oldValue = e.value;
/*  687 */           if ((first == tab[index]) && (oldValue != null)) {
/*  688 */             e.value = null;
/*  689 */             this.count -= 1;
/*      */ 
/*  691 */             Entry head = e.next;
/*  692 */             for (Entry p = first; p != e; p = p.next) {
/*  693 */               head = new Entry(p.hash, p.key, p.value, head);
/*      */             }
/*  695 */             tab[index] = head;
/*  696 */             recordModification(head);
/*  697 */             return oldValue;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  703 */       return sremove(key, hash);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Object sremove(Object key, int hash)
/*      */   {
/*  713 */     Entry[] tab = this.table;
/*  714 */     int index = hash & tab.length - 1;
/*  715 */     Entry first = tab[index];
/*      */ 
/*  717 */     for (Entry e = first; e != null; e = e.next) {
/*  718 */       if ((e.hash == hash) && (eq(key, e.key))) {
/*  719 */         Object oldValue = e.value;
/*  720 */         e.value = null;
/*  721 */         this.count -= 1;
/*  722 */         Entry head = e.next;
/*  723 */         for (Entry p = first; p != e; p = p.next) {
/*  724 */           head = new Entry(p.hash, p.key, p.value, head);
/*      */         }
/*  726 */         tab[index] = head;
/*  727 */         recordModification(head);
/*  728 */         return oldValue;
/*      */       }
/*      */     }
/*  731 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean containsValue(Object value)
/*      */   {
/*  748 */     if (value == null) throw new NullPointerException();
/*      */ 
/*  750 */     Entry[] tab = getTableForReading();
/*      */ 
/*  752 */     for (int i = 0; i < tab.length; i++) {
/*  753 */       for (Entry e = tab[i]; e != null; e = e.next) {
/*  754 */         if (value.equals(e.value))
/*  755 */           return true;
/*      */       }
/*      */     }
/*  758 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean contains(Object value)
/*      */   {
/*  781 */     return containsValue(value);
/*      */   }
/*      */ 
/*      */   public synchronized void putAll(Map t)
/*      */   {
/*  795 */     int n = t.size();
/*  796 */     if (n == 0) {
/*  797 */       return;
/*      */     }
/*      */ 
/*      */     do
/*      */     {
/*  803 */       rehash();
/*      */     }
/*  802 */     while (n >= this.threshold);
/*      */ 
/*  805 */     for (Iterator it = t.entrySet().iterator(); it.hasNext(); ) {
/*  806 */       Map.Entry entry = (Map.Entry)it.next();
/*  807 */       Object key = entry.getKey();
/*  808 */       Object value = entry.getValue();
/*  809 */       put(key, value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void clear()
/*      */   {
/*  818 */     Entry[] tab = this.table;
/*  819 */     for (int i = 0; i < tab.length; i++)
/*      */     {
/*  822 */       for (Entry e = tab[i]; e != null; e = e.next) {
/*  823 */         e.value = null;
/*      */       }
/*  825 */       tab[i] = null;
/*      */     }
/*  827 */     this.count = 0;
/*  828 */     recordModification(tab);
/*      */   }
/*      */ 
/*      */   public synchronized Object clone()
/*      */   {
/*      */     try
/*      */     {
/*  841 */       ConcurrentReaderHashMap t = (ConcurrentReaderHashMap)super.clone();
/*      */ 
/*  843 */       t.keySet = null;
/*  844 */       t.entrySet = null;
/*  845 */       t.values = null;
/*      */ 
/*  847 */       Entry[] tab = this.table;
/*  848 */       t.table = new Entry[tab.length];
/*  849 */       Entry[] ttab = t.table;
/*      */ 
/*  851 */       for (int i = 0; i < tab.length; i++) {
/*  852 */         Entry first = null;
/*  853 */         for (Entry e = tab[i]; e != null; e = e.next)
/*  854 */           first = new Entry(e.hash, e.key, e.value, first);
/*  855 */         ttab[i] = first;
/*      */       }
/*      */ 
/*  858 */       return t;
/*      */     }
/*      */     catch (CloneNotSupportedException e) {
/*      */     }
/*  862 */     throw new InternalError();
/*      */   }
/*      */ 
/*      */   public Set keySet()
/*      */   {
/*  885 */     Set ks = this.keySet;
/*  886 */     return this.keySet = new KeySet(null);
/*      */   }
/*      */ 
/*      */   public Collection values()
/*      */   {
/*  948 */     Collection vs = this.values;
/*  949 */     return this.values = new Values(null);
/*      */   }
/*      */ 
/*      */   public Set entrySet()
/*      */   {
/* 1010 */     Set es = this.entrySet;
/* 1011 */     return this.entrySet = new EntrySet(null);
/*      */   }
/*      */ 
/*      */   protected synchronized boolean findAndRemoveEntry(Map.Entry entry)
/*      */   {
/* 1070 */     Object key = entry.getKey();
/* 1071 */     Object v = get(key);
/* 1072 */     if ((v != null) && (v.equals(entry.getValue()))) {
/* 1073 */       remove(key);
/* 1074 */       return true;
/*      */     }
/*      */ 
/* 1077 */     return false;
/*      */   }
/*      */ 
/*      */   public Enumeration keys()
/*      */   {
/* 1090 */     return new KeyIterator();
/*      */   }
/*      */ 
/*      */   public Enumeration elements()
/*      */   {
/* 1106 */     return new ValueIterator();
/*      */   }
/*      */ 
/*      */   private synchronized void writeObject(ObjectOutputStream s)
/*      */     throws IOException
/*      */   {
/* 1302 */     s.defaultWriteObject();
/*      */ 
/* 1305 */     s.writeInt(this.table.length);
/*      */ 
/* 1308 */     s.writeInt(this.count);
/*      */ 
/* 1311 */     for (int index = this.table.length - 1; index >= 0; index--) {
/* 1312 */       Entry entry = this.table[index];
/*      */ 
/* 1314 */       while (entry != null) {
/* 1315 */         s.writeObject(entry.key);
/* 1316 */         s.writeObject(entry.value);
/* 1317 */         entry = entry.next;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private synchronized void readObject(ObjectInputStream s)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/* 1330 */     s.defaultReadObject();
/*      */ 
/* 1333 */     int numBuckets = s.readInt();
/* 1334 */     this.table = new Entry[numBuckets];
/*      */ 
/* 1337 */     int size = s.readInt();
/*      */ 
/* 1340 */     for (int i = 0; i < size; i++) {
/* 1341 */       Object key = s.readObject();
/* 1342 */       Object value = s.readObject();
/* 1343 */       put(key, value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized int capacity()
/*      */   {
/* 1352 */     return this.table.length;
/*      */   }
/*      */ 
/*      */   public float loadFactor()
/*      */   {
/* 1359 */     return this.loadFactor;
/*      */   }
/*      */ 
/*      */   protected static class BarrierLock
/*      */     implements Serializable
/*      */   {
/*      */   }
/*      */ 
/*      */   protected static class Entry
/*      */     implements Map.Entry
/*      */   {
/*      */     protected final int hash;
/*      */     protected final Object key;
/*      */     protected final Entry next;
/*      */     protected volatile Object value;
/*      */ 
/*      */     Entry(int hash, Object key, Object value, Entry next)
/*      */     {
/* 1129 */       this.hash = hash;
/* 1130 */       this.key = key;
/* 1131 */       this.next = next;
/* 1132 */       this.value = value;
/*      */     }
/*      */ 
/*      */     public Object getKey()
/*      */     {
/* 1138 */       return this.key;
/*      */     }
/*      */ 
/*      */     public Object getValue()
/*      */     {
/* 1154 */       return this.value;
/*      */     }
/*      */ 
/*      */     public Object setValue(Object value)
/*      */     {
/* 1179 */       if (value == null)
/* 1180 */         throw new NullPointerException();
/* 1181 */       Object oldValue = this.value;
/* 1182 */       this.value = value;
/* 1183 */       return oldValue;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object o) {
/* 1187 */       if (!(o instanceof Map.Entry))
/* 1188 */         return false;
/* 1189 */       Map.Entry e = (Map.Entry)o;
/* 1190 */       return (this.key.equals(e.getKey())) && (this.value.equals(e.getValue()));
/*      */     }
/*      */ 
/*      */     public int hashCode() {
/* 1194 */       return this.key.hashCode() ^ this.value.hashCode();
/*      */     }
/*      */ 
/*      */     public String toString() {
/* 1198 */       return this.key + "=" + this.value;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class EntrySet extends AbstractSet
/*      */   {
/*      */     private EntrySet()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/* 1016 */       return new ConcurrentReaderHashMap.HashIterator(ConcurrentReaderHashMap.this);
/*      */     }
/*      */     public boolean contains(Object o) {
/* 1019 */       if (!(o instanceof Map.Entry))
/* 1020 */         return false;
/* 1021 */       Map.Entry entry = (Map.Entry)o;
/* 1022 */       Object v = ConcurrentReaderHashMap.this.get(entry.getKey());
/* 1023 */       return (v != null) && (v.equals(entry.getValue()));
/*      */     }
/*      */     public boolean remove(Object o) {
/* 1026 */       if (!(o instanceof Map.Entry))
/* 1027 */         return false;
/* 1028 */       return ConcurrentReaderHashMap.this.findAndRemoveEntry((Map.Entry)o);
/*      */     }
/*      */     public int size() {
/* 1031 */       return ConcurrentReaderHashMap.this.size();
/*      */     }
/*      */     public void clear() {
/* 1034 */       ConcurrentReaderHashMap.this.clear();
/*      */     }
/*      */ 
/*      */     public Object[] toArray() {
/* 1038 */       Collection c = new ArrayList();
/* 1039 */       Object o = null;
/* 1040 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/* 1042 */         o = i.next();
/* 1043 */         if (o == null)
/*      */           continue;
/* 1045 */         c.add(o);
/*      */       }
/*      */ 
/* 1048 */       return c.toArray();
/*      */     }
/*      */ 
/*      */     public Object[] toArray(Object[] a) {
/* 1052 */       Collection c = new ArrayList();
/* 1053 */       Object o = null;
/* 1054 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/* 1056 */         o = i.next();
/* 1057 */         if (o == null)
/*      */           continue;
/* 1059 */         c.add(o);
/*      */       }
/*      */ 
/* 1062 */       return c.toArray(a);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class HashIterator
/*      */     implements Iterator, Enumeration
/*      */   {
/* 1212 */     protected final ConcurrentReaderHashMap.Entry[] tab = ConcurrentReaderHashMap.this.getTableForReading();
/* 1213 */     protected int index = this.tab.length - 1;
/*      */ 
/* 1206 */     protected ConcurrentReaderHashMap.Entry entry = null;
/*      */     protected Object currentKey;
/*      */     protected Object currentValue;
/* 1209 */     protected ConcurrentReaderHashMap.Entry lastReturned = null;
/*      */ 
/*      */     protected HashIterator()
/*      */     {
/*      */     }
/*      */ 
/*      */     public boolean hasMoreElements() {
/* 1216 */       return hasNext(); } 
/* 1217 */     public Object nextElement() { return next();
/*      */     }
/*      */ 
/*      */     public boolean hasNext()
/*      */     {
/*      */       do
/*      */       {
/* 1231 */         if (this.entry != null) {
/* 1232 */           Object v = this.entry.value;
/* 1233 */           if (v != null) {
/* 1234 */             this.currentKey = this.entry.key;
/* 1235 */             this.currentValue = v;
/* 1236 */             return true;
/*      */           }
/*      */ 
/* 1239 */           this.entry = this.entry.next;
/*      */         }
/*      */ 
/* 1242 */         while ((this.entry == null) && (this.index >= 0))
/* 1243 */           this.entry = this.tab[(this.index--)];
/*      */       }
/* 1245 */       while (this.entry != null);
/* 1246 */       this.currentKey = (this.currentValue = null);
/* 1247 */       return false;
/*      */     }
/*      */ 
/*      */     protected Object returnValueOfNext()
/*      */     {
/* 1252 */       return this.entry;
/*      */     }
/*      */     public Object next() {
/* 1255 */       if ((this.currentKey == null) && (!hasNext())) {
/* 1256 */         throw new NoSuchElementException();
/*      */       }
/* 1258 */       Object result = returnValueOfNext();
/* 1259 */       this.lastReturned = this.entry;
/* 1260 */       this.currentKey = (this.currentValue = null);
/* 1261 */       this.entry = this.entry.next;
/* 1262 */       return result;
/*      */     }
/*      */ 
/*      */     public void remove() {
/* 1266 */       if (this.lastReturned == null)
/* 1267 */         throw new IllegalStateException();
/* 1268 */       ConcurrentReaderHashMap.this.remove(this.lastReturned.key);
/* 1269 */       this.lastReturned = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class KeyIterator extends ConcurrentReaderHashMap.HashIterator {
/*      */     protected KeyIterator() {
/* 1275 */       super(); } 
/* 1276 */     protected Object returnValueOfNext() { return this.currentKey;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class KeySet extends AbstractSet
/*      */   {
/*      */     private KeySet()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/*  891 */       return new ConcurrentReaderHashMap.KeyIterator(ConcurrentReaderHashMap.this);
/*      */     }
/*      */     public int size() {
/*  894 */       return ConcurrentReaderHashMap.this.size();
/*      */     }
/*      */     public boolean contains(Object o) {
/*  897 */       return ConcurrentReaderHashMap.this.containsKey(o);
/*      */     }
/*      */     public boolean remove(Object o) {
/*  900 */       return ConcurrentReaderHashMap.this.remove(o) != null;
/*      */     }
/*      */     public void clear() {
/*  903 */       ConcurrentReaderHashMap.this.clear();
/*      */     }
/*      */ 
/*      */     public Object[] toArray() {
/*  907 */       Collection c = new ArrayList();
/*  908 */       Object o = null;
/*  909 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  911 */         o = i.next();
/*  912 */         if (o == null)
/*      */           continue;
/*  914 */         c.add(o);
/*      */       }
/*      */ 
/*  917 */       return c.toArray();
/*      */     }
/*      */ 
/*      */     public Object[] toArray(Object[] a) {
/*  921 */       Collection c = new ArrayList();
/*  922 */       Object o = null;
/*  923 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  925 */         o = i.next();
/*  926 */         if (o == null)
/*      */           continue;
/*  928 */         c.add(o);
/*      */       }
/*      */ 
/*  931 */       return c.toArray(a);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class ValueIterator extends ConcurrentReaderHashMap.HashIterator
/*      */   {
/*      */     protected ValueIterator()
/*      */     {
/* 1279 */       super(); } 
/* 1280 */     protected Object returnValueOfNext() { return this.currentValue;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class Values extends AbstractCollection
/*      */   {
/*      */     private Values()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/*  954 */       return new ConcurrentReaderHashMap.ValueIterator(ConcurrentReaderHashMap.this);
/*      */     }
/*      */     public int size() {
/*  957 */       return ConcurrentReaderHashMap.this.size();
/*      */     }
/*      */     public boolean contains(Object o) {
/*  960 */       return ConcurrentReaderHashMap.this.containsValue(o);
/*      */     }
/*      */     public void clear() {
/*  963 */       ConcurrentReaderHashMap.this.clear();
/*      */     }
/*      */ 
/*      */     public Object[] toArray() {
/*  967 */       Collection c = new ArrayList();
/*  968 */       Object o = null;
/*  969 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  971 */         o = i.next();
/*  972 */         if (o == null)
/*      */           continue;
/*  974 */         c.add(o);
/*      */       }
/*      */ 
/*  977 */       return c.toArray();
/*      */     }
/*      */ 
/*      */     public Object[] toArray(Object[] a) {
/*  981 */       Collection c = new ArrayList();
/*  982 */       Object o = null;
/*  983 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  985 */         o = i.next();
/*  986 */         if (o == null)
/*      */           continue;
/*  988 */         c.add(o);
/*      */       }
/*      */ 
/*  991 */       return c.toArray(a);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap
 * JD-Core Version:    0.6.0
 */