/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.util.Comparator;
/*     */ 
/*     */ public class BoundedPriorityQueue extends SemaphoreControlledChannel
/*     */ {
/*     */   protected final Heap heap_;
/*     */ 
/*     */   public BoundedPriorityQueue(int capacity, Comparator cmp)
/*     */     throws IllegalArgumentException
/*     */   {
/*  55 */     super(capacity);
/*  56 */     this.heap_ = new Heap(capacity, cmp);
/*     */   }
/*     */ 
/*     */   public BoundedPriorityQueue(Comparator comparator)
/*     */   {
/*  65 */     this(DefaultChannelCapacity.get(), comparator);
/*     */   }
/*     */ 
/*     */   public BoundedPriorityQueue(int capacity)
/*     */   {
/*  74 */     this(capacity, null);
/*     */   }
/*     */ 
/*     */   public BoundedPriorityQueue()
/*     */   {
/*  83 */     this(DefaultChannelCapacity.get(), null);
/*     */   }
/*     */ 
/*     */   public BoundedPriorityQueue(int capacity, Comparator cmp, Class semaphoreClass)
/*     */     throws IllegalArgumentException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException
/*     */   {
/* 109 */     super(capacity, semaphoreClass);
/* 110 */     this.heap_ = new Heap(capacity, cmp);
/*     */   }
/*     */   protected void insert(Object x) {
/* 113 */     this.heap_.insert(x); } 
/* 114 */   protected Object extract() { return this.heap_.extract(); } 
/* 115 */   public Object peek() { return this.heap_.peek();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue
 * JD-Core Version:    0.6.0
 */