/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class BoundedLinkedQueue
/*     */   implements BoundedChannel
/*     */ {
/*     */   protected LinkedNode head_;
/*     */   protected LinkedNode last_;
/*  74 */   protected final Object putGuard_ = new Object();
/*     */ 
/*  80 */   protected final Object takeGuard_ = new Object();
/*     */   protected int capacity_;
/*     */   protected int putSidePutPermits_;
/* 104 */   protected int takeSidePutPermits_ = 0;
/*     */ 
/*     */   public BoundedLinkedQueue(int capacity)
/*     */   {
/* 112 */     if (capacity <= 0) throw new IllegalArgumentException();
/* 113 */     this.capacity_ = capacity;
/* 114 */     this.putSidePutPermits_ = capacity;
/* 115 */     this.head_ = new LinkedNode(null);
/* 116 */     this.last_ = this.head_;
/*     */   }
/*     */ 
/*     */   public BoundedLinkedQueue()
/*     */   {
/* 124 */     this(DefaultChannelCapacity.get());
/*     */   }
/*     */ 
/*     */   protected final int reconcilePutPermits()
/*     */   {
/* 133 */     this.putSidePutPermits_ += this.takeSidePutPermits_;
/* 134 */     this.takeSidePutPermits_ = 0;
/* 135 */     return this.putSidePutPermits_;
/*     */   }
/*     */ 
/*     */   public synchronized int capacity()
/*     */   {
/* 140 */     return this.capacity_;
/*     */   }
/*     */ 
/*     */   public synchronized int size()
/*     */   {
/* 157 */     return this.capacity_ - (this.takeSidePutPermits_ + this.putSidePutPermits_);
/*     */   }
/*     */ 
/*     */   public void setCapacity(int newCapacity)
/*     */   {
/* 171 */     if (newCapacity <= 0) throw new IllegalArgumentException();
/* 172 */     synchronized (this.putGuard_) {
/* 173 */       synchronized (this) {
/* 174 */         this.takeSidePutPermits_ += newCapacity - this.capacity_;
/* 175 */         this.capacity_ = newCapacity;
/*     */ 
/* 178 */         reconcilePutPermits();
/* 179 */         notifyAll();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized Object extract()
/*     */   {
/* 187 */     synchronized (this.head_) {
/* 188 */       Object x = null;
/* 189 */       LinkedNode first = this.head_.next;
/* 190 */       if (first != null) {
/* 191 */         x = first.value;
/* 192 */         first.value = null;
/* 193 */         this.head_ = first;
/* 194 */         this.takeSidePutPermits_ += 1;
/* 195 */         notify();
/*     */       }
/* 197 */       return x;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object peek() {
/* 202 */     synchronized (this.head_) {
/* 203 */       LinkedNode first = this.head_.next;
/* 204 */       if (first != null) {
/* 205 */         return first.value;
/*     */       }
/* 207 */       return null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object take() throws InterruptedException {
/* 212 */     if (Thread.interrupted()) throw new InterruptedException();
/* 213 */     Object x = extract();
/* 214 */     if (x != null) {
/* 215 */       return x;
/*     */     }
/* 217 */     synchronized (this.takeGuard_) {
/*     */       try {
/*     */         while (true) {
/* 220 */           x = extract();
/* 221 */           if (x != null) {
/* 222 */             return x;
/*     */           }
/*     */ 
/* 225 */           this.takeGuard_.wait();
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 230 */         this.takeGuard_.notify();
/* 231 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs) throws InterruptedException
/*     */   {
/* 238 */     if (Thread.interrupted()) throw new InterruptedException();
/* 239 */     Object x = extract();
/* 240 */     if (x != null) {
/* 241 */       return x;
/*     */     }
/* 243 */     synchronized (this.takeGuard_) {
/*     */       try {
/* 245 */         long waitTime = msecs;
/* 246 */         long start = msecs <= 0L ? 0L : System.currentTimeMillis();
/*     */         while (true) {
/* 248 */           x = extract();
/* 249 */           if ((x != null) || (waitTime <= 0L)) {
/* 250 */             return x;
/*     */           }
/*     */ 
/* 253 */           this.takeGuard_.wait(waitTime);
/* 254 */           waitTime = msecs - (System.currentTimeMillis() - start);
/*     */         }
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/* 259 */         this.takeGuard_.notify();
/* 260 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final void allowTake()
/*     */   {
/* 268 */     synchronized (this.takeGuard_) {
/* 269 */       this.takeGuard_.notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void insert(Object x)
/*     */   {
/* 279 */     this.putSidePutPermits_ -= 1;
/* 280 */     LinkedNode p = new LinkedNode(x);
/* 281 */     synchronized (this.last_) {
/* 282 */       this.last_.next = p;
/* 283 */       this.last_ = p;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(Object x)
/*     */     throws InterruptedException
/*     */   {
/* 293 */     if (x == null) throw new IllegalArgumentException();
/* 294 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 296 */     synchronized (this.putGuard_)
/*     */     {
/* 298 */       if (this.putSidePutPermits_ <= 0) {
/* 299 */         synchronized (this) {
/* 300 */           if (reconcilePutPermits() <= 0) {
/*     */             try {
/*     */               do
/* 303 */                 wait();
/* 304 */               while (reconcilePutPermits() <= 0);
/*     */             }
/*     */             catch (InterruptedException ex)
/*     */             {
/* 310 */               notify();
/* 311 */               throw ex;
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 316 */       insert(x);
/*     */     }
/*     */ 
/* 319 */     allowTake();
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs) throws InterruptedException {
/* 323 */     if (x == null) throw new IllegalArgumentException();
/* 324 */     if (Thread.interrupted()) throw new InterruptedException();
/*     */ 
/* 326 */     synchronized (this.putGuard_)
/*     */     {
/* 328 */       if (this.putSidePutPermits_ <= 0) {
/* 329 */         synchronized (this) {
/* 330 */           if (reconcilePutPermits() <= 0) {
/* 331 */             if (msecs <= 0L)
/* 332 */               return false;
/*     */             try
/*     */             {
/* 335 */               long waitTime = msecs;
/* 336 */               long start = System.currentTimeMillis();
/*     */               while (true)
/*     */               {
/* 339 */                 wait(waitTime);
/* 340 */                 if (reconcilePutPermits() > 0)
/*     */                 {
/*     */                   break;
/*     */                 }
/* 344 */                 waitTime = msecs - (System.currentTimeMillis() - start);
/* 345 */                 if (waitTime <= 0L) {
/* 346 */                   return false;
/*     */                 }
/*     */               }
/*     */             }
/*     */             catch (InterruptedException ex)
/*     */             {
/* 352 */               notify();
/* 353 */               throw ex;
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 360 */       insert(x);
/*     */     }
/*     */ 
/* 363 */     allowTake();
/* 364 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty() {
/* 368 */     synchronized (this.head_) {
/* 369 */       return this.head_.next == null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue
 * JD-Core Version:    0.6.0
 */