/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.util.JBossStringBuilder;

public class RequirementDependencyItem
extends AbstractDependencyItem {
    private Module module;
    private Requirement requirement;

    public RequirementDependencyItem(Module module, Requirement requirement, ControllerState state) {
        super((Object)(module != null ? module.getContextName() : null), null, state, ControllerState.INSTALLED);
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (requirement == null) {
            throw new IllegalArgumentException("Null requirement");
        }
        this.module = module;
        this.requirement = requirement;
    }

    public Module getModule() {
        return this.module;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public boolean resolve(Controller controller) {
        Requirement requirement = this.getRequirement();
        Module module = this.getModule().resolveModule(this, true);
        if (module != null) {
            String iDependOn = module.getContextName();
            ControllerContext context = controller.getContext((Object)iDependOn, this.getDependentState());
            if (context != null) {
                this.setIDependOn(context.getName());
                this.addDependsOnMe(controller, context);
                this.setResolved(true);
            } else {
                this.setResolved(false);
            }
        } else if (requirement.isOptional() || requirement.isDynamic()) {
            this.setResolved(true);
        }
        return this.isResolved();
    }

    public boolean unresolved(Controller controller) {
        this.setIDependOn(null);
        this.setResolved(false);
        return true;
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" requirement=").append((Object)this.getRequirement());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName()).append(" ").append((Object)this.getRequirement());
    }

    public String toHumanReadableString() {
        return this.getRequirement().toString();
    }
}

