/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.aspects.currentinvocation;

import java.io.Serializable;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;

/**
 * CurrentInvocationInterceptor
 * 
 * Associates the current invocation with the running
 * Thread for retrieval by any component within 
 * the same request context.  Clears the association 
 * at the end of the Interceptor chain for safe return to 
 * a potential Thread pool.
 * 
 * @see CurrentInvocation
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public class CurrentInvocationInterceptor implements Interceptor, Serializable
{
   // -------------------------------------------------------------------------------------------------||
   // Class Members -----------------------------------------------------------------------------------||
   // -------------------------------------------------------------------------------------------------||

   private static final long serialVersionUID = 1L;

   // -------------------------------------------------------------------------------------------------||
   // Required Implementations ------------------------------------------------------------------------||
   // -------------------------------------------------------------------------------------------------||

   public String getName()
   {
      return CurrentInvocationInterceptor.class.getSimpleName();
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      try
      {
         // Place the Invocation in Request scope
         CurrentInvocation.registerInvocation(invocation);

         // Carry on 
         return invocation.invokeNext();
      }
      finally
      {
         // Clean up from this invocation
         CurrentInvocation.deregisterCurrentInvocation();
      }
   }
}
