/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;

public abstract class ThreadPoolReadAttributeHandler
extends AbstractRuntimeOnlyHandler {
    private ParametersValidator validator = new ParametersValidator();
    private final List<String> metrics;

    public ThreadPoolReadAttributeHandler(List<String> metrics) {
        this.metrics = metrics;
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        for (String metric : this.metrics) {
            registration.registerMetric(metric, (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        String attributeName = operation.require("name").asString();
        ServiceController<?> serviceController = this.getService(context, operation);
        Service service = serviceController.getService();
        this.setResult(context, attributeName, service);
        context.completeStep();
    }

    protected abstract void setResult(OperationContext var1, String var2, Service<?> var3) throws OperationFailedException;

    protected ServiceController<?> getService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ServiceController controller = context.getServiceRegistry(true).getService(ThreadsServices.executorName(name));
        if (controller == null) {
            throw new OperationFailedException(new ModelNode().set("Failed to locate executor service " + ThreadsServices.executorName(name)));
        }
        return controller;
    }
}

