/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.as.threads.QueuelessThreadPoolService;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class QueuelessThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    public static final QueuelessThreadPoolWriteAttributeHandler INSTANCE = new QueuelessThreadPoolWriteAttributeHandler();

    private QueuelessThreadPoolWriteAttributeHandler() {
        super(QueuelessThreadPoolAdd.ATTRIBUTES, QueuelessThreadPoolAdd.RW_ATTRIBUTES);
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode operation, String attributeName, ServiceController<?> service) {
        block11: {
            QueuelessThreadPoolService pool = (QueuelessThreadPoolService)service.getService();
            try {
                ModelNode value = operation.require("value");
                if ("keepalive-time".equals(attributeName)) {
                    TimeUnit unit;
                    if (!value.hasDefined("time")) {
                        throw new IllegalArgumentException("Missing 'time' for 'keepalive-time'");
                    }
                    if (!value.hasDefined("unit")) {
                        unit = pool.getKeepAliveUnit();
                    } else {
                        try {
                            unit = Enum.valueOf(TimeUnit.class, value.get("unit").asString());
                        }
                        catch (IllegalArgumentException e) {
                            throw new OperationFailedException(new ModelNode().set("Failed to parse 'unit', allowed values are: " + Arrays.asList(TimeUnit.values())));
                        }
                    }
                    TimeSpec spec = new TimeSpec(unit, value.get("time").asLong());
                    pool.setKeepAlive(spec);
                    break block11;
                }
                if ("max-threads".equals(attributeName)) {
                    pool.setMaxThreads(this.getScaledCount("max-threads", value));
                    break block11;
                }
                if ("blocking".equals(attributeName)) {
                    pool.setBlocking(value.asBoolean());
                    break block11;
                }
                throw new IllegalArgumentException("Unexpected attribute '" + attributeName + "'");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected int getScaledCount(String attributeName, ModelNode value) {
        BigDecimal perCpu;
        BigDecimal count;
        if (!value.hasDefined("count")) {
            throw new IllegalArgumentException("Missing 'count' for '" + attributeName + "'");
        }
        if (!value.hasDefined("per-cpu")) {
            throw new IllegalArgumentException("Missing 'per-cpu' for '" + attributeName + "'");
        }
        try {
            count = value.get("count").asBigDecimal();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse 'count' as java.math.BigDecimal", e);
        }
        try {
            perCpu = value.get("per-cpu").asBigDecimal();
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse 'per-cpu' as java.math.BigDecimal", e);
        }
        return new ScaledCount(count, perCpu).getScaledCount();
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = ThreadsServices.executorName(name);
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller == null) {
            throw new OperationFailedException(new ModelNode().set("Service " + serviceName + " not found."));
        }
        return controller;
    }
}

