/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PropagatingCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.threads.Attribute;
import org.jboss.as.threads.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public interface PoolAttributeDefinitions {
    public static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinition("name", ModelType.STRING, true);
    public static final SimpleAttributeDefinition THREAD_FACTORY = new SimpleAttributeDefinition("thread-factory", ModelType.STRING, true);
    public static final ListAttributeDefinition PROPERTIES = new ListAttributeDefinition("properties", true, (ParameterValidator)new ModelTypeValidator(ModelType.PROPERTY)){

        protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
            this.setValueType(node);
        }

        protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            this.setValueType(node);
        }

        protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
            this.setValueType(node);
        }

        private void setValueType(ModelNode node) {
            node.get("value-type").set(ModelType.PROPERTY);
        }

        public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
            List list;
            if (resourceModel.hasDefined(this.getName()) && (list = resourceModel.get(this.getName()).asList()).size() > 0) {
                writer.writeStartElement(Element.PROPERTIES.getLocalName());
                for (ModelNode child : list) {
                    Property prop = child.asProperty();
                    writer.writeEmptyElement(Element.PROPERTY.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                    writer.writeAttribute(Attribute.VALUE.getLocalName(), prop.getValue().asString());
                }
            }
        }
    };
    public static final SimpleAttributeDefinition MAX_THREADS = new SimpleAttributeDefinition("max-threads", ModelType.OBJECT, false);
    public static final SimpleAttributeDefinition KEEPALIVE_TIME = new SimpleAttributeDefinition("keepalive-time", ModelType.OBJECT, true, (ParameterCorrector)PropagatingCorrector.INSTANCE, new ParameterValidator(){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if (value.getType() == ModelType.UNDEFINED) {
                return;
            }
            if (value.getType() != ModelType.OBJECT) {
                throw new IllegalArgumentException("Attribute " + parameterName + " expects values of type OBJECT but got " + value + " of type " + value.getType());
            }
            Set keys = value.keys();
            if (keys.size() != 2) {
                throw new IllegalArgumentException("Attribute " + parameterName + " expects values consisting of '" + "time" + "' and '" + "unit" + "' but the new value consists of " + keys);
            }
            if (!keys.contains("time")) {
                throw new IllegalArgumentException("Missing 'time' for '" + parameterName + "'");
            }
            if (!keys.contains("unit")) {
                throw new IllegalArgumentException("Missing 'unit' for '" + parameterName + "'");
            }
        }

        public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
            this.validateParameter(parameterName, value);
        }
    });
    public static final SimpleAttributeDefinition CORE_THREADS = new SimpleAttributeDefinition("core-threads", ModelType.OBJECT, true);
    public static final SimpleAttributeDefinition HANDOFF_EXECUTOR = new SimpleAttributeDefinition("handoff-executor", ModelType.STRING, true);
    public static final SimpleAttributeDefinition QUEUE_LENGTH = new SimpleAttributeDefinition("queue-length", ModelType.OBJECT, false);
    public static final SimpleAttributeDefinition BLOCKING = new SimpleAttributeDefinition("blocking", ModelType.BOOLEAN, true);
    public static final SimpleAttributeDefinition ALLOW_CORE_TIMEOUT = new SimpleAttributeDefinition("allow-core-timeout", ModelType.BOOLEAN, true);
    public static final SimpleAttributeDefinition GROUP_NAME = new SimpleAttributeDefinition("group-name", ModelType.STRING, true);
    public static final SimpleAttributeDefinition THREAD_NAME_PATTERN = new SimpleAttributeDefinition("thread-name-pattern", ModelType.STRING, true);
    public static final SimpleAttributeDefinition PRIORITY = new SimpleAttributeDefinition("priority", "priority", new ModelNode().set(-1), ModelType.INT, true, true, MeasurementUnit.NONE, (ParameterValidator)new IntRangeValidator(-1, 10, true, true));
    public static final AttributeDefinition[] THREAD_FACTORY_ATTRIBUTES = new AttributeDefinition[]{NAME, PROPERTIES, GROUP_NAME, THREAD_NAME_PATTERN, PRIORITY};
}

