/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class RemoteDestinationOutboundSocketBindingAddHandler
extends AbstractAddStepHandler {
    static final RemoteDestinationOutboundSocketBindingAddHandler INSTANCE = new RemoteDestinationOutboundSocketBindingAddHandler();

    public static ModelNode getOperation(ModelNode address, ModelNode remoteDestinationOutboundSocketBinding) {
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        addOperation.get("address").set(address);
        addOperation.get("host").set(remoteDestinationOutboundSocketBinding.get("host"));
        addOperation.get("port").set(remoteDestinationOutboundSocketBinding.get("port"));
        if (remoteDestinationOutboundSocketBinding.get("source-interface").isDefined()) {
            addOperation.get("source-interface").set(remoteDestinationOutboundSocketBinding.get("source-interface"));
        }
        if (remoteDestinationOutboundSocketBinding.get("source-port").isDefined()) {
            addOperation.get("source-port").set(remoteDestinationOutboundSocketBinding.get("source-port"));
        }
        if (remoteDestinationOutboundSocketBinding.get("fixed-source-port").isDefined()) {
            addOperation.get("fixed-source-port").set(remoteDestinationOutboundSocketBinding.get("fixed-source-port"));
        }
        return addOperation;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.get("host").set(operation.get("host"));
        model.get("port").set(operation.get("port"));
        if (operation.hasDefined("source-interface")) {
            model.get("source-interface").set(operation.get("source-interface"));
        }
        if (operation.hasDefined("source-port")) {
            model.get("source-port").set(operation.get("source-port"));
        }
        if (operation.hasDefined("fixed-source-port")) {
            model.get("fixed-source-port").set(operation.get("fixed-source-port"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ServiceController<OutboundSocketBinding> outboundSocketBindingServiceController;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String outboundSocketName = address.getLastElement().getValue();
        try {
            outboundSocketBindingServiceController = RemoteDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, model, outboundSocketName);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        serviceControllers.add(outboundSocketBindingServiceController);
    }

    public static ServiceController<OutboundSocketBinding> installOutboundSocketBindingService(OperationContext context, ModelNode model, String outboundSocketName) throws OperationFailedException, UnknownHostException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        String destinationHost = RemoteDestinationOutboundSocketBindingResourceDefinition.HOST.resolveModelAttribute(context, model).asString();
        int destinationPort = RemoteDestinationOutboundSocketBindingResourceDefinition.PORT.resolveModelAttribute(context, model).asInt();
        ModelNode sourceInterfaceModelNode = OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.resolveModelAttribute(context, model);
        String sourceInterfaceName = sourceInterfaceModelNode.isDefined() ? sourceInterfaceModelNode.asString() : null;
        ModelNode sourcePortModelNode = OutboundSocketBindingResourceDefinition.SOURCE_PORT.resolveModelAttribute(context, model);
        Integer sourcePort = sourcePortModelNode.isDefined() ? Integer.valueOf(sourcePortModelNode.asInt()) : null;
        ModelNode fixedSourcePortModelNode = OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.resolveModelAttribute(context, model);
        boolean fixedSourcePort = fixedSourcePortModelNode.isDefined() ? fixedSourcePortModelNode.asBoolean() : false;
        RemoteDestinationOutboundSocketBindingService outboundSocketBindingService = new RemoteDestinationOutboundSocketBindingService(outboundSocketName, destinationHost, destinationPort, sourcePort, fixedSourcePort);
        ServiceBuilder serviceBuilder = serviceTarget.addService(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketName}), (Service)outboundSocketBindingService);
        if (sourceInterfaceName != null) {
            serviceBuilder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{sourceInterfaceName}), NetworkInterfaceBinding.class, outboundSocketBindingService.getSourceNetworkInterfaceBindingInjector());
        }
        serviceBuilder.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, outboundSocketBindingService.getSocketBindingManagerInjector());
        return serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

