/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentFullReplaceHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    protected final ContentRepository contentRepository;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();
    private final AbstractVaultReader vaultReader;

    protected DeploymentFullReplaceHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                AbstractDeploymentHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
        this.vaultReader = vaultReader;
    }

    public static DeploymentFullReplaceHandler createForStandalone(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentFullReplaceHandler(contentRepository, vaultReader);
    }

    public static DeploymentFullReplaceHandler createForDomainServer(ContentRepository contentRepository, DeploymentFileRepository remoteFileRepository, AbstractVaultReader vaultReader) {
        return new DomainServerDeploymentFullReplaceHandler(contentRepository, remoteFileRepository, vaultReader);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation((Locale)locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)});
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        boolean exists = root.hasChild(PathElement.pathElement((String)"deployment", (String)name));
        if (!exists) {
            ServerMessages.MESSAGES.noSuchDeployment(name);
        }
        ModelNode replaceNode = context.readResourceForUpdate(address).getModel();
        String replacedRuntimeName = replaceNode.require("runtime-name").asString();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : replacedRuntimeName;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            byte[] hash = contentItemNode.require("hash").asBytes();
            contentItem = this.addFromHash(hash);
        } else {
            contentItem = AbstractDeploymentHandler.hasValidContentAdditionParameterDefined(contentItemNode) ? this.addFromContentAdditionParameter(context, contentItemNode) : this.addUnmanaged(contentItemNode);
        }
        boolean start = replaceNode.get("enabled").asBoolean();
        byte[] originalHash = replaceNode.get("content").get(0).hasDefined("hash") ? replaceNode.get("content").get(0).get("hash").asBytes() : null;
        ModelNode deployNode = context.readResourceForUpdate(address).getModel();
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("content").set(content);
        deployNode.get("enabled").set(start);
        DeploymentFullReplaceHandler.removeContentAdditions(deployNode.require("content"));
        if (start) {
            DeploymentHandlerUtil.replace(context, replaceNode, runtimeName, name, replacedRuntimeName, this.vaultReader, contentItem);
        }
        if (context.completeStep() == OperationContext.ResultAction.KEEP) {
            byte[] newHash;
            if (originalHash != null && replaceNode.get("content").get(0).hasDefined("hash") && !Arrays.equals(originalHash, newHash = replaceNode.get("content").get(0).get("hash").asBytes())) {
                this.contentRepository.removeContent(originalHash);
            }
        } else if (replaceNode.get("content").get(0).hasDefined("hash")) {
            byte[] newHash = replaceNode.get("content").get(0).get("hash").asBytes();
            this.contentRepository.removeContent(newHash);
        }
    }

    private static void removeAttributes(ModelNode node, Iterable<String> attributeNames) {
        for (String attributeName : attributeNames) {
            node.remove(attributeName);
        }
    }

    private static void removeContentAdditions(ModelNode content) {
        for (ModelNode contentItem : content.asList()) {
            DeploymentFullReplaceHandler.removeAttributes(contentItem, AbstractDeploymentHandler.CONTENT_ADDITION_PARAMETERS);
        }
    }

    DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash) throws OperationFailedException {
        if (!this.contentRepository.hasContent(hash)) {
            throw ServerMessages.MESSAGES.noSuchDeploymentContent(HashUtil.bytesToHexString((byte[])hash));
        }
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = AbstractDeploymentHandler.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw AbstractDeploymentHandler.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        contentItemNode.clear();
        contentItemNode.get("hash").set(hash);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(ModelNode contentItemNode) throws OperationFailedException {
        this.unmanagedContentValidator.validate(contentItemNode);
        String path = contentItemNode.require("path").asString();
        String relativeTo = AbstractDeploymentHandler.asString(contentItemNode, "relative-to");
        boolean archive = contentItemNode.require("archive").asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }

    private static class DomainServerDeploymentFullReplaceHandler
    extends DeploymentFullReplaceHandler {
        final DeploymentFileRepository remoteFileRepository;

        DomainServerDeploymentFullReplaceHandler(ContentRepository contentRepository, DeploymentFileRepository remoteFileRepository, AbstractVaultReader vaultReader) {
            super(contentRepository, vaultReader);
            assert (remoteFileRepository != null) : "Null remoteFileRepository";
            this.remoteFileRepository = remoteFileRepository;
        }

        @Override
        DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash) throws OperationFailedException {
            this.remoteFileRepository.getDeploymentFiles(hash);
            return super.addFromHash(hash);
        }

        @Override
        DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
            throw ServerMessages.MESSAGES.onlyHashAllowedForDeploymentFullReplaceInDomainServer(contentItemNode);
        }
    }
}

