/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class InvokeMBeanRaw
extends AbstractRuntimeOnlyHandler {
    private static final String NOTIFICATION_FILE = "notification-file";
    private static final String MBEAN_NAME = "mbean-name";
    private static final String MBEAN_OPERATION_NAME = "mbean-operation-name";
    private static final String SIGNATURE = "signature";
    private static final String PARAMETERS = "parameters";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        Object result;
        block13: {
            ServiceController service = context.getServiceRegistry(false).getRequiredService(MBeanServerService.SERVICE_NAME);
            MBeanServer server = (MBeanServer)service.getValue();
            String name = operation.require(MBEAN_NAME).asString();
            String operationName = operation.require(MBEAN_OPERATION_NAME).asString();
            ArrayList<String> signatureList = new ArrayList<String>();
            if (operation.hasDefined(SIGNATURE)) {
                for (ModelNode node : operation.get(SIGNATURE).asList()) {
                    signatureList.add(node.asString());
                }
            }
            ArrayList<Object> parameterList = new ArrayList<Object>();
            if (operation.hasDefined(PARAMETERS)) {
                for (ModelNode node : operation.get(PARAMETERS).asList()) {
                    parameterList.add(InvokeMBeanRaw.getObject(node.asBytes()));
                }
            }
            File file = operation.hasDefined(NOTIFICATION_FILE) ? new File(operation.get(NOTIFICATION_FILE).asString()) : null;
            FileNotificationListener listener = null;
            ObjectName beanName = null;
            try {
                beanName = ObjectName.getInstance(name);
                boolean notifications = server.isInstanceOf(beanName, NotificationBroadcaster.class.getName());
                if (notifications && file != null && file.exists()) {
                    listener = new FileNotificationListener(file);
                    server.addNotificationListener(beanName, listener, null, null);
                }
                result = server.invoke(beanName, operationName, parameterList.toArray(), signatureList.toArray(new String[0]));
                if (listener == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw new OperationFailedException(e.getMessage(), (Throwable)e, new ModelNode().set(e.getMessage()));
                }
                catch (Throwable throwable) {
                    if (listener == null) throw throwable;
                    try {
                        server.removeNotificationListener(beanName, listener);
                        listener.done();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                server.removeNotificationListener(beanName, listener);
                listener.done();
            }
            catch (Exception e) {}
        }
        context.getResult().set(InvokeMBeanRaw.getBytes(result));
        context.completeStep();
    }

    private static Object getObject(byte[] bytes) throws OperationFailedException {
        try {
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    static byte[] getBytes(Object param) throws OperationFailedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(param);
            oos.flush();
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    private class FileNotificationListener
    implements NotificationListener {
        private ObjectOutputStream oos;

        public FileNotificationListener(File file) {
            try {
                this.oos = new ObjectOutputStream(new FileOutputStream(file));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            try {
                this.oos.writeObject(notification);
                this.oos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void done() {
            try {
                this.oos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

