/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.FileKeystoreService;
import org.jboss.as.domain.management.security.JaasCallbackHandler;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesSubjectSupplemental;
import org.jboss.as.domain.management.security.SSLIdentityService;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class SecurityRealmAddHandler
implements OperationStepHandler {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();
    public static final String OPERATION_NAME = "add";

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void installServices(OperationContext context, String realmName, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode authentication = model.hasDefined("authentication") ? model.get("authentication") : null;
        ModelNode authorization = model.hasDefined("authorization") ? model.get("authorization") : null;
        ModelNode serverIdentities = model.hasDefined("server-identity") ? model.get("server-identity") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        SecurityRealmService securityRealmService = new SecurityRealmService(realmName);
        ServiceName realmServiceName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName, (Service)securityRealmService);
        ServiceName authenticationName = null;
        ServiceName authorizationName = null;
        ModelNode authTruststore = null;
        if (authentication != null) {
            if (authentication.hasDefined("truststore")) {
                authTruststore = authentication.require("truststore");
            }
            if (authentication.hasDefined("jaas")) {
                authenticationName = this.addJaasService(authentication.require("jaas"), realmServiceName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("ldap")) {
                authenticationName = this.addLdapService(authentication.require("ldap"), realmServiceName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("properties")) {
                authenticationName = this.addPropertiesAuthenticationService(authentication.require("properties"), realmServiceName, realmName, serviceTarget, newControllers);
            } else if (authentication.hasDefined("users")) {
                authenticationName = this.addUsersService(context, authentication.require("users"), realmServiceName, realmName, serviceTarget, newControllers);
            }
        }
        if (authorization != null && authorization.hasDefined("properties")) {
            authorizationName = this.addPropertiesAuthorizationService(authorization.require("properties"), realmServiceName, realmName, serviceTarget, newControllers);
        }
        if (authenticationName != null) {
            realmBuilder.addDependency(authenticationName, DomainCallbackHandler.class, securityRealmService.getCallbackHandlerInjector());
        }
        if (authorizationName != null) {
            realmBuilder.addDependency(authorizationName, SubjectSupplemental.class, securityRealmService.getSubjectSupplementalInjector());
        }
        ModelNode ssl = null;
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ssl = serverIdentities.require("ssl");
            }
            if (serverIdentities.hasDefined("secret")) {
                ServiceName secretServiceName = this.addSecretService(context, serverIdentities.require("secret"), realmServiceName, serviceTarget, newControllers);
                realmBuilder.addDependency(secretServiceName, CallbackHandlerFactory.class, securityRealmService.getSecretCallbackFactory());
            }
        }
        if (ssl != null || authTruststore != null) {
            ServiceName sslServiceName = this.addSSLService(context, ssl, authTruststore, realmServiceName, serviceTarget, newControllers);
            realmBuilder.addDependency(sslServiceName, SSLIdentityService.class, securityRealmService.getSSLIdentityInjector());
        }
        realmBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        ServiceController sc = realmBuilder.install();
        if (newControllers != null) {
            newControllers.add(sc);
        }
    }

    private ServiceName addJaasService(ModelNode jaas, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName jaasServiceName = realmServiceName.append(new String[]{"jaas"});
        JaasCallbackHandler jaasCallbackHandler = new JaasCallbackHandler(jaas.get("name").asString());
        ServiceBuilder jaasBuilder = serviceTarget.addService(jaasServiceName, (Service)jaasCallbackHandler);
        newControllers.add(jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        return jaasServiceName;
    }

    private ServiceName addLdapService(ModelNode ldap, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName ldapServiceName = realmServiceName.append(new String[]{"ldap"});
        UserLdapCallbackHandler ldapCallbackHandler = new UserLdapCallbackHandler(ldap);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapServiceName, (Service)ldapCallbackHandler);
        String connectionManager = ldap.require("connection").asString();
        ldapBuilder.addDependency(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{connectionManager}), ConnectionManager.class, ldapCallbackHandler.getConnectionManagerInjector());
        ServiceController serviceController = ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return ldapServiceName;
    }

    private ServiceName addPropertiesAuthenticationService(ModelNode properties, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties_authentication"});
        PropertiesCallbackHandler propsCallbackHandler = new PropertiesCallbackHandler(realmName, properties);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsCallbackHandler);
        if (properties.hasDefined("relative-to")) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(properties.get("relative-to").asString()), String.class, propsCallbackHandler.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return propsServiceName;
    }

    private ServiceName addPropertiesAuthorizationService(ModelNode properties, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) {
        ServiceName propsServiceName = realmServiceName.append(new String[]{"properties_authorization"});
        PropertiesSubjectSupplemental propsSubjectSupplemental = new PropertiesSubjectSupplemental(properties);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsSubjectSupplemental);
        if (properties.hasDefined("relative-to")) {
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(properties.get("relative-to").asString()), String.class, propsSubjectSupplemental.getRelativeToInjector());
        }
        ServiceController serviceController = propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return propsServiceName;
    }

    private ServiceName addSSLService(OperationContext context, ModelNode ssl, ModelNode trustStore, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName sslServiceName = realmServiceName.append(new String[]{"ssl"});
        ServiceName keystoreServiceName = null;
        char[] password = null;
        if (ssl != null && ssl.hasDefined("keystore-path")) {
            keystoreServiceName = realmServiceName.append(new String[]{"keystore"});
            password = this.addFileKeystoreService(context, ssl, keystoreServiceName, serviceTarget, newControllers);
        }
        ServiceName truststoreServiceName = null;
        if (trustStore != null) {
            truststoreServiceName = realmServiceName.append(new String[]{"truststore"});
            this.addFileKeystoreService(context, trustStore, truststoreServiceName, serviceTarget, newControllers);
        }
        String protocol = "TLS";
        if (ssl != null && ssl.hasDefined("protocol")) {
            protocol = ssl.get("protocol").asString();
        }
        SSLIdentityService sslIdentityService = new SSLIdentityService(protocol, password);
        ServiceBuilder sslBuilder = serviceTarget.addService(sslServiceName, (Service)sslIdentityService);
        if (keystoreServiceName != null) {
            sslBuilder.addDependency(keystoreServiceName, KeyStore.class, sslIdentityService.getKeyStoreInjector());
        }
        if (truststoreServiceName != null) {
            sslBuilder.addDependency(truststoreServiceName, KeyStore.class, sslIdentityService.getTrustStoreInjector());
        }
        ServiceController serviceController = sslBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return sslServiceName;
    }

    private char[] addFileKeystoreService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        char[] password = this.unmaskPassword(context, ssl.require("keystore-password"));
        FileKeystoreService fileKeystoreService = new FileKeystoreService(ssl.require("keystore-path").asString(), password);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)fileKeystoreService);
        if (ssl.hasDefined("keystore-relative-to")) {
            serviceBuilder.addDependency(SecurityRealmAddHandler.pathName(ssl.require("keystore-relative-to").asString()), String.class, fileKeystoreService.getRelativeToInjector());
        }
        ServiceController serviceController = serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return password;
    }

    private ServiceName addSecretService(OperationContext context, ModelNode secret, ServiceName realmServiceName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName secretServiceName = realmServiceName.append(new String[]{"secret"});
        ModelNode secretValueNode = secret.require("value");
        String resolvedValue = context.resolveExpressions(secretValueNode).asString();
        SecretIdentityService sis = new SecretIdentityService(resolvedValue, secretValueNode.asString().equals(resolvedValue));
        ServiceController serviceController = serviceTarget.addService(secretServiceName, (Service)sis).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return secretServiceName;
    }

    private ServiceName addUsersService(OperationContext context, ModelNode users, ServiceName realmServiceName, String realmName, ServiceTarget serviceTarget, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName usersServiceName = realmServiceName.append(new String[]{"users"});
        UserDomainCallbackHandler usersCallbackHandler = new UserDomainCallbackHandler(realmName, this.unmaskUsersPasswords(context, users));
        ServiceBuilder usersBuilder = serviceTarget.addService(usersServiceName, (Service)usersCallbackHandler);
        ServiceController serviceController = usersBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (newControllers != null) {
            newControllers.add(serviceController);
        }
        return usersServiceName;
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    private char[] unmaskPassword(OperationContext context, ModelNode password) throws OperationFailedException {
        return context.resolveExpressions(password).asString().toCharArray();
    }

    private ModelNode unmaskUsersPasswords(OperationContext context, ModelNode users) throws OperationFailedException {
        users = users.clone();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = property.getValue();
            if (!user.hasDefined("password")) continue;
            user.set("password", context.resolveExpressions(user.get("password")).asString());
        }
        return users;
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ArrayList newControllers = new ArrayList();
            String realmName = ManagementUtil.getSecurityRealmName(operation);
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            INSTANCE.installServices(context, realmName, model, new ServiceVerificationHandler(), newControllers);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    for (ServiceController sc : newControllers) {
                        context.removeService(sc);
                    }
                }
            });
        }
    }
}

