/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class PropertiesFileLoader {
    private final String path;
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private File propertiesFile;
    private volatile long fileUpdated = -1L;
    private volatile Properties properties = null;

    protected PropertiesFileLoader(String path) {
        this.path = path;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    public void start(StartContext context) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        this.propertiesFile = new File(file);
        try {
            this.getProperties();
        }
        catch (IOException ioe) {
            throw DomainManagementMessages.MESSAGES.unableToLoadProperties(ioe);
        }
    }

    public void stop(StopContext context) {
        this.properties.clear();
        this.properties = null;
        this.propertiesFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties() throws IOException {
        boolean loadRequired;
        boolean bl = loadRequired = this.properties == null || this.fileUpdated != this.propertiesFile.lastModified();
        if (loadRequired) {
            PropertiesFileLoader propertiesFileLoader = this;
            synchronized (propertiesFileLoader) {
                boolean loadReallyRequired;
                long fileLastModified = this.propertiesFile.lastModified();
                boolean bl2 = loadReallyRequired = this.properties == null || this.fileUpdated != fileLastModified;
                if (loadReallyRequired) {
                    DomainManagementLogger.ROOT_LOGGER.debugf("Reloading properties file '%s'", this.propertiesFile.getAbsolutePath());
                    Properties props = new Properties();
                    FileInputStream is = new FileInputStream(this.propertiesFile);
                    try {
                        props.load(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    this.verifyProperties(props);
                    this.properties = props;
                    this.fileUpdated = fileLastModified;
                }
            }
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void persistProperties() throws IOException {
        Properties toSave = (Properties)this.properties.clone();
        File backup = new File(this.propertiesFile.getCanonicalPath() + ".bak");
        if (backup.exists() && !backup.delete()) {
            throw new IllegalStateException("Unable to delete backup properties file.");
        }
        if (!this.propertiesFile.renameTo(backup)) {
            throw new IllegalStateException("Unable to backup properties file.");
        }
        FileReader fr = new FileReader(backup);
        BufferedReader br = new BufferedReader(fr);
        FileWriter fw = new FileWriter(this.propertiesFile);
        BufferedWriter bw = new BufferedWriter(fw);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String userName;
                String trimmed = line.trim();
                if (trimmed.startsWith("#")) {
                    bw.append(line);
                    bw.newLine();
                    continue;
                }
                if (trimmed.length() == 0) {
                    bw.newLine();
                    continue;
                }
                int equals = trimmed.indexOf(61);
                if (equals <= 0 || !toSave.contains(userName = trimmed.substring(0, equals))) continue;
                bw.append(userName + "=" + toSave.getProperty(userName));
                bw.newLine();
                toSave.remove(userName);
            }
            for (Object currentKey : toSave.keySet()) {
                bw.append(currentKey + "=" + toSave.getProperty((String)currentKey));
                bw.newLine();
            }
            bw.newLine();
        }
        finally {
            this.safeClose(bw);
            this.safeClose(fw);
            this.safeClose(br);
            this.safeClose(fr);
        }
    }

    private void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void verifyProperties(Properties properties) throws IOException {
    }
}

